package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-06-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EmployeeConsumeCost implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 期间
   */
  @TableField("periodTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime periodTime;

  /**
   * 提交人名称
   */
  private String tripper;

  /**
   * 提交人编码
   */
  @TableField("tripCode")
  private String tripCode;

  /**
   * 单号
   */
  @TableField("bizNo")
  private String bizNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 标题
   */
  @TableField("applyName")
  private String applyName;

  /**
   * 提交日期
   */
  @TableField("applyDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyDate;

  /**
   * 支付日期
   */
  @TableField("payDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payDate;

  /**
   * 消费事由
   */
  @TableField("consumeReason")
  private String consumeReason;

  /**
   * Chargecode编码
   */
  @TableField("chargeCode")
  private String chargeCode;

  /**
   * Chargecode名称
   */
  @TableField("chargeName")
  private String chargeName;

  /**
   * Owner编码
   */
  @TableField("chargeOwnerCode")
  private String chargeOwnerCode;

  /**
   * Owner名称
   */
  @TableField("chargeOwnerName")
  private String chargeOwnerName;

  /**
   * 费用金额
   */
  @TableField("costAmount")
  private BigDecimal costAmount;

  /**
   * 费用明细名称
   */
  @TableField("costFullDetail")
  private String costFullDetail;

  /**
   * 一级费用明细名称
   */
  @TableField("oneCostItem")
  private String oneCostItem;

  /**
   * 二级费用明细名称
   */
  @TableField("twoCostItem")
  private String twoCostItem;

  /**
   * 三级费用明细名称
   */
  @TableField("threeCostItem")
  private String threeCostItem;

  /**
   * 四级费用明细名称
   */
  @TableField("fourCostItem")
  private String fourCostItem;

  /**
   * 五级费用明细名称
   */
  @TableField("fiveCostItem")
  private String fiveCostItem;

  /**
   * 末级费用明细名称
   */
  @TableField("lastCostItem")
  private String lastCostItem;

  /**
   * 关联申请编码
   */
  @TableField("refApplyCode")
  private String refApplyCode;

  /**
   * 关联申请名称
   */
  @TableField("refApplyName")
  private String refApplyName;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 付款类型名称
   */
  @TableField("payTypeName")
  private String payTypeName;

  /**
   * 分摊比例/%
   */
  @TableField("shareRatio")
  private BigDecimal shareRatio;

  /**
   * 汇总统计所属部门
   */
  @TableField("summaryDepartment")
  private String summaryDepartment;

  /**
   * Chargecode类型
   */
  @TableField("chargeCodeType")
  private String chargeCodeType;

  /**
   * 费用明细编码
   */
  @TableField("costFullCode")
  private String costFullCode;

  /**
   * 一级费用明细编码
   */
  @TableField("oneCostCode")
  private String oneCostCode;

  /**
   * 二级费用明细编码
   */
  @TableField("twoCostCode")
  private String twoCostCode;

  /**
   * 三级费用明细编码
   */
  @TableField("threeCostCode")
  private String threeCostCode;

  /**
   * 四级费用明细编码
   */
  @TableField("fourCostCode")
  private String fourCostCode;

  /**
   * 五级费用明细编码
   */
  @TableField("fiveCostCode")
  private String fiveCostCode;

  /**
   * 末级费用明细编码
   */
  @TableField("lastCostCode")
  private String lastCostCode;

  /**
   * 费用类型
   */
  @TableField("statisticsCostType")
  private String statisticsCostType;

  /**
   * 单据模板名称
   */
  @TableField("bilTemplateName")
  private String bilTemplateName;

  /**
   * Chargecode类型归属部门
   */
  @TableField("chargeTypeDepartment")
  private String chargeTypeDepartment;

  /**
   * 数据来源
   */
  private String source;

  /**
   * 费用类型是否参与统计
   */
  @TableField("joinStatistics")
  private String joinStatistics;

  /**
   * 归档
   */
  private Boolean archive;

  /**
   * 主单号
   */
  @TableField("mainBizNo")
  private String mainBizNo;

  /**
   * 下级部门
   */
  @TableField("departmentName")
  private String departmentName;

  /**
   * 提交人所属一级部门
   */
  @TableField("oneDepartmentName")
  private String oneDepartmentName;

  /**
   * chargecode归属部门统计部门
   */
  @TableField("chargedeCodeOrgSummaryDepartment")
  private String chargedeCodeOrgSummaryDepartment;

  /**
   * 报销金额
   */
  @TableField("claimAmount")
  private BigDecimal claimAmount;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("periodTime", BocpGenUtils.toTimestamp(periodTime));
      map.put("tripper", tripper);
      map.put("tripCode", tripCode);
      map.put("bizNo", bizNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("applyName", applyName);
      map.put("applyDate", BocpGenUtils.toTimestamp(applyDate));
      map.put("payDate", BocpGenUtils.toTimestamp(payDate));
      map.put("consumeReason", consumeReason);
      map.put("chargeCode", chargeCode);
      map.put("chargeName", chargeName);
      map.put("chargeOwnerCode", chargeOwnerCode);
      map.put("chargeOwnerName", chargeOwnerName);
      map.put("costAmount", costAmount);
      map.put("costFullDetail", costFullDetail);
      map.put("oneCostItem", oneCostItem);
      map.put("twoCostItem", twoCostItem);
      map.put("threeCostItem", threeCostItem);
      map.put("fourCostItem", fourCostItem);
      map.put("fiveCostItem", fiveCostItem);
      map.put("lastCostItem", lastCostItem);
      map.put("refApplyCode", refApplyCode);
      map.put("refApplyName", refApplyName);
      map.put("supplierName", supplierName);
      map.put("payTypeName", payTypeName);
      map.put("shareRatio", shareRatio);
      map.put("summaryDepartment", summaryDepartment);
      map.put("chargeCodeType", chargeCodeType);
      map.put("costFullCode", costFullCode);
      map.put("oneCostCode", oneCostCode);
      map.put("twoCostCode", twoCostCode);
      map.put("threeCostCode", threeCostCode);
      map.put("fourCostCode", fourCostCode);
      map.put("fiveCostCode", fiveCostCode);
      map.put("lastCostCode", lastCostCode);
      map.put("statisticsCostType", statisticsCostType);
      map.put("bilTemplateName", bilTemplateName);
      map.put("chargeTypeDepartment", chargeTypeDepartment);
      map.put("source", source);
      map.put("joinStatistics", joinStatistics);
      map.put("archive", archive);
      map.put("mainBizNo", mainBizNo);
      map.put("departmentName", departmentName);
      map.put("oneDepartmentName", oneDepartmentName);
      map.put("chargedeCodeOrgSummaryDepartment", chargedeCodeOrgSummaryDepartment);
      map.put("claimAmount", claimAmount);

      return map;
  }

  public static EmployeeConsumeCost fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    EmployeeConsumeCost entity = new EmployeeConsumeCost();
    if(map.containsKey("periodTime")) {
      Object obj = map.get("periodTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPeriodTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPeriodTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPeriodTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPeriodTime(null);
      }
    }
    if(map.containsKey("tripper")) {
      Object obj = map.get("tripper");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTripper((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tripCode")) {
      Object obj = map.get("tripCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTripCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizNo")) {
      Object obj = map.get("bizNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyDate")) {
      Object obj = map.get("applyDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplyDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyDate(null);
      }
    }
    if(map.containsKey("payDate")) {
      Object obj = map.get("payDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayDate(null);
      }
    }
    if(map.containsKey("consumeReason")) {
      Object obj = map.get("consumeReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsumeReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeName")) {
      Object obj = map.get("chargeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeOwnerCode")) {
      Object obj = map.get("chargeOwnerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeOwnerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeOwnerName")) {
      Object obj = map.get("chargeOwnerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeOwnerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costAmount")) {
      Object obj = map.get("costAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("costFullDetail")) {
      Object obj = map.get("costFullDetail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostFullDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oneCostItem")) {
      Object obj = map.get("oneCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOneCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("twoCostItem")) {
      Object obj = map.get("twoCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTwoCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("threeCostItem")) {
      Object obj = map.get("threeCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThreeCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fourCostItem")) {
      Object obj = map.get("fourCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFourCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fiveCostItem")) {
      Object obj = map.get("fiveCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFiveCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastCostItem")) {
      Object obj = map.get("lastCostItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastCostItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refApplyCode")) {
      Object obj = map.get("refApplyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefApplyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refApplyName")) {
      Object obj = map.get("refApplyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payTypeName")) {
      Object obj = map.get("payTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shareRatio")) {
      Object obj = map.get("shareRatio");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareRatio((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareRatio(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareRatio(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShareRatio(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareRatio(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("summaryDepartment")) {
      Object obj = map.get("summaryDepartment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSummaryDepartment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCodeType")) {
      Object obj = map.get("chargeCodeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCodeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costFullCode")) {
      Object obj = map.get("costFullCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostFullCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oneCostCode")) {
      Object obj = map.get("oneCostCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOneCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("twoCostCode")) {
      Object obj = map.get("twoCostCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTwoCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("threeCostCode")) {
      Object obj = map.get("threeCostCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThreeCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fourCostCode")) {
      Object obj = map.get("fourCostCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFourCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fiveCostCode")) {
      Object obj = map.get("fiveCostCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFiveCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastCostCode")) {
      Object obj = map.get("lastCostCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statisticsCostType")) {
      Object obj = map.get("statisticsCostType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatisticsCostType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bilTemplateName")) {
      Object obj = map.get("bilTemplateName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBilTemplateName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeTypeDepartment")) {
      Object obj = map.get("chargeTypeDepartment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeTypeDepartment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("joinStatistics")) {
      Object obj = map.get("joinStatistics");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJoinStatistics((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("archive")) {
      Object obj = map.get("archive");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setArchive((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setArchive(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("mainBizNo")) {
      Object obj = map.get("mainBizNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMainBizNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departmentName")) {
      Object obj = map.get("departmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oneDepartmentName")) {
      Object obj = map.get("oneDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOneDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargedeCodeOrgSummaryDepartment")) {
      Object obj = map.get("chargedeCodeOrgSummaryDepartment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargedeCodeOrgSummaryDepartment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("claimAmount")) {
      Object obj = map.get("claimAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setClaimAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setClaimAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setClaimAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setClaimAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setClaimAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("periodTime")) {
      Object obj = map.get("periodTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPeriodTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPeriodTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPeriodTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPeriodTime(null);
      }
    }
    if(map.containsKey("tripper")) {
      Object obj = map.get("tripper");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTripper((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tripCode")) {
      Object obj = map.get("tripCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTripCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizNo")) {
      Object obj = map.get("bizNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyDate")) {
      Object obj = map.get("applyDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApplyDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApplyDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApplyDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApplyDate(null);
      }
    }
    if(map.containsKey("payDate")) {
      Object obj = map.get("payDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPayDate(null);
      }
    }
    if(map.containsKey("consumeReason")) {
      Object obj = map.get("consumeReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsumeReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeName")) {
      Object obj = map.get("chargeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeOwnerCode")) {
      Object obj = map.get("chargeOwnerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeOwnerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeOwnerName")) {
      Object obj = map.get("chargeOwnerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeOwnerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costAmount")) {
      Object obj = map.get("costAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("costFullDetail")) {
      Object obj = map.get("costFullDetail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostFullDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oneCostItem")) {
      Object obj = map.get("oneCostItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOneCostItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("twoCostItem")) {
      Object obj = map.get("twoCostItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTwoCostItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("threeCostItem")) {
      Object obj = map.get("threeCostItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThreeCostItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fourCostItem")) {
      Object obj = map.get("fourCostItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFourCostItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fiveCostItem")) {
      Object obj = map.get("fiveCostItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFiveCostItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastCostItem")) {
      Object obj = map.get("lastCostItem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLastCostItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refApplyCode")) {
      Object obj = map.get("refApplyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefApplyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refApplyName")) {
      Object obj = map.get("refApplyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefApplyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payTypeName")) {
      Object obj = map.get("payTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shareRatio")) {
      Object obj = map.get("shareRatio");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setShareRatio((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setShareRatio(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setShareRatio(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShareRatio(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setShareRatio(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("summaryDepartment")) {
      Object obj = map.get("summaryDepartment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSummaryDepartment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeCodeType")) {
      Object obj = map.get("chargeCodeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCodeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costFullCode")) {
      Object obj = map.get("costFullCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostFullCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oneCostCode")) {
      Object obj = map.get("oneCostCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOneCostCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("twoCostCode")) {
      Object obj = map.get("twoCostCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTwoCostCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("threeCostCode")) {
      Object obj = map.get("threeCostCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThreeCostCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fourCostCode")) {
      Object obj = map.get("fourCostCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFourCostCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fiveCostCode")) {
      Object obj = map.get("fiveCostCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFiveCostCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastCostCode")) {
      Object obj = map.get("lastCostCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLastCostCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("statisticsCostType")) {
      Object obj = map.get("statisticsCostType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatisticsCostType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bilTemplateName")) {
      Object obj = map.get("bilTemplateName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBilTemplateName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeTypeDepartment")) {
      Object obj = map.get("chargeTypeDepartment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeTypeDepartment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("joinStatistics")) {
      Object obj = map.get("joinStatistics");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJoinStatistics((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("archive")) {
      Object obj = map.get("archive");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setArchive((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setArchive(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("mainBizNo")) {
      Object obj = map.get("mainBizNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMainBizNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("departmentName")) {
      Object obj = map.get("departmentName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oneDepartmentName")) {
      Object obj = map.get("oneDepartmentName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOneDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargedeCodeOrgSummaryDepartment")) {
      Object obj = map.get("chargedeCodeOrgSummaryDepartment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargedeCodeOrgSummaryDepartment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("claimAmount")) {
      Object obj = map.get("claimAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setClaimAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setClaimAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setClaimAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setClaimAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setClaimAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
  }
}
