package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-06-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderInfo implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 计价单位
   */
  @TableField("pricingUnit")
  private String pricingUnit;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 版本
   */
  private Long version;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private String orderStatus;

  /**
   * 合同ID
   */
  @TableField("contractId")
  private String contractId;

  /**
   * 关联合同ID
   */
  @TableField("relatedContractId")
  private String relatedContractId;

  /**
   * 产品编号
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 购买产品的数量
   */
  @TableField("purchaseQuantity")
  private BigDecimal purchaseQuantity;

  /**
   * 订单总金额(含税)
   */
  @TableField("totalAmountStr")
  private BigDecimal totalAmountStr;

  /**
   * 订单付款比例
   */
  @TableField("paymentPercent")
  private BigDecimal paymentPercent;

  /**
   * 付费类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 服务收费类型
   */
  @TableField("serviceType")
  private String serviceType;

  /**
   * 是否保证金
   */
  @TableField("isRetentionMoney")
  private Boolean isRetentionMoney;

  /**
   * 付款条件
   */
  @TableField("paymentRequirement")
  private String paymentRequirement;

  /**
   * 待核销金额
   */
  @TableField("waitingAmount")
  private BigDecimal waitingAmount;

  /**
   * 已核销金额
   */
  @TableField("readyAmount")
  private BigDecimal readyAmount;

  /**
   * 优惠金额（含税）
   */
  @TableField("discountAmountWithTax")
  private BigDecimal discountAmountWithTax;

  /**
   * 应付金额（含税）
   */
  @TableField("payableAmountWithTax")
  private BigDecimal payableAmountWithTax;

  /**
   * 实收金额（含税）
   */
  @TableField("receivableAmountWithTax")
  private BigDecimal receivableAmountWithTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 售价金额（不含税）
   */
  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  /**
   * 订单开票状态
   */
  @TableField("orderInvoiceStatus")
  private String orderInvoiceStatus;

  /**
   * 订单创建日期
   */
  @TableField("generateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime generateDate;

  /**
   * 订单生效日期
   */
  @TableField("effectiveDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime effectiveDate;

  /**
   * 订单失效日期(旧)
   */
  @TableField("expiryDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expiryDate;

  /**
   * 付款类型
   */
  @TableField("payType")
  private String payType;

  /**
   * 付款条件
   */
  @TableField("paymentCondition")
  private String paymentCondition;

  /**
   * B租户ID
   */
  @TableField("centralTenantId")
  private Long centralTenantId;

  /**
   * B租户名称
   */
  @TableField("centralTenantName")
  private String centralTenantName;

  /**
   * B租户code
   */
  @TableField("centralTenantCode")
  private String centralTenantCode;

  /**
   * 订单已开票金额
   */
  @TableField("inOrderInvoicedAmount")
  private BigDecimal inOrderInvoicedAmount;

  /**
   * 订单未开票金额
   */
  @TableField("inOrderNoInvoicedAmount")
  private BigDecimal inOrderNoInvoicedAmount;

  /**
   * 计费同步的原始合同ID
   */
  @TableField("originContractId")
  private String originContractId;

  /**
   * 支付状态
   */
  @TableField("payStatus")
  private String payStatus;

  /**
   * 计费类型
   */
  @TableField("billingType")
  private String billingType;

  /**
   * 订单类型--作废
   */
  @TableField("orderType")
  private String orderType;

  /**
   * 折抵金额(含税)
   */
  @TableField("remainDeductAmount")
  private BigDecimal remainDeductAmount;

  /**
   * 折抵订单号溯源
   */
  @TableField("originRemainDeductAmoutnOrder")
  private String originRemainDeductAmoutnOrder;

  /**
   * 计费规则
   */
  @TableField("billingRule")
  private String billingRule;

  /**
   * 验收时间
   */
  @TableField("receptionDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receptionDate;

  /**
   * 验收状态
   */
  @TableField("receptionStatus")
  private String receptionStatus;

  /**
   * 项目分期Code
   */
  @TableField("projectItemCode")
  private String projectItemCode;

  /**
   * 项目分期名称
   */
  @TableField("projectItemName")
  private String projectItemName;

  /**
   * 使用方税号
   */
  @TableField("taxNoList")
  private String taxNoList;

  /**
   * 渠道类型
   */
  @TableField("tenantType")
  private String tenantType;

  /**
   * 汇款码
   */
  @TableField("remittanceNo")
  private String remittanceNo;

  /**
   * 账单id
   */
  @TableField("invoiceRecordId")
  private String invoiceRecordId;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 下单方式
   */
  @TableField("orderWay")
  private String orderWay;

  /**
   * 合同状态
   */
  @TableField("contractStatus")
  private String contractStatus;

  /**
   * 支付方式
   */
  @TableField("paymentWay")
  private String paymentWay;

  /**
   * 支付时间
   */
  @TableField("paymentTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentTime;

  /**
   * 服务开通时间
   */
  @TableField("serviceOpenTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime serviceOpenTime;

  /**
   * 服务预计结束时间
   */
  @TableField("preServiceCloseTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime preServiceCloseTime;

  /**
   * 实际服务结束时间
   */
  @TableField("realServiceCloseTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime realServiceCloseTime;

  /**
   * 激活状态
   */
  @TableField("activateStatus")
  private String activateStatus;

  /**
   * 标的
   */
  @TableField("subjectMatter")
  private String subjectMatter;

  /**
   * 原始订单号
   */
  @TableField("originOrderNo")
  private String originOrderNo;

  /**
   * 小B订单服务关闭类型
   */
  @TableField("serviceCloseType")
  private String serviceCloseType;


  /**
   * 对一关联关系 关联对象 contract
   */
    private Long manyOrderToOneContractId;
  /**
   * 对一关联关系 关联对象 contractDetail
   */
    private Long orderToContractDetailId;
  /**
   * 对一关联关系 关联对象 incomeSummary
   */
    private Long oneIncomeSummaryToManyOrderInfoId;
  /**
   * 对一关联关系 关联对象 billStatics
   */
    private Long oneBillStaticsToManyOrderInfoId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderNo", orderNo);
      map.put("pricingUnit", pricingUnit);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("version", version);
      map.put("orderStatus", orderStatus);
      map.put("contractId", contractId);
      map.put("relatedContractId", relatedContractId);
      map.put("productCode", productCode);
      map.put("productName", productName);
      map.put("purchaseQuantity", purchaseQuantity);
      map.put("totalAmountStr", totalAmountStr);
      map.put("paymentPercent", paymentPercent);
      map.put("paymentType", paymentType);
      map.put("serviceType", serviceType);
      map.put("isRetentionMoney", isRetentionMoney);
      map.put("paymentRequirement", paymentRequirement);
      map.put("waitingAmount", waitingAmount);
      map.put("readyAmount", readyAmount);
      map.put("discountAmountWithTax", discountAmountWithTax);
      map.put("payableAmountWithTax", payableAmountWithTax);
      map.put("receivableAmountWithTax", receivableAmountWithTax);
      map.put("taxRate", taxRate);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("orderInvoiceStatus", orderInvoiceStatus);
      map.put("generateDate", BocpGenUtils.toTimestamp(generateDate));
      map.put("effectiveDate", BocpGenUtils.toTimestamp(effectiveDate));
      map.put("expiryDate", BocpGenUtils.toTimestamp(expiryDate));
      map.put("payType", payType);
      map.put("paymentCondition", paymentCondition);
      map.put("centralTenantId", centralTenantId);
      map.put("centralTenantName", centralTenantName);
      map.put("centralTenantCode", centralTenantCode);
      map.put("inOrderInvoicedAmount", inOrderInvoicedAmount);
      map.put("inOrderNoInvoicedAmount", inOrderNoInvoicedAmount);
      map.put("originContractId", originContractId);
      map.put("payStatus", payStatus);
      map.put("billingType", billingType);
      map.put("orderType", orderType);
      map.put("remainDeductAmount", remainDeductAmount);
      map.put("originRemainDeductAmoutnOrder", originRemainDeductAmoutnOrder);
      map.put("billingRule", billingRule);
      map.put("receptionDate", BocpGenUtils.toTimestamp(receptionDate));
      map.put("receptionStatus", receptionStatus);
      map.put("projectItemCode", projectItemCode);
      map.put("projectItemName", projectItemName);
      map.put("taxNoList", taxNoList);
      map.put("tenantType", tenantType);
      map.put("remittanceNo", remittanceNo);
      map.put("invoiceRecordId", invoiceRecordId);
      map.put("purchaserName", purchaserName);
      map.put("orderWay", orderWay);
      map.put("contractStatus", contractStatus);
      map.put("paymentWay", paymentWay);
      map.put("paymentTime", BocpGenUtils.toTimestamp(paymentTime));
      map.put("serviceOpenTime", BocpGenUtils.toTimestamp(serviceOpenTime));
      map.put("preServiceCloseTime", BocpGenUtils.toTimestamp(preServiceCloseTime));
      map.put("realServiceCloseTime", BocpGenUtils.toTimestamp(realServiceCloseTime));
      map.put("activateStatus", activateStatus);
      map.put("subjectMatter", subjectMatter);
      map.put("originOrderNo", originOrderNo);
      map.put("serviceCloseType", serviceCloseType);

       map.put("manyOrderToOneContract.id", manyOrderToOneContractId);
       map.put("orderToContractDetail.id", orderToContractDetailId);
       map.put("oneIncomeSummaryToManyOrderInfo.id", oneIncomeSummaryToManyOrderInfoId);
       map.put("oneBillStaticsToManyOrderInfo.id", oneBillStaticsToManyOrderInfoId);
      return map;
  }

  public static OrderInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderInfo entity = new OrderInfo();
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pricingUnit")) {
      Object obj = map.get("pricingUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPricingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relatedContractId")) {
      Object obj = map.get("relatedContractId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRelatedContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseQuantity")) {
      Object obj = map.get("purchaseQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchaseQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchaseQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchaseQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaseQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaseQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountStr")) {
      Object obj = map.get("totalAmountStr");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmountStr((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmountStr(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmountStr(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmountStr(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmountStr(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentPercent")) {
      Object obj = map.get("paymentPercent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentPercent((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentPercent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentPercent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentPercent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentPercent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceType")) {
      Object obj = map.get("serviceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isRetentionMoney")) {
      Object obj = map.get("isRetentionMoney");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsRetentionMoney((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsRetentionMoney(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waitingAmount")) {
      Object obj = map.get("waitingAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWaitingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWaitingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWaitingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWaitingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWaitingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("readyAmount")) {
      Object obj = map.get("readyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountAmountWithTax")) {
      Object obj = map.get("discountAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payableAmountWithTax")) {
      Object obj = map.get("payableAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayableAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayableAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayableAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayableAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayableAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivableAmountWithTax")) {
      Object obj = map.get("receivableAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivableAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivableAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivableAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderInvoiceStatus")) {
      Object obj = map.get("orderInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generateDate")) {
      Object obj = map.get("generateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGenerateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGenerateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGenerateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGenerateDate(null);
      }
    }
    if(map.containsKey("effectiveDate")) {
      Object obj = map.get("effectiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEffectiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setEffectiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEffectiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEffectiveDate(null);
      }
    }
    if(map.containsKey("expiryDate")) {
      Object obj = map.get("expiryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpiryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExpiryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpiryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpiryDate(null);
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentCondition")) {
      Object obj = map.get("paymentCondition");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentCondition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("centralTenantId")) {
      Object obj = map.get("centralTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCentralTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCentralTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCentralTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("centralTenantName")) {
      Object obj = map.get("centralTenantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCentralTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("centralTenantCode")) {
      Object obj = map.get("centralTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCentralTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inOrderInvoicedAmount")) {
      Object obj = map.get("inOrderInvoicedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInOrderInvoicedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInOrderInvoicedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInOrderInvoicedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInOrderInvoicedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInOrderInvoicedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("inOrderNoInvoicedAmount")) {
      Object obj = map.get("inOrderNoInvoicedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInOrderNoInvoicedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInOrderNoInvoicedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInOrderNoInvoicedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInOrderNoInvoicedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInOrderNoInvoicedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payStatus")) {
      Object obj = map.get("payStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remainDeductAmount")) {
      Object obj = map.get("remainDeductAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRemainDeductAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRemainDeductAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRemainDeductAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRemainDeductAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRemainDeductAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("originRemainDeductAmoutnOrder")) {
      Object obj = map.get("originRemainDeductAmoutnOrder");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginRemainDeductAmoutnOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingRule")) {
      Object obj = map.get("billingRule");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingRule((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receptionDate")) {
      Object obj = map.get("receptionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceptionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReceptionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceptionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceptionDate(null);
      }
    }
    if(map.containsKey("receptionStatus")) {
      Object obj = map.get("receptionStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceptionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemCode")) {
      Object obj = map.get("projectItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemName")) {
      Object obj = map.get("projectItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNoList")) {
      Object obj = map.get("taxNoList");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNoList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantType")) {
      Object obj = map.get("tenantType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remittanceNo")) {
      Object obj = map.get("remittanceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemittanceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceRecordId")) {
      Object obj = map.get("invoiceRecordId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceRecordId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderWay")) {
      Object obj = map.get("orderWay");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractStatus")) {
      Object obj = map.get("contractStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentWay")) {
      Object obj = map.get("paymentWay");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTime")) {
      Object obj = map.get("paymentTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaymentTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentTime(null);
      }
    }
    if(map.containsKey("serviceOpenTime")) {
      Object obj = map.get("serviceOpenTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setServiceOpenTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setServiceOpenTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setServiceOpenTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setServiceOpenTime(null);
      }
    }
    if(map.containsKey("preServiceCloseTime")) {
      Object obj = map.get("preServiceCloseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPreServiceCloseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPreServiceCloseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPreServiceCloseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPreServiceCloseTime(null);
      }
    }
    if(map.containsKey("realServiceCloseTime")) {
      Object obj = map.get("realServiceCloseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRealServiceCloseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRealServiceCloseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRealServiceCloseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRealServiceCloseTime(null);
      }
    }
    if(map.containsKey("activateStatus")) {
      Object obj = map.get("activateStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActivateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subjectMatter")) {
      Object obj = map.get("subjectMatter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubjectMatter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originOrderNo")) {
      Object obj = map.get("originOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceCloseType")) {
      Object obj = map.get("serviceCloseType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceCloseType((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("manyOrderToOneContract.id")) {
        Object obj = map.get("manyOrderToOneContract.id");
      if(obj instanceof Long) {
        entity.setManyOrderToOneContractId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setManyOrderToOneContractId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("orderToContractDetail.id")) {
        Object obj = map.get("orderToContractDetail.id");
      if(obj instanceof Long) {
        entity.setOrderToContractDetailId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOrderToContractDetailId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("oneIncomeSummaryToManyOrderInfo.id")) {
        Object obj = map.get("oneIncomeSummaryToManyOrderInfo.id");
      if(obj instanceof Long) {
        entity.setOneIncomeSummaryToManyOrderInfoId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOneIncomeSummaryToManyOrderInfoId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("oneBillStaticsToManyOrderInfo.id")) {
        Object obj = map.get("oneBillStaticsToManyOrderInfo.id");
      if(obj instanceof Long) {
        entity.setOneBillStaticsToManyOrderInfoId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOneBillStaticsToManyOrderInfoId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pricingUnit")) {
      Object obj = map.get("pricingUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPricingUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setVersion(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("relatedContractId")) {
      Object obj = map.get("relatedContractId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRelatedContractId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseQuantity")) {
      Object obj = map.get("purchaseQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPurchaseQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPurchaseQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPurchaseQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaseQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaseQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmountStr")) {
      Object obj = map.get("totalAmountStr");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmountStr((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmountStr(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmountStr(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmountStr(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmountStr(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paymentPercent")) {
      Object obj = map.get("paymentPercent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaymentPercent((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaymentPercent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaymentPercent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaymentPercent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaymentPercent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("serviceType")) {
      Object obj = map.get("serviceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setServiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isRetentionMoney")) {
      Object obj = map.get("isRetentionMoney");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsRetentionMoney((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsRetentionMoney(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentRequirement((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("waitingAmount")) {
      Object obj = map.get("waitingAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setWaitingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setWaitingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setWaitingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWaitingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setWaitingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("readyAmount")) {
      Object obj = map.get("readyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountAmountWithTax")) {
      Object obj = map.get("discountAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("payableAmountWithTax")) {
      Object obj = map.get("payableAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayableAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayableAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayableAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayableAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayableAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("receivableAmountWithTax")) {
      Object obj = map.get("receivableAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReceivableAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReceivableAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReceivableAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceivableAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceivableAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("orderInvoiceStatus")) {
      Object obj = map.get("orderInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("generateDate")) {
      Object obj = map.get("generateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGenerateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGenerateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGenerateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGenerateDate(null);
      }
    }
    if(map.containsKey("effectiveDate")) {
      Object obj = map.get("effectiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setEffectiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setEffectiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEffectiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setEffectiveDate(null);
      }
    }
    if(map.containsKey("expiryDate")) {
      Object obj = map.get("expiryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExpiryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExpiryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpiryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExpiryDate(null);
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentCondition")) {
      Object obj = map.get("paymentCondition");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentCondition((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("centralTenantId")) {
      Object obj = map.get("centralTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCentralTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCentralTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCentralTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("centralTenantName")) {
      Object obj = map.get("centralTenantName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCentralTenantName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("centralTenantCode")) {
      Object obj = map.get("centralTenantCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCentralTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inOrderInvoicedAmount")) {
      Object obj = map.get("inOrderInvoicedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInOrderInvoicedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInOrderInvoicedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInOrderInvoicedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInOrderInvoicedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInOrderInvoicedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("inOrderNoInvoicedAmount")) {
      Object obj = map.get("inOrderNoInvoicedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInOrderNoInvoicedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInOrderNoInvoicedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInOrderNoInvoicedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInOrderNoInvoicedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInOrderNoInvoicedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginContractId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payStatus")) {
      Object obj = map.get("payStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remainDeductAmount")) {
      Object obj = map.get("remainDeductAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRemainDeductAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRemainDeductAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRemainDeductAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRemainDeductAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRemainDeductAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("originRemainDeductAmoutnOrder")) {
      Object obj = map.get("originRemainDeductAmoutnOrder");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginRemainDeductAmoutnOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingRule")) {
      Object obj = map.get("billingRule");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingRule((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receptionDate")) {
      Object obj = map.get("receptionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceptionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReceptionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceptionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReceptionDate(null);
      }
    }
    if(map.containsKey("receptionStatus")) {
      Object obj = map.get("receptionStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceptionStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectItemCode")) {
      Object obj = map.get("projectItemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectItemName")) {
      Object obj = map.get("projectItemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxNoList")) {
      Object obj = map.get("taxNoList");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxNoList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tenantType")) {
      Object obj = map.get("tenantType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remittanceNo")) {
      Object obj = map.get("remittanceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemittanceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceRecordId")) {
      Object obj = map.get("invoiceRecordId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceRecordId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderWay")) {
      Object obj = map.get("orderWay");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractStatus")) {
      Object obj = map.get("contractStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentWay")) {
      Object obj = map.get("paymentWay");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentTime")) {
      Object obj = map.get("paymentTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaymentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPaymentTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaymentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPaymentTime(null);
      }
    }
    if(map.containsKey("serviceOpenTime")) {
      Object obj = map.get("serviceOpenTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setServiceOpenTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setServiceOpenTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setServiceOpenTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setServiceOpenTime(null);
      }
    }
    if(map.containsKey("preServiceCloseTime")) {
      Object obj = map.get("preServiceCloseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPreServiceCloseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPreServiceCloseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPreServiceCloseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPreServiceCloseTime(null);
      }
    }
    if(map.containsKey("realServiceCloseTime")) {
      Object obj = map.get("realServiceCloseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRealServiceCloseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRealServiceCloseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRealServiceCloseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRealServiceCloseTime(null);
      }
    }
    if(map.containsKey("activateStatus")) {
      Object obj = map.get("activateStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setActivateStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("subjectMatter")) {
      Object obj = map.get("subjectMatter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSubjectMatter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originOrderNo")) {
      Object obj = map.get("originOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("serviceCloseType")) {
      Object obj = map.get("serviceCloseType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setServiceCloseType((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("manyOrderToOneContract.id")) {
        Object obj = map.get("manyOrderToOneContract.id");
        if(obj instanceof Long) {
          this.setManyOrderToOneContractId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setManyOrderToOneContractId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("orderToContractDetail.id")) {
        Object obj = map.get("orderToContractDetail.id");
        if(obj instanceof Long) {
          this.setOrderToContractDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderToContractDetailId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("oneIncomeSummaryToManyOrderInfo.id")) {
        Object obj = map.get("oneIncomeSummaryToManyOrderInfo.id");
        if(obj instanceof Long) {
          this.setOneIncomeSummaryToManyOrderInfoId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOneIncomeSummaryToManyOrderInfoId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("oneBillStaticsToManyOrderInfo.id")) {
        Object obj = map.get("oneBillStaticsToManyOrderInfo.id");
        if(obj instanceof Long) {
          this.setOneBillStaticsToManyOrderInfoId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOneBillStaticsToManyOrderInfoId(Long.parseLong((String)obj));
        }
      }
  }
}
