package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-06-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReceivedPaymentsNotTaken implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 交易流水号
   */
  @TableField("tradeNo")
  private String tradeNo;

  /**
   * 回款时间
   */
  @TableField("returnedTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime returnedTime;

  /**
   * 回款金额
   */
  @TableField("returnMoney")
  private BigDecimal returnMoney;

  /**
   * 对方户名
   */
  @TableField("customerName")
  private String customerName;

  /**
   * 认领状态
   */
  @TableField("takenStatus")
  private String takenStatus;

  /**
   * 待认领金额
   */
  @TableField("waitingTakenMoney")
  private BigDecimal waitingTakenMoney;

  /**
   * 已认领金额
   */
  @TableField("takenMoney")
  private BigDecimal takenMoney;

  /**
   * 对方银行账号
   */
  @TableField("customerBankNo")
  private String customerBankNo;

  /**
   * 对方开户机构
   */
  @TableField("openAccountInstitutions")
  private String openAccountInstitutions;

  /**
   * 备注
   */
  private String remark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 币种
   */
  private String cny;

  /**
   * 回款流水数据来源
   */
  private String channel;

  /**
   * 回执编号
   */
  @TableField("voucherNo")
  private String voucherNo;

  /**
   * 开户行名名称
   */
  @TableField("bankName")
  private String bankName;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("tradeNo", tradeNo);
      map.put("returnedTime", BocpGenUtils.toTimestamp(returnedTime));
      map.put("returnMoney", returnMoney);
      map.put("customerName", customerName);
      map.put("takenStatus", takenStatus);
      map.put("waitingTakenMoney", waitingTakenMoney);
      map.put("takenMoney", takenMoney);
      map.put("customerBankNo", customerBankNo);
      map.put("openAccountInstitutions", openAccountInstitutions);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("cny", cny);
      map.put("channel", channel);
      map.put("voucherNo", voucherNo);
      map.put("bankName", bankName);

      return map;
  }

  public static ReceivedPaymentsNotTaken fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReceivedPaymentsNotTaken entity = new ReceivedPaymentsNotTaken();
    if(map.containsKey("tradeNo")) {
      Object obj = map.get("tradeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnedTime")) {
      Object obj = map.get("returnedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReturnedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReturnedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReturnedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReturnedTime(null);
      }
    }
    if(map.containsKey("returnMoney")) {
      Object obj = map.get("returnMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReturnMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("takenStatus")) {
      Object obj = map.get("takenStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTakenStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waitingTakenMoney")) {
      Object obj = map.get("waitingTakenMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWaitingTakenMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWaitingTakenMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWaitingTakenMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWaitingTakenMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWaitingTakenMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("takenMoney")) {
      Object obj = map.get("takenMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTakenMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTakenMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTakenMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTakenMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTakenMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customerBankNo")) {
      Object obj = map.get("customerBankNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openAccountInstitutions")) {
      Object obj = map.get("openAccountInstitutions");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpenAccountInstitutions((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cny")) {
      Object obj = map.get("cny");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCny((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherNo")) {
      Object obj = map.get("voucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBankName((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("tradeNo")) {
      Object obj = map.get("tradeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnedTime")) {
      Object obj = map.get("returnedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReturnedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReturnedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReturnedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReturnedTime(null);
      }
    }
    if(map.containsKey("returnMoney")) {
      Object obj = map.get("returnMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReturnMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReturnMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReturnMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReturnMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReturnMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("takenStatus")) {
      Object obj = map.get("takenStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTakenStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("waitingTakenMoney")) {
      Object obj = map.get("waitingTakenMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setWaitingTakenMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setWaitingTakenMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setWaitingTakenMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWaitingTakenMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setWaitingTakenMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("takenMoney")) {
      Object obj = map.get("takenMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTakenMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTakenMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTakenMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTakenMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTakenMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customerBankNo")) {
      Object obj = map.get("customerBankNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerBankNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("openAccountInstitutions")) {
      Object obj = map.get("openAccountInstitutions");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpenAccountInstitutions((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cny")) {
      Object obj = map.get("cny");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCny((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("voucherNo")) {
      Object obj = map.get("voucherNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVoucherNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBankName((String)obj);
        }
      } else {
      }
    }
  }
}
