package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-06-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class YkbHsOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 产品类型
   */
  @TableField("productType")
  private String productType;

  /**
   * 合思订单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 票证状态
   */
  @TableField("ticketStatus")
  private String ticketStatus;

  /**
   * 业务状态
   */
  @TableField("bizStatus")
  private String bizStatus;

  /**
   * 申请单号
   */
  @TableField("applyNo")
  private String applyNo;

  /**
   * 申请单名
   */
  @TableField("applyName")
  private String applyName;

  /**
   * 票号
   */
  @TableField("ticketNo")
  private String ticketNo;

  /**
   * 最原始票号
   */
  @TableField("originalTicketNo")
  private String originalTicketNo;

  /**
   * 上一次修改票号
   */
  @TableField("lastTicketNo")
  private String lastTicketNo;

  /**
   * 航线类型/商品类目
   */
  @TableField("airType")
  private String airType;

  /**
   * 航程代码/商品ID
   */
  @TableField("airCode")
  private String airCode;

  /**
   * 餐厅名称
   */
  @TableField("diningRoomName")
  private String diningRoomName;

  /**
   * 行程/车程/城市
   */
  private String city;

  /**
   * 航班号/车次/酒店名称/商品名称
   */
  @TableField("flightNumber")
  private String flightNumber;

  /**
   * 实际上车地点
   */
  @TableField("startAddress")
  private String startAddress;

  /**
   * 实际下车地点/收货地址
   */
  @TableField("endAddress")
  private String endAddress;

  /**
   * 起飞/出发/入住时间/下单时间
   */
  @TableField("startTime")
  private String startTime;

  /**
   * 降落/到达/离店时间/完成时间
   */
  @TableField("endTime")
  private String endTime;

  /**
   * 舱位/席别/房型/规格型号
   */
  @TableField("seatGrade")
  private String seatGrade;

  /**
   * 舱位描述/商品单位
   */
  @TableField("seatType")
  private String seatType;

  /**
   * 确认时间
   */
  @TableField("confirmTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime confirmTime;

  /**
   * 机票折扣
   */
  @TableField("airTicketDiscount")
  private BigDecimal airTicketDiscount;

  /**
   * 房间数量/商品数量
   */
  @TableField("productCount")
  private Long productCount;

  /**
   * 入住天数
   */
  @TableField("resideDays")
  private Long resideDays;

  /**
   * 承运人
   */
  private String carrier;

  /**
   * 航司名称
   */
  @TableField("airlineCompanyName")
  private String airlineCompanyName;

  /**
   * 公司名称
   */
  @TableField("buyCompanyName")
  private String buyCompanyName;

  /**
   * 预定人
   */
  @TableField("buyEmployeeName")
  private String buyEmployeeName;

  /**
   * 预定人末级部门
   */
  @TableField("buyEmployeeOrgName")
  private String buyEmployeeOrgName;

  /**
   * 预定人全部部门
   */
  @TableField("buyEmployeeFullOrgName")
  private String buyEmployeeFullOrgName;

  /**
   * 预定时间
   */
  @TableField("orderTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderTime;

  /**
   * 支付时间
   */
  @TableField("payTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payTime;

  /**
   * 出行人/入住人
   */
  @TableField("tripperName")
  private String tripperName;

  /**
   * 出行人工号
   */
  @TableField("tripperCode")
  private String tripperCode;

  /**
   * 出行人末级部门
   */
  @TableField("tripperOrgName")
  private String tripperOrgName;

  /**
   * 出行人全部部门
   */
  @TableField("tripperFullOrgName")
  private String tripperFullOrgName;

  /**
   * 是否超标
   */
  @TableField("outOfLimit")
  private String outOfLimit;

  /**
   * 超标原因
   */
  @TableField("outOfLimitReason")
  private String outOfLimitReason;

  /**
   * 用车事由/退改签原因（管理）
   */
  @TableField("refundReason")
  private String refundReason;

  /**
   * 用车取消原因/退改签原因补充说明（管理）
   */
  @TableField("refundReason2")
  private String refundReason2;

  /**
   * 活动金额
   */
  @TableField("activityAmount")
  private BigDecimal activityAmount;

  /**
   * 燃油费
   */
  @TableField("oilAmount")
  private BigDecimal oilAmount;

  /**
   * 机建费
   */
  @TableField("airportAmount")
  private BigDecimal airportAmount;

  /**
   * 税费小计
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 票面价/房价
   */
  @TableField("ticketAmount")
  private BigDecimal ticketAmount;

  /**
   * 服务费
   */
  @TableField("serviceAmount")
  private BigDecimal serviceAmount;

  /**
   * 预存支付金额
   */
  @TableField("prePayAmount")
  private BigDecimal prePayAmount;

  /**
   * 授信支付金额
   */
  @TableField("creditAmount")
  private BigDecimal creditAmount;

  /**
   * 微信支付金额
   */
  @TableField("wxPayAmount")
  private BigDecimal wxPayAmount;

  /**
   * 支付宝支付金额
   */
  @TableField("aliPayAmount")
  private BigDecimal aliPayAmount;

  /**
   * 个人钱包支付金额
   */
  @TableField("personPayAmount")
  private BigDecimal personPayAmount;

  /**
   * 销售价
   */
  @TableField("saleAmount")
  private BigDecimal saleAmount;

  /**
   * 保险份数
   */
  @TableField("insuranceCount")
  private Long insuranceCount;

  /**
   * 保险总价
   */
  @TableField("insuranceAmount")
  private BigDecimal insuranceAmount;

  /**
   * 应收金额
   */
  @TableField("incomeAmount")
  private BigDecimal incomeAmount;

  /**
   * 实收金额
   */
  @TableField("realIncomeAmount")
  private BigDecimal realIncomeAmount;

  /**
   * 客户退改手续费
   */
  @TableField("customerRefundFeeAmount")
  private BigDecimal customerRefundFeeAmount;

  /**
   * 客户退改费率
   */
  @TableField("customerRefundRate")
  private BigDecimal customerRefundRate;

  /**
   * 客户实退金额
   */
  @TableField("customerRealRefundAmount")
  private BigDecimal customerRealRefundAmount;

  /**
   * 退款状态
   */
  @TableField("refundStatus")
  private String refundStatus;

  /**
   * 合计
   */
  @TableField("totalAmount")
  private BigDecimal totalAmount;

  /**
   * 最原始订单号
   */
  @TableField("originalOrderNo")
  private String originalOrderNo;

  /**
   * 父订单号
   */
  @TableField("parentOrderNo")
  private String parentOrderNo;

  /**
   * 预定人工号
   */
  @TableField("orderEmployeeNumber")
  private String orderEmployeeNumber;

  /**
   * 超标详细
   */
  @TableField("outOfLimitDetail")
  private String outOfLimitDetail;

  /**
   * 客户改签手续费
   */
  @TableField("customerChangeFeeAmount")
  private BigDecimal customerChangeFeeAmount;

  /**
   * 客户退票手续费
   */
  @TableField("customerRefundTicketFeeAmount")
  private BigDecimal customerRefundTicketFeeAmount;

  /**
   * 报销状态
   */
  @TableField("expensedStatus")
  private String expensedStatus;

  /**
   * 付款方式
   */
  @TableField("payType")
  private String payType;

  /**
   * 成本归属项目
   */
  @TableField("chargeCodeName")
  private String chargeCodeName;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 产品描述
   */
  @TableField("productDetail")
  private String productDetail;

  /**
   * 出行类型
   */
  @TableField("tripType")
  private String tripType;

  /**
   * 支付账户
   */
  @TableField("payAccount")
  private String payAccount;

  /**
   * 票据领取方式
   */
  @TableField("pullTicketType")
  private String pullTicketType;

  /**
   * 保险类型
   */
  @TableField("insuranceType")
  private String insuranceType;

  /**
   * 关联业务类型
   */
  @TableField("refBizType")
  private String refBizType;

  /**
   * 随单业务订单号
   */
  @TableField("refBizOrderNo")
  private String refBizOrderNo;

  /**
   * 备注
   */
  private String remark;

  /**
   * 场景
   */
  private String scene;

  /**
   * 票根费
   */
  @TableField("ticketStubFee")
  private BigDecimal ticketStubFee;

  /**
   * 成本归属部门
   */
  @TableField("costDepartment")
  private String costDepartment;

  /**
   * 成本归属备注
   */
  @TableField("costRemark")
  private String costRemark;

  /**
   * 优惠券
   */
  private BigDecimal coupon;

  /**
   * 开票状态
   */
  @TableField("invoiceStatus")
  private String invoiceStatus;

  /**
   * 法人实体
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 子订单号
   */
  @TableField("subOrderNo")
  private String subOrderNo;

  /**
   * 票面单价
   */
  @TableField("ticketUnitPrice")
  private BigDecimal ticketUnitPrice;

  /**
   * 实收单价
   */
  @TableField("realUnitPrice")
  private BigDecimal realUnitPrice;

  /**
   * 自定义档案
   */
  @TableField("customArchives")
  private String customArchives;

  /**
   * 税额加成
   */
  @TableField("taxAmountAddition")
  private BigDecimal taxAmountAddition;

  /**
   * 托管服务费
   */
  @TableField("trusteeServiceAmount")
  private BigDecimal trusteeServiceAmount;

  /**
   * 后结服务费
   */
  @TableField("postPayServiceAmount")
  private BigDecimal postPayServiceAmount;

  /**
   * 账户名称
   */
  @TableField("accountName")
  private String accountName;

  /**
   * 费控企业ID
   */
  @TableField("companyId")
  private String companyId;

  /**
   * 红包金额
   */
  @TableField("redPacket")
  private BigDecimal redPacket;

  /**
   * 税点
   */
  @TableField("taxPoint")
  private BigDecimal taxPoint;

  /**
   * 开票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 税收分类编码
   */
  @TableField("taxTypeCode")
  private String taxTypeCode;

  /**
   * 明细id
   */
  @TableField("itemId")
  private String itemId;

  /**
   * chargeCode
   */
  @TableField("chargeCode")
  private String chargeCode;

  /**
   * charge名称
   */
  @TableField("chargeName")
  private String chargeName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("productType", productType);
      map.put("orderNo", orderNo);
      map.put("ticketStatus", ticketStatus);
      map.put("bizStatus", bizStatus);
      map.put("applyNo", applyNo);
      map.put("applyName", applyName);
      map.put("ticketNo", ticketNo);
      map.put("originalTicketNo", originalTicketNo);
      map.put("lastTicketNo", lastTicketNo);
      map.put("airType", airType);
      map.put("airCode", airCode);
      map.put("diningRoomName", diningRoomName);
      map.put("city", city);
      map.put("flightNumber", flightNumber);
      map.put("startAddress", startAddress);
      map.put("endAddress", endAddress);
      map.put("startTime", startTime);
      map.put("endTime", endTime);
      map.put("seatGrade", seatGrade);
      map.put("seatType", seatType);
      map.put("confirmTime", BocpGenUtils.toTimestamp(confirmTime));
      map.put("airTicketDiscount", airTicketDiscount);
      map.put("productCount", productCount);
      map.put("resideDays", resideDays);
      map.put("carrier", carrier);
      map.put("airlineCompanyName", airlineCompanyName);
      map.put("buyCompanyName", buyCompanyName);
      map.put("buyEmployeeName", buyEmployeeName);
      map.put("buyEmployeeOrgName", buyEmployeeOrgName);
      map.put("buyEmployeeFullOrgName", buyEmployeeFullOrgName);
      map.put("orderTime", BocpGenUtils.toTimestamp(orderTime));
      map.put("payTime", BocpGenUtils.toTimestamp(payTime));
      map.put("tripperName", tripperName);
      map.put("tripperCode", tripperCode);
      map.put("tripperOrgName", tripperOrgName);
      map.put("tripperFullOrgName", tripperFullOrgName);
      map.put("outOfLimit", outOfLimit);
      map.put("outOfLimitReason", outOfLimitReason);
      map.put("refundReason", refundReason);
      map.put("refundReason2", refundReason2);
      map.put("activityAmount", activityAmount);
      map.put("oilAmount", oilAmount);
      map.put("airportAmount", airportAmount);
      map.put("taxAmount", taxAmount);
      map.put("ticketAmount", ticketAmount);
      map.put("serviceAmount", serviceAmount);
      map.put("prePayAmount", prePayAmount);
      map.put("creditAmount", creditAmount);
      map.put("wxPayAmount", wxPayAmount);
      map.put("aliPayAmount", aliPayAmount);
      map.put("personPayAmount", personPayAmount);
      map.put("saleAmount", saleAmount);
      map.put("insuranceCount", insuranceCount);
      map.put("insuranceAmount", insuranceAmount);
      map.put("incomeAmount", incomeAmount);
      map.put("realIncomeAmount", realIncomeAmount);
      map.put("customerRefundFeeAmount", customerRefundFeeAmount);
      map.put("customerRefundRate", customerRefundRate);
      map.put("customerRealRefundAmount", customerRealRefundAmount);
      map.put("refundStatus", refundStatus);
      map.put("totalAmount", totalAmount);
      map.put("originalOrderNo", originalOrderNo);
      map.put("parentOrderNo", parentOrderNo);
      map.put("orderEmployeeNumber", orderEmployeeNumber);
      map.put("outOfLimitDetail", outOfLimitDetail);
      map.put("customerChangeFeeAmount", customerChangeFeeAmount);
      map.put("customerRefundTicketFeeAmount", customerRefundTicketFeeAmount);
      map.put("expensedStatus", expensedStatus);
      map.put("payType", payType);
      map.put("chargeCodeName", chargeCodeName);
      map.put("productName", productName);
      map.put("productDetail", productDetail);
      map.put("tripType", tripType);
      map.put("payAccount", payAccount);
      map.put("pullTicketType", pullTicketType);
      map.put("insuranceType", insuranceType);
      map.put("refBizType", refBizType);
      map.put("refBizOrderNo", refBizOrderNo);
      map.put("remark", remark);
      map.put("scene", scene);
      map.put("ticketStubFee", ticketStubFee);
      map.put("costDepartment", costDepartment);
      map.put("costRemark", costRemark);
      map.put("coupon", coupon);
      map.put("invoiceStatus", invoiceStatus);
      map.put("companyName", companyName);
      map.put("subOrderNo", subOrderNo);
      map.put("ticketUnitPrice", ticketUnitPrice);
      map.put("realUnitPrice", realUnitPrice);
      map.put("customArchives", customArchives);
      map.put("taxAmountAddition", taxAmountAddition);
      map.put("trusteeServiceAmount", trusteeServiceAmount);
      map.put("postPayServiceAmount", postPayServiceAmount);
      map.put("accountName", accountName);
      map.put("companyId", companyId);
      map.put("redPacket", redPacket);
      map.put("taxPoint", taxPoint);
      map.put("invoiceType", invoiceType);
      map.put("taxTypeCode", taxTypeCode);
      map.put("itemId", itemId);
      map.put("chargeCode", chargeCode);
      map.put("chargeName", chargeName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static YkbHsOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    YkbHsOrder entity = new YkbHsOrder();
    if(map.containsKey("productType")) {
      Object obj = map.get("productType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticketStatus")) {
      Object obj = map.get("ticketStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizStatus")) {
      Object obj = map.get("bizStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticketNo")) {
      Object obj = map.get("ticketNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalTicketNo")) {
      Object obj = map.get("originalTicketNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalTicketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastTicketNo")) {
      Object obj = map.get("lastTicketNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastTicketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("airType")) {
      Object obj = map.get("airType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAirType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("airCode")) {
      Object obj = map.get("airCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAirCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diningRoomName")) {
      Object obj = map.get("diningRoomName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiningRoomName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flightNumber")) {
      Object obj = map.get("flightNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlightNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startAddress")) {
      Object obj = map.get("startAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStartAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endAddress")) {
      Object obj = map.get("endAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEndAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startTime")) {
      Object obj = map.get("startTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endTime")) {
      Object obj = map.get("endTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEndTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seatGrade")) {
      Object obj = map.get("seatGrade");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSeatGrade((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seatType")) {
      Object obj = map.get("seatType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSeatType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("confirmTime")) {
      Object obj = map.get("confirmTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setConfirmTime(null);
      }
    }
    if(map.containsKey("airTicketDiscount")) {
      Object obj = map.get("airTicketDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAirTicketDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAirTicketDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAirTicketDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAirTicketDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAirTicketDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("productCount")) {
      Object obj = map.get("productCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProductCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProductCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProductCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("resideDays")) {
      Object obj = map.get("resideDays");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setResideDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setResideDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setResideDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("carrier")) {
      Object obj = map.get("carrier");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCarrier((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("airlineCompanyName")) {
      Object obj = map.get("airlineCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAirlineCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyCompanyName")) {
      Object obj = map.get("buyCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyEmployeeName")) {
      Object obj = map.get("buyEmployeeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyEmployeeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyEmployeeOrgName")) {
      Object obj = map.get("buyEmployeeOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyEmployeeOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyEmployeeFullOrgName")) {
      Object obj = map.get("buyEmployeeFullOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyEmployeeFullOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderTime")) {
      Object obj = map.get("orderTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderTime(null);
      }
    }
    if(map.containsKey("payTime")) {
      Object obj = map.get("payTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayTime(null);
      }
    }
    if(map.containsKey("tripperName")) {
      Object obj = map.get("tripperName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTripperName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tripperCode")) {
      Object obj = map.get("tripperCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTripperCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tripperOrgName")) {
      Object obj = map.get("tripperOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTripperOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tripperFullOrgName")) {
      Object obj = map.get("tripperFullOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTripperFullOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outOfLimit")) {
      Object obj = map.get("outOfLimit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOutOfLimit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outOfLimitReason")) {
      Object obj = map.get("outOfLimitReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOutOfLimitReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundReason")) {
      Object obj = map.get("refundReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundReason2")) {
      Object obj = map.get("refundReason2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundReason2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("activityAmount")) {
      Object obj = map.get("activityAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActivityAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActivityAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActivityAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActivityAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActivityAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("oilAmount")) {
      Object obj = map.get("oilAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOilAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOilAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOilAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOilAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOilAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("airportAmount")) {
      Object obj = map.get("airportAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAirportAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAirportAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAirportAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAirportAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAirportAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ticketAmount")) {
      Object obj = map.get("ticketAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTicketAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTicketAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTicketAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTicketAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTicketAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("serviceAmount")) {
      Object obj = map.get("serviceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setServiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setServiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setServiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setServiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setServiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("prePayAmount")) {
      Object obj = map.get("prePayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrePayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrePayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrePayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrePayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrePayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("creditAmount")) {
      Object obj = map.get("creditAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCreditAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCreditAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCreditAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreditAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreditAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("wxPayAmount")) {
      Object obj = map.get("wxPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWxPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWxPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWxPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWxPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWxPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("aliPayAmount")) {
      Object obj = map.get("aliPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAliPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAliPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAliPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAliPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAliPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("personPayAmount")) {
      Object obj = map.get("personPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPersonPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPersonPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPersonPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPersonPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPersonPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("saleAmount")) {
      Object obj = map.get("saleAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSaleAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSaleAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSaleAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSaleAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSaleAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("insuranceCount")) {
      Object obj = map.get("insuranceCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInsuranceCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInsuranceCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInsuranceCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("insuranceAmount")) {
      Object obj = map.get("insuranceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInsuranceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInsuranceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInsuranceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInsuranceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInsuranceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("incomeAmount")) {
      Object obj = map.get("incomeAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setIncomeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setIncomeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setIncomeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIncomeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIncomeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("realIncomeAmount")) {
      Object obj = map.get("realIncomeAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRealIncomeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRealIncomeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRealIncomeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRealIncomeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRealIncomeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customerRefundFeeAmount")) {
      Object obj = map.get("customerRefundFeeAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerRefundFeeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerRefundFeeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerRefundFeeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerRefundFeeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerRefundFeeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customerRefundRate")) {
      Object obj = map.get("customerRefundRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerRefundRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerRefundRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerRefundRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerRefundRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerRefundRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customerRealRefundAmount")) {
      Object obj = map.get("customerRealRefundAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerRealRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerRealRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerRealRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerRealRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerRealRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refundStatus")) {
      Object obj = map.get("refundStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("originalOrderNo")) {
      Object obj = map.get("originalOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentOrderNo")) {
      Object obj = map.get("parentOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setParentOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderEmployeeNumber")) {
      Object obj = map.get("orderEmployeeNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderEmployeeNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outOfLimitDetail")) {
      Object obj = map.get("outOfLimitDetail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOutOfLimitDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerChangeFeeAmount")) {
      Object obj = map.get("customerChangeFeeAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerChangeFeeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerChangeFeeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerChangeFeeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerChangeFeeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerChangeFeeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customerRefundTicketFeeAmount")) {
      Object obj = map.get("customerRefundTicketFeeAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerRefundTicketFeeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerRefundTicketFeeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerRefundTicketFeeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerRefundTicketFeeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerRefundTicketFeeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expensedStatus")) {
      Object obj = map.get("expensedStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpensedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCodeName")) {
      Object obj = map.get("chargeCodeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCodeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productDetail")) {
      Object obj = map.get("productDetail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tripType")) {
      Object obj = map.get("tripType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTripType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payAccount")) {
      Object obj = map.get("payAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pullTicketType")) {
      Object obj = map.get("pullTicketType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPullTicketType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("insuranceType")) {
      Object obj = map.get("insuranceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInsuranceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refBizType")) {
      Object obj = map.get("refBizType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefBizType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refBizOrderNo")) {
      Object obj = map.get("refBizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scene")) {
      Object obj = map.get("scene");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setScene((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticketStubFee")) {
      Object obj = map.get("ticketStubFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTicketStubFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTicketStubFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTicketStubFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTicketStubFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTicketStubFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("costDepartment")) {
      Object obj = map.get("costDepartment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostDepartment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costRemark")) {
      Object obj = map.get("costRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coupon")) {
      Object obj = map.get("coupon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCoupon((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCoupon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCoupon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCoupon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCoupon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subOrderNo")) {
      Object obj = map.get("subOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticketUnitPrice")) {
      Object obj = map.get("ticketUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTicketUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTicketUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTicketUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTicketUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTicketUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("realUnitPrice")) {
      Object obj = map.get("realUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRealUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRealUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRealUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRealUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRealUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customArchives")) {
      Object obj = map.get("customArchives");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomArchives((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmountAddition")) {
      Object obj = map.get("taxAmountAddition");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmountAddition((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmountAddition(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmountAddition(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmountAddition(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmountAddition(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("trusteeServiceAmount")) {
      Object obj = map.get("trusteeServiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTrusteeServiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTrusteeServiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTrusteeServiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTrusteeServiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTrusteeServiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("postPayServiceAmount")) {
      Object obj = map.get("postPayServiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostPayServiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostPayServiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostPayServiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostPayServiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostPayServiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("accountName")) {
      Object obj = map.get("accountName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redPacket")) {
      Object obj = map.get("redPacket");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRedPacket((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRedPacket(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRedPacket(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedPacket(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedPacket(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxPoint")) {
      Object obj = map.get("taxPoint");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxPoint((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxPoint(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxPoint(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxPoint(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxPoint(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxTypeCode")) {
      Object obj = map.get("taxTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemId")) {
      Object obj = map.get("itemId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeName")) {
      Object obj = map.get("chargeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("productType")) {
      Object obj = map.get("productType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticketStatus")) {
      Object obj = map.get("ticketStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTicketStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizStatus")) {
      Object obj = map.get("bizStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticketNo")) {
      Object obj = map.get("ticketNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTicketNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalTicketNo")) {
      Object obj = map.get("originalTicketNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalTicketNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastTicketNo")) {
      Object obj = map.get("lastTicketNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLastTicketNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("airType")) {
      Object obj = map.get("airType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAirType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("airCode")) {
      Object obj = map.get("airCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAirCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("diningRoomName")) {
      Object obj = map.get("diningRoomName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiningRoomName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flightNumber")) {
      Object obj = map.get("flightNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlightNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("startAddress")) {
      Object obj = map.get("startAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStartAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("endAddress")) {
      Object obj = map.get("endAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEndAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("startTime")) {
      Object obj = map.get("startTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStartTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("endTime")) {
      Object obj = map.get("endTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEndTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seatGrade")) {
      Object obj = map.get("seatGrade");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSeatGrade((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seatType")) {
      Object obj = map.get("seatType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSeatType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("confirmTime")) {
      Object obj = map.get("confirmTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setConfirmTime(null);
      }
    }
    if(map.containsKey("airTicketDiscount")) {
      Object obj = map.get("airTicketDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAirTicketDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAirTicketDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAirTicketDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAirTicketDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAirTicketDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("productCount")) {
      Object obj = map.get("productCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setProductCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProductCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setProductCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("resideDays")) {
      Object obj = map.get("resideDays");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setResideDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setResideDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setResideDays(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("carrier")) {
      Object obj = map.get("carrier");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCarrier((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("airlineCompanyName")) {
      Object obj = map.get("airlineCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAirlineCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyCompanyName")) {
      Object obj = map.get("buyCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyEmployeeName")) {
      Object obj = map.get("buyEmployeeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyEmployeeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyEmployeeOrgName")) {
      Object obj = map.get("buyEmployeeOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyEmployeeOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyEmployeeFullOrgName")) {
      Object obj = map.get("buyEmployeeFullOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyEmployeeFullOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderTime")) {
      Object obj = map.get("orderTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderTime(null);
      }
    }
    if(map.containsKey("payTime")) {
      Object obj = map.get("payTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPayTime(null);
      }
    }
    if(map.containsKey("tripperName")) {
      Object obj = map.get("tripperName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTripperName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tripperCode")) {
      Object obj = map.get("tripperCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTripperCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tripperOrgName")) {
      Object obj = map.get("tripperOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTripperOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tripperFullOrgName")) {
      Object obj = map.get("tripperFullOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTripperFullOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outOfLimit")) {
      Object obj = map.get("outOfLimit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOutOfLimit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outOfLimitReason")) {
      Object obj = map.get("outOfLimitReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOutOfLimitReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refundReason")) {
      Object obj = map.get("refundReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refundReason2")) {
      Object obj = map.get("refundReason2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundReason2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("activityAmount")) {
      Object obj = map.get("activityAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setActivityAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setActivityAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setActivityAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActivityAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setActivityAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("oilAmount")) {
      Object obj = map.get("oilAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOilAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOilAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOilAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOilAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOilAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("airportAmount")) {
      Object obj = map.get("airportAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAirportAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAirportAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAirportAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAirportAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAirportAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("ticketAmount")) {
      Object obj = map.get("ticketAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTicketAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTicketAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTicketAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTicketAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTicketAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("serviceAmount")) {
      Object obj = map.get("serviceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setServiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setServiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setServiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setServiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setServiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("prePayAmount")) {
      Object obj = map.get("prePayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPrePayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPrePayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPrePayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPrePayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPrePayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("creditAmount")) {
      Object obj = map.get("creditAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCreditAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCreditAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCreditAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreditAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreditAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("wxPayAmount")) {
      Object obj = map.get("wxPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setWxPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setWxPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setWxPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWxPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setWxPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("aliPayAmount")) {
      Object obj = map.get("aliPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAliPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAliPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAliPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAliPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAliPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("personPayAmount")) {
      Object obj = map.get("personPayAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPersonPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPersonPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPersonPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPersonPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPersonPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("saleAmount")) {
      Object obj = map.get("saleAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSaleAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSaleAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSaleAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSaleAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSaleAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("insuranceCount")) {
      Object obj = map.get("insuranceCount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInsuranceCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInsuranceCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInsuranceCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("insuranceAmount")) {
      Object obj = map.get("insuranceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInsuranceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInsuranceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInsuranceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInsuranceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInsuranceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("incomeAmount")) {
      Object obj = map.get("incomeAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setIncomeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setIncomeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setIncomeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIncomeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setIncomeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("realIncomeAmount")) {
      Object obj = map.get("realIncomeAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRealIncomeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRealIncomeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRealIncomeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRealIncomeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRealIncomeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customerRefundFeeAmount")) {
      Object obj = map.get("customerRefundFeeAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCustomerRefundFeeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCustomerRefundFeeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCustomerRefundFeeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCustomerRefundFeeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCustomerRefundFeeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customerRefundRate")) {
      Object obj = map.get("customerRefundRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCustomerRefundRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCustomerRefundRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCustomerRefundRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCustomerRefundRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCustomerRefundRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customerRealRefundAmount")) {
      Object obj = map.get("customerRealRefundAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCustomerRealRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCustomerRealRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCustomerRealRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCustomerRealRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCustomerRealRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("refundStatus")) {
      Object obj = map.get("refundStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("originalOrderNo")) {
      Object obj = map.get("originalOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("parentOrderNo")) {
      Object obj = map.get("parentOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setParentOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderEmployeeNumber")) {
      Object obj = map.get("orderEmployeeNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderEmployeeNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outOfLimitDetail")) {
      Object obj = map.get("outOfLimitDetail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOutOfLimitDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerChangeFeeAmount")) {
      Object obj = map.get("customerChangeFeeAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCustomerChangeFeeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCustomerChangeFeeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCustomerChangeFeeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCustomerChangeFeeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCustomerChangeFeeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customerRefundTicketFeeAmount")) {
      Object obj = map.get("customerRefundTicketFeeAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCustomerRefundTicketFeeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCustomerRefundTicketFeeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCustomerRefundTicketFeeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCustomerRefundTicketFeeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCustomerRefundTicketFeeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expensedStatus")) {
      Object obj = map.get("expensedStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpensedStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payType")) {
      Object obj = map.get("payType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeCodeName")) {
      Object obj = map.get("chargeCodeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCodeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productDetail")) {
      Object obj = map.get("productDetail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tripType")) {
      Object obj = map.get("tripType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTripType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payAccount")) {
      Object obj = map.get("payAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pullTicketType")) {
      Object obj = map.get("pullTicketType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPullTicketType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("insuranceType")) {
      Object obj = map.get("insuranceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInsuranceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refBizType")) {
      Object obj = map.get("refBizType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefBizType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refBizOrderNo")) {
      Object obj = map.get("refBizOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scene")) {
      Object obj = map.get("scene");
      if(obj != null) {
        if(obj instanceof String) {
          this.setScene((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticketStubFee")) {
      Object obj = map.get("ticketStubFee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTicketStubFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTicketStubFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTicketStubFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTicketStubFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTicketStubFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("costDepartment")) {
      Object obj = map.get("costDepartment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostDepartment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costRemark")) {
      Object obj = map.get("costRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("coupon")) {
      Object obj = map.get("coupon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCoupon((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCoupon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCoupon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCoupon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCoupon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("subOrderNo")) {
      Object obj = map.get("subOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSubOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticketUnitPrice")) {
      Object obj = map.get("ticketUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTicketUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTicketUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTicketUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTicketUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTicketUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("realUnitPrice")) {
      Object obj = map.get("realUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRealUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRealUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRealUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRealUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRealUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customArchives")) {
      Object obj = map.get("customArchives");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomArchives((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxAmountAddition")) {
      Object obj = map.get("taxAmountAddition");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmountAddition((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmountAddition(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmountAddition(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmountAddition(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmountAddition(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("trusteeServiceAmount")) {
      Object obj = map.get("trusteeServiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTrusteeServiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTrusteeServiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTrusteeServiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTrusteeServiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTrusteeServiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("postPayServiceAmount")) {
      Object obj = map.get("postPayServiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostPayServiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostPayServiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostPayServiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostPayServiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostPayServiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("accountName")) {
      Object obj = map.get("accountName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redPacket")) {
      Object obj = map.get("redPacket");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRedPacket((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRedPacket(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRedPacket(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedPacket(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRedPacket(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxPoint")) {
      Object obj = map.get("taxPoint");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxPoint((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxPoint(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxPoint(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxPoint(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxPoint(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxTypeCode")) {
      Object obj = map.get("taxTypeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemId")) {
      Object obj = map.get("itemId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeName")) {
      Object obj = map.get("chargeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
