package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * charge_code_data
 * </p>
 *
 * @author ultraman
 * @since 2021-11-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChargeCodeData implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 计费代码
   */
  private String chargeCode;
  /**
   * 计费代码名称
   */
  private String chargeCodeName;
  /**
   * 负责人
   */
  private String chargePerson;
  /**
   * 负责人姓名
   */
  private String chargePersonName;
  /**
   * 源名称
   */
  private String orgName;
  /**
   * 使用人
   */
  private String rightsUser;
  /**
   * 角色
   */
  private String rightsRole;
  /**
   * 是否
   */
  private String isDel;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("chargeCode", chargeCode);
      map.put("chargeCodeName", chargeCodeName);
      map.put("chargePerson", chargePerson);
      map.put("chargePersonName", chargePersonName);
      map.put("orgName", orgName);
      map.put("rightsUser", rightsUser);
      map.put("rightsRole", rightsRole);
      map.put("isDel", isDel);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static ChargeCodeData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChargeCodeData entity = new ChargeCodeData();

    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCodeName")) {
      Object obj = map.get("chargeCodeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCodeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargePerson")) {
      Object obj = map.get("chargePerson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargePerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargePersonName")) {
      Object obj = map.get("chargePersonName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargePersonName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orgName")) {
      Object obj = map.get("orgName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rightsUser")) {
      Object obj = map.get("rightsUser");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRightsUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rightsRole")) {
      Object obj = map.get("rightsRole");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRightsRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDel")) {
      Object obj = map.get("isDel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsDel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeCodeName")) {
      Object obj = map.get("chargeCodeName");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeCodeName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargePerson")) {
      Object obj = map.get("chargePerson");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargePerson((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargePersonName")) {
      Object obj = map.get("chargePersonName");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargePersonName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("orgName")) {
      Object obj = map.get("orgName");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrgName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("rightsUser")) {
      Object obj = map.get("rightsUser");
      if(obj != null) {
        if(obj instanceof String){
            this.setRightsUser((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("rightsRole")) {
      Object obj = map.get("rightsRole");
      if(obj != null) {
        if(obj instanceof String){
            this.setRightsRole((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("isDel")) {
      Object obj = map.get("isDel");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsDel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
