package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * contract
 * </p>
 *
 * @author ultraman
 * @since 2021-11-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Contract implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 项目编号
   */
  private String projectNo;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 签约团队
   */
  private String signTeam;
  /**
   * 签署方名称
   */
  private String signatoryName;
  /**
   * 合同有效期约定
   */
  private String periodPromise;
  /**
   * 账期
   */
  private Long paymentPeriod;
  /**
   * 账期性质
   */
  private String paymentPeriodType;
  /**
   * 合同签订日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signDate;
  /**
   * 合同生效日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime effectStartTime;
  /**
   * 验收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiptSignDate;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 是否有质保金
   */
  private String containsRetentionMoney;
  /**
   * 项目ChargeCode
   */
  private String chargeCode;
  /**
   * 合同号
   */
  private String contractId;
  /**
   * 合同到期日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime contractExpiryDate;
  /**
   * 合同类型
   */
  private String contractType;
  /**
   * 合同总金额(含税)
   */
  private BigDecimal contractTotalMoney;
  /**
   * 租户Id
   */
  private String tenantGroupId;
  /**
   * 租户名称
   */
  private String tenantName;
  /**
   * 客户
   */
  private String customer;
  /**
   * 经营单元
   */
  private String businessUnit;
  /**
   * 负责人
   */
  private String principalPerson;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectNo", projectNo);
      map.put("projectName", projectName);
      map.put("signTeam", signTeam);
      map.put("signatoryName", signatoryName);
      map.put("periodPromise", periodPromise);
      map.put("paymentPeriod", paymentPeriod);
      map.put("paymentPeriodType", paymentPeriodType);
      map.put("signDate", BocpGenUtils.toTimestamp(signDate));
      map.put("effectStartTime", BocpGenUtils.toTimestamp(effectStartTime));
      map.put("receiptSignDate", BocpGenUtils.toTimestamp(receiptSignDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("containsRetentionMoney", containsRetentionMoney);
      map.put("chargeCode", chargeCode);
      map.put("contractId", contractId);
      map.put("contractExpiryDate", BocpGenUtils.toTimestamp(contractExpiryDate));
      map.put("contractType", contractType);
      map.put("contractTotalMoney", contractTotalMoney);
      map.put("tenantGroupId", tenantGroupId);
      map.put("tenantName", tenantName);
      map.put("customer", customer);
      map.put("businessUnit", businessUnit);
      map.put("principalPerson", principalPerson);

      return map;
  }

  public static Contract fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Contract entity = new Contract();

    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signTeam")) {
      Object obj = map.get("signTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signatoryName")) {
      Object obj = map.get("signatoryName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignatoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("periodPromise")) {
      Object obj = map.get("periodPromise");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPeriodPromise((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriod")) {
      Object obj = map.get("paymentPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentPeriod((Long)obj);
        } else if(obj instanceof String) {
          entity.setPaymentPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPaymentPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriodType")) {
      Object obj = map.get("paymentPeriodType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentPeriodType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signDate")) {
      Object obj = map.get("signDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignDate(null);
      }
    }
    if(map.containsKey("effectStartTime")) {
      Object obj = map.get("effectStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEffectStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEffectStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEffectStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEffectStartTime(null);
      }
    }
    if(map.containsKey("receiptSignDate")) {
      Object obj = map.get("receiptSignDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiptSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiptSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReceiptSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiptSignDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("containsRetentionMoney")) {
      Object obj = map.get("containsRetentionMoney");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContainsRetentionMoney((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractExpiryDate")) {
      Object obj = map.get("contractExpiryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setContractExpiryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setContractExpiryDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setContractExpiryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setContractExpiryDate(null);
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractTotalMoney")) {
      Object obj = map.get("contractTotalMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setContractTotalMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setContractTotalMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setContractTotalMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setContractTotalMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractTotalMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tenantGroupId")) {
      Object obj = map.get("tenantGroupId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantGroupId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("principalPerson")) {
      Object obj = map.get("principalPerson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrincipalPerson((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setProjectNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProjectName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("signTeam")) {
      Object obj = map.get("signTeam");
      if(obj != null) {
        if(obj instanceof String){
            this.setSignTeam((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("signatoryName")) {
      Object obj = map.get("signatoryName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSignatoryName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("periodPromise")) {
      Object obj = map.get("periodPromise");
      if(obj != null) {
        if(obj instanceof String){
            this.setPeriodPromise((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentPeriod")) {
      Object obj = map.get("paymentPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaymentPeriod((Long)obj);
        } else if(obj instanceof String) {
            this.setPaymentPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPaymentPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("paymentPeriodType")) {
      Object obj = map.get("paymentPeriodType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentPeriodType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("signDate")) {
      Object obj = map.get("signDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSignDate(null);
      }
   }
    if(map.containsKey("effectStartTime")) {
      Object obj = map.get("effectStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEffectStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEffectStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setEffectStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEffectStartTime(null);
      }
   }
    if(map.containsKey("receiptSignDate")) {
      Object obj = map.get("receiptSignDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReceiptSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReceiptSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setReceiptSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReceiptSignDate(null);
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("containsRetentionMoney")) {
      Object obj = map.get("containsRetentionMoney");
      if(obj != null) {
        if(obj instanceof String){
            this.setContainsRetentionMoney((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractExpiryDate")) {
      Object obj = map.get("contractExpiryDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setContractExpiryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setContractExpiryDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setContractExpiryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setContractExpiryDate(null);
      }
   }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractTotalMoney")) {
      Object obj = map.get("contractTotalMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setContractTotalMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setContractTotalMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setContractTotalMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setContractTotalMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setContractTotalMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("tenantGroupId")) {
      Object obj = map.get("tenantGroupId");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantGroupId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String){
            this.setCustomer((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("principalPerson")) {
      Object obj = map.get("principalPerson");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrincipalPerson((String)obj);
        }
      } else{
      }
   }

  }

}
