package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * reconciliation_data
 * </p>
 *
 * @author ultraman
 * @since 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReconciliationData implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 结算对账单号
   */
  private String reconcilationCode;
  /**
   * 对账单结算金额（含税）
   */
  private BigDecimal reconcilationSettleAccounts;
  /**
   * 对账状态
   */
  private String reconcilationStatus;
  /**
   * 质保金
   */
  private String warranty;
  /**
   * 服务收费类型
   */
  private String incomeType;
  /**
   * 实付金额
   */
  private BigDecimal actualMoney;
  /**
   * 结算周期开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;
  /**
   * 结算周期结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;
  /**
   * 结算对账单生成日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reconcilationCreateTime;
  /**
   * 产品名称
   */
  private String productName;
  /**
   * 付费方式
   */
  private String chargeType;
  /**
   * 数量
   */
  private BigDecimal amount;
  /**
   * 发票开具状态	
   */
  private String invoiceStatus;
  /**
   * 折抵/优惠金额	
   */
  private BigDecimal discountMoney;
  /**
   * 是否生成结算统计表
   */
  private String generateStatus;
  /**
   * 租户
   */
  private String tenantName;
  /**
   * 应付金额
   */
  private BigDecimal payableAmount;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 产品代码
   */
  private String productCode;
  /**
   * 结算周期
   */
  private String settlementCycle;
  /**
   * 是否已验收
   */
  private String whetherValidation;
  /**
   * 支付状态
   */
  private String paymentStatus;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 单价
   */
  private BigDecimal unitPriceWithoutTax;
  /**
   * 计价单位
   */
  private String chargeUnit;
  /**
   * 付款条件
   */
  private String paymentRequirement;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("reconcilationCode", reconcilationCode);
      map.put("reconcilationSettleAccounts", reconcilationSettleAccounts);
      map.put("reconcilationStatus", reconcilationStatus);
      map.put("warranty", warranty);
      map.put("incomeType", incomeType);
      map.put("actualMoney", actualMoney);
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("reconcilationCreateTime", BocpGenUtils.toTimestamp(reconcilationCreateTime));
      map.put("productName", productName);
      map.put("chargeType", chargeType);
      map.put("amount", amount);
      map.put("invoiceStatus", invoiceStatus);
      map.put("discountMoney", discountMoney);
      map.put("generateStatus", generateStatus);
      map.put("tenantName", tenantName);
      map.put("payableAmount", payableAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("productCode", productCode);
      map.put("settlementCycle", settlementCycle);
      map.put("whetherValidation", whetherValidation);
      map.put("paymentStatus", paymentStatus);
      map.put("taxRate", taxRate);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("chargeUnit", chargeUnit);
      map.put("paymentRequirement", paymentRequirement);

      return map;
  }

  public static ReconciliationData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReconciliationData entity = new ReconciliationData();

    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reconcilationCode")) {
      Object obj = map.get("reconcilationCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReconcilationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reconcilationSettleAccounts")) {
      Object obj = map.get("reconcilationSettleAccounts");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReconcilationSettleAccounts((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReconcilationSettleAccounts(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReconcilationSettleAccounts(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReconcilationSettleAccounts(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReconcilationSettleAccounts(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reconcilationStatus")) {
      Object obj = map.get("reconcilationStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReconcilationStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warranty")) {
      Object obj = map.get("warranty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarranty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("incomeType")) {
      Object obj = map.get("incomeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIncomeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("actualMoney")) {
      Object obj = map.get("actualMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setActualMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("reconcilationCreateTime")) {
      Object obj = map.get("reconcilationCreateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReconcilationCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReconcilationCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReconcilationCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReconcilationCreateTime(null);
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountMoney")) {
      Object obj = map.get("discountMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("generateStatus")) {
      Object obj = map.get("generateStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGenerateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payableAmount")) {
      Object obj = map.get("payableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPayableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementCycle")) {
      Object obj = map.get("settlementCycle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("whetherValidation")) {
      Object obj = map.get("whetherValidation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWhetherValidation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentRequirement((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reconcilationCode")) {
      Object obj = map.get("reconcilationCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setReconcilationCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reconcilationSettleAccounts")) {
      Object obj = map.get("reconcilationSettleAccounts");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReconcilationSettleAccounts((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReconcilationSettleAccounts(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReconcilationSettleAccounts(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setReconcilationSettleAccounts(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReconcilationSettleAccounts(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("reconcilationStatus")) {
      Object obj = map.get("reconcilationStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setReconcilationStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("warranty")) {
      Object obj = map.get("warranty");
      if(obj != null) {
        if(obj instanceof String){
            this.setWarranty((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("incomeType")) {
      Object obj = map.get("incomeType");
      if(obj != null) {
        if(obj instanceof String){
            this.setIncomeType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("actualMoney")) {
      Object obj = map.get("actualMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setActualMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setActualMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setActualMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setActualMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setActualMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setChargeStartDate(null);
      }
   }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setChargeEndDate(null);
      }
   }
    if(map.containsKey("reconcilationCreateTime")) {
      Object obj = map.get("reconcilationCreateTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReconcilationCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReconcilationCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setReconcilationCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReconcilationCreateTime(null);
      }
   }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("discountMoney")) {
      Object obj = map.get("discountMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setDiscountMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("generateStatus")) {
      Object obj = map.get("generateStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setGenerateStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payableAmount")) {
      Object obj = map.get("payableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPayableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPayableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPayableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPayableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPayableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("settlementCycle")) {
      Object obj = map.get("settlementCycle");
      if(obj != null) {
        if(obj instanceof String){
            this.setSettlementCycle((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("whetherValidation")) {
      Object obj = map.get("whetherValidation");
      if(obj != null) {
        if(obj instanceof String){
            this.setWhetherValidation((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentRequirement((String)obj);
        }
      } else{
      }
   }

  }

}
