package com.xforceplus.ultraman.app.financialsettlement.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;


/**
* 对象元数据
*
* @author ultraman
* @since 2021-11-02
*/
public class EntityMeta {

    public interface ChargeMetaData {
        static Long id() {
            return 1414504703901081602L;
        }
        static String code() {
            return "chargeMetaData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_DIMENSION = new TypedField<>(String.class, "chargeDimension");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> CYCLE = new TypedField<>(String.class, "cycle");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "chargeItem");
        TypedField<String> CHARGE_WATER_CODE = new TypedField<>(String.class, "chargeWaterCode");
        TypedField<String> CHARGE_LABEL = new TypedField<>(String.class, "chargeLabel");
        TypedField<BigDecimal> CHARGE_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> ACTUAL_USAGE = new TypedField<>(BigDecimal.class, "actualUsage");
        TypedField<LocalDateTime> CREATE_DATE = new TypedField<>(LocalDateTime.class, "createDate");
        TypedField<Long> USING_MONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<LocalDateTime> MODIFY_TIME = new TypedField<>(LocalDateTime.class, "modifyTime");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> GENERATE_STATUS = new TypedField<>(String.class, "generateStatus");
        TypedField<String> IS_WARANTY = new TypedField<>(String.class, "isWaranty");
        TypedField<BigDecimal> LIMIT_AMOUNT = new TypedField<>(BigDecimal.class, "limitAmount");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> COMPANY_ID = new TypedField<>(String.class, "companyId");
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        /**
         * 对多关联关系 关联对象 incomeMainMsg
         */
        TypedField<Long> INCOMEMAINMSGONETOMANYCHARGEMETADATA_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.id");

        interface ToOneRel {
            interface INCOMEMAINMSGONETOMANYCHARGEMETADATA {
                static String code () {
                    return "incomeMainMsgOneToManychargeMetaData" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.productName");
                TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.startChargeTime");
                TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.stopChargeTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.delete_flag");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.projectName");
                TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.chargeItem");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.companyName");
                TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.companyTax");
                TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManychargeMetaData.totalMoneyTax");
                TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManychargeMetaData.totalMoneyWithoutTax");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.property");
                TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.settlementStartTime");
                TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.settlementEndTime");
            }
        }
    }
    public interface Costing {
        static Long id() {
            return 1415207897100840961L;
        }
        static String code() {
            return "costing";
        }
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "charge_type");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<BigDecimal> CHARGE_MONEY = new TypedField<>(BigDecimal.class, "charge_money");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<LocalDateTime> OCCURRENCE_TIME = new TypedField<>(LocalDateTime.class, "occurrence_time");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 serviceCost
         */
        TypedField<Long> SERVICECOSTONETOMANYCOST_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.id");

        interface ToOneRel {
            interface SERVICECOSTONETOMANYCOST {
                static String code () {
                    return "serviceCostOneToManyCost" ;
                }
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "serviceCostOneToManyCost.service_type");
                TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.service_code");
                TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.service_name");
                TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.occrency_time");
                TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.divide_code");
                TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "serviceCostOneToManyCost.currency_status");
                TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.cumulative_cost");
                TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.current_cost");
                TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.cumulative_output");
                TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.current_output");
                TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "serviceCostOneToManyCost.accounting_year");
                TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "serviceCostOneToManyCost.accounting_month");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.unit_price");
                TypedField<String> SRV_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.srv_code");
                TypedField<String> SRV_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.srv_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "serviceCostOneToManyCost.delete_flag");
            }
        }
    }
    public interface ChargeCode {
        static Long id() {
            return 1415208266803572738L;
        }
        static String code() {
            return "chargeCode";
        }
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<String> CUSTOMER_CODE = new TypedField<>(String.class, "customer_code");
        TypedField<String> CLASSIFICATION = new TypedField<>(String.class, "classification");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ProjectBasicInfo {
        static Long id() {
            return 1415208663073026050L;
        }
        static String code() {
            return "projectBasicInfo";
        }
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "project_name");
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> TENTANT_NAME = new TypedField<>(String.class, "tentant_name");
        TypedField<String> PRODUCT_MODEL = new TypedField<>(String.class, "product_model");
        TypedField<BigDecimal> COUNT = new TypedField<>(BigDecimal.class, "count");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 unitPrice
         */
        TypedField<Long> PROJECTMANYTOONEUNITPRICE_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.id");

        interface ToOneRel {
            interface PROJECTMANYTOONEUNITPRICE {
                static String code () {
                    return "projectManyToOneUnitPrice" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "projectManyToOneUnitPrice.code");
                TypedField<String> NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.name");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "projectManyToOneUnitPrice.unit_price");
                TypedField<String> UNIT = new TypedField<>(String.class, "projectManyToOneUnitPrice.unit");
                TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.start_time");
                TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.end_time");
                TypedField<String> INPUT_WAY = new TypedField<>(String.class, "projectManyToOneUnitPrice.input_way");
                TypedField<Long> YEAR = new TypedField<>(Long.class, "projectManyToOneUnitPrice.year");
                TypedField<Long> MONTH = new TypedField<>(Long.class, "projectManyToOneUnitPrice.month");
                TypedField<Long> ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "projectManyToOneUnitPrice.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "projectManyToOneUnitPrice.delete_flag");
            }
        }
    }
    public interface ProductAllocation {
        static Long id() {
            return 1415208799121907714L;
        }
        static String code() {
            return "productAllocation";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<LocalDateTime> TIME = new TypedField<>(LocalDateTime.class, "time");
        TypedField<String> NUMBER = new TypedField<>(String.class, "number");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface UnitPrice {
        static Long id() {
            return 1415208953767653377L;
        }
        static String code() {
            return "unitPrice";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> INPUT_WAY = new TypedField<>(String.class, "input_way");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface AllocationRuleDetails {
        static Long id() {
            return 1415209110972604418L;
        }
        static String code() {
            return "allocationRuleDetails";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> ALLOCATION_PROPORTION = new TypedField<>(BigDecimal.class, "allocation_proportion");
        TypedField<BigDecimal> CONSUMPTION = new TypedField<>(BigDecimal.class, "consumption");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        /**
         * 对多关联关系 关联对象 allocationRule
         */
        TypedField<Long> ALLOCATIONRULEONETOMANYRULEDETAIL_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.id");

        interface ToOneRel {
            interface ALLOCATIONRULEONETOMANYRULEDETAIL {
                static String code () {
                    return "allocationRuleOneToManyRuleDetail" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.code");
                TypedField<String> NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.name");
                TypedField<String> ALLOCATION_TYPE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.allocation_type");
                TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.start_time");
                TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.end_time");
                TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.charge_belong");
                TypedField<Long> MONTH = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.month");
                TypedField<Long> ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.delete_flag");
            }
        }
    }
    public interface AllocationRule {
        static Long id() {
            return 1415211734738006018L;
        }
        static String code() {
            return "allocationRule";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> ALLOCATION_TYPE = new TypedField<>(String.class, "allocation_type");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface ChargeCodeMaintain {
        static Long id() {
            return 1415212005962674177L;
        }
        static String code() {
            return "chargeCodeMaintain";
        }
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface InfoBI {
        static Long id() {
            return 1415212818932035585L;
        }
        static String code() {
            return "infoBI";
        }
        TypedField<String> TAX_NUMBER = new TypedField<>(String.class, "tax_number");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> MIDDLE_GROUND_CODE = new TypedField<>(String.class, "middle_ground_code");
        TypedField<BigDecimal> AMOUNT_USAGE = new TypedField<>(BigDecimal.class, "amount_usage");
        TypedField<String> MIDDLE_GROUND_NAME = new TypedField<>(String.class, "middle_ground_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> TENTANT = new TypedField<>(String.class, "tentant");
        TypedField<LocalDateTime> STARTING_TIME = new TypedField<>(LocalDateTime.class, "starting_time");
        TypedField<LocalDateTime> ENDING_TIME = new TypedField<>(LocalDateTime.class, "ending_time");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ServiceCostDetails {
        static Long id() {
            return 1415214963842392066L;
        }
        static String code() {
            return "serviceCostDetails";
        }
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> COST_CODE = new TypedField<>(String.class, "cost_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> COST_TYPE = new TypedField<>(String.class, "cost_type");
        TypedField<String> COST_BELONG = new TypedField<>(String.class, "cost_belong");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<LocalDateTime> OCCURENCY_TIME = new TypedField<>(LocalDateTime.class, "occurency_time");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> COST_NAME = new TypedField<>(String.class, "cost_name");
        TypedField<String> PARENT_CHARGECODE = new TypedField<>(String.class, "parent_chargecode");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 serviceCost
         */
        TypedField<Long> SEVICECOSTONETOMANYDETAIL_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.id");

        interface ToOneRel {
            interface SEVICECOSTONETOMANYDETAIL {
                static String code () {
                    return "seviceCostOneToManyDetail" ;
                }
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_type");
                TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_code");
                TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_name");
                TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.occrency_time");
                TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.divide_code");
                TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "seviceCostOneToManyDetail.currency_status");
                TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.cumulative_cost");
                TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.current_cost");
                TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.cumulative_output");
                TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.current_output");
                TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "seviceCostOneToManyDetail.accounting_year");
                TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "seviceCostOneToManyDetail.accounting_month");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.unit_price");
                TypedField<String> SRV_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.srv_code");
                TypedField<String> SRV_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.srv_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "seviceCostOneToManyDetail.delete_flag");
            }
        }
    }
    public interface ServiceCost {
        static Long id() {
            return 1415215356366331905L;
        }
        static String code() {
            return "serviceCost";
        }
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "occrency_time");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "currency_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> SRV_CODE = new TypedField<>(String.class, "srv_code");
        TypedField<String> SRV_NAME = new TypedField<>(String.class, "srv_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface Income {
        static Long id() {
            return 1415498206489735170L;
        }
        static String code() {
            return "income";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> USE_COMPANY_NAME = new TypedField<>(String.class, "useCompanyName");
        TypedField<String> USE_COMPANYTAX_NO = new TypedField<>(String.class, "useCompanytaxNo");
        TypedField<String> PRODUCT = new TypedField<>(String.class, "product");
        TypedField<String> MODEL_NO = new TypedField<>(String.class, "modelNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<BigDecimal> UNIT = new TypedField<>(BigDecimal.class, "unit");
        TypedField<BigDecimal> RATIO = new TypedField<>(BigDecimal.class, "ratio");
        TypedField<Long> NUMBER = new TypedField<>(Long.class, "number");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> START_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "startChargeDate");
        TypedField<LocalDateTime> END_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "endChargeDate");
        TypedField<Long> USE_MONTH = new TypedField<>(Long.class, "useMonth");
        TypedField<Long> USE_YEAR = new TypedField<>(Long.class, "useYear");
        TypedField<BigDecimal> CUR_INCOME = new TypedField<>(BigDecimal.class, "curIncome");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface SettlementData {
        static Long id() {
            return 1415502111091400706L;
        }
        static String code() {
            return "settlementData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<LocalDateTime> STATEMENT_CREATE_DATE = new TypedField<>(LocalDateTime.class, "statementCreateDate");
        TypedField<String> INVOICE_COMPANY_NAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<String> INVOICE_COMPANY_TAX = new TypedField<>(String.class, "invoiceCompanyTax");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoiceDate");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithoutTax");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithTax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_METHOD = new TypedField<>(String.class, "chargeMethod");
        TypedField<LocalDateTime> ACCEPTANCE_DATE = new TypedField<>(LocalDateTime.class, "acceptanceDate");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<BigDecimal> CHARGE_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithoutTax");
        TypedField<BigDecimal> CHARGE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithTax");
        TypedField<LocalDateTime> RETURN_DATE = new TypedField<>(LocalDateTime.class, "returnDate");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> PAYER_COMPANY = new TypedField<>(String.class, "payerCompany");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<Long> CHARGE_DAYS = new TypedField<>(Long.class, "chargeDays");
        TypedField<BigDecimal> CURRENT_DISCOUNT_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "currentDiscountMoneyWithTax");
        TypedField<BigDecimal> DISCOUNT_LATER_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "discountLaterMoneyWithTax");
        TypedField<BigDecimal> DISCOUNT_LATER_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "discountLaterMoneyWithoutTax");
        /**
         * 对多关联关系 关联对象 settlementMainData
         */
        TypedField<Long> SETTLEMENTMAINDATAONETOMANYSETTLEMENTDATA_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.id");

        interface ToOneRel {
            interface SETTLEMENTMAINDATAONETOMANYSETTLEMENTDATA {
                static String code () {
                    return "settlementMainDataOneToManySettlementData" ;
                }
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.projectName");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.productName");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.chargeRequirement");
                TypedField<BigDecimal> SETTLED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.settledMoneyWithTax");
                TypedField<BigDecimal> WAITING_SETTLE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.waitingSettleMoneyWithTax");
                TypedField<BigDecimal> INVOICED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.invoicedMoneyWithTax");
                TypedField<BigDecimal> RETURNED_MONEY = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.returnedMoney");
                TypedField<Long> ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.delete_flag");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.contractNo");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.chargeEndDate");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.chargeType");
                TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.statementNo");
            }
        }
    }
    public interface Contract {
        static Long id() {
            return 1415514648138260481L;
        }
        static String code() {
            return "contract";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> SIGN_TEAM = new TypedField<>(String.class, "signTeam");
        TypedField<String> SIGNATORY_NAME = new TypedField<>(String.class, "signatoryName");
        TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "periodPromise");
        TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "paymentPeriod");
        TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "paymentPeriodType");
        TypedField<LocalDateTime> SIGN_DATE = new TypedField<>(LocalDateTime.class, "signDate");
        TypedField<LocalDateTime> EFFECT_START_TIME = new TypedField<>(LocalDateTime.class, "effectStartTime");
        TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "receiptSignDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "containsRetentionMoney");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "contractId");
        TypedField<LocalDateTime> CONTRACT_EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "contractExpiryDate");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contractType");
        TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "contractTotalMoney");
        TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "tenantGroupId");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "principalPerson");

        interface ToOneRel {
        }
    }
    public interface Project {
        static Long id() {
            return 1415517014084415490L;
        }
        static String code() {
            return "project";
        }
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> SALE_DIRECTOR_EMAIL = new TypedField<>(String.class, "saleDirectorEmail");
        TypedField<String> SALE_DIRECTOR = new TypedField<>(String.class, "saleDirector");
        TypedField<String> EMAIL = new TypedField<>(String.class, "email");
        TypedField<String> SALE_PRINCIPAL = new TypedField<>(String.class, "salePrincipal");
        TypedField<String> SIGN_TEAM = new TypedField<>(String.class, "signTeam");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ProductFunction {
        static Long id() {
            return 1415519149595336706L;
        }
        static String code() {
            return "productFunction";
        }
        TypedField<String> PRODUCT_NO = new TypedField<>(String.class, "productNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_TYPE = new TypedField<>(String.class, "productType");
        TypedField<String> FUNCTION_TYPE = new TypedField<>(String.class, "functionType");
        TypedField<String> FUNTION_DESC = new TypedField<>(String.class, "funtionDesc");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> PRODUCT_SRV_NAME = new TypedField<>(String.class, "productSrvName");
        TypedField<String> TAX_ED = new TypedField<>(String.class, "taxEd");
        TypedField<String> INVOICE_UNIT = new TypedField<>(String.class, "invoiceUnit");
        TypedField<String> USE_INVOICE_TYPE = new TypedField<>(String.class, "useInvoiceType");
        TypedField<LocalDateTime> SRV_START_DATE = new TypedField<>(LocalDateTime.class, "srvStartDate");
        TypedField<LocalDateTime> SRV_END_DATE = new TypedField<>(LocalDateTime.class, "srvEndDate");
        TypedField<String> CREATE_USER = new TypedField<>(String.class, "createUser");
        TypedField<String> UPDATE_USER = new TypedField<>(String.class, "updateUser");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface IncomeMainMsg {
        static Long id() {
            return 1415957144165621761L;
        }
        static String code() {
            return "incomeMainMsg";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "stopChargeTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "chargeItem");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "totalMoneyTax");
        TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "totalMoneyWithoutTax");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "settlementStartTime");
        TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "settlementEndTime");

        interface ToOneRel {
        }
    }
    public interface ChargeJob {
        static Long id() {
            return 1416945394439102465L;
        }
        static String code() {
            return "chargeJob";
        }
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> INCOME_MAIN_MSG_ID = new TypedField<>(String.class, "incomeMainMsgId");
        TypedField<String> JOB_TYPE = new TypedField<>(String.class, "jobType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELF_ID = new TypedField<>(String.class, "selfId");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> WHETHER_RECEIVED = new TypedField<>(String.class, "whetherReceived");
        TypedField<String> WHETHER_VALIDATE = new TypedField<>(String.class, "whetherValidate");

    }
    public interface IncomeDetail {
        static Long id() {
            return 1422827562209681410L;
        }
        static String code() {
            return "incomeDetail";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<LocalDateTime> START_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "startChargeDate");
        TypedField<LocalDateTime> END_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "endChargeDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> CURRENT_INCOME_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "currentIncomeWithoutTax");
        TypedField<LocalDateTime> ACCEPTANCE_DATE = new TypedField<>(LocalDateTime.class, "acceptanceDate");
        TypedField<String> ACCOUNTING_TIME = new TypedField<>(String.class, "accountingTime");
        TypedField<String> CHARGE_METHOD = new TypedField<>(String.class, "chargeMethod");
        TypedField<String> USING_MONTH = new TypedField<>(String.class, "usingMonth");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        /**
         * 对多关联关系 关联对象 incomeMainMsg
         */
        TypedField<Long> INCOMEMAINMSGONETOMANYINCOMEDETAILMSG_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.id");

        interface ToOneRel {
            interface INCOMEMAINMSGONETOMANYINCOMEDETAILMSG {
                static String code () {
                    return "incomeMainMsgOneToManyincomeDetailMsg" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.productName");
                TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.startChargeTime");
                TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.stopChargeTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.delete_flag");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.projectName");
                TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.chargeItem");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.companyName");
                TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.companyTax");
                TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManyincomeDetailMsg.totalMoneyTax");
                TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManyincomeDetailMsg.totalMoneyWithoutTax");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.property");
                TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.settlementStartTime");
                TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.settlementEndTime");
            }
        }
    }
    public interface InvoiceData {
        static Long id() {
            return 1422867883811573762L;
        }
        static String code() {
            return "invoiceData";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "originalInvoiceCode");
        TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "originalInvoiceNo");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> SELLER_TAX_NAME = new TypedField<>(String.class, "sellerTaxName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> EFFECTIVE_STATUS = new TypedField<>(String.class, "effectiveStatus");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchStatus");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> INVOICE_DATE = new TypedField<>(String.class, "invoiceDate");
        TypedField<BigDecimal> AMOUT_WITH_TAX_UN_MATCHED = new TypedField<>(BigDecimal.class, "amoutWithTaxUnMatched");
        TypedField<BigDecimal> PAYMENT_FLOW = new TypedField<>(BigDecimal.class, "paymentFlow");

    }
    public interface JobList {
        static Long id() {
            return 1425736007619231745L;
        }
        static String code() {
            return "jobList";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> WHETHER_EFFECTIVE = new TypedField<>(String.class, "whetherEffective");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ReconciliationDetailData {
        static Long id() {
            return 1428252466707075073L;
        }
        static String code() {
            return "reconciliationDetailData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> RECONCILIATION_DETAIL_CODE = new TypedField<>(String.class, "reconciliationDetailCode");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_I_D = new TypedField<>(String.class, "companyID");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> BUSINESS_DIMENSION = new TypedField<>(String.class, "businessDimension");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<LocalDateTime> RECONCILIATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconciliationCreateTime");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<BigDecimal> RECONCILIATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "reconciliationSettleAccounts");
        TypedField<BigDecimal> USAGE = new TypedField<>(BigDecimal.class, "usage");
        TypedField<String> ONE_TIME_UNIT = new TypedField<>(String.class, "oneTimeUnit");

    }
    public interface ReconciliationAndInvoiceRelation {
        static Long id() {
            return 1428562157585108994L;
        }
        static String code() {
            return "reconciliationAndInvoiceRelation";
        }
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ReconciliationData {
        static Long id() {
            return 1429648136449986561L;
        }
        static String code() {
            return "reconciliationData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<BigDecimal> RECONCILATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "reconcilationSettleAccounts");
        TypedField<String> RECONCILATION_STATUS = new TypedField<>(String.class, "reconcilationStatus");
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<BigDecimal> ACTUAL_MONEY = new TypedField<>(BigDecimal.class, "actualMoney");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<LocalDateTime> RECONCILATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconcilationCreateTime");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<String> GENERATE_STATUS = new TypedField<>(String.class, "generateStatus");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlementCycle");
        TypedField<String> WHETHER_VALIDATION = new TypedField<>(String.class, "whetherValidation");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");

    }
    public interface ChargeCodeData {
        static Long id() {
            return 1430426677404307458L;
        }
        static String code() {
            return "chargeCodeData";
        }
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CHARGE_CODE_NAME = new TypedField<>(String.class, "chargeCodeName");
        TypedField<String> CHARGE_PERSON = new TypedField<>(String.class, "chargePerson");
        TypedField<String> CHARGE_PERSON_NAME = new TypedField<>(String.class, "chargePersonName");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "orgName");
        TypedField<String> RIGHTS_USER = new TypedField<>(String.class, "rightsUser");
        TypedField<String> RIGHTS_ROLE = new TypedField<>(String.class, "rightsRole");
        TypedField<String> IS_DEL = new TypedField<>(String.class, "isDel");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface SettlementMainData {
        static Long id() {
            return 1432542303681417217L;
        }
        static String code() {
            return "settlementMainData";
        }
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "chargeRequirement");
        TypedField<BigDecimal> SETTLED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settledMoneyWithTax");
        TypedField<BigDecimal> WAITING_SETTLE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "waitingSettleMoneyWithTax");
        TypedField<BigDecimal> INVOICED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "invoicedMoneyWithTax");
        TypedField<BigDecimal> RETURNED_MONEY = new TypedField<>(BigDecimal.class, "returnedMoney");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");

        interface ToOneRel {
        }
    }
    public interface PayWater {
        static Long id() {
            return 1433255154737909761L;
        }
        static String code() {
            return "payWater";
        }
        TypedField<LocalDateTime> TRADE_TIME = new TypedField<>(LocalDateTime.class, "tradeTime");
        TypedField<BigDecimal> DEBIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "debitMoneyAmount");
        TypedField<BigDecimal> CREDIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "creditMoneyAmount");
        TypedField<String> BANK_NAME = new TypedField<>(String.class, "bankName");
        TypedField<String> BANK_ACCOUNT = new TypedField<>(String.class, "bankAccount");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface StatisticBusinessUsage {
        static Long id() {
            return 1434914546386120706L;
        }
        static String code() {
            return "statisticBusinessUsage";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlementCycle");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> BUSINESS_DIMENSION = new TypedField<>(String.class, "businessDimension");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> BUSINESS_TIME = new TypedField<>(String.class, "businessTime");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface SettlementDetailAndInvoiceRelation {
        static Long id() {
            return 1437620316654374914L;
        }
        static String code() {
            return "settlementDetailAndInvoiceRelation";
        }
        TypedField<String> SETTLEMENT_DETAIL_CODE = new TypedField<>(String.class, "settlementDetailCode");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_STUTAS = new TypedField<>(String.class, "invoiceStutas");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface RecordTable {
        static Long id() {
            return 1451184261675716610L;
        }
        static String code() {
            return "recordTable";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<BigDecimal> RECONCILIATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "reconciliationSettleAccounts");
        TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "reconciliationStatus");
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<BigDecimal> ACTUAL_MONEY = new TypedField<>(BigDecimal.class, "actualMoney");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<LocalDateTime> RECONCILIATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconciliationCreateTime");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlementCycle");
        TypedField<String> WHETHER_VALIDATION = new TypedField<>(String.class, "whetherValidation");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> RECONCILIATION_DETAIL_CODE = new TypedField<>(String.class, "reconciliationDetailCode");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_I_D = new TypedField<>(String.class, "companyID");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> BUSINESS_DIMENSION = new TypedField<>(String.class, "businessDimension");
        TypedField<BigDecimal> USAGE = new TypedField<>(BigDecimal.class, "usage");
        TypedField<String> COMPRESS = new TypedField<>(String.class, "compress");

    }
    public interface ContractDetail {
        static Long id() {
            return 1455020711739621378L;
        }
        static String code() {
            return "contractDetail";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "chargeRequirement");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> VALIDATION = new TypedField<>(String.class, "validation");
        /**
         * 对多关联关系 关联对象 contract
         */
        TypedField<Long> ONECONTRACTMAINTOMANYCONTRACTDETAIL_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.id");

        interface ToOneRel {
            interface ONECONTRACTMAINTOMANYCONTRACTDETAIL {
                static String code () {
                    return "oneContractMainToManyContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.projectName");
                TypedField<String> SIGN_TEAM = new TypedField<>(String.class, "oneContractMainToManyContractDetail.signTeam");
                TypedField<String> SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.signatoryName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.paymentPeriodType");
                TypedField<LocalDateTime> SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.signDate");
                TypedField<LocalDateTime> EFFECT_START_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.effectStartTime");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.receiptSignDate");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneContractMainToManyContractDetail.delete_flag");
                TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "oneContractMainToManyContractDetail.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.chargeCode");
                TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractId");
                TypedField<LocalDateTime> CONTRACT_EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.contractExpiryDate");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "oneContractMainToManyContractDetail.contractTotalMoney");
                TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.tenantGroupId");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.tenantName");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneContractMainToManyContractDetail.customer");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneContractMainToManyContractDetail.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneContractMainToManyContractDetail.principalPerson");
            }
        }
    }
    public interface TaxNoList {
        static Long id() {
            return 1455075594576560130L;
        }
        static String code() {
            return "taxNoList";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_STATUS = new TypedField<>(String.class, "taxStatus");
        TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<LocalDateTime> STOP_TIME = new TypedField<>(LocalDateTime.class, "stopTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 contract
         */
        TypedField<Long> ONECONTRACTMAINTOMANYTAXNOLIST_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.id");

        interface ToOneRel {
            interface ONECONTRACTMAINTOMANYTAXNOLIST {
                static String code () {
                    return "oneContractMainToManyTaxNoList" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.projectName");
                TypedField<String> SIGN_TEAM = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.signTeam");
                TypedField<String> SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.signatoryName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.paymentPeriodType");
                TypedField<LocalDateTime> SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.signDate");
                TypedField<LocalDateTime> EFFECT_START_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.effectStartTime");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.receiptSignDate");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.delete_flag");
                TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.chargeCode");
                TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractId");
                TypedField<LocalDateTime> CONTRACT_EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.contractExpiryDate");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "oneContractMainToManyTaxNoList.contractTotalMoney");
                TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.tenantGroupId");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.tenantName");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.customer");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.principalPerson");
            }
        }
    }
    public interface ContractRawData {
        static Long id() {
            return 1455449612420874242L;
        }
        static String code() {
            return "contractRawData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "tenantGroupId");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> JSON_STR = new TypedField<>(String.class, "jsonStr");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
}
