package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 质保金类型
 * </p>
 *
 * @author ultraman
 * @since 2021-11-05
 */
public enum WarrantyType {

    NO_GUARANTEE("noGuarantee", "非质保金"),
    GUARANTEE("guarantee", "质保金");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WarrantyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WarrantyType fromCode(String code){
        switch(code) {
            case "noGuarantee":
                return NO_GUARANTEE;
            case "guarantee":
                return GUARANTEE;
            default:
                return null;
        }
    }
}
