package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * charge_code_pool
 * </p>
 *
 * @author ultraman
 * @since 2021-11-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChargeCodePool implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 编号
   */
  private String ccCode;
  /**
   * 名称
   */
  private String ccName;
  /**
   * 类型
   */
  private String ccType;
  /**
   * 负责人
   */
  private String owner;
  /**
   * 被授权人
   */
  private String authorizedMembers;
  /**
   * code关系
   */
  private String relationCodes;
  /**
   * 大区
   */
  private String district;
  /**
   * 经营单元
   */
  private String bizUnit;
  /**
   * 直属领导
   */
  private String primaryLeader;
  /**
   * 状态
   */
  private String ccStatus;
  /**
   * 扩展标签
   */
  private String extensionTag;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ccCode", ccCode);
      map.put("ccName", ccName);
      map.put("ccType", ccType);
      map.put("owner", owner);
      map.put("authorizedMembers", authorizedMembers);
      map.put("relationCodes", relationCodes);
      map.put("district", district);
      map.put("bizUnit", bizUnit);
      map.put("primaryLeader", primaryLeader);
      map.put("ccStatus", ccStatus);
      map.put("extensionTag", extensionTag);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static ChargeCodePool fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChargeCodePool entity = new ChargeCodePool();

    if(map.containsKey("ccCode")) {
      Object obj = map.get("ccCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCcCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccName")) {
      Object obj = map.get("ccName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCcName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccType")) {
      Object obj = map.get("ccType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCcType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("owner")) {
      Object obj = map.get("owner");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwner((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authorizedMembers")) {
      Object obj = map.get("authorizedMembers");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthorizedMembers((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relationCodes")) {
      Object obj = map.get("relationCodes");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelationCodes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("district")) {
      Object obj = map.get("district");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDistrict((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizUnit")) {
      Object obj = map.get("bizUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBizUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("primaryLeader")) {
      Object obj = map.get("primaryLeader");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryLeader((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccStatus")) {
      Object obj = map.get("ccStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCcStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extensionTag")) {
      Object obj = map.get("extensionTag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtensionTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("ccCode")) {
      Object obj = map.get("ccCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setCcCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ccName")) {
      Object obj = map.get("ccName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCcName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ccType")) {
      Object obj = map.get("ccType");
      if(obj != null) {
        if(obj instanceof String){
            this.setCcType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("owner")) {
      Object obj = map.get("owner");
      if(obj != null) {
        if(obj instanceof String){
            this.setOwner((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("authorizedMembers")) {
      Object obj = map.get("authorizedMembers");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthorizedMembers((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("relationCodes")) {
      Object obj = map.get("relationCodes");
      if(obj != null) {
        if(obj instanceof String){
            this.setRelationCodes((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("district")) {
      Object obj = map.get("district");
      if(obj != null) {
        if(obj instanceof String){
            this.setDistrict((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bizUnit")) {
      Object obj = map.get("bizUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setBizUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("primaryLeader")) {
      Object obj = map.get("primaryLeader");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrimaryLeader((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ccStatus")) {
      Object obj = map.get("ccStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setCcStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("extensionTag")) {
      Object obj = map.get("extensionTag");
      if(obj != null) {
        if(obj instanceof String){
            this.setExtensionTag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
