package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 收费方式
 * </p>
 *
 * @author ultraman
 * @since 2021-11-23
 */
public enum ChargeType {

    PRE_PAID("prePaid", "预收"),
    POST_PAID("postPaid", "后付"),
    CONTRACT_PAID("contractPaid", "按合同付");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeType fromCode(String code){
        switch(code) {
            case "prePaid":
                return PRE_PAID;
            case "postPaid":
                return POST_PAID;
            case "contractPaid":
                return CONTRACT_PAID;
            default:
                return null;
        }
    }
}
