package com.xforceplus.ultraman.app.financialsettlement.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;


/**
* 对象元数据
*
* @author ultraman
* @since 2021-11-23
*/
public class EntityMeta {

    public interface ChargeMetaData {
        static Long id() {
            return 1414504703901081602L;
        }
        static String code() {
            return "chargeMetaData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_DIMENSION = new TypedField<>(String.class, "chargeDimension");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "chargeItem");
        TypedField<String> CHARGE_LABEL = new TypedField<>(String.class, "chargeLabel");
        TypedField<BigDecimal> CHARGE_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> ACTUAL_USAGE = new TypedField<>(BigDecimal.class, "actualUsage");
        TypedField<Long> USING_MONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> IS_WARANTY = new TypedField<>(String.class, "isWaranty");
        TypedField<BigDecimal> LIMIT_AMOUNT = new TypedField<>(BigDecimal.class, "limitAmount");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> COMPANY_ID = new TypedField<>(String.class, "companyId");
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "settlementStartTime");
        TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "settlementEndTime");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        /**
         * 对多关联关系 关联对象 incomeMainMsg
         */
        TypedField<Long> INCOMEMAINMSGONETOMANYCHARGEMETADATA_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.id");

        interface ToOneRel {
            interface INCOMEMAINMSGONETOMANYCHARGEMETADATA {
                static String code () {
                    return "incomeMainMsgOneToManychargeMetaData" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.productName");
                TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.startChargeTime");
                TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.stopChargeTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.delete_flag");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.projectName");
                TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.chargeItem");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.companyName");
                TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.companyTax");
                TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManychargeMetaData.totalMoneyTax");
                TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManychargeMetaData.totalMoneyWithoutTax");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.property");
                TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.settlementStartTime");
                TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.settlementEndTime");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.productCode");
            }
        }
    }
    public interface Costing {
        static Long id() {
            return 1415207897100840961L;
        }
        static String code() {
            return "costing";
        }
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "charge_type");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<BigDecimal> CHARGE_MONEY = new TypedField<>(BigDecimal.class, "charge_money");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<LocalDateTime> OCCURRENCE_TIME = new TypedField<>(LocalDateTime.class, "occurrence_time");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 serviceCost
         */
        TypedField<Long> SERVICECOSTONETOMANYCOST_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.id");

        interface ToOneRel {
            interface SERVICECOSTONETOMANYCOST {
                static String code () {
                    return "serviceCostOneToManyCost" ;
                }
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "serviceCostOneToManyCost.service_type");
                TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.service_code");
                TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.service_name");
                TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.occrency_time");
                TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.divide_code");
                TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "serviceCostOneToManyCost.currency_status");
                TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.cumulative_cost");
                TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.current_cost");
                TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.cumulative_output");
                TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.current_output");
                TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "serviceCostOneToManyCost.accounting_year");
                TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "serviceCostOneToManyCost.accounting_month");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.unit_price");
                TypedField<String> SRV_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.srv_code");
                TypedField<String> SRV_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.srv_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "serviceCostOneToManyCost.delete_flag");
            }
        }
    }
    public interface ChargeCode {
        static Long id() {
            return 1415208266803572738L;
        }
        static String code() {
            return "chargeCode";
        }
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<String> CUSTOMER_CODE = new TypedField<>(String.class, "customer_code");
        TypedField<String> CLASSIFICATION = new TypedField<>(String.class, "classification");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ProjectBasicInfo {
        static Long id() {
            return 1415208663073026050L;
        }
        static String code() {
            return "projectBasicInfo";
        }
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "project_name");
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> TENTANT_NAME = new TypedField<>(String.class, "tentant_name");
        TypedField<String> PRODUCT_MODEL = new TypedField<>(String.class, "product_model");
        TypedField<BigDecimal> COUNT = new TypedField<>(BigDecimal.class, "count");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 unitPrice
         */
        TypedField<Long> PROJECTMANYTOONEUNITPRICE_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.id");

        interface ToOneRel {
            interface PROJECTMANYTOONEUNITPRICE {
                static String code () {
                    return "projectManyToOneUnitPrice" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "projectManyToOneUnitPrice.code");
                TypedField<String> NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.name");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "projectManyToOneUnitPrice.unit_price");
                TypedField<String> UNIT = new TypedField<>(String.class, "projectManyToOneUnitPrice.unit");
                TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.start_time");
                TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.end_time");
                TypedField<String> INPUT_WAY = new TypedField<>(String.class, "projectManyToOneUnitPrice.input_way");
                TypedField<Long> YEAR = new TypedField<>(Long.class, "projectManyToOneUnitPrice.year");
                TypedField<Long> MONTH = new TypedField<>(Long.class, "projectManyToOneUnitPrice.month");
                TypedField<Long> ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "projectManyToOneUnitPrice.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "projectManyToOneUnitPrice.delete_flag");
            }
        }
    }
    public interface ProductAllocation {
        static Long id() {
            return 1415208799121907714L;
        }
        static String code() {
            return "productAllocation";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<LocalDateTime> TIME = new TypedField<>(LocalDateTime.class, "time");
        TypedField<String> NUMBER = new TypedField<>(String.class, "number");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface UnitPrice {
        static Long id() {
            return 1415208953767653377L;
        }
        static String code() {
            return "unitPrice";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> INPUT_WAY = new TypedField<>(String.class, "input_way");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface AllocationRuleDetails {
        static Long id() {
            return 1415209110972604418L;
        }
        static String code() {
            return "allocationRuleDetails";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> ALLOCATION_PROPORTION = new TypedField<>(BigDecimal.class, "allocation_proportion");
        TypedField<BigDecimal> CONSUMPTION = new TypedField<>(BigDecimal.class, "consumption");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        /**
         * 对多关联关系 关联对象 allocationRule
         */
        TypedField<Long> ALLOCATIONRULEONETOMANYRULEDETAIL_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.id");

        interface ToOneRel {
            interface ALLOCATIONRULEONETOMANYRULEDETAIL {
                static String code () {
                    return "allocationRuleOneToManyRuleDetail" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.code");
                TypedField<String> NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.name");
                TypedField<String> ALLOCATION_TYPE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.allocation_type");
                TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.start_time");
                TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.end_time");
                TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.charge_belong");
                TypedField<Long> MONTH = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.month");
                TypedField<Long> ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.delete_flag");
            }
        }
    }
    public interface AllocationRule {
        static Long id() {
            return 1415211734738006018L;
        }
        static String code() {
            return "allocationRule";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> ALLOCATION_TYPE = new TypedField<>(String.class, "allocation_type");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface ChargeCodeMaintain {
        static Long id() {
            return 1415212005962674177L;
        }
        static String code() {
            return "chargeCodeMaintain";
        }
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface InfoBI {
        static Long id() {
            return 1415212818932035585L;
        }
        static String code() {
            return "infoBI";
        }
        TypedField<String> TAX_NUMBER = new TypedField<>(String.class, "tax_number");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> MIDDLE_GROUND_CODE = new TypedField<>(String.class, "middle_ground_code");
        TypedField<BigDecimal> AMOUNT_USAGE = new TypedField<>(BigDecimal.class, "amount_usage");
        TypedField<String> MIDDLE_GROUND_NAME = new TypedField<>(String.class, "middle_ground_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> TENTANT = new TypedField<>(String.class, "tentant");
        TypedField<LocalDateTime> STARTING_TIME = new TypedField<>(LocalDateTime.class, "starting_time");
        TypedField<LocalDateTime> ENDING_TIME = new TypedField<>(LocalDateTime.class, "ending_time");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ServiceCostDetails {
        static Long id() {
            return 1415214963842392066L;
        }
        static String code() {
            return "serviceCostDetails";
        }
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> COST_CODE = new TypedField<>(String.class, "cost_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> COST_TYPE = new TypedField<>(String.class, "cost_type");
        TypedField<String> COST_BELONG = new TypedField<>(String.class, "cost_belong");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<LocalDateTime> OCCURENCY_TIME = new TypedField<>(LocalDateTime.class, "occurency_time");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> COST_NAME = new TypedField<>(String.class, "cost_name");
        TypedField<String> PARENT_CHARGECODE = new TypedField<>(String.class, "parent_chargecode");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 serviceCost
         */
        TypedField<Long> SEVICECOSTONETOMANYDETAIL_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.id");

        interface ToOneRel {
            interface SEVICECOSTONETOMANYDETAIL {
                static String code () {
                    return "seviceCostOneToManyDetail" ;
                }
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_type");
                TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_code");
                TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_name");
                TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.occrency_time");
                TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.divide_code");
                TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "seviceCostOneToManyDetail.currency_status");
                TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.cumulative_cost");
                TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.current_cost");
                TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.cumulative_output");
                TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.current_output");
                TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "seviceCostOneToManyDetail.accounting_year");
                TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "seviceCostOneToManyDetail.accounting_month");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.unit_price");
                TypedField<String> SRV_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.srv_code");
                TypedField<String> SRV_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.srv_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "seviceCostOneToManyDetail.delete_flag");
            }
        }
    }
    public interface ServiceCost {
        static Long id() {
            return 1415215356366331905L;
        }
        static String code() {
            return "serviceCost";
        }
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "occrency_time");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "currency_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> SRV_CODE = new TypedField<>(String.class, "srv_code");
        TypedField<String> SRV_NAME = new TypedField<>(String.class, "srv_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface Income {
        static Long id() {
            return 1415498206489735170L;
        }
        static String code() {
            return "income";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> USE_COMPANY_NAME = new TypedField<>(String.class, "useCompanyName");
        TypedField<String> USE_COMPANYTAX_NO = new TypedField<>(String.class, "useCompanytaxNo");
        TypedField<String> PRODUCT = new TypedField<>(String.class, "product");
        TypedField<String> MODEL_NO = new TypedField<>(String.class, "modelNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<BigDecimal> UNIT = new TypedField<>(BigDecimal.class, "unit");
        TypedField<BigDecimal> RATIO = new TypedField<>(BigDecimal.class, "ratio");
        TypedField<Long> NUMBER = new TypedField<>(Long.class, "number");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> START_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "startChargeDate");
        TypedField<LocalDateTime> END_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "endChargeDate");
        TypedField<Long> USE_MONTH = new TypedField<>(Long.class, "useMonth");
        TypedField<Long> USE_YEAR = new TypedField<>(Long.class, "useYear");
        TypedField<BigDecimal> CUR_INCOME = new TypedField<>(BigDecimal.class, "curIncome");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface SettlementData {
        static Long id() {
            return 1415502111091400706L;
        }
        static String code() {
            return "settlementData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<LocalDateTime> STATEMENT_CREATE_DATE = new TypedField<>(LocalDateTime.class, "statementCreateDate");
        TypedField<String> INVOICE_COMPANY_NAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<String> INVOICE_COMPANY_TAX = new TypedField<>(String.class, "invoiceCompanyTax");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoiceDate");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithoutTax");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithTax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_METHOD = new TypedField<>(String.class, "chargeMethod");
        TypedField<LocalDateTime> ACCEPTANCE_DATE = new TypedField<>(LocalDateTime.class, "acceptanceDate");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<BigDecimal> CHARGE_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithoutTax");
        TypedField<BigDecimal> CHARGE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithTax");
        TypedField<LocalDateTime> RETURN_DATE = new TypedField<>(LocalDateTime.class, "returnDate");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> PAYER_COMPANY = new TypedField<>(String.class, "payerCompany");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<Long> CHARGE_DAYS = new TypedField<>(Long.class, "chargeDays");
        TypedField<BigDecimal> CURRENT_DISCOUNT_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "currentDiscountMoneyWithTax");
        TypedField<BigDecimal> DISCOUNT_LATER_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "discountLaterMoneyWithTax");
        TypedField<BigDecimal> DISCOUNT_LATER_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "discountLaterMoneyWithoutTax");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<LocalDateTime> ORDER_GENERATE_DATE = new TypedField<>(LocalDateTime.class, "orderGenerateDate");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        /**
         * 对多关联关系 关联对象 settlementMainData
         */
        TypedField<Long> SETTLEMENTMAINDATAONETOMANYSETTLEMENTDATA_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.id");
        /**
         * 对多关联关系 关联对象 reconciliationDetailData
         */
        TypedField<Long> ONESETTLEMENTDETAILTOONERECONCILIATIONDETAIL_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.id");

        interface ToOneRel {
            interface SETTLEMENTMAINDATAONETOMANYSETTLEMENTDATA {
                static String code () {
                    return "settlementMainDataOneToManySettlementData" ;
                }
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.projectName");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.productName");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.chargeRequirement");
                TypedField<BigDecimal> SETTLED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.settledMoneyWithTax");
                TypedField<BigDecimal> WAITING_SETTLE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.waitingSettleMoneyWithTax");
                TypedField<BigDecimal> INVOICED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.invoicedMoneyWithTax");
                TypedField<BigDecimal> RETURNED_MONEY = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.returnedMoney");
                TypedField<Long> ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.delete_flag");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.contractNo");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.chargeEndDate");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.chargeType");
                TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.statementNo");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.customer");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.principalPerson");
                TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.tenantGroupId");
                TypedField<BigDecimal> ORDER_TOTAL_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.orderTotalMoneyWithTax");
                TypedField<String> REGION = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.region");
                TypedField<String> REGION_ID = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.regionId");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.productCode");
            }
            interface ONESETTLEMENTDETAILTOONERECONCILIATIONDETAIL {
                static String code () {
                    return "oneSettlementDetailToOneReconciliationDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.contractNo");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.tenantName");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.productName");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.chargeEndDate");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.chargeType");
                TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.payableAmount");
                TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.discountMoney");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.amount");
                TypedField<String> RECONCILIATION_DETAIL_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationDetailCode");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.projectNo");
                TypedField<String> TAX_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.taxNo");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.companyName");
                TypedField<String> COMPANY_I_D = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.companyID");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.billingType");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.unitPriceWithoutTax");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.taxRate");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.delete_flag");
                TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationCode");
                TypedField<LocalDateTime> RECONCILIATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationCreateTime");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.productCode");
                TypedField<BigDecimal> RECONCILIATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationSettleAccounts");
                TypedField<String> ONE_TIME_UNIT = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.oneTimeUnit");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.chargeCycle");
            }
        }
    }
    public interface Contract {
        static Long id() {
            return 1415514648138260481L;
        }
        static String code() {
            return "contract";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> SIGN_TEAM = new TypedField<>(String.class, "signTeam");
        TypedField<String> SIGNATORY_NAME = new TypedField<>(String.class, "signatoryName");
        TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "periodPromise");
        TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "paymentPeriod");
        TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "paymentPeriodType");
        TypedField<LocalDateTime> SIGN_DATE = new TypedField<>(LocalDateTime.class, "signDate");
        TypedField<LocalDateTime> EFFECT_START_TIME = new TypedField<>(LocalDateTime.class, "effectStartTime");
        TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "receiptSignDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "containsRetentionMoney");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "chargeCode");
        TypedField<LocalDateTime> CONTRACT_EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "contractExpiryDate");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contractType");
        TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "contractTotalMoney");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "tenantGroupId");
        TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "chargeContractId");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> REGION_ID = new TypedField<>(String.class, "regionId");
        TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "saChargeCode");
        TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "saChargeCodeName");

        interface ToOneRel {
        }
    }
    public interface Project {
        static Long id() {
            return 1415517014084415490L;
        }
        static String code() {
            return "project";
        }
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> SALE_DIRECTOR_EMAIL = new TypedField<>(String.class, "saleDirectorEmail");
        TypedField<String> SALE_DIRECTOR = new TypedField<>(String.class, "saleDirector");
        TypedField<String> EMAIL = new TypedField<>(String.class, "email");
        TypedField<String> SALE_PRINCIPAL = new TypedField<>(String.class, "salePrincipal");
        TypedField<String> SIGN_TEAM = new TypedField<>(String.class, "signTeam");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ProductFunction {
        static Long id() {
            return 1415519149595336706L;
        }
        static String code() {
            return "productFunction";
        }
        TypedField<String> PRODUCT_NO = new TypedField<>(String.class, "productNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_TYPE = new TypedField<>(String.class, "productType");
        TypedField<String> FUNCTION_TYPE = new TypedField<>(String.class, "functionType");
        TypedField<String> FUNTION_DESC = new TypedField<>(String.class, "funtionDesc");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> PRODUCT_SRV_NAME = new TypedField<>(String.class, "productSrvName");
        TypedField<String> TAX_ED = new TypedField<>(String.class, "taxEd");
        TypedField<String> INVOICE_UNIT = new TypedField<>(String.class, "invoiceUnit");
        TypedField<String> USE_INVOICE_TYPE = new TypedField<>(String.class, "useInvoiceType");
        TypedField<LocalDateTime> SRV_START_DATE = new TypedField<>(LocalDateTime.class, "srvStartDate");
        TypedField<LocalDateTime> SRV_END_DATE = new TypedField<>(LocalDateTime.class, "srvEndDate");
        TypedField<String> CREATE_USER = new TypedField<>(String.class, "createUser");
        TypedField<String> UPDATE_USER = new TypedField<>(String.class, "updateUser");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface IncomeMainMsg {
        static Long id() {
            return 1415957144165621761L;
        }
        static String code() {
            return "incomeMainMsg";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "stopChargeTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "chargeItem");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "totalMoneyTax");
        TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "totalMoneyWithoutTax");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "settlementStartTime");
        TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "settlementEndTime");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");

        interface ToOneRel {
        }
    }
    public interface ChargeJob {
        static Long id() {
            return 1416945394439102465L;
        }
        static String code() {
            return "chargeJob";
        }
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> INCOME_MAIN_MSG_ID = new TypedField<>(String.class, "incomeMainMsgId");
        TypedField<String> JOB_TYPE = new TypedField<>(String.class, "jobType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELF_ID = new TypedField<>(String.class, "selfId");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> WHETHER_RECEIVED = new TypedField<>(String.class, "whetherReceived");
        TypedField<String> WHETHER_VALIDATE = new TypedField<>(String.class, "whetherValidate");

    }
    public interface IncomeDetail {
        static Long id() {
            return 1422827562209681410L;
        }
        static String code() {
            return "incomeDetail";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<LocalDateTime> START_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "startChargeDate");
        TypedField<LocalDateTime> END_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "endChargeDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> CURRENT_INCOME_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "currentIncomeWithoutTax");
        TypedField<LocalDateTime> ACCEPTANCE_DATE = new TypedField<>(LocalDateTime.class, "acceptanceDate");
        TypedField<String> ACCOUNTING_TIME = new TypedField<>(String.class, "accountingTime");
        TypedField<String> CHARGE_METHOD = new TypedField<>(String.class, "chargeMethod");
        TypedField<String> USING_MONTH = new TypedField<>(String.class, "usingMonth");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> REGION_ID = new TypedField<>(String.class, "regionId");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        /**
         * 对多关联关系 关联对象 incomeMainMsg
         */
        TypedField<Long> INCOMEMAINMSGONETOMANYINCOMEDETAILMSG_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.id");

        interface ToOneRel {
            interface INCOMEMAINMSGONETOMANYINCOMEDETAILMSG {
                static String code () {
                    return "incomeMainMsgOneToManyincomeDetailMsg" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.productName");
                TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.startChargeTime");
                TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.stopChargeTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.delete_flag");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.projectName");
                TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.chargeItem");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.companyName");
                TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.companyTax");
                TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManyincomeDetailMsg.totalMoneyTax");
                TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManyincomeDetailMsg.totalMoneyWithoutTax");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.property");
                TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.settlementStartTime");
                TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.settlementEndTime");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.productCode");
            }
        }
    }
    public interface InvoiceData {
        static Long id() {
            return 1422867883811573762L;
        }
        static String code() {
            return "invoiceData";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "originalInvoiceCode");
        TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "originalInvoiceNo");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> SELLER_TAX_NAME = new TypedField<>(String.class, "sellerTaxName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> EFFECTIVE_STATUS = new TypedField<>(String.class, "effectiveStatus");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchStatus");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> INVOICE_DATE = new TypedField<>(String.class, "invoiceDate");
        TypedField<BigDecimal> AMOUT_WITH_TAX_UN_MATCHED = new TypedField<>(BigDecimal.class, "amoutWithTaxUnMatched");
        TypedField<BigDecimal> PAYMENT_FLOW = new TypedField<>(BigDecimal.class, "paymentFlow");

    }
    public interface JobList {
        static Long id() {
            return 1425736007619231745L;
        }
        static String code() {
            return "jobList";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> WHETHER_EFFECTIVE = new TypedField<>(String.class, "whetherEffective");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ReconciliationDetailData {
        static Long id() {
            return 1428252466707075073L;
        }
        static String code() {
            return "reconciliationDetailData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> RECONCILIATION_DETAIL_CODE = new TypedField<>(String.class, "reconciliationDetailCode");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_I_D = new TypedField<>(String.class, "companyID");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<LocalDateTime> RECONCILIATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconciliationCreateTime");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<BigDecimal> RECONCILIATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "reconciliationSettleAccounts");
        TypedField<String> ONE_TIME_UNIT = new TypedField<>(String.class, "oneTimeUnit");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        /**
         * 对多关联关系 关联对象 orderNo
         */
        TypedField<Long> ORDERTOMANYSETTLEMENTDETAIL_ID = new TypedField<>(Long.class, "orderToManySettlementDetail.id");

        interface ToOneRel {
            interface ORDERTOMANYSETTLEMENTDETAIL {
                static String code () {
                    return "orderToManySettlementDetail" ;
                }
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderToManySettlementDetail.orderNo");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "orderToManySettlementDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "orderToManySettlementDetail.productName");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "orderToManySettlementDetail.chargeType");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "orderToManySettlementDetail.paymentRequirement");
                TypedField<BigDecimal> ORDER_TOTAL_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.orderTotalMoneyWithTax");
                TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.discountMoney");
                TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.payableAmount");
                TypedField<BigDecimal> ACTUAL_MONEY = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.actualMoney");
                TypedField<LocalDateTime> ORDER_GENERATE_DATE = new TypedField<>(LocalDateTime.class, "orderToManySettlementDetail.orderGenerateDate");
                TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "orderToManySettlementDetail.reconciliationStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "orderToManySettlementDetail.paymentStatus");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "orderToManySettlementDetail.invoiceStatus");
                TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "orderToManySettlementDetail.incomeType");
                TypedField<String> WARRANTY = new TypedField<>(String.class, "orderToManySettlementDetail.warranty");
                TypedField<String> WHETHER_VALIDATION = new TypedField<>(String.class, "orderToManySettlementDetail.whetherValidation");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "orderToManySettlementDetail.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "orderToManySettlementDetail.chargeEndDate");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.amount");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.taxRate");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.unitPriceWithoutTax");
                TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "orderToManySettlementDetail.chargeUnit");
                TypedField<Long> ID = new TypedField<>(Long.class, "orderToManySettlementDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "orderToManySettlementDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "orderToManySettlementDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "orderToManySettlementDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "orderToManySettlementDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "orderToManySettlementDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "orderToManySettlementDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "orderToManySettlementDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "orderToManySettlementDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "orderToManySettlementDetail.delete_flag");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "orderToManySettlementDetail.productCode");
                TypedField<BigDecimal> ORDER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.orderDiscountWithoutTax");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "orderToManySettlementDetail.projectName");
            }
        }
    }
    public interface ReconciliationAndInvoiceRelation {
        static Long id() {
            return 1428562157585108994L;
        }
        static String code() {
            return "reconciliationAndInvoiceRelation";
        }
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ReconciliationData {
        static Long id() {
            return 1429648136449986561L;
        }
        static String code() {
            return "reconciliationData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<BigDecimal> RECONCILATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "reconcilationSettleAccounts");
        TypedField<String> RECONCILATION_STATUS = new TypedField<>(String.class, "reconcilationStatus");
        TypedField<BigDecimal> ACTUAL_MONEY = new TypedField<>(BigDecimal.class, "actualMoney");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<LocalDateTime> RECONCILATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconcilationCreateTime");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");

    }
    public interface ChargeCodeData {
        static Long id() {
            return 1430426677404307458L;
        }
        static String code() {
            return "chargeCodeData";
        }
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CHARGE_CODE_NAME = new TypedField<>(String.class, "chargeCodeName");
        TypedField<String> CHARGE_PERSON = new TypedField<>(String.class, "chargePerson");
        TypedField<String> CHARGE_PERSON_NAME = new TypedField<>(String.class, "chargePersonName");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "orgName");
        TypedField<String> RIGHTS_USER = new TypedField<>(String.class, "rightsUser");
        TypedField<String> RIGHTS_ROLE = new TypedField<>(String.class, "rightsRole");
        TypedField<String> IS_DEL = new TypedField<>(String.class, "isDel");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface SettlementMainData {
        static Long id() {
            return 1432542303681417217L;
        }
        static String code() {
            return "settlementMainData";
        }
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "chargeRequirement");
        TypedField<BigDecimal> SETTLED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settledMoneyWithTax");
        TypedField<BigDecimal> WAITING_SETTLE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "waitingSettleMoneyWithTax");
        TypedField<BigDecimal> INVOICED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "invoicedMoneyWithTax");
        TypedField<BigDecimal> RETURNED_MONEY = new TypedField<>(BigDecimal.class, "returnedMoney");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "tenantGroupId");
        TypedField<BigDecimal> ORDER_TOTAL_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "orderTotalMoneyWithTax");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> REGION_ID = new TypedField<>(String.class, "regionId");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");

        interface ToOneRel {
        }
    }
    public interface PayWater {
        static Long id() {
            return 1433255154737909761L;
        }
        static String code() {
            return "payWater";
        }
        TypedField<LocalDateTime> TRADE_TIME = new TypedField<>(LocalDateTime.class, "tradeTime");
        TypedField<BigDecimal> DEBIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "debitMoneyAmount");
        TypedField<BigDecimal> CREDIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "creditMoneyAmount");
        TypedField<String> BANK_NAME = new TypedField<>(String.class, "bankName");
        TypedField<String> BANK_ACCOUNT = new TypedField<>(String.class, "bankAccount");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "accountingDate");
        TypedField<String> ABSTRACTION = new TypedField<>(String.class, "abstraction");

    }
    public interface StatisticBusinessUsage {
        static Long id() {
            return 1434914546386120706L;
        }
        static String code() {
            return "statisticBusinessUsage";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlementCycle");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> BUSINESS_DIMENSION = new TypedField<>(String.class, "businessDimension");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> BUSINESS_TIME = new TypedField<>(String.class, "businessTime");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");

    }
    public interface SettlementDetailAndInvoiceRelation {
        static Long id() {
            return 1437620316654374914L;
        }
        static String code() {
            return "settlementDetailAndInvoiceRelation";
        }
        TypedField<String> SETTLEMENT_DETAIL_CODE = new TypedField<>(String.class, "settlementDetailCode");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");

    }
    public interface RecordTable {
        static Long id() {
            return 1451184261675716610L;
        }
        static String code() {
            return "recordTable";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<BigDecimal> RECONCILIATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "reconciliationSettleAccounts");
        TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "reconciliationStatus");
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<BigDecimal> ACTUAL_MONEY = new TypedField<>(BigDecimal.class, "actualMoney");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<LocalDateTime> RECONCILIATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconciliationCreateTime");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlementCycle");
        TypedField<String> WHETHER_VALIDATION = new TypedField<>(String.class, "whetherValidation");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> RECONCILIATION_DETAIL_CODE = new TypedField<>(String.class, "reconciliationDetailCode");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_I_D = new TypedField<>(String.class, "companyID");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> BUSINESS_DIMENSION = new TypedField<>(String.class, "businessDimension");
        TypedField<BigDecimal> USAGE = new TypedField<>(BigDecimal.class, "usage");
        TypedField<String> COMPRESS = new TypedField<>(String.class, "compress");

    }
    public interface ContractDetail {
        static Long id() {
            return 1455020711739621378L;
        }
        static String code() {
            return "contractDetail";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "chargeRequirement");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> VALIDATION = new TypedField<>(String.class, "validation");
        /**
         * 对多关联关系 关联对象 contract
         */
        TypedField<Long> ONECONTRACTMAINTOMANYCONTRACTDETAIL_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.id");

        interface ToOneRel {
            interface ONECONTRACTMAINTOMANYCONTRACTDETAIL {
                static String code () {
                    return "oneContractMainToManyContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.projectName");
                TypedField<String> SIGN_TEAM = new TypedField<>(String.class, "oneContractMainToManyContractDetail.signTeam");
                TypedField<String> SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.signatoryName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.paymentPeriodType");
                TypedField<LocalDateTime> SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.signDate");
                TypedField<LocalDateTime> EFFECT_START_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.effectStartTime");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.receiptSignDate");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneContractMainToManyContractDetail.delete_flag");
                TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "oneContractMainToManyContractDetail.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.chargeCode");
                TypedField<LocalDateTime> CONTRACT_EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.contractExpiryDate");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "oneContractMainToManyContractDetail.contractTotalMoney");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.tenantName");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneContractMainToManyContractDetail.customer");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneContractMainToManyContractDetail.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneContractMainToManyContractDetail.principalPerson");
                TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.tenantGroupId");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "oneContractMainToManyContractDetail.chargeContractId");
                TypedField<String> REGION = new TypedField<>(String.class, "oneContractMainToManyContractDetail.region");
                TypedField<String> REGION_ID = new TypedField<>(String.class, "oneContractMainToManyContractDetail.regionId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.saChargeCodeName");
            }
        }
    }
    public interface TaxNoList {
        static Long id() {
            return 1455075594576560130L;
        }
        static String code() {
            return "taxNoList";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_STATUS = new TypedField<>(String.class, "taxStatus");
        TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<LocalDateTime> STOP_TIME = new TypedField<>(LocalDateTime.class, "stopTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        /**
         * 对多关联关系 关联对象 contract
         */
        TypedField<Long> ONECONTRACTMAINTOMANYTAXNOLIST_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.id");

        interface ToOneRel {
            interface ONECONTRACTMAINTOMANYTAXNOLIST {
                static String code () {
                    return "oneContractMainToManyTaxNoList" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.projectName");
                TypedField<String> SIGN_TEAM = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.signTeam");
                TypedField<String> SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.signatoryName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.paymentPeriodType");
                TypedField<LocalDateTime> SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.signDate");
                TypedField<LocalDateTime> EFFECT_START_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.effectStartTime");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.receiptSignDate");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.delete_flag");
                TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.chargeCode");
                TypedField<LocalDateTime> CONTRACT_EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.contractExpiryDate");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "oneContractMainToManyTaxNoList.contractTotalMoney");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.tenantName");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.customer");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.principalPerson");
                TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.tenantGroupId");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.chargeContractId");
                TypedField<String> REGION = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.region");
                TypedField<String> REGION_ID = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.regionId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.saChargeCodeName");
            }
        }
    }
    public interface ContractRawData {
        static Long id() {
            return 1455449612420874242L;
        }
        static String code() {
            return "contractRawData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "tenantGroupId");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> JSON_STR = new TypedField<>(String.class, "jsonStr");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface OrderNo {
        static Long id() {
            return 1455513339056848898L;
        }
        static String code() {
            return "orderNo";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<BigDecimal> ORDER_TOTAL_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "orderTotalMoneyWithTax");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<BigDecimal> ACTUAL_MONEY = new TypedField<>(BigDecimal.class, "actualMoney");
        TypedField<LocalDateTime> ORDER_GENERATE_DATE = new TypedField<>(LocalDateTime.class, "orderGenerateDate");
        TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "reconciliationStatus");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> WHETHER_VALIDATION = new TypedField<>(String.class, "whetherValidation");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<BigDecimal> ORDER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "orderDiscountWithoutTax");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        /**
         * 对多关联关系 关联对象 settlementMainData
         */
        TypedField<Long> MANYORDERTOSETTLEMENTMAIN_ID = new TypedField<>(Long.class, "manyOrderToSettlementMain.id");

        interface ToOneRel {
            interface MANYORDERTOSETTLEMENTMAIN {
                static String code () {
                    return "manyOrderToSettlementMain" ;
                }
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "manyOrderToSettlementMain.projectName");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "manyOrderToSettlementMain.productName");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "manyOrderToSettlementMain.chargeRequirement");
                TypedField<BigDecimal> SETTLED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "manyOrderToSettlementMain.settledMoneyWithTax");
                TypedField<BigDecimal> WAITING_SETTLE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "manyOrderToSettlementMain.waitingSettleMoneyWithTax");
                TypedField<BigDecimal> INVOICED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "manyOrderToSettlementMain.invoicedMoneyWithTax");
                TypedField<BigDecimal> RETURNED_MONEY = new TypedField<>(BigDecimal.class, "manyOrderToSettlementMain.returnedMoney");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyOrderToSettlementMain.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyOrderToSettlementMain.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyOrderToSettlementMain.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyOrderToSettlementMain.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyOrderToSettlementMain.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyOrderToSettlementMain.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyOrderToSettlementMain.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyOrderToSettlementMain.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyOrderToSettlementMain.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyOrderToSettlementMain.delete_flag");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "manyOrderToSettlementMain.contractNo");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "manyOrderToSettlementMain.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "manyOrderToSettlementMain.chargeEndDate");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "manyOrderToSettlementMain.chargeType");
                TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "manyOrderToSettlementMain.statementNo");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "manyOrderToSettlementMain.customer");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "manyOrderToSettlementMain.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "manyOrderToSettlementMain.principalPerson");
                TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "manyOrderToSettlementMain.tenantGroupId");
                TypedField<BigDecimal> ORDER_TOTAL_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "manyOrderToSettlementMain.orderTotalMoneyWithTax");
                TypedField<String> REGION = new TypedField<>(String.class, "manyOrderToSettlementMain.region");
                TypedField<String> REGION_ID = new TypedField<>(String.class, "manyOrderToSettlementMain.regionId");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "manyOrderToSettlementMain.productCode");
            }
        }
    }
    public interface ChargeCodePool {
        static Long id() {
            return 1455811807088549889L;
        }
        static String code() {
            return "chargeCodePool";
        }
        TypedField<String> CC_CODE = new TypedField<>(String.class, "ccCode");
        TypedField<String> CC_NAME = new TypedField<>(String.class, "ccName");
        TypedField<String> CC_TYPE = new TypedField<>(String.class, "ccType");
        TypedField<String> RELATION_CODES = new TypedField<>(String.class, "relationCodes");
        TypedField<String> DISTRICT = new TypedField<>(String.class, "district");
        TypedField<String> BIZ_UNIT = new TypedField<>(String.class, "bizUnit");
        TypedField<String> CC_STATUS = new TypedField<>(String.class, "ccStatus");
        TypedField<String> EXTENSION_TAG = new TypedField<>(String.class, "extensionTag");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> KAM = new TypedField<>(String.class, "kam");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PRIMARY_LEADER_CODE = new TypedField<>(String.class, "primaryLeaderCode");
        TypedField<String> PRIMARY_LEADER_NAME = new TypedField<>(String.class, "primaryLeaderName");

        interface ToOneRel {
        }
    }
    public interface ChargeGivenRelation {
        static Long id() {
            return 1458801856491102209L;
        }
        static String code() {
            return "chargeGivenRelation";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<LocalDateTime> TAX_START_DATE = new TypedField<>(LocalDateTime.class, "taxStartDate");
        TypedField<LocalDateTime> SETTLEMENT_START_DATE = new TypedField<>(LocalDateTime.class, "settlementStartDate");
        TypedField<LocalDateTime> SETTLEMENT_END_DATE = new TypedField<>(LocalDateTime.class, "settlementEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAX_NO_COMPANY_NAME = new TypedField<>(String.class, "taxNoCompanyName");
        TypedField<Long> CORRESPONDING_TENANT_ID = new TypedField<>(Long.class, "correspondingTenantId");
        TypedField<String> CORRESPONDING_TENANT_NAME = new TypedField<>(String.class, "correspondingTenantName");

    }
    public interface Member {
        static Long id() {
            return 1460875049720451074L;
        }
        static String code() {
            return "member";
        }
        TypedField<String> MEMBER_NAME = new TypedField<>(String.class, "member_name");
        TypedField<String> MEMBER_CODE = new TypedField<>(String.class, "member_code");
        TypedField<String> BELONGS_COMPANY = new TypedField<>(String.class, "belongs_company");
        TypedField<String> BELONGS_COMPANY_TAX_NO = new TypedField<>(String.class, "belongs_company_tax_no");
        TypedField<String> COMPANY_EMAIL_ADDRESS = new TypedField<>(String.class, "company_email_address");
        TypedField<String> MEMBER_PHONE_NO = new TypedField<>(String.class, "member_phone_no");
        TypedField<String> MEMBER_STATUS = new TypedField<>(String.class, "member_status");
        TypedField<String> BELONGS_DEPARTMENT = new TypedField<>(String.class, "belongs_department");
        TypedField<String> PRIMARY_LEADER_CODE = new TypedField<>(String.class, "primary_leader_code");
        TypedField<String> PRIMARY_LEADER_NAME = new TypedField<>(String.class, "primary_leader_name");
        TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "level_one_department_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> YKB_SYNC_ID = new TypedField<>(String.class, "ykb_sync_id");

    }
    public interface AuthorizedMembers {
        static Long id() {
            return 1460896585479196673L;
        }
        static String code() {
            return "authorizedMembers";
        }
        TypedField<String> AUTHORIZED_MEMBER_CODE = new TypedField<>(String.class, "authorizedMemberCode");
        TypedField<String> AUTHORIZED_MEMBER_NAME = new TypedField<>(String.class, "authorizedMemberName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ACTIVE = new TypedField<>(String.class, "active");
        TypedField<LocalDateTime> INACTIVE_TIME = new TypedField<>(LocalDateTime.class, "inactiveTime");
        /**
         * 对多关联关系 关联对象 chargeCodePool
         */
        TypedField<Long> AUTHORIZEDMEMBERS_ID = new TypedField<>(Long.class, "authorizedMembers.id");

        interface ToOneRel {
            interface AUTHORIZEDMEMBERS {
                static String code () {
                    return "authorizedMembers" ;
                }
                TypedField<String> CC_CODE = new TypedField<>(String.class, "authorizedMembers.ccCode");
                TypedField<String> CC_NAME = new TypedField<>(String.class, "authorizedMembers.ccName");
                TypedField<String> CC_TYPE = new TypedField<>(String.class, "authorizedMembers.ccType");
                TypedField<String> RELATION_CODES = new TypedField<>(String.class, "authorizedMembers.relationCodes");
                TypedField<String> DISTRICT = new TypedField<>(String.class, "authorizedMembers.district");
                TypedField<String> BIZ_UNIT = new TypedField<>(String.class, "authorizedMembers.bizUnit");
                TypedField<String> CC_STATUS = new TypedField<>(String.class, "authorizedMembers.ccStatus");
                TypedField<String> EXTENSION_TAG = new TypedField<>(String.class, "authorizedMembers.extensionTag");
                TypedField<Long> ID = new TypedField<>(Long.class, "authorizedMembers.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "authorizedMembers.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "authorizedMembers.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "authorizedMembers.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "authorizedMembers.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "authorizedMembers.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "authorizedMembers.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "authorizedMembers.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "authorizedMembers.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "authorizedMembers.delete_flag");
                TypedField<String> KAM = new TypedField<>(String.class, "authorizedMembers.kam");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "authorizedMembers.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "authorizedMembers.ownerName");
                TypedField<String> PRIMARY_LEADER_CODE = new TypedField<>(String.class, "authorizedMembers.primaryLeaderCode");
                TypedField<String> PRIMARY_LEADER_NAME = new TypedField<>(String.class, "authorizedMembers.primaryLeaderName");
            }
        }
    }
    public interface InvoiceRawData {
        static Long id() {
            return 1460936664507584513L;
        }
        static String code() {
            return "invoiceRawData";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PAPER_DRAW_DATE = new TypedField<>(String.class, "paperDrawDate");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "deposeTime");
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RAW_JSON = new TypedField<>(String.class, "rawJson");

    }
    public interface ReceivedPaymentsNotTaken {
        static Long id() {
            return 1461010346936832002L;
        }
        static String code() {
            return "receivedPaymentsNotTaken";
        }
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "waitingTakenMoney");
        TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "takenMoney");
        TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface ReceivedPaymentsNoNeed {
        static Long id() {
            return 1461010672058306561L;
        }
        static String code() {
            return "receivedPaymentsNoNeed";
        }
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ReceivedPaymentsTaken {
        static Long id() {
            return 1461010979454652417L;
        }
        static String code() {
            return "receivedPaymentsTaken";
        }
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "takenMoney");
        TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface AllocationByOrder {
        static Long id() {
            return 1461023981952241666L;
        }
        static String code() {
            return "allocationByOrder";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDER_MONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDER_WAITING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<BigDecimal> ORDER_INVOICE_MONEY = new TypedField<>(BigDecimal.class, "orderInvoiceMoney");
        TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_START_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_END_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<LocalDateTime> ORDER_DATE = new TypedField<>(LocalDateTime.class, "orderDate");
        TypedField<BigDecimal> CURRENT_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
        /**
         * 对多关联关系 关联对象 receivedPaymentsNotTaken
         */
        TypedField<Long> ONERECEIVEPAYMENTSNOTTAKENTOMANYALLOCATIONS_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.id");

        interface ToOneRel {
            interface ONERECEIVEPAYMENTSNOTTAKENTOMANYALLOCATIONS {
                static String code () {
                    return "oneReceivePaymentsNotTakenToManyAllocations" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyAllocations.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyAllocations.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.takenStatus");
                TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyAllocations.waitingTakenMoney");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyAllocations.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyAllocations.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyAllocations.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.delete_flag");
            }
        }
    }
    public interface AllocationByInvoice {
        static Long id() {
            return 1461157480399048706L;
        }
        static String code() {
            return "allocationByInvoice";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDER_MONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDER_WAITING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<BigDecimal> ORDER_INVOICE_MONEY = new TypedField<>(BigDecimal.class, "orderInvoiceMoney");
        TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_START_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_END_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<LocalDateTime> ORDER_DATE = new TypedField<>(LocalDateTime.class, "orderDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> CURRENT_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
        /**
         * 对多关联关系 关联对象 receivedPaymentsNotTaken
         */
        TypedField<Long> ONERECEIVEPAYMENTSNOTTAKENTOMANYINVOICEALLOCATIONS_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.id");

        interface ToOneRel {
            interface ONERECEIVEPAYMENTSNOTTAKENTOMANYINVOICEALLOCATIONS {
                static String code () {
                    return "oneReceivePaymentsNotTakenToManyInvoiceAllocations" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.takenStatus");
                TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.waitingTakenMoney");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.delete_flag");
            }
        }
    }
    public interface AllocationByTaxNo {
        static Long id() {
            return 1461158165773488129L;
        }
        static String code() {
            return "allocationByTaxNo";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDER_MONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDER_WAITING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<BigDecimal> ORDER_INVOICE_MONEY = new TypedField<>(BigDecimal.class, "orderInvoiceMoney");
        TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_START_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_END_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<LocalDateTime> ORDER_DATE = new TypedField<>(LocalDateTime.class, "orderDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> CURRENT_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
        /**
         * 对多关联关系 关联对象 receivedPaymentsNotTaken
         */
        TypedField<Long> ONERECEIVEPAYMENTSNOTTAKENTOMANYTAXNOALLOCATIONS_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.id");

        interface ToOneRel {
            interface ONERECEIVEPAYMENTSNOTTAKENTOMANYTAXNOALLOCATIONS {
                static String code () {
                    return "oneReceivePaymentsNotTakenToManyTaxNoAllocations" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.takenStatus");
                TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.waitingTakenMoney");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.delete_flag");
            }
        }
    }
    public interface NoNeedList {
        static Long id() {
            return 1461263582046392321L;
        }
        static String code() {
            return "noNeedList";
        }
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
}
