package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * income
 * </p>
 *
 * @author ultraman
 * @since 2021-12-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Income implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 对账单编号
   */
  private String statementNo;
  /**
   * 使用公司名称
   */
  private String useCompanyName;
  /**
   * 使用公司税号
   */
  private String useCompanytaxNo;
  /**
   * 产品
   */
  private String product;
  /**
   * 型号
   */
  private String modelNo;
  /**
   * 性质
   */
  private String property;
  /**
   * 单价（不含税）
   */
  private BigDecimal unit;
  /**
   * 税率
   */
  private BigDecimal ratio;
  /**
   * 数量
   */
  private Long number;
  /**
   * 计价单位
   */
  private String chargeUnit;
  /**
   * 计价方式
   */
  private String chargeType;
  /**
   * 验收日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiptDate;
  /**
   * 开始计费日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startChargeDate;
  /**
   * 结束计费日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endChargeDate;
  /**
   * 使用月份
   */
  private Long useMonth;
  /**
   * 会计期间
   */
  private Long useYear;
  /**
   * 当期收入金额（不含税）
   */
  private BigDecimal curIncome;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 对应租户ID
   */
  private Long correspondingTenantId;
  /**
   * 对应租户编号
   */
  private String correspondingTenantCode;
  /**
   * 对应租户名称
   */
  private String correspondingTenantName;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectName", projectName);
      map.put("statementNo", statementNo);
      map.put("useCompanyName", useCompanyName);
      map.put("useCompanytaxNo", useCompanytaxNo);
      map.put("product", product);
      map.put("modelNo", modelNo);
      map.put("property", property);
      map.put("unit", unit);
      map.put("ratio", ratio);
      map.put("number", number);
      map.put("chargeUnit", chargeUnit);
      map.put("chargeType", chargeType);
      map.put("receiptDate", BocpGenUtils.toTimestamp(receiptDate));
      map.put("startChargeDate", BocpGenUtils.toTimestamp(startChargeDate));
      map.put("endChargeDate", BocpGenUtils.toTimestamp(endChargeDate));
      map.put("useMonth", useMonth);
      map.put("useYear", useYear);
      map.put("curIncome", curIncome);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("correspondingTenantId", correspondingTenantId);
      map.put("correspondingTenantCode", correspondingTenantCode);
      map.put("correspondingTenantName", correspondingTenantName);

      return map;
  }

  public static Income fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Income entity = new Income();

    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useCompanyName")) {
      Object obj = map.get("useCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useCompanytaxNo")) {
      Object obj = map.get("useCompanytaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUseCompanytaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product")) {
      Object obj = map.get("product");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProduct((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("modelNo")) {
      Object obj = map.get("modelNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setModelNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ratio")) {
      Object obj = map.get("ratio");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRatio((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRatio(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRatio(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRatio(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRatio(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("number")) {
      Object obj = map.get("number");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNumber((Long)obj);
        } else if(obj instanceof String) {
          entity.setNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setNumber(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptDate")) {
      Object obj = map.get("receiptDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiptDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiptDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReceiptDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiptDate(null);
      }
    }
    if(map.containsKey("startChargeDate")) {
      Object obj = map.get("startChargeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartChargeDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartChargeDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartChargeDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartChargeDate(null);
      }
    }
    if(map.containsKey("endChargeDate")) {
      Object obj = map.get("endChargeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndChargeDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndChargeDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndChargeDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndChargeDate(null);
      }
    }
    if(map.containsKey("useMonth")) {
      Object obj = map.get("useMonth");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUseMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setUseMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUseMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("useYear")) {
      Object obj = map.get("useYear");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUseYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setUseYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUseYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("curIncome")) {
      Object obj = map.get("curIncome");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("correspondingTenantId")) {
      Object obj = map.get("correspondingTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCorrespondingTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCorrespondingTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCorrespondingTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("correspondingTenantCode")) {
      Object obj = map.get("correspondingTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCorrespondingTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("correspondingTenantName")) {
      Object obj = map.get("correspondingTenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCorrespondingTenantName((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProjectName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setStatementNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("useCompanyName")) {
      Object obj = map.get("useCompanyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setUseCompanyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("useCompanytaxNo")) {
      Object obj = map.get("useCompanytaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setUseCompanytaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("product")) {
      Object obj = map.get("product");
      if(obj != null) {
        if(obj instanceof String){
            this.setProduct((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("modelNo")) {
      Object obj = map.get("modelNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setModelNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String){
            this.setProperty((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("ratio")) {
      Object obj = map.get("ratio");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRatio((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRatio(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRatio(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setRatio(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRatio(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("number")) {
      Object obj = map.get("number");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setNumber((Long)obj);
        } else if(obj instanceof String) {
            this.setNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setNumber(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receiptDate")) {
      Object obj = map.get("receiptDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReceiptDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReceiptDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setReceiptDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReceiptDate(null);
      }
   }
    if(map.containsKey("startChargeDate")) {
      Object obj = map.get("startChargeDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartChargeDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartChargeDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setStartChargeDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartChargeDate(null);
      }
   }
    if(map.containsKey("endChargeDate")) {
      Object obj = map.get("endChargeDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEndChargeDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEndChargeDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setEndChargeDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEndChargeDate(null);
      }
   }
    if(map.containsKey("useMonth")) {
      Object obj = map.get("useMonth");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUseMonth((Long)obj);
        } else if(obj instanceof String) {
            this.setUseMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUseMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("useYear")) {
      Object obj = map.get("useYear");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUseYear((Long)obj);
        } else if(obj instanceof String) {
            this.setUseYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUseYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("curIncome")) {
      Object obj = map.get("curIncome");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCurIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCurIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCurIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setCurIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCurIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("correspondingTenantId")) {
      Object obj = map.get("correspondingTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCorrespondingTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setCorrespondingTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCorrespondingTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("correspondingTenantCode")) {
      Object obj = map.get("correspondingTenantCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setCorrespondingTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("correspondingTenantName")) {
      Object obj = map.get("correspondingTenantName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCorrespondingTenantName((String)obj);
        }
      } else{
      }
   }

  }

}
