package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费业务维度
 * </p>
 *
 * @author ultraman
 * @since 2021-12-28
 */
public enum BusinessDimension {

    _0("0", "认证次数"),
    _1("1", "识别次数"),
    _2("2", "验真次数"),
    _3("3", "验真发票张数"),
    _4("4", "开票张数"),
    _5("5", "勾选次数"),
    _6("6", "勾选发票张数"),
    _7("7", "认证发票张数");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessDimension(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessDimension fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
