package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * allocation_rule_details
 * </p>
 *
 * @author ultraman
 * @since 2021-12-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AllocationRuleDetails implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 服务编码
   */
  private String code;
  /**
   * 服务名称
   */
  private String name;
  /**
   * 分摊比例
   */
  private BigDecimal allocationProportion;
  /**
   * 用量
   */
  private BigDecimal consumption;
  /**
   * 成本编码
   */
  private String chargeCode;
  /**
   * 状态
   */
  private String status;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 月份
   */
  private Long month;

  /**
   * 对多关联关系 关联对象 allocationRule
   */
  private Long allocationRuleOneToManyRuleDetailId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("code", code);
      map.put("name", name);
      map.put("allocation_proportion", allocationProportion);
      map.put("consumption", consumption);
      map.put("charge_code", chargeCode);
      map.put("status", status);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("month", month);

      map.put("allocationRuleOneToManyRuleDetail.id", allocationRuleOneToManyRuleDetailId);
      return map;
  }

  public static AllocationRuleDetails fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AllocationRuleDetails entity = new AllocationRuleDetails();

    if(map.containsKey("code")) {
      Object obj = map.get("code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allocation_proportion")) {
      Object obj = map.get("allocation_proportion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAllocationProportion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAllocationProportion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAllocationProportion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAllocationProportion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAllocationProportion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("consumption")) {
      Object obj = map.get("consumption");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setConsumption((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setConsumption(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setConsumption(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setConsumption(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setConsumption(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("charge_code")) {
      Object obj = map.get("charge_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("month")) {
      Object obj = map.get("month");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    if(map.containsKey("allocationRuleOneToManyRuleDetail.id")) {
       entity.setAllocationRuleOneToManyRuleDetailId((Long)map.get("allocationRuleOneToManyRuleDetail.id" ));
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("code")) {
      Object obj = map.get("code");
      if(obj != null) {
        if(obj instanceof String){
            this.setCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String){
            this.setName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("allocation_proportion")) {
      Object obj = map.get("allocation_proportion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAllocationProportion((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAllocationProportion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAllocationProportion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAllocationProportion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAllocationProportion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("consumption")) {
      Object obj = map.get("consumption");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setConsumption((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setConsumption(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setConsumption(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setConsumption(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setConsumption(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("charge_code")) {
      Object obj = map.get("charge_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
            this.setStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("month")) {
      Object obj = map.get("month");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMonth((Long)obj);
        } else if(obj instanceof String) {
            this.setMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }

  if(map.containsKey("allocationRuleOneToManyRuleDetail.id")) {
    this.setAllocationRuleOneToManyRuleDetailId((Long)map.get("allocationRuleOneToManyRuleDetail.id" ));
  }
  }

}
