package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * income_item
 * </p>
 *
 * @author ultraman
 * @since 2022-01-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class IncomeItem implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 对账单编号
   */
  private String billNo;
  /**
   * 订单号
   */
  private String relatedOrderNos;
  /**
   * 使用公司名称
   */
  private String taxCompanyName;
  /**
   * 使用公司税号
   */
  private String taxNo;
  /**
   * 性质
   */
  private String property;
  /**
   * 计价单位
   */
  private String pricingUnit;
  /**
   * 开始计费日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;
  /**
   * 结束计费日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;
  /**
   * 使用月份
   */
  private Long usingMonth;
  /**
   * 会计期间
   */
  private Long accountingPeriod;
  /**
   * 当期收入金额（不含税）
   */
  private String currentPeriodAmountWithoutTax;
  /**
   * 合同号
   */
  private String contractNo;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;

  /**
   * 对一关联关系 关联对象 contract
   */
  private Long incomeDetailToOneContractId;
  /**
   * 对一关联关系 关联对象 contractDetail
   */
  private Long incomeToOneContractDetailId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billNo", billNo);
      map.put("relatedOrderNos", relatedOrderNos);
      map.put("taxCompanyName", taxCompanyName);
      map.put("taxNo", taxNo);
      map.put("property", property);
      map.put("pricingUnit", pricingUnit);
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("usingMonth", usingMonth);
      map.put("accountingPeriod", accountingPeriod);
      map.put("currentPeriodAmountWithoutTax", currentPeriodAmountWithoutTax);
      map.put("contractNo", contractNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      map.put("incomeDetailToOneContract.id", incomeDetailToOneContractId);
      map.put("incomeToOneContractDetail.id", incomeToOneContractDetailId);
      return map;
  }

  public static IncomeItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    IncomeItem entity = new IncomeItem();

    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relatedOrderNos")) {
      Object obj = map.get("relatedOrderNos");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelatedOrderNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pricingUnit")) {
      Object obj = map.get("pricingUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPricingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("usingMonth")) {
      Object obj = map.get("usingMonth");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUsingMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setUsingMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUsingMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("accountingPeriod")) {
      Object obj = map.get("accountingPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingPeriod((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountingPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountingPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("currentPeriodAmountWithoutTax")) {
      Object obj = map.get("currentPeriodAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentPeriodAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("incomeDetailToOneContract.id")) {
      Object obj = map.get("incomeDetailToOneContract.id");
      if(obj instanceof Long) {
        entity.setIncomeDetailToOneContractId((Long)obj);
      } else if(obj instanceof String) {
        entity.setIncomeDetailToOneContractId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("incomeToOneContractDetail.id")) {
      Object obj = map.get("incomeToOneContractDetail.id");
      if(obj instanceof Long) {
        entity.setIncomeToOneContractDetailId((Long)obj);
      } else if(obj instanceof String) {
        entity.setIncomeToOneContractDetailId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relatedOrderNos")) {
      Object obj = map.get("relatedOrderNos");
      if(obj != null) {
        if(obj instanceof String){
            this.setRelatedOrderNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String){
            this.setProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pricingUnit")) {
      Object obj = map.get("pricingUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setPricingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setChargeEndDate(null);
      }
    }
    if(map.containsKey("usingMonth")) {
      Object obj = map.get("usingMonth");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUsingMonth((Long)obj);
        } else if(obj instanceof String) {
            this.setUsingMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUsingMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("accountingPeriod")) {
      Object obj = map.get("accountingPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingPeriod((Long)obj);
        } else if(obj instanceof String) {
            this.setAccountingPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setAccountingPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("currentPeriodAmountWithoutTax")) {
      Object obj = map.get("currentPeriodAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrentPeriodAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("incomeDetailToOneContract.id")) {
      Object obj = map.get("incomeDetailToOneContract.id");
      if(obj instanceof Long) {
        this.setIncomeDetailToOneContractId((Long)obj);
      } else if(obj instanceof String) {
        this.setIncomeDetailToOneContractId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("incomeToOneContractDetail.id")) {
      Object obj = map.get("incomeToOneContractDetail.id");
      if(obj instanceof Long) {
        this.setIncomeToOneContractDetailId((Long)obj);
      } else if(obj instanceof String) {
        this.setIncomeToOneContractDetailId(Long.parseLong((String)obj));
      }
    }
  }
}
