package com.xforceplus.ultraman.app.financialsettlement.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;


/**
* 对象元数据
*
* @author ultraman
* @since 2022-01-24
*/
public class EntityMeta {

    public interface ChargeMetaData {
        static Long id() {
            return 1414504703901081602L;
        }
        static String code() {
            return "chargeMetaData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_DIMENSION = new TypedField<>(String.class, "chargeDimension");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "chargeItem");
        TypedField<String> CHARGE_LABEL = new TypedField<>(String.class, "chargeLabel");
        TypedField<BigDecimal> CHARGE_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> ACTUAL_USAGE = new TypedField<>(BigDecimal.class, "actualUsage");
        TypedField<Long> USING_MONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> IS_WARANTY = new TypedField<>(String.class, "isWaranty");
        TypedField<BigDecimal> LIMIT_AMOUNT = new TypedField<>(BigDecimal.class, "limitAmount");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> COMPANY_ID = new TypedField<>(String.class, "companyId");
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "settlementStartTime");
        TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "settlementEndTime");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        /**
         * 对多关联关系 关联对象 incomeMainMsg
         */
        TypedField<Long> INCOMEMAINMSGONETOMANYCHARGEMETADATA_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.id");

        interface ToOneRel {
            interface INCOMEMAINMSGONETOMANYCHARGEMETADATA {
                static String code () {
                    return "incomeMainMsgOneToManychargeMetaData" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.productName");
                TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.startChargeTime");
                TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.stopChargeTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.delete_flag");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.projectName");
                TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.chargeItem");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.companyName");
                TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.companyTax");
                TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManychargeMetaData.totalMoneyTax");
                TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManychargeMetaData.totalMoneyWithoutTax");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.property");
                TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.settlementStartTime");
                TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.settlementEndTime");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.productCode");
                TypedField<Long> CORRESPONDING_TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.correspondingTenantId");
                TypedField<String> CORRESPONDING_TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.correspondingTenantCode");
                TypedField<String> CORRESPONDING_TENANT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.correspondingTenantName");
                TypedField<String> INCOME_STATUS = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.incomeStatus");
            }
        }
    }
    public interface Costing {
        static Long id() {
            return 1415207897100840961L;
        }
        static String code() {
            return "costing";
        }
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "charge_type");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<BigDecimal> CHARGE_MONEY = new TypedField<>(BigDecimal.class, "charge_money");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<LocalDateTime> OCCURRENCE_TIME = new TypedField<>(LocalDateTime.class, "occurrence_time");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 serviceCost
         */
        TypedField<Long> SERVICECOSTONETOMANYCOST_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.id");

        interface ToOneRel {
            interface SERVICECOSTONETOMANYCOST {
                static String code () {
                    return "serviceCostOneToManyCost" ;
                }
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "serviceCostOneToManyCost.service_type");
                TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.service_code");
                TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.service_name");
                TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.occrency_time");
                TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.divide_code");
                TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "serviceCostOneToManyCost.currency_status");
                TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.cumulative_cost");
                TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.current_cost");
                TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.cumulative_output");
                TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.current_output");
                TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "serviceCostOneToManyCost.accounting_year");
                TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "serviceCostOneToManyCost.accounting_month");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.unit_price");
                TypedField<String> SRV_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.srv_code");
                TypedField<String> SRV_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.srv_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "serviceCostOneToManyCost.delete_flag");
            }
        }
    }
    public interface ChargeCode {
        static Long id() {
            return 1415208266803572738L;
        }
        static String code() {
            return "chargeCode";
        }
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<String> CUSTOMER_CODE = new TypedField<>(String.class, "customer_code");
        TypedField<String> CLASSIFICATION = new TypedField<>(String.class, "classification");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ProjectBasicInfo {
        static Long id() {
            return 1415208663073026050L;
        }
        static String code() {
            return "projectBasicInfo";
        }
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "project_name");
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> TENTANT_NAME = new TypedField<>(String.class, "tentant_name");
        TypedField<String> PRODUCT_MODEL = new TypedField<>(String.class, "product_model");
        TypedField<BigDecimal> COUNT = new TypedField<>(BigDecimal.class, "count");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 unitPrice
         */
        TypedField<Long> PROJECTMANYTOONEUNITPRICE_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.id");

        interface ToOneRel {
            interface PROJECTMANYTOONEUNITPRICE {
                static String code () {
                    return "projectManyToOneUnitPrice" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "projectManyToOneUnitPrice.code");
                TypedField<String> NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.name");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "projectManyToOneUnitPrice.unit_price");
                TypedField<String> UNIT = new TypedField<>(String.class, "projectManyToOneUnitPrice.unit");
                TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.start_time");
                TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.end_time");
                TypedField<String> INPUT_WAY = new TypedField<>(String.class, "projectManyToOneUnitPrice.input_way");
                TypedField<Long> YEAR = new TypedField<>(Long.class, "projectManyToOneUnitPrice.year");
                TypedField<Long> MONTH = new TypedField<>(Long.class, "projectManyToOneUnitPrice.month");
                TypedField<Long> ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "projectManyToOneUnitPrice.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "projectManyToOneUnitPrice.delete_flag");
            }
        }
    }
    public interface ProductAllocation {
        static Long id() {
            return 1415208799121907714L;
        }
        static String code() {
            return "productAllocation";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<LocalDateTime> TIME = new TypedField<>(LocalDateTime.class, "time");
        TypedField<String> NUMBER = new TypedField<>(String.class, "number");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 contractDetail
         */
        TypedField<Long> INCOMETOONECONTRACTDETAIL_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");

        interface ToOneRel {
            interface INCOMETOONECONTRACTDETAIL {
                static String code () {
                    return "incomeToOneContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.productName");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.productCode");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.amount");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.unitPrice");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "incomeToOneContractDetail.chargeRequirement");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeToOneContractDetail.delete_flag");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "incomeToOneContractDetail.chargeType");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "incomeToOneContractDetail.taxRate");
                TypedField<String> VALIDATION = new TypedField<>(String.class, "incomeToOneContractDetail.validation");
                TypedField<String> QUANTITY = new TypedField<>(String.class, "incomeToOneContractDetail.quantity");
                TypedField<String> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(String.class, "incomeToOneContractDetail.unitPriceWithoutTax");
            }
        }
    }
    public interface UnitPrice {
        static Long id() {
            return 1415208953767653377L;
        }
        static String code() {
            return "unitPrice";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> INPUT_WAY = new TypedField<>(String.class, "input_way");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface AllocationRuleDetails {
        static Long id() {
            return 1415209110972604418L;
        }
        static String code() {
            return "allocationRuleDetails";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> ALLOCATION_PROPORTION = new TypedField<>(BigDecimal.class, "allocation_proportion");
        TypedField<BigDecimal> CONSUMPTION = new TypedField<>(BigDecimal.class, "consumption");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        /**
         * 对多关联关系 关联对象 allocationRule
         */
        TypedField<Long> ALLOCATIONRULEONETOMANYRULEDETAIL_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.id");

        interface ToOneRel {
            interface ALLOCATIONRULEONETOMANYRULEDETAIL {
                static String code () {
                    return "allocationRuleOneToManyRuleDetail" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.code");
                TypedField<String> NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.name");
                TypedField<String> ALLOCATION_TYPE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.allocation_type");
                TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.start_time");
                TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.end_time");
                TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.charge_belong");
                TypedField<Long> MONTH = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.month");
                TypedField<Long> ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.delete_flag");
            }
        }
    }
    public interface AllocationRule {
        static Long id() {
            return 1415211734738006018L;
        }
        static String code() {
            return "allocationRule";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> ALLOCATION_TYPE = new TypedField<>(String.class, "allocation_type");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface ChargeCodeMaintain {
        static Long id() {
            return 1415212005962674177L;
        }
        static String code() {
            return "chargeCodeMaintain";
        }
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface InfoBI {
        static Long id() {
            return 1415212818932035585L;
        }
        static String code() {
            return "infoBI";
        }
        TypedField<String> TAX_NUMBER = new TypedField<>(String.class, "tax_number");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> MIDDLE_GROUND_CODE = new TypedField<>(String.class, "middle_ground_code");
        TypedField<BigDecimal> AMOUNT_USAGE = new TypedField<>(BigDecimal.class, "amount_usage");
        TypedField<String> MIDDLE_GROUND_NAME = new TypedField<>(String.class, "middle_ground_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> TENTANT = new TypedField<>(String.class, "tentant");
        TypedField<LocalDateTime> STARTING_TIME = new TypedField<>(LocalDateTime.class, "starting_time");
        TypedField<LocalDateTime> ENDING_TIME = new TypedField<>(LocalDateTime.class, "ending_time");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ServiceCostDetails {
        static Long id() {
            return 1415214963842392066L;
        }
        static String code() {
            return "serviceCostDetails";
        }
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> COST_CODE = new TypedField<>(String.class, "cost_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> COST_TYPE = new TypedField<>(String.class, "cost_type");
        TypedField<String> COST_BELONG = new TypedField<>(String.class, "cost_belong");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<LocalDateTime> OCCURENCY_TIME = new TypedField<>(LocalDateTime.class, "occurency_time");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> COST_NAME = new TypedField<>(String.class, "cost_name");
        TypedField<String> PARENT_CHARGECODE = new TypedField<>(String.class, "parent_chargecode");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 serviceCost
         */
        TypedField<Long> SEVICECOSTONETOMANYDETAIL_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.id");

        interface ToOneRel {
            interface SEVICECOSTONETOMANYDETAIL {
                static String code () {
                    return "seviceCostOneToManyDetail" ;
                }
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_type");
                TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_code");
                TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_name");
                TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.occrency_time");
                TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.divide_code");
                TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "seviceCostOneToManyDetail.currency_status");
                TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.cumulative_cost");
                TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.current_cost");
                TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.cumulative_output");
                TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.current_output");
                TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "seviceCostOneToManyDetail.accounting_year");
                TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "seviceCostOneToManyDetail.accounting_month");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.unit_price");
                TypedField<String> SRV_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.srv_code");
                TypedField<String> SRV_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.srv_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "seviceCostOneToManyDetail.delete_flag");
            }
        }
    }
    public interface ServiceCost {
        static Long id() {
            return 1415215356366331905L;
        }
        static String code() {
            return "serviceCost";
        }
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "occrency_time");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "currency_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> SRV_CODE = new TypedField<>(String.class, "srv_code");
        TypedField<String> SRV_NAME = new TypedField<>(String.class, "srv_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface Income {
        static Long id() {
            return 1415498206489735170L;
        }
        static String code() {
            return "income";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> USE_COMPANY_NAME = new TypedField<>(String.class, "useCompanyName");
        TypedField<String> USE_COMPANYTAX_NO = new TypedField<>(String.class, "useCompanytaxNo");
        TypedField<String> PRODUCT = new TypedField<>(String.class, "product");
        TypedField<String> MODEL_NO = new TypedField<>(String.class, "modelNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<BigDecimal> UNIT = new TypedField<>(BigDecimal.class, "unit");
        TypedField<BigDecimal> RATIO = new TypedField<>(BigDecimal.class, "ratio");
        TypedField<Long> NUMBER = new TypedField<>(Long.class, "number");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> START_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "startChargeDate");
        TypedField<LocalDateTime> END_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "endChargeDate");
        TypedField<Long> USE_MONTH = new TypedField<>(Long.class, "useMonth");
        TypedField<Long> USE_YEAR = new TypedField<>(Long.class, "useYear");
        TypedField<BigDecimal> CUR_INCOME = new TypedField<>(BigDecimal.class, "curIncome");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> CORRESPONDING_TENANT_ID = new TypedField<>(Long.class, "correspondingTenantId");
        TypedField<String> CORRESPONDING_TENANT_CODE = new TypedField<>(String.class, "correspondingTenantCode");
        TypedField<String> CORRESPONDING_TENANT_NAME = new TypedField<>(String.class, "correspondingTenantName");

    }
    public interface SettlementData {
        static Long id() {
            return 1415502111091400706L;
        }
        static String code() {
            return "settlementData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<LocalDateTime> STATEMENT_CREATE_DATE = new TypedField<>(LocalDateTime.class, "statementCreateDate");
        TypedField<String> INVOICE_COMPANY_NAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<String> INVOICE_COMPANY_TAX = new TypedField<>(String.class, "invoiceCompanyTax");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoiceDate");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithoutTax");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithTax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_METHOD = new TypedField<>(String.class, "chargeMethod");
        TypedField<LocalDateTime> ACCEPTANCE_DATE = new TypedField<>(LocalDateTime.class, "acceptanceDate");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<BigDecimal> CHARGE_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithoutTax");
        TypedField<BigDecimal> CHARGE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithTax");
        TypedField<LocalDateTime> RETURN_DATE = new TypedField<>(LocalDateTime.class, "returnDate");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> PAYER_COMPANY = new TypedField<>(String.class, "payerCompany");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<Long> CHARGE_DAYS = new TypedField<>(Long.class, "chargeDays");
        TypedField<BigDecimal> CURRENT_DISCOUNT_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "currentDiscountMoneyWithTax");
        TypedField<BigDecimal> DISCOUNT_LATER_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "discountLaterMoneyWithTax");
        TypedField<BigDecimal> DISCOUNT_LATER_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "discountLaterMoneyWithoutTax");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<LocalDateTime> ORDER_GENERATE_DATE = new TypedField<>(LocalDateTime.class, "orderGenerateDate");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "receiptSignDateStr");
        /**
         * 对多关联关系 关联对象 settlementMainData
         */
        TypedField<Long> SETTLEMENTMAINDATAONETOMANYSETTLEMENTDATA_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.id");
        /**
         * 对多关联关系 关联对象 reconciliationDetailData
         */
        TypedField<Long> ONESETTLEMENTDETAILTOONERECONCILIATIONDETAIL_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.id");
        /**
         * 对多关联关系 关联对象 order
         */
        TypedField<Long> TOONEORDER_ID = new TypedField<>(Long.class, "toOneOrder.id");

        interface ToOneRel {
            interface SETTLEMENTMAINDATAONETOMANYSETTLEMENTDATA {
                static String code () {
                    return "settlementMainDataOneToManySettlementData" ;
                }
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.projectName");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.productName");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.chargeRequirement");
                TypedField<BigDecimal> SETTLED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.settledMoneyWithTax");
                TypedField<BigDecimal> WAITING_SETTLE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.waitingSettleMoneyWithTax");
                TypedField<BigDecimal> INVOICED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.invoicedMoneyWithTax");
                TypedField<BigDecimal> RETURNED_MONEY = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.returnedMoney");
                TypedField<Long> ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.delete_flag");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.contractNo");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.chargeEndDate");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.chargeType");
                TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.statementNo");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.customer");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.principalPerson");
                TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.tenantGroupId");
                TypedField<BigDecimal> ORDER_TOTAL_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.orderTotalMoneyWithTax");
                TypedField<String> REGION = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.region");
                TypedField<String> REGION_ID = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.regionId");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.productCode");
            }
            interface ONESETTLEMENTDETAILTOONERECONCILIATIONDETAIL {
                static String code () {
                    return "oneSettlementDetailToOneReconciliationDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.contractNo");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.tenantName");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.productName");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.chargeEndDate");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.chargeType");
                TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.payableAmount");
                TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.discountMoney");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.amount");
                TypedField<String> RECONCILIATION_DETAIL_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationDetailCode");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.projectNo");
                TypedField<String> TAX_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.taxNo");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.companyName");
                TypedField<String> COMPANY_I_D = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.companyID");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.billingType");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.unitPriceWithoutTax");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.taxRate");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.delete_flag");
                TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationCode");
                TypedField<LocalDateTime> RECONCILIATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationCreateTime");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.productCode");
                TypedField<BigDecimal> RECONCILIATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationSettleAccounts");
                TypedField<String> ONE_TIME_UNIT = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.oneTimeUnit");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.chargeCycle");
                TypedField<String> SETTLEMENT_AMOUNT = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.settlementAmount");
            }
            interface TOONEORDER {
                static String code () {
                    return "toOneOrder" ;
                }
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "toOneOrder.orderNo");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "toOneOrder.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "toOneOrder.productName");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "toOneOrder.chargeType");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "toOneOrder.paymentRequirement");
                TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "toOneOrder.totalAmountWithTax");
                TypedField<String> DISCOUNT_AMOUNT = new TypedField<>(String.class, "toOneOrder.discountAmount");
                TypedField<String> PAYABLE_AMOUNT = new TypedField<>(String.class, "toOneOrder.payableAmount");
                TypedField<String> ACTUAL_PAYMENT_AMOUNT = new TypedField<>(String.class, "toOneOrder.actualPaymentAmount");
                TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "toOneOrder.generateDate");
                TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "toOneOrder.reconciliationStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "toOneOrder.paymentStatus");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "toOneOrder.invoiceStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "toOneOrder.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "toOneOrder.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "toOneOrder.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "toOneOrder.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "toOneOrder.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "toOneOrder.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "toOneOrder.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "toOneOrder.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "toOneOrder.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "toOneOrder.delete_flag");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "toOneOrder.orderType");
                TypedField<Boolean> VALIDATED = new TypedField<>(Boolean.class, "toOneOrder.validated");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "toOneOrder.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "toOneOrder.chargeEndDate");
                TypedField<BigDecimal> TAX_QUANTITY = new TypedField<>(BigDecimal.class, "toOneOrder.taxQuantity");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "toOneOrder.taxRate");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "toOneOrder.unitPriceWithoutTax");
                TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "toOneOrder.chargeUnit");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "toOneOrder.productCode");
                TypedField<String> DISCOUNT_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "toOneOrder.discountAmountWithoutTax");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "toOneOrder.projectName");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "toOneOrder.orderStatus");
                TypedField<String> RETENTION_MONEY = new TypedField<>(String.class, "toOneOrder.retentionMoney");
            }
        }
    }
    public interface Contract {
        static Long id() {
            return 1415514648138260481L;
        }
        static String code() {
            return "contract";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "periodPromise");
        TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "paymentPeriod");
        TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "paymentPeriodType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "containsRetentionMoney");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contractType");
        TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "contractTotalMoney");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "chargeContractId");
        TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "saChargeCode");
        TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "saChargeCodeName");
        TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "totalAmountWithTax");
        TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "relatedContractNo");
        TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "signTeamCode");
        TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "signTeamName");
        TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "customerSignatoryTaxNos");
        TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "customerSignatoryName");
        TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "expenseBearer");
        TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "businessUnitDeptCode");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> REGION_CODE = new TypedField<>(String.class, "regionCode");
        TypedField<String> REGION_NAME = new TypedField<>(String.class, "regionName");
        TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "ourSignatoryName");
        TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "ourSignatoryTaxNo");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "attachmentUrl");
        TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "signDateStr");
        TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "expiryDateStr");
        TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "receiptSignDateStr");
        TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "effectiveDateStr");
        TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "contractStatus");
        TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "contractVersion");

        interface ToOneRel {
        }
    }
    public interface Project {
        static Long id() {
            return 1415517014084415490L;
        }
        static String code() {
            return "project";
        }
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> SALE_DIRECTOR_EMAIL = new TypedField<>(String.class, "saleDirectorEmail");
        TypedField<String> SALE_DIRECTOR = new TypedField<>(String.class, "saleDirector");
        TypedField<String> EMAIL = new TypedField<>(String.class, "email");
        TypedField<String> SALE_PRINCIPAL = new TypedField<>(String.class, "salePrincipal");
        TypedField<String> SIGN_TEAM = new TypedField<>(String.class, "signTeam");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ProductFunction {
        static Long id() {
            return 1415519149595336706L;
        }
        static String code() {
            return "productFunction";
        }
        TypedField<String> PRODUCT_NO = new TypedField<>(String.class, "productNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_TYPE = new TypedField<>(String.class, "productType");
        TypedField<String> FUNCTION_TYPE = new TypedField<>(String.class, "functionType");
        TypedField<String> FUNTION_DESC = new TypedField<>(String.class, "funtionDesc");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> PRODUCT_SRV_NAME = new TypedField<>(String.class, "productSrvName");
        TypedField<String> TAX_ED = new TypedField<>(String.class, "taxEd");
        TypedField<String> INVOICE_UNIT = new TypedField<>(String.class, "invoiceUnit");
        TypedField<String> USE_INVOICE_TYPE = new TypedField<>(String.class, "useInvoiceType");
        TypedField<LocalDateTime> SRV_START_DATE = new TypedField<>(LocalDateTime.class, "srvStartDate");
        TypedField<LocalDateTime> SRV_END_DATE = new TypedField<>(LocalDateTime.class, "srvEndDate");
        TypedField<String> CREATE_USER = new TypedField<>(String.class, "createUser");
        TypedField<String> UPDATE_USER = new TypedField<>(String.class, "updateUser");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface IncomeMainMsg {
        static Long id() {
            return 1415957144165621761L;
        }
        static String code() {
            return "incomeMainMsg";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "stopChargeTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "chargeItem");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "totalMoneyTax");
        TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "totalMoneyWithoutTax");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "settlementStartTime");
        TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "settlementEndTime");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<Long> CORRESPONDING_TENANT_ID = new TypedField<>(Long.class, "correspondingTenantId");
        TypedField<String> CORRESPONDING_TENANT_CODE = new TypedField<>(String.class, "correspondingTenantCode");
        TypedField<String> CORRESPONDING_TENANT_NAME = new TypedField<>(String.class, "correspondingTenantName");
        TypedField<String> INCOME_STATUS = new TypedField<>(String.class, "incomeStatus");

        interface ToOneRel {
        }
    }
    public interface ChargeJob {
        static Long id() {
            return 1416945394439102465L;
        }
        static String code() {
            return "chargeJob";
        }
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> INCOME_MAIN_MSG_ID = new TypedField<>(String.class, "incomeMainMsgId");
        TypedField<String> JOB_TYPE = new TypedField<>(String.class, "jobType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELF_ID = new TypedField<>(String.class, "selfId");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> WHETHER_RECEIVED = new TypedField<>(String.class, "whetherReceived");
        TypedField<String> WHETHER_VALIDATE = new TypedField<>(String.class, "whetherValidate");

    }
    public interface IncomeDetail {
        static Long id() {
            return 1422827562209681410L;
        }
        static String code() {
            return "incomeDetail";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<LocalDateTime> START_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "startChargeDate");
        TypedField<LocalDateTime> END_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "endChargeDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> CURRENT_INCOME_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "currentIncomeWithoutTax");
        TypedField<String> ACCEPTANCE_DATE = new TypedField<>(String.class, "acceptanceDate");
        TypedField<String> ACCOUNTING_TIME = new TypedField<>(String.class, "accountingTime");
        TypedField<String> CHARGE_METHOD = new TypedField<>(String.class, "chargeMethod");
        TypedField<String> USING_MONTH = new TypedField<>(String.class, "usingMonth");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> REGION_ID = new TypedField<>(String.class, "regionId");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> RELATED_ORDER_NOS = new TypedField<>(String.class, "relatedOrderNos");
        /**
         * 对多关联关系 关联对象 incomeMainMsg
         */
        TypedField<Long> INCOMEMAINMSGONETOMANYINCOMEDETAILMSG_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.id");
        /**
         * 对多关联关系 关联对象 contract
         */
        TypedField<Long> MANYINCOMEDETAILTOONECONTRACT_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.id");
        /**
         * 对多关联关系 关联对象 contractDetail
         */
        TypedField<Long> MANYINCOMEDETAILTOONECONTRACTDETAIL_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContractDetail.id");

        interface ToOneRel {
            interface INCOMEMAINMSGONETOMANYINCOMEDETAILMSG {
                static String code () {
                    return "incomeMainMsgOneToManyincomeDetailMsg" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.productName");
                TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.startChargeTime");
                TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.stopChargeTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.delete_flag");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.projectName");
                TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.chargeItem");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.companyName");
                TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.companyTax");
                TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManyincomeDetailMsg.totalMoneyTax");
                TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManyincomeDetailMsg.totalMoneyWithoutTax");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.property");
                TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.settlementStartTime");
                TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.settlementEndTime");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.productCode");
                TypedField<Long> CORRESPONDING_TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.correspondingTenantId");
                TypedField<String> CORRESPONDING_TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.correspondingTenantCode");
                TypedField<String> CORRESPONDING_TENANT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.correspondingTenantName");
                TypedField<String> INCOME_STATUS = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.incomeStatus");
            }
            interface MANYINCOMEDETAILTOONECONTRACT {
                static String code () {
                    return "manyIncomeDetailToOneContract" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContract.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContract.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyIncomeDetailToOneContract.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyIncomeDetailToOneContract.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyIncomeDetailToOneContract.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "manyIncomeDetailToOneContract.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "manyIncomeDetailToOneContract.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "manyIncomeDetailToOneContract.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "manyIncomeDetailToOneContract.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "manyIncomeDetailToOneContract.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.saChargeCodeName");
                TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "manyIncomeDetailToOneContract.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContract.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "manyIncomeDetailToOneContract.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "manyIncomeDetailToOneContract.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "manyIncomeDetailToOneContract.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContract.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.chargeCycle");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "manyIncomeDetailToOneContract.attachmentUrl");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "manyIncomeDetailToOneContract.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "manyIncomeDetailToOneContract.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "manyIncomeDetailToOneContract.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "manyIncomeDetailToOneContract.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "manyIncomeDetailToOneContract.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.contractVersion");
            }
            interface MANYINCOMEDETAILTOONECONTRACTDETAIL {
                static String code () {
                    return "manyIncomeDetailToOneContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.productName");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.productCode");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "manyIncomeDetailToOneContractDetail.amount");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "manyIncomeDetailToOneContractDetail.unitPrice");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.chargeRequirement");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyIncomeDetailToOneContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyIncomeDetailToOneContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.delete_flag");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.chargeType");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.taxRate");
                TypedField<String> VALIDATION = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.validation");
                TypedField<String> QUANTITY = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.quantity");
                TypedField<String> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.unitPriceWithoutTax");
            }
        }
    }
    public interface InvoiceData {
        static Long id() {
            return 1422867883811573762L;
        }
        static String code() {
            return "invoiceData";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "originalInvoiceCode");
        TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "originalInvoiceNo");
        TypedField<String> SELLER_TAX_NAME = new TypedField<>(String.class, "sellerTaxName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> EFFECTIVE_STATUS = new TypedField<>(String.class, "effectiveStatus");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchStatus");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> INVOICE_DATE = new TypedField<>(String.class, "invoiceDate");
        TypedField<BigDecimal> AMOUT_WITH_TAX_UN_MATCHED = new TypedField<>(BigDecimal.class, "amoutWithTaxUnMatched");
        TypedField<BigDecimal> PAYMENT_FLOW = new TypedField<>(BigDecimal.class, "paymentFlow");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");

    }
    public interface JobList {
        static Long id() {
            return 1425736007619231745L;
        }
        static String code() {
            return "jobList";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> WHETHER_EFFECTIVE = new TypedField<>(String.class, "whetherEffective");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ReconciliationDetailData {
        static Long id() {
            return 1428252466707075073L;
        }
        static String code() {
            return "reconciliationDetailData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> RECONCILIATION_DETAIL_CODE = new TypedField<>(String.class, "reconciliationDetailCode");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_I_D = new TypedField<>(String.class, "companyID");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<LocalDateTime> RECONCILIATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconciliationCreateTime");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<BigDecimal> RECONCILIATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "reconciliationSettleAccounts");
        TypedField<String> ONE_TIME_UNIT = new TypedField<>(String.class, "oneTimeUnit");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<String> SETTLEMENT_AMOUNT = new TypedField<>(String.class, "settlementAmount");
        /**
         * 对多关联关系 关联对象 order
         */
        TypedField<Long> ONEORDERTOMANYSETTLEMENTDETAIL_ID = new TypedField<>(Long.class, "oneOrderToManySettlementDetail.id");

        interface ToOneRel {
            interface ONEORDERTOMANYSETTLEMENTDETAIL {
                static String code () {
                    return "oneOrderToManySettlementDetail" ;
                }
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "oneOrderToManySettlementDetail.orderNo");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneOrderToManySettlementDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneOrderToManySettlementDetail.productName");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "oneOrderToManySettlementDetail.chargeType");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "oneOrderToManySettlementDetail.paymentRequirement");
                TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "oneOrderToManySettlementDetail.totalAmountWithTax");
                TypedField<String> DISCOUNT_AMOUNT = new TypedField<>(String.class, "oneOrderToManySettlementDetail.discountAmount");
                TypedField<String> PAYABLE_AMOUNT = new TypedField<>(String.class, "oneOrderToManySettlementDetail.payableAmount");
                TypedField<String> ACTUAL_PAYMENT_AMOUNT = new TypedField<>(String.class, "oneOrderToManySettlementDetail.actualPaymentAmount");
                TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "oneOrderToManySettlementDetail.generateDate");
                TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "oneOrderToManySettlementDetail.reconciliationStatus");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "oneOrderToManySettlementDetail.paymentStatus");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "oneOrderToManySettlementDetail.invoiceStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneOrderToManySettlementDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneOrderToManySettlementDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneOrderToManySettlementDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneOrderToManySettlementDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneOrderToManySettlementDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneOrderToManySettlementDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneOrderToManySettlementDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneOrderToManySettlementDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneOrderToManySettlementDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneOrderToManySettlementDetail.delete_flag");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "oneOrderToManySettlementDetail.orderType");
                TypedField<Boolean> VALIDATED = new TypedField<>(Boolean.class, "oneOrderToManySettlementDetail.validated");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "oneOrderToManySettlementDetail.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "oneOrderToManySettlementDetail.chargeEndDate");
                TypedField<BigDecimal> TAX_QUANTITY = new TypedField<>(BigDecimal.class, "oneOrderToManySettlementDetail.taxQuantity");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "oneOrderToManySettlementDetail.taxRate");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneOrderToManySettlementDetail.unitPriceWithoutTax");
                TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "oneOrderToManySettlementDetail.chargeUnit");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneOrderToManySettlementDetail.productCode");
                TypedField<String> DISCOUNT_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "oneOrderToManySettlementDetail.discountAmountWithoutTax");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneOrderToManySettlementDetail.projectName");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "oneOrderToManySettlementDetail.orderStatus");
                TypedField<String> RETENTION_MONEY = new TypedField<>(String.class, "oneOrderToManySettlementDetail.retentionMoney");
            }
        }
    }
    public interface ReconciliationAndInvoiceRelation {
        static Long id() {
            return 1428562157585108994L;
        }
        static String code() {
            return "reconciliationAndInvoiceRelation";
        }
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ReconciliationData {
        static Long id() {
            return 1429648136449986561L;
        }
        static String code() {
            return "reconciliationData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<String> RECONCILATION_STATUS = new TypedField<>(String.class, "reconcilationStatus");
        TypedField<BigDecimal> ACTUAL_MONEY = new TypedField<>(BigDecimal.class, "actualMoney");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<LocalDateTime> RECONCILATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconcilationCreateTime");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> SETTLEMENT_AMOUNT = new TypedField<>(String.class, "settlementAmount");
        TypedField<String> DISCOUNT_AMOUNT = new TypedField<>(String.class, "discountAmount");

    }
    public interface SettlementMainData {
        static Long id() {
            return 1432542303681417217L;
        }
        static String code() {
            return "settlementMainData";
        }
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "chargeRequirement");
        TypedField<BigDecimal> SETTLED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settledMoneyWithTax");
        TypedField<BigDecimal> WAITING_SETTLE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "waitingSettleMoneyWithTax");
        TypedField<BigDecimal> INVOICED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "invoicedMoneyWithTax");
        TypedField<BigDecimal> RETURNED_MONEY = new TypedField<>(BigDecimal.class, "returnedMoney");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "tenantGroupId");
        TypedField<BigDecimal> ORDER_TOTAL_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "orderTotalMoneyWithTax");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> REGION_ID = new TypedField<>(String.class, "regionId");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        /**
         * 对多关联关系 关联对象 contract
         */
        TypedField<Long> TOONECONTRACT_ID = new TypedField<>(Long.class, "toOneContract.id");

        interface ToOneRel {
            interface TOONECONTRACT {
                static String code () {
                    return "toOneContract" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "toOneContract.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "toOneContract.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "toOneContract.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "toOneContract.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "toOneContract.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "toOneContract.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "toOneContract.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "toOneContract.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "toOneContract.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "toOneContract.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "toOneContract.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "toOneContract.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "toOneContract.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "toOneContract.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "toOneContract.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "toOneContract.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "toOneContract.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "toOneContract.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "toOneContract.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "toOneContract.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "toOneContract.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "toOneContract.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "toOneContract.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "toOneContract.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "toOneContract.saChargeCodeName");
                TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "toOneContract.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "toOneContract.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "toOneContract.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "toOneContract.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "toOneContract.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "toOneContract.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "toOneContract.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "toOneContract.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "toOneContract.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "toOneContract.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "toOneContract.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "toOneContract.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "toOneContract.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "toOneContract.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "toOneContract.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "toOneContract.chargeCycle");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "toOneContract.attachmentUrl");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "toOneContract.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "toOneContract.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "toOneContract.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "toOneContract.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "toOneContract.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "toOneContract.contractVersion");
            }
        }
    }
    public interface PayWater {
        static Long id() {
            return 1433255154737909761L;
        }
        static String code() {
            return "payWater";
        }
        TypedField<LocalDateTime> TRADE_TIME = new TypedField<>(LocalDateTime.class, "tradeTime");
        TypedField<BigDecimal> DEBIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "debitMoneyAmount");
        TypedField<BigDecimal> CREDIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "creditMoneyAmount");
        TypedField<String> BANK_NAME = new TypedField<>(String.class, "bankName");
        TypedField<String> BANK_ACCOUNT = new TypedField<>(String.class, "bankAccount");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "accountingDate");
        TypedField<String> ABSTRACTION = new TypedField<>(String.class, "abstraction");

        interface ToOneRel {
        }
    }
    public interface StatisticBusinessUsage {
        static Long id() {
            return 1434914546386120706L;
        }
        static String code() {
            return "statisticBusinessUsage";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlementCycle");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> BUSINESS_DIMENSION = new TypedField<>(String.class, "businessDimension");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> BUSINESS_TIME = new TypedField<>(String.class, "businessTime");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");

    }
    public interface SettlementDetailAndInvoiceRelation {
        static Long id() {
            return 1437620316654374914L;
        }
        static String code() {
            return "settlementDetailAndInvoiceRelation";
        }
        TypedField<String> SETTLEMENT_DETAIL_CODE = new TypedField<>(String.class, "settlementDetailCode");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");

    }
    public interface RecordTable {
        static Long id() {
            return 1451184261675716610L;
        }
        static String code() {
            return "recordTable";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<BigDecimal> RECONCILIATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "reconciliationSettleAccounts");
        TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "reconciliationStatus");
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<BigDecimal> ACTUAL_MONEY = new TypedField<>(BigDecimal.class, "actualMoney");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<LocalDateTime> RECONCILIATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconciliationCreateTime");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlementCycle");
        TypedField<String> WHETHER_VALIDATION = new TypedField<>(String.class, "whetherValidation");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> RECONCILIATION_DETAIL_CODE = new TypedField<>(String.class, "reconciliationDetailCode");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_I_D = new TypedField<>(String.class, "companyID");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> BUSINESS_DIMENSION = new TypedField<>(String.class, "businessDimension");
        TypedField<BigDecimal> USAGE = new TypedField<>(BigDecimal.class, "usage");
        TypedField<String> COMPRESS = new TypedField<>(String.class, "compress");
        TypedField<String> RECORD_TYPE = new TypedField<>(String.class, "recordType");

    }
    public interface ContractDetail {
        static Long id() {
            return 1455020711739621378L;
        }
        static String code() {
            return "contractDetail";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "chargeRequirement");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> VALIDATION = new TypedField<>(String.class, "validation");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(String.class, "unitPriceWithoutTax");
        /**
         * 对多关联关系 关联对象 contract
         */
        TypedField<Long> ONECONTRACTMAINTOMANYCONTRACTDETAIL_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.id");

        interface ToOneRel {
            interface ONECONTRACTMAINTOMANYCONTRACTDETAIL {
                static String code () {
                    return "oneContractMainToManyContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneContractMainToManyContractDetail.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "oneContractMainToManyContractDetail.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "oneContractMainToManyContractDetail.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneContractMainToManyContractDetail.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneContractMainToManyContractDetail.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "oneContractMainToManyContractDetail.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.saChargeCodeName");
                TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "oneContractMainToManyContractDetail.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "oneContractMainToManyContractDetail.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "oneContractMainToManyContractDetail.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneContractMainToManyContractDetail.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.chargeCycle");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "oneContractMainToManyContractDetail.attachmentUrl");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyContractDetail.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyContractDetail.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyContractDetail.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyContractDetail.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.contractVersion");
            }
        }
    }
    public interface TaxNoList {
        static Long id() {
            return 1455075594576560130L;
        }
        static String code() {
            return "taxNoList";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<LocalDateTime> STOP_TIME = new TypedField<>(LocalDateTime.class, "stopTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TAX_NO_STATUS = new TypedField<>(String.class, "taxNoStatus");
        /**
         * 对多关联关系 关联对象 contract
         */
        TypedField<Long> ONECONTRACTMAINTOMANYTAXNOLIST_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.id");

        interface ToOneRel {
            interface ONECONTRACTMAINTOMANYTAXNOLIST {
                static String code () {
                    return "oneContractMainToManyTaxNoList" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "oneContractMainToManyTaxNoList.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "oneContractMainToManyTaxNoList.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.saChargeCodeName");
                TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.chargeCycle");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.attachmentUrl");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.contractVersion");
            }
        }
    }
    public interface ContractRawData {
        static Long id() {
            return 1455449612420874242L;
        }
        static String code() {
            return "contractRawData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "tenantGroupId");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> JSON_STR = new TypedField<>(String.class, "jsonStr");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ChargeCodePool {
        static Long id() {
            return 1455811807088549889L;
        }
        static String code() {
            return "chargeCodePool";
        }
        TypedField<String> CC_CODE = new TypedField<>(String.class, "ccCode");
        TypedField<String> CC_NAME = new TypedField<>(String.class, "ccName");
        TypedField<String> CC_TYPE = new TypedField<>(String.class, "ccType");
        TypedField<String> RELATION_CODES = new TypedField<>(String.class, "relationCodes");
        TypedField<String> DISTRICT = new TypedField<>(String.class, "district");
        TypedField<String> BIZ_UNIT = new TypedField<>(String.class, "bizUnit");
        TypedField<String> CC_STATUS = new TypedField<>(String.class, "ccStatus");
        TypedField<String> EXTENSION_TAG = new TypedField<>(String.class, "extensionTag");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> KAM = new TypedField<>(String.class, "kam");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PRIMARY_LEADER_CODE = new TypedField<>(String.class, "primaryLeaderCode");
        TypedField<String> PRIMARY_LEADER_NAME = new TypedField<>(String.class, "primaryLeaderName");
        TypedField<String> CC_TYPE_CODE = new TypedField<>(String.class, "ccTypeCode");
        TypedField<String> DISTRICT_CODE = new TypedField<>(String.class, "districtCode");
        TypedField<String> BIZ_UNIT_CODE = new TypedField<>(String.class, "bizUnitCode");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> LEVEL_ONE_DEPARTMENT_CODE = new TypedField<>(String.class, "levelOneDepartmentCode");
        TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "levelOneDepartmentName");
        TypedField<String> REQUEST_ID = new TypedField<>(String.class, "requestId");
        TypedField<String> PUSH_TIME = new TypedField<>(String.class, "pushTime");
        TypedField<Long> CC_CREATE_USER_ID = new TypedField<>(Long.class, "ccCreateUserId");
        TypedField<String> CC_CREATE_USER_NAME = new TypedField<>(String.class, "ccCreateUserName");
        TypedField<Long> CC_UPDATE_USER_ID = new TypedField<>(Long.class, "ccUpdateUserId");
        TypedField<String> CC_UPDATE_USER_NAME = new TypedField<>(String.class, "ccUpdateUserName");
        TypedField<LocalDateTime> INSERT_TIME = new TypedField<>(LocalDateTime.class, "insertTime");

        interface ToOneRel {
        }
    }
    public interface ChargeGivenRelation {
        static Long id() {
            return 1458801856491102209L;
        }
        static String code() {
            return "chargeGivenRelation";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<LocalDateTime> TAX_START_DATE = new TypedField<>(LocalDateTime.class, "taxStartDate");
        TypedField<LocalDateTime> SETTLEMENT_START_DATE = new TypedField<>(LocalDateTime.class, "settlementStartDate");
        TypedField<LocalDateTime> SETTLEMENT_END_DATE = new TypedField<>(LocalDateTime.class, "settlementEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAX_NO_COMPANY_NAME = new TypedField<>(String.class, "taxNoCompanyName");
        TypedField<Long> CORRESPONDING_TENANT_ID = new TypedField<>(Long.class, "correspondingTenantId");
        TypedField<String> CORRESPONDING_TENANT_NAME = new TypedField<>(String.class, "correspondingTenantName");

    }
    public interface AuthorizedMembers {
        static Long id() {
            return 1460896585479196673L;
        }
        static String code() {
            return "authorizedMembers";
        }
        TypedField<String> AUTHORIZED_MEMBER_CODE = new TypedField<>(String.class, "authorizedMemberCode");
        TypedField<String> AUTHORIZED_MEMBER_NAME = new TypedField<>(String.class, "authorizedMemberName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ACTIVE = new TypedField<>(String.class, "active");
        TypedField<LocalDateTime> INACTIVE_TIME = new TypedField<>(LocalDateTime.class, "inactiveTime");
        /**
         * 对多关联关系 关联对象 chargeCodePool
         */
        TypedField<Long> AUTHORIZEDMEMBERS_ID = new TypedField<>(Long.class, "authorizedMembers.id");

        interface ToOneRel {
            interface AUTHORIZEDMEMBERS {
                static String code () {
                    return "authorizedMembers" ;
                }
                TypedField<String> CC_CODE = new TypedField<>(String.class, "authorizedMembers.ccCode");
                TypedField<String> CC_NAME = new TypedField<>(String.class, "authorizedMembers.ccName");
                TypedField<String> CC_TYPE = new TypedField<>(String.class, "authorizedMembers.ccType");
                TypedField<String> RELATION_CODES = new TypedField<>(String.class, "authorizedMembers.relationCodes");
                TypedField<String> DISTRICT = new TypedField<>(String.class, "authorizedMembers.district");
                TypedField<String> BIZ_UNIT = new TypedField<>(String.class, "authorizedMembers.bizUnit");
                TypedField<String> CC_STATUS = new TypedField<>(String.class, "authorizedMembers.ccStatus");
                TypedField<String> EXTENSION_TAG = new TypedField<>(String.class, "authorizedMembers.extensionTag");
                TypedField<Long> ID = new TypedField<>(Long.class, "authorizedMembers.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "authorizedMembers.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "authorizedMembers.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "authorizedMembers.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "authorizedMembers.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "authorizedMembers.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "authorizedMembers.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "authorizedMembers.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "authorizedMembers.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "authorizedMembers.delete_flag");
                TypedField<String> KAM = new TypedField<>(String.class, "authorizedMembers.kam");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "authorizedMembers.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "authorizedMembers.ownerName");
                TypedField<String> PRIMARY_LEADER_CODE = new TypedField<>(String.class, "authorizedMembers.primaryLeaderCode");
                TypedField<String> PRIMARY_LEADER_NAME = new TypedField<>(String.class, "authorizedMembers.primaryLeaderName");
                TypedField<String> CC_TYPE_CODE = new TypedField<>(String.class, "authorizedMembers.ccTypeCode");
                TypedField<String> DISTRICT_CODE = new TypedField<>(String.class, "authorizedMembers.districtCode");
                TypedField<String> BIZ_UNIT_CODE = new TypedField<>(String.class, "authorizedMembers.bizUnitCode");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "authorizedMembers.kamCode");
                TypedField<String> LEVEL_ONE_DEPARTMENT_CODE = new TypedField<>(String.class, "authorizedMembers.levelOneDepartmentCode");
                TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "authorizedMembers.levelOneDepartmentName");
                TypedField<String> REQUEST_ID = new TypedField<>(String.class, "authorizedMembers.requestId");
                TypedField<String> PUSH_TIME = new TypedField<>(String.class, "authorizedMembers.pushTime");
                TypedField<Long> CC_CREATE_USER_ID = new TypedField<>(Long.class, "authorizedMembers.ccCreateUserId");
                TypedField<String> CC_CREATE_USER_NAME = new TypedField<>(String.class, "authorizedMembers.ccCreateUserName");
                TypedField<Long> CC_UPDATE_USER_ID = new TypedField<>(Long.class, "authorizedMembers.ccUpdateUserId");
                TypedField<String> CC_UPDATE_USER_NAME = new TypedField<>(String.class, "authorizedMembers.ccUpdateUserName");
                TypedField<LocalDateTime> INSERT_TIME = new TypedField<>(LocalDateTime.class, "authorizedMembers.insertTime");
            }
        }
    }
    public interface InvoiceRawData {
        static Long id() {
            return 1460936664507584513L;
        }
        static String code() {
            return "invoiceRawData";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PAPER_DRAW_DATE = new TypedField<>(String.class, "paperDrawDate");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "deposeTime");
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RAW_JSON = new TypedField<>(String.class, "rawJson");

    }
    public interface ReceivedPaymentsNotTaken {
        static Long id() {
            return 1461010346936832002L;
        }
        static String code() {
            return "receivedPaymentsNotTaken";
        }
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "waitingTakenMoney");
        TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "takenMoney");
        TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface ReceivedPaymentsNoNeed {
        static Long id() {
            return 1461010672058306561L;
        }
        static String code() {
            return "receivedPaymentsNoNeed";
        }
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

        interface ToOneRel {
        }
    }
    public interface ReceivedPaymentsTaken {
        static Long id() {
            return 1461010979454652417L;
        }
        static String code() {
            return "receivedPaymentsTaken";
        }
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "takenMoney");
        TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ACCOUNT_NAME = new TypedField<>(String.class, "accountName");

        interface ToOneRel {
        }
    }
    public interface AllocationByOrder {
        static Long id() {
            return 1461023981952241666L;
        }
        static String code() {
            return "allocationByOrder";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDER_MONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDER_WAITING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<BigDecimal> ORDER_INVOICE_MONEY = new TypedField<>(BigDecimal.class, "orderInvoiceMoney");
        TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_START_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_END_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<LocalDateTime> ORDER_DATE = new TypedField<>(LocalDateTime.class, "orderDate");
        TypedField<BigDecimal> CURRENT_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
        /**
         * 对多关联关系 关联对象 receivedPaymentsNotTaken
         */
        TypedField<Long> ONERECEIVEPAYMENTSNOTTAKENTOMANYALLOCATIONS_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.id");

        interface ToOneRel {
            interface ONERECEIVEPAYMENTSNOTTAKENTOMANYALLOCATIONS {
                static String code () {
                    return "oneReceivePaymentsNotTakenToManyAllocations" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyAllocations.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyAllocations.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.takenStatus");
                TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyAllocations.waitingTakenMoney");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyAllocations.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyAllocations.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyAllocations.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.delete_flag");
            }
        }
    }
    public interface AllocationByInvoice {
        static Long id() {
            return 1461157480399048706L;
        }
        static String code() {
            return "allocationByInvoice";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDER_MONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDER_WAITING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_START_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_END_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> CURRENT_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_COMPANY_NAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<BigDecimal> INVOICE_MONEY = new TypedField<>(BigDecimal.class, "invoiceMoney");
        TypedField<BigDecimal> INVOICE_WAITING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "invoiceWaitingWrittenOffMoney");
        TypedField<BigDecimal> INVOICE_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "invoiceWrittenOffMoney");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoiceDate");
        /**
         * 对多关联关系 关联对象 receivedPaymentsNotTaken
         */
        TypedField<Long> ONERECEIVEPAYMENTSNOTTAKENTOMANYINVOICEALLOCATIONS_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.id");

        interface ToOneRel {
            interface ONERECEIVEPAYMENTSNOTTAKENTOMANYINVOICEALLOCATIONS {
                static String code () {
                    return "oneReceivePaymentsNotTakenToManyInvoiceAllocations" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.takenStatus");
                TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.waitingTakenMoney");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.delete_flag");
            }
        }
    }
    public interface AllocationByTaxNo {
        static Long id() {
            return 1461158165773488129L;
        }
        static String code() {
            return "allocationByTaxNo";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDER_MONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDER_WAITING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_START_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_END_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<LocalDateTime> ORDER_DATE = new TypedField<>(LocalDateTime.class, "orderDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> CURRENT_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
        TypedField<String> USING_COMPANY_NAME = new TypedField<>(String.class, "usingCompanyName");
        TypedField<BigDecimal> USING_PAYABLE_MONEY = new TypedField<>(BigDecimal.class, "usingPayableMoney");
        TypedField<BigDecimal> USING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "usingWrittenOffMoney");
        TypedField<String> USING_TAX_NO = new TypedField<>(String.class, "usingTaxNo");
        /**
         * 对多关联关系 关联对象 receivedPaymentsNotTaken
         */
        TypedField<Long> ONERECEIVEPAYMENTSNOTTAKENTOMANYTAXNOALLOCATIONS_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.id");

        interface ToOneRel {
            interface ONERECEIVEPAYMENTSNOTTAKENTOMANYTAXNOALLOCATIONS {
                static String code () {
                    return "oneReceivePaymentsNotTakenToManyTaxNoAllocations" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.takenStatus");
                TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.waitingTakenMoney");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.delete_flag");
            }
        }
    }
    public interface NoNeedList {
        static Long id() {
            return 1461263582046392321L;
        }
        static String code() {
            return "noNeedList";
        }
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface CapitalFlowOperationRecord {
        static Long id() {
            return 1464077964732080130L;
        }
        static String code() {
            return "capitalFlowOperationRecord";
        }
        TypedField<LocalDateTime> OPERATION_TIME = new TypedField<>(LocalDateTime.class, "operationTime");
        TypedField<String> OPERATION_PERSON = new TypedField<>(String.class, "operationPerson");
        TypedField<String> OPERATION_CONTENT = new TypedField<>(String.class, "operationContent");
        TypedField<String> RESULT = new TypedField<>(String.class, "result");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        /**
         * 对多关联关系 关联对象 payWater
         */
        TypedField<Long> ONERECEIVEDPAYMENTTOMANYCAPITALFLOWRECORDS_ID = new TypedField<>(Long.class, "oneReceivedPaymentToManyCapitalFlowRecords.id");
        /**
         * 对多关联关系 关联对象 receivedPaymentsTaken
         */
        TypedField<Long> ONERECEIVEDPAYMENTTAKENTOMANYRECORDS_ID = new TypedField<>(Long.class, "oneReceivedPaymentTakenToManyRecords.id");
        /**
         * 对多关联关系 关联对象 receivedPaymentsNotTaken
         */
        TypedField<Long> ONERECEIVEDPAYMENTNOTTAKENTOMANYRECORDS_ID = new TypedField<>(Long.class, "oneReceivedPaymentNotTakenToManyRecords.id");
        /**
         * 对多关联关系 关联对象 receivedPaymentsNoNeed
         */
        TypedField<Long> ONECAPITALFLOWNONEEDTOMANYRESUMES_ID = new TypedField<>(Long.class, "oneCapitalFlowNoNeedToManyResumes.id");

        interface ToOneRel {
            interface ONERECEIVEDPAYMENTTOMANYCAPITALFLOWRECORDS {
                static String code () {
                    return "oneReceivedPaymentToManyCapitalFlowRecords" ;
                }
                TypedField<LocalDateTime> TRADE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentToManyCapitalFlowRecords.tradeTime");
                TypedField<BigDecimal> DEBIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "oneReceivedPaymentToManyCapitalFlowRecords.debitMoneyAmount");
                TypedField<BigDecimal> CREDIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "oneReceivedPaymentToManyCapitalFlowRecords.creditMoneyAmount");
                TypedField<String> BANK_NAME = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.bankName");
                TypedField<String> BANK_ACCOUNT = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.bankAccount");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.openAccountInstitutions");
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.tradeNo");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivedPaymentToManyCapitalFlowRecords.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivedPaymentToManyCapitalFlowRecords.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentToManyCapitalFlowRecords.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentToManyCapitalFlowRecords.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentToManyCapitalFlowRecords.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentToManyCapitalFlowRecords.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.delete_flag");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.currency");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.customerName");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentToManyCapitalFlowRecords.accountingDate");
                TypedField<String> ABSTRACTION = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.abstraction");
            }
            interface ONERECEIVEDPAYMENTTAKENTOMANYRECORDS {
                static String code () {
                    return "oneReceivedPaymentTakenToManyRecords" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentTakenToManyRecords.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivedPaymentTakenToManyRecords.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.takenStatus");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivedPaymentTakenToManyRecords.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.remark");
                TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.contractSignatureName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.contractNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.projectName");
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.orderNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.productName");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivedPaymentTakenToManyRecords.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivedPaymentTakenToManyRecords.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentTakenToManyRecords.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentTakenToManyRecords.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentTakenToManyRecords.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentTakenToManyRecords.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.delete_flag");
                TypedField<String> ACCOUNT_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.accountName");
            }
            interface ONERECEIVEDPAYMENTNOTTAKENTOMANYRECORDS {
                static String code () {
                    return "oneReceivedPaymentNotTakenToManyRecords" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentNotTakenToManyRecords.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivedPaymentNotTakenToManyRecords.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.takenStatus");
                TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivedPaymentNotTakenToManyRecords.waitingTakenMoney");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivedPaymentNotTakenToManyRecords.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivedPaymentNotTakenToManyRecords.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivedPaymentNotTakenToManyRecords.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentNotTakenToManyRecords.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentNotTakenToManyRecords.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentNotTakenToManyRecords.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentNotTakenToManyRecords.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.delete_flag");
            }
            interface ONECAPITALFLOWNONEEDTOMANYRESUMES {
                static String code () {
                    return "oneCapitalFlowNoNeedToManyResumes" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneCapitalFlowNoNeedToManyResumes.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneCapitalFlowNoNeedToManyResumes.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.takenStatus");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneCapitalFlowNoNeedToManyResumes.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneCapitalFlowNoNeedToManyResumes.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneCapitalFlowNoNeedToManyResumes.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneCapitalFlowNoNeedToManyResumes.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneCapitalFlowNoNeedToManyResumes.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneCapitalFlowNoNeedToManyResumes.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.delete_flag");
            }
        }
    }
    public interface Test {
        static Long id() {
            return 1467688303306440706L;
        }
        static String code() {
            return "test";
        }
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> AGE = new TypedField<>(Long.class, "age");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> RETENTION_MONEY = new TypedField<>(String.class, "retentionMoney");
        TypedField<String> NEW_FIELD = new TypedField<>(String.class, "newField");

    }
    public interface Order {
        static Long id() {
            return 1468879132712730625L;
        }
        static String code() {
            return "order";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "totalAmountWithTax");
        TypedField<String> DISCOUNT_AMOUNT = new TypedField<>(String.class, "discountAmount");
        TypedField<String> PAYABLE_AMOUNT = new TypedField<>(String.class, "payableAmount");
        TypedField<String> ACTUAL_PAYMENT_AMOUNT = new TypedField<>(String.class, "actualPaymentAmount");
        TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "generateDate");
        TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "reconciliationStatus");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<Boolean> VALIDATED = new TypedField<>(Boolean.class, "validated");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<BigDecimal> TAX_QUANTITY = new TypedField<>(BigDecimal.class, "taxQuantity");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> DISCOUNT_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "discountAmountWithoutTax");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> RETENTION_MONEY = new TypedField<>(String.class, "retentionMoney");
        /**
         * 对多关联关系 关联对象 settlementMainData
         */
        TypedField<Long> MANYORDERTOONESETTLEMENT_ID = new TypedField<>(Long.class, "manyOrderToOneSettlement.id");
        /**
         * 对多关联关系 关联对象 incomeDetail
         */
        TypedField<Long> ONEINCOMEDETAILTOMANYORDER_ID = new TypedField<>(Long.class, "oneIncomeDetailToManyOrder.id");

        interface ToOneRel {
            interface MANYORDERTOONESETTLEMENT {
                static String code () {
                    return "manyOrderToOneSettlement" ;
                }
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "manyOrderToOneSettlement.projectName");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "manyOrderToOneSettlement.productName");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "manyOrderToOneSettlement.chargeRequirement");
                TypedField<BigDecimal> SETTLED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "manyOrderToOneSettlement.settledMoneyWithTax");
                TypedField<BigDecimal> WAITING_SETTLE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "manyOrderToOneSettlement.waitingSettleMoneyWithTax");
                TypedField<BigDecimal> INVOICED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "manyOrderToOneSettlement.invoicedMoneyWithTax");
                TypedField<BigDecimal> RETURNED_MONEY = new TypedField<>(BigDecimal.class, "manyOrderToOneSettlement.returnedMoney");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyOrderToOneSettlement.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyOrderToOneSettlement.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyOrderToOneSettlement.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyOrderToOneSettlement.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyOrderToOneSettlement.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyOrderToOneSettlement.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyOrderToOneSettlement.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyOrderToOneSettlement.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyOrderToOneSettlement.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyOrderToOneSettlement.delete_flag");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "manyOrderToOneSettlement.contractNo");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "manyOrderToOneSettlement.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "manyOrderToOneSettlement.chargeEndDate");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "manyOrderToOneSettlement.chargeType");
                TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "manyOrderToOneSettlement.statementNo");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "manyOrderToOneSettlement.customer");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "manyOrderToOneSettlement.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "manyOrderToOneSettlement.principalPerson");
                TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "manyOrderToOneSettlement.tenantGroupId");
                TypedField<BigDecimal> ORDER_TOTAL_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "manyOrderToOneSettlement.orderTotalMoneyWithTax");
                TypedField<String> REGION = new TypedField<>(String.class, "manyOrderToOneSettlement.region");
                TypedField<String> REGION_ID = new TypedField<>(String.class, "manyOrderToOneSettlement.regionId");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "manyOrderToOneSettlement.productCode");
            }
            interface ONEINCOMEDETAILTOMANYORDER {
                static String code () {
                    return "oneIncomeDetailToManyOrder" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.contractNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.projectName");
                TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.statementNo");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.property");
                TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.chargeUnit");
                TypedField<LocalDateTime> START_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "oneIncomeDetailToManyOrder.startChargeDate");
                TypedField<LocalDateTime> END_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "oneIncomeDetailToManyOrder.endChargeDate");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneIncomeDetailToManyOrder.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneIncomeDetailToManyOrder.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneIncomeDetailToManyOrder.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneIncomeDetailToManyOrder.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneIncomeDetailToManyOrder.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneIncomeDetailToManyOrder.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.delete_flag");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.companyName");
                TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.companyTax");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.productName");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "oneIncomeDetailToManyOrder.amount");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneIncomeDetailToManyOrder.unitPriceWithoutTax");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "oneIncomeDetailToManyOrder.taxRate");
                TypedField<BigDecimal> CURRENT_INCOME_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneIncomeDetailToManyOrder.currentIncomeWithoutTax");
                TypedField<String> ACCEPTANCE_DATE = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.acceptanceDate");
                TypedField<String> ACCOUNTING_TIME = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.accountingTime");
                TypedField<String> CHARGE_METHOD = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.chargeMethod");
                TypedField<String> USING_MONTH = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.usingMonth");
                TypedField<String> STATUS = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.status");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.customer");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.principalPerson");
                TypedField<String> REGION = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.region");
                TypedField<String> REGION_ID = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.regionId");
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.orderNo");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.productCode");
                TypedField<String> RELATED_ORDER_NOS = new TypedField<>(String.class, "oneIncomeDetailToManyOrder.relatedOrderNos");
            }
        }
    }
    public interface SettleStaticsOrderRel {
        static Long id() {
            return 1469139798002339842L;
        }
        static String code() {
            return "settleStaticsOrderRel";
        }
        TypedField<Long> SETTLE_STATICS_ID = new TypedField<>(Long.class, "settleStaticsId");
        TypedField<Long> ORDER_ID = new TypedField<>(Long.class, "orderId");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ChargeCodeBudget {
        static Long id() {
            return 1473551179818655746L;
        }
        static String code() {
            return "chargeCodeBudget";
        }
        TypedField<String> CC_CODE = new TypedField<>(String.class, "ccCode");
        TypedField<String> CC_NAME = new TypedField<>(String.class, "ccName");
        TypedField<String> CC_TYPE = new TypedField<>(String.class, "ccType");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> CFO_CODE = new TypedField<>(String.class, "cfoCode");
        TypedField<String> CFO_NAME = new TypedField<>(String.class, "cfoName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CC_TYPE_CODE = new TypedField<>(String.class, "ccTypeCode");
        TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "levelOneDepartmentName");
        TypedField<String> LEVEL_ONE_DEPARTMENT_CODE = new TypedField<>(String.class, "levelOneDepartmentCode");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> REQUEST_ID = new TypedField<>(String.class, "requestId");
        TypedField<String> PUSH_TIME = new TypedField<>(String.class, "pushTime");
        TypedField<Long> CC_CREATE_USER_ID = new TypedField<>(Long.class, "ccCreateUserId");
        TypedField<String> CC_CREATE_USER_NAME = new TypedField<>(String.class, "ccCreateUserName");
        TypedField<Long> CC_UPDATE_USER_ID = new TypedField<>(Long.class, "ccUpdateUserId");
        TypedField<String> CC_UPDATE_USER_NAME = new TypedField<>(String.class, "ccUpdateUserName");
        TypedField<String> APPROVE_DATE = new TypedField<>(String.class, "approveDate");
        TypedField<String> INVALID_DATE = new TypedField<>(String.class, "invalidDate");
        TypedField<LocalDateTime> APPROVE_DATE_WEB = new TypedField<>(LocalDateTime.class, "approveDateWeb");
        TypedField<LocalDateTime> INVALID_DATE_WEB = new TypedField<>(LocalDateTime.class, "invalidDateWeb");

        interface ToOneRel {
        }
    }
    public interface Organize {
        static Long id() {
            return 1473561617230913537L;
        }
        static String code() {
            return "organize";
        }
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "orgCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> OWNER_NO = new TypedField<>(String.class, "ownerNo");
        TypedField<String> PARENT_ORG_NAME = new TypedField<>(String.class, "parentOrgName");
        TypedField<String> PARENT_ORG_CODE = new TypedField<>(String.class, "parentOrgCode");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "orgName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ESTABLISH_DATE = new TypedField<>(String.class, "establishDate");
        TypedField<String> CHANGE_DATE = new TypedField<>(String.class, "changeDate");
        TypedField<String> ORG_LEVEL = new TypedField<>(String.class, "orgLevel");
        TypedField<String> ORG_LEVEL_SERIA = new TypedField<>(String.class, "orgLevelSeria");
        TypedField<String> ORG_ID = new TypedField<>(String.class, "orgId");
        TypedField<String> OWNER_ID = new TypedField<>(String.class, "ownerId");
        TypedField<String> PARENT_ORG_ID = new TypedField<>(String.class, "parentOrgId");
        TypedField<LocalDateTime> ESTABLISH_DATE_WEB = new TypedField<>(LocalDateTime.class, "establishDateWeb");
        TypedField<LocalDateTime> CHANGE_DATE_WEB = new TypedField<>(LocalDateTime.class, "changeDateWeb");

    }
    public interface ChargeCodeBudgetDetail {
        static Long id() {
            return 1473849458675421185L;
        }
        static String code() {
            return "chargeCodeBudgetDetail";
        }
        TypedField<String> BUDGET_DESC = new TypedField<>(String.class, "budgetDesc");
        TypedField<String> BUDGET_AMOUNT = new TypedField<>(String.class, "budgetAmount");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CC_CODE = new TypedField<>(String.class, "ccCode");
        TypedField<String> BUDGET_TYPE = new TypedField<>(String.class, "budgetType");
        /**
         * 对多关联关系 关联对象 chargeCodeBudget
         */
        TypedField<Long> BUDGETDETAIL_ID = new TypedField<>(Long.class, "budgetDetail.id");

        interface ToOneRel {
            interface BUDGETDETAIL {
                static String code () {
                    return "budgetDetail" ;
                }
                TypedField<String> CC_CODE = new TypedField<>(String.class, "budgetDetail.ccCode");
                TypedField<String> CC_NAME = new TypedField<>(String.class, "budgetDetail.ccName");
                TypedField<String> CC_TYPE = new TypedField<>(String.class, "budgetDetail.ccType");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "budgetDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "budgetDetail.ownerName");
                TypedField<String> CFO_CODE = new TypedField<>(String.class, "budgetDetail.cfoCode");
                TypedField<String> CFO_NAME = new TypedField<>(String.class, "budgetDetail.cfoName");
                TypedField<Long> ID = new TypedField<>(Long.class, "budgetDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "budgetDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "budgetDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "budgetDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "budgetDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "budgetDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "budgetDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "budgetDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "budgetDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "budgetDetail.delete_flag");
                TypedField<String> CC_TYPE_CODE = new TypedField<>(String.class, "budgetDetail.ccTypeCode");
                TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "budgetDetail.levelOneDepartmentName");
                TypedField<String> LEVEL_ONE_DEPARTMENT_CODE = new TypedField<>(String.class, "budgetDetail.levelOneDepartmentCode");
                TypedField<String> STATUS = new TypedField<>(String.class, "budgetDetail.status");
                TypedField<String> REQUEST_ID = new TypedField<>(String.class, "budgetDetail.requestId");
                TypedField<String> PUSH_TIME = new TypedField<>(String.class, "budgetDetail.pushTime");
                TypedField<Long> CC_CREATE_USER_ID = new TypedField<>(Long.class, "budgetDetail.ccCreateUserId");
                TypedField<String> CC_CREATE_USER_NAME = new TypedField<>(String.class, "budgetDetail.ccCreateUserName");
                TypedField<Long> CC_UPDATE_USER_ID = new TypedField<>(Long.class, "budgetDetail.ccUpdateUserId");
                TypedField<String> CC_UPDATE_USER_NAME = new TypedField<>(String.class, "budgetDetail.ccUpdateUserName");
                TypedField<String> APPROVE_DATE = new TypedField<>(String.class, "budgetDetail.approveDate");
                TypedField<String> INVALID_DATE = new TypedField<>(String.class, "budgetDetail.invalidDate");
                TypedField<LocalDateTime> APPROVE_DATE_WEB = new TypedField<>(LocalDateTime.class, "budgetDetail.approveDateWeb");
                TypedField<LocalDateTime> INVALID_DATE_WEB = new TypedField<>(LocalDateTime.class, "budgetDetail.invalidDateWeb");
            }
        }
    }
    public interface PmsMateData {
        static Long id() {
            return 1474187323395461122L;
        }
        static String code() {
            return "pmsMateData";
        }
        TypedField<String> PMS_CODE = new TypedField<>(String.class, "pmsCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> PUSH_TIME = new TypedField<>(String.class, "pushTime");
        TypedField<String> BODY = new TypedField<>(String.class, "body");
        TypedField<String> REQUEST_ID = new TypedField<>(String.class, "requestId");

    }
    public interface IncomeDetailOrderRel {
        static Long id() {
            return 1474197210030673922L;
        }
        static String code() {
            return "incomeDetailOrderRel";
        }
        TypedField<Long> INCOME_DETAIL_ID = new TypedField<>(Long.class, "incomeDetailId");
        TypedField<Long> ORDER_ID = new TypedField<>(Long.class, "orderId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");

    }
    public interface MemberInfo {
        static Long id() {
            return 1475703079099883521L;
        }
        static String code() {
            return "memberInfo";
        }
        TypedField<String> MEMBER_NAME = new TypedField<>(String.class, "member_name");
        TypedField<String> MEMBER_CODE = new TypedField<>(String.class, "member_code");
        TypedField<String> BELONGS_COMPANY = new TypedField<>(String.class, "belongs_company");
        TypedField<String> BELONGS_COMPANY_TAX_NO = new TypedField<>(String.class, "belongs_company_tax_no");
        TypedField<String> COMPANY_EMAIL_ADDRESS = new TypedField<>(String.class, "company_email_address");
        TypedField<String> MEMBER_PHONE_NO = new TypedField<>(String.class, "member_phone_no");
        TypedField<String> MEMBER_STATUS = new TypedField<>(String.class, "member_status");
        TypedField<String> BELONGS_DEPARTMENT = new TypedField<>(String.class, "belongs_department");
        TypedField<String> PRIMARY_LEADER_CODE = new TypedField<>(String.class, "primary_leader_code");
        TypedField<String> PRIMARY_LEADER_NAME = new TypedField<>(String.class, "primary_leader_name");
        TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "level_one_department_name");
        TypedField<String> YKB_SYNC_ID = new TypedField<>(String.class, "ykb_sync_id");
        TypedField<String> LEVEL_ONE_DEPARTMENT_CODE = new TypedField<>(String.class, "level_one_department_code");
        TypedField<String> LEVEL_ONE_DEPARTMENT_OWNER_NAME = new TypedField<>(String.class, "level_one_department_owner_name");
        TypedField<String> LEVEL_ONE_DEPARTMENT_OWNER_CODE = new TypedField<>(String.class, "level_one_department_owner_code");
        TypedField<String> MEMBER_LEVEL = new TypedField<>(String.class, "member_level");
        TypedField<String> BELONGS_DEPARTMENT_CODE = new TypedField<>(String.class, "belongs_department_code");
        TypedField<String> IS_OUTER = new TypedField<>(String.class, "is_outer");
        TypedField<String> INDUCTION_TIME = new TypedField<>(String.class, "induction_time");
        TypedField<String> LEAVE_TIME = new TypedField<>(String.class, "leave_time");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SYNC_TIME = new TypedField<>(String.class, "sync_time");
        TypedField<Long> USER_ID = new TypedField<>(Long.class, "user_id");
        TypedField<String> BELONGS_COMPANY_SEIRA = new TypedField<>(String.class, "belongs_company_seira");
        TypedField<String> PRIMARY_LEADER_USER_ID = new TypedField<>(String.class, "primary_leader_user_id");
        TypedField<String> LEVEL_ONE_DEPARTMENT_OWNER_USER_ID = new TypedField<>(String.class, "level_one_department_owner_user_id");
        TypedField<String> LEVEL_ONE_DEPARTMENT_ID = new TypedField<>(String.class, "level_one_department_id");
        TypedField<String> BELONGS_DEPARTMENT_ID = new TypedField<>(String.class, "belongs_department_id");
        TypedField<LocalDateTime> INDUCTION_TIME_WEB = new TypedField<>(LocalDateTime.class, "induction_time_web");
        TypedField<LocalDateTime> LEAVE_TIME_WEB = new TypedField<>(LocalDateTime.class, "leave_time_web");

    }
    public interface FinancialSyncWindow {
        static Long id() {
            return 1476437584449032194L;
        }
        static String code() {
            return "financialSyncWindow";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> SYNC_TIME = new TypedField<>(String.class, "syncTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");

    }
    public interface ChargeCodePrimeCost {
        static Long id() {
            return 1479004481472352258L;
        }
        static String code() {
            return "chargeCodePrimeCost";
        }
        TypedField<String> PROJECT_MONTH = new TypedField<>(String.class, "projectMonth");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CHARGE_CODE_NAME = new TypedField<>(String.class, "chargeCodeName");
        TypedField<String> CHARGE_CODE_DESC = new TypedField<>(String.class, "chargeCodeDesc");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "departmentCode");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "departmentName");
        TypedField<String> TOTAL_AMOUNT = new TypedField<>(String.class, "totalAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROJECT_MONTH_TIME = new TypedField<>(String.class, "projectMonthTime");
        TypedField<String> TOTAL_AMOUNT_WEB = new TypedField<>(String.class, "totalAmountWeb");

    }
    public interface OrderTaxRelation {
        static Long id() {
            return 1481437369255256065L;
        }
        static String code() {
            return "orderTaxRelation";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> TAX_CHARGE_START_DATE = new TypedField<>(String.class, "taxChargeStartDate");
        TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface OrderBillRelation {
        static Long id() {
            return 1481437684166479873L;
        }
        static String code() {
            return "orderBillRelation";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> BILL_DETAIL_NO = new TypedField<>(String.class, "billDetailNo");
        TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface OrderInvoiceRelation {
        static Long id() {
            return 1481437944976691201L;
        }
        static String code() {
            return "orderInvoiceRelation";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface OrderInfo {
        static Long id() {
            return 1481443933895528450L;
        }
        static String code() {
            return "orderInfo";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "pricingUnit");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<Long> USING_MONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<Long> ACCOUNTING_PERIOD = new TypedField<>(Long.class, "accountingPeriod");
        TypedField<String> CURRENT_PERIOD_INCOME_AMOUNT = new TypedField<>(String.class, "currentPeriodIncomeAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<Long> VERSION = new TypedField<>(Long.class, "version");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        /**
         * 对多关联关系 关联对象 contract
         */
        TypedField<Long> MANYORDERTOONECONTRACT_ID = new TypedField<>(Long.class, "manyOrderToOneContract.id");
        /**
         * 对多关联关系 关联对象 contractDetail
         */
        TypedField<Long> ORDERTOCONTRACTDETAIL_ID = new TypedField<>(Long.class, "orderToContractDetail.id");

        interface ToOneRel {
            interface MANYORDERTOONECONTRACT {
                static String code () {
                    return "manyOrderToOneContract" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "manyOrderToOneContract.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "manyOrderToOneContract.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "manyOrderToOneContract.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "manyOrderToOneContract.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "manyOrderToOneContract.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "manyOrderToOneContract.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyOrderToOneContract.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyOrderToOneContract.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyOrderToOneContract.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyOrderToOneContract.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyOrderToOneContract.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyOrderToOneContract.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyOrderToOneContract.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyOrderToOneContract.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyOrderToOneContract.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyOrderToOneContract.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "manyOrderToOneContract.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "manyOrderToOneContract.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "manyOrderToOneContract.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "manyOrderToOneContract.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "manyOrderToOneContract.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "manyOrderToOneContract.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "manyOrderToOneContract.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "manyOrderToOneContract.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "manyOrderToOneContract.saChargeCodeName");
                TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "manyOrderToOneContract.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "manyOrderToOneContract.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "manyOrderToOneContract.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "manyOrderToOneContract.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "manyOrderToOneContract.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "manyOrderToOneContract.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "manyOrderToOneContract.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "manyOrderToOneContract.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "manyOrderToOneContract.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "manyOrderToOneContract.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "manyOrderToOneContract.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "manyOrderToOneContract.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "manyOrderToOneContract.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "manyOrderToOneContract.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "manyOrderToOneContract.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "manyOrderToOneContract.chargeCycle");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "manyOrderToOneContract.attachmentUrl");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "manyOrderToOneContract.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "manyOrderToOneContract.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "manyOrderToOneContract.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "manyOrderToOneContract.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "manyOrderToOneContract.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "manyOrderToOneContract.contractVersion");
            }
            interface ORDERTOCONTRACTDETAIL {
                static String code () {
                    return "orderToContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "orderToContractDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "orderToContractDetail.productName");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "orderToContractDetail.productCode");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "orderToContractDetail.amount");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "orderToContractDetail.unitPrice");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "orderToContractDetail.chargeRequirement");
                TypedField<Long> ID = new TypedField<>(Long.class, "orderToContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "orderToContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "orderToContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "orderToContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "orderToContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "orderToContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "orderToContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "orderToContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "orderToContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "orderToContractDetail.delete_flag");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "orderToContractDetail.chargeType");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "orderToContractDetail.taxRate");
                TypedField<String> VALIDATION = new TypedField<>(String.class, "orderToContractDetail.validation");
                TypedField<String> QUANTITY = new TypedField<>(String.class, "orderToContractDetail.quantity");
                TypedField<String> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(String.class, "orderToContractDetail.unitPriceWithoutTax");
            }
        }
    }
    public interface BillStatics {
        static Long id() {
            return 1481470809122721793L;
        }
        static String code() {
            return "billStatics";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<LocalDateTime> SETTLEMENT_START_DATE = new TypedField<>(LocalDateTime.class, "settlementStartDate");
        TypedField<LocalDateTime> SETTLEMENT_END_DATE = new TypedField<>(LocalDateTime.class, "settlementEndDate");
        TypedField<String> SETTLEMENT_AMOUNT_WITH_TAX = new TypedField<>(String.class, "settlementAmountWithTax");
        TypedField<String> SETTLEMENT_DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(String.class, "settlementDiscountAmountWithTax");
        TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "generateDate");
        TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "reconciliationStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface BillStaticsDetail {
        static Long id() {
            return 1481471899815907330L;
        }
        static String code() {
            return "billStaticsDetail";
        }
        TypedField<String> BILL_DETAIL_NO = new TypedField<>(String.class, "billDetailNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NO = new TypedField<>(String.class, "productNo");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> SALE_PRICE_WITHOUT_TAX = new TypedField<>(String.class, "salePriceWithoutTax");
        TypedField<String> UNIT_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "unitAmountWithoutTax");
        TypedField<String> CURRENT_PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(String.class, "currentPayableAmountWithTax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface Bill {
        static Long id() {
            return 1481525805784682498L;
        }
        static String code() {
            return "bill";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<LocalDateTime> SETTLEMENT_START_DATE = new TypedField<>(LocalDateTime.class, "settlementStartDate");
        TypedField<LocalDateTime> SETTLEMENT_END_DATE = new TypedField<>(LocalDateTime.class, "settlementEndDate");
        TypedField<String> SETTLEMENT_AMOUNT_WITH_TAX = new TypedField<>(String.class, "settlementAmountWithTax");
        TypedField<String> SETTLEMENT_DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(String.class, "settlementDiscountAmountWithTax");
        TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "generateDate");
        TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "reconciliationStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface BillDetail {
        static Long id() {
            return 1481527030850785282L;
        }
        static String code() {
            return "billDetail";
        }
        TypedField<String> BILL_DETAIL_NO = new TypedField<>(String.class, "billDetailNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NO = new TypedField<>(String.class, "productNo");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> PAYMENT_METHOD = new TypedField<>(String.class, "paymentMethod");
        TypedField<String> SALE_PRICE_WITHOUT_TAX = new TypedField<>(String.class, "salePriceWithoutTax");
        TypedField<String> UNIT_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "unitAmountWithoutTax");
        TypedField<String> CURRENT_PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(String.class, "currentPayableAmountWithTax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface IncomeSummary {
        static Long id() {
            return 1481539368520966145L;
        }
        static String code() {
            return "incomeSummary";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "pricingUnit");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<Long> USING_MONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<Long> ACCOUNTING_PERIOD = new TypedField<>(Long.class, "accountingPeriod");
        TypedField<String> CURRENT_PERIOD_INCOME_AMOUNT = new TypedField<>(String.class, "currentPeriodIncomeAmount");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        /**
         * 对多关联关系 关联对象 contract
         */
        TypedField<Long> INCOMETOONECONTRACTMAIN_ID = new TypedField<>(Long.class, "incomeToOneContractMain.id");
        /**
         * 对多关联关系 关联对象 contractDetail
         */
        TypedField<Long> INCOMETOONECONTRACTDETAIL_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");

        interface ToOneRel {
            interface INCOMETOONECONTRACTMAIN {
                static String code () {
                    return "incomeToOneContractMain" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractMain.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "incomeToOneContractMain.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeToOneContractMain.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "incomeToOneContractMain.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "incomeToOneContractMain.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "incomeToOneContractMain.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeToOneContractMain.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeToOneContractMain.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeToOneContractMain.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractMain.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractMain.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractMain.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractMain.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractMain.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractMain.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeToOneContractMain.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "incomeToOneContractMain.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "incomeToOneContractMain.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "incomeToOneContractMain.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "incomeToOneContractMain.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "incomeToOneContractMain.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "incomeToOneContractMain.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "incomeToOneContractMain.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "incomeToOneContractMain.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "incomeToOneContractMain.saChargeCodeName");
                TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "incomeToOneContractMain.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractMain.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "incomeToOneContractMain.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "incomeToOneContractMain.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "incomeToOneContractMain.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "incomeToOneContractMain.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "incomeToOneContractMain.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "incomeToOneContractMain.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "incomeToOneContractMain.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "incomeToOneContractMain.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "incomeToOneContractMain.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "incomeToOneContractMain.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "incomeToOneContractMain.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "incomeToOneContractMain.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "incomeToOneContractMain.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "incomeToOneContractMain.chargeCycle");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "incomeToOneContractMain.attachmentUrl");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "incomeToOneContractMain.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "incomeToOneContractMain.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "incomeToOneContractMain.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "incomeToOneContractMain.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "incomeToOneContractMain.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "incomeToOneContractMain.contractVersion");
            }
            interface INCOMETOONECONTRACTDETAIL {
                static String code () {
                    return "incomeToOneContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.productName");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.productCode");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.amount");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.unitPrice");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "incomeToOneContractDetail.chargeRequirement");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeToOneContractDetail.delete_flag");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "incomeToOneContractDetail.chargeType");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "incomeToOneContractDetail.taxRate");
                TypedField<String> VALIDATION = new TypedField<>(String.class, "incomeToOneContractDetail.validation");
                TypedField<String> QUANTITY = new TypedField<>(String.class, "incomeToOneContractDetail.quantity");
                TypedField<String> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(String.class, "incomeToOneContractDetail.unitPriceWithoutTax");
            }
        }
    }
    public interface IncomeItem {
        static Long id() {
            return 1481546350567804929L;
        }
        static String code() {
            return "incomeItem";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> RELATED_ORDER_NOS = new TypedField<>(String.class, "relatedOrderNos");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "pricingUnit");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<Long> USING_MONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<Long> ACCOUNTING_PERIOD = new TypedField<>(Long.class, "accountingPeriod");
        TypedField<String> CURRENT_PERIOD_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "currentPeriodAmountWithoutTax");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对多关联关系 关联对象 contract
         */
        TypedField<Long> INCOMEDETAILTOONECONTRACT_ID = new TypedField<>(Long.class, "incomeDetailToOneContract.id");
        /**
         * 对多关联关系 关联对象 contractDetail
         */
        TypedField<Long> INCOMETOONECONTRACTDETAIL_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");

        interface ToOneRel {
            interface INCOMEDETAILTOONECONTRACT {
                static String code () {
                    return "incomeDetailToOneContract" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeDetailToOneContract.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "incomeDetailToOneContract.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "incomeDetailToOneContract.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "incomeDetailToOneContract.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "incomeDetailToOneContract.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeDetailToOneContract.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeDetailToOneContract.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeDetailToOneContract.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeDetailToOneContract.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeDetailToOneContract.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeDetailToOneContract.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeDetailToOneContract.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "incomeDetailToOneContract.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "incomeDetailToOneContract.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "incomeDetailToOneContract.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "incomeDetailToOneContract.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "incomeDetailToOneContract.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "incomeDetailToOneContract.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.saChargeCodeName");
                TypedField<String> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "incomeDetailToOneContract.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "incomeDetailToOneContract.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "incomeDetailToOneContract.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "incomeDetailToOneContract.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "incomeDetailToOneContract.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "incomeDetailToOneContract.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "incomeDetailToOneContract.chargeCycle");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "incomeDetailToOneContract.attachmentUrl");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "incomeDetailToOneContract.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "incomeDetailToOneContract.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "incomeDetailToOneContract.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "incomeDetailToOneContract.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "incomeDetailToOneContract.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "incomeDetailToOneContract.contractVersion");
            }
            interface INCOMETOONECONTRACTDETAIL {
                static String code () {
                    return "incomeToOneContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.productName");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.productCode");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.amount");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.unitPrice");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "incomeToOneContractDetail.chargeRequirement");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeToOneContractDetail.delete_flag");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "incomeToOneContractDetail.chargeType");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "incomeToOneContractDetail.taxRate");
                TypedField<String> VALIDATION = new TypedField<>(String.class, "incomeToOneContractDetail.validation");
                TypedField<String> QUANTITY = new TypedField<>(String.class, "incomeToOneContractDetail.quantity");
                TypedField<String> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(String.class, "incomeToOneContractDetail.unitPriceWithoutTax");
            }
        }
    }
    public interface BillTaxUsage {
        static Long id() {
            return 1482962910322065410L;
        }
        static String code() {
            return "billTaxUsage";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> CHARGE_BIZ_DIMENSION = new TypedField<>(String.class, "chargeBizDimension");
        TypedField<String> ACTUAL_BIZ_VOLUME = new TypedField<>(String.class, "actualBizVolume");
        TypedField<String> BIZ_MONTH = new TypedField<>(String.class, "bizMonth");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
}
