package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * order_info
 * </p>
 *
 * @author ultraman
 * @since 2022-02-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderInfo implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 订单号
   */
  private String orderNo;
  /**
   * 计价单位
   */
  private String pricingUnit;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 版本
   */
  private Long version;
  /**
   * 订单状态
   */
  private String orderStatus;
  /**
   * 合同ID
   */
  private String contractId;
  /**
   * 关联合同ID
   */
  private String relatedContractId;
  /**
   * 订单创建日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime generateDateStr;
  /**
   * 订单生效日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime effectiveDateStr;
  /**
   * 订单失效日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expiryDateStr;
  /**
   * 产品编号
   */
  private String productCode;
  /**
   * 产品名称
   */
  private String productName;
  /**
   * 购买产品的数量
   */
  private BigDecimal purchaseQuantity;
  /**
   * 订单总金额(含税)
   */
  private String totalAmountStr;
  /**
   * 订单付款比例
   */
  private BigDecimal paymentPercent;
  /**
   * 付费类型
   */
  private String paymentType;
  /**
   * 服务收费类型
   */
  private String serviceType;
  /**
   * 是否保证金
   */
  private Boolean isRetentionMoney;
  /**
   * 付款条件
   */
  private String paymentRequirement;

  /**
   * 对一关联关系 关联对象 contract
   */
  private Long manyOrderToOneContractId;
  /**
   * 对一关联关系 关联对象 contractDetail
   */
  private Long orderToContractDetailId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderNo", orderNo);
      map.put("pricingUnit", pricingUnit);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("version", version);
      map.put("orderStatus", orderStatus);
      map.put("contractId", contractId);
      map.put("relatedContractId", relatedContractId);
      map.put("generateDateStr", BocpGenUtils.toTimestamp(generateDateStr));
      map.put("effectiveDateStr", BocpGenUtils.toTimestamp(effectiveDateStr));
      map.put("expiryDateStr", BocpGenUtils.toTimestamp(expiryDateStr));
      map.put("productCode", productCode);
      map.put("productName", productName);
      map.put("purchaseQuantity", purchaseQuantity);
      map.put("totalAmountStr", totalAmountStr);
      map.put("paymentPercent", paymentPercent);
      map.put("paymentType", paymentType);
      map.put("serviceType", serviceType);
      map.put("isRetentionMoney", isRetentionMoney);
      map.put("paymentRequirement", paymentRequirement);

      map.put("manyOrderToOneContract.id", manyOrderToOneContractId);
      map.put("orderToContractDetail.id", orderToContractDetailId);
      return map;
  }

  public static OrderInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderInfo entity = new OrderInfo();

    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pricingUnit")) {
      Object obj = map.get("pricingUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPricingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVersion((Long)obj);
        } else if(obj instanceof String) {
          entity.setVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relatedContractId")) {
      Object obj = map.get("relatedContractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelatedContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generateDateStr")) {
      Object obj = map.get("generateDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGenerateDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGenerateDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setGenerateDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGenerateDateStr(null);
      }
    }
    if(map.containsKey("effectiveDateStr")) {
      Object obj = map.get("effectiveDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEffectiveDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEffectiveDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEffectiveDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEffectiveDateStr(null);
      }
    }
    if(map.containsKey("expiryDateStr")) {
      Object obj = map.get("expiryDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpiryDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setExpiryDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setExpiryDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpiryDateStr(null);
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseQuantity")) {
      Object obj = map.get("purchaseQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchaseQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchaseQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchaseQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPurchaseQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaseQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountStr")) {
      Object obj = map.get("totalAmountStr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmountStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPercent")) {
      Object obj = map.get("paymentPercent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentPercent((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentPercent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentPercent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaymentPercent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentPercent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceType")) {
      Object obj = map.get("serviceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setServiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isRetentionMoney")) {
      Object obj = map.get("isRetentionMoney");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsRetentionMoney((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsRetentionMoney(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentRequirement((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("manyOrderToOneContract.id")) {
      Object obj = map.get("manyOrderToOneContract.id");
      if(obj instanceof Long) {
        entity.setManyOrderToOneContractId((Long)obj);
      } else if(obj instanceof String) {
        entity.setManyOrderToOneContractId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("orderToContractDetail.id")) {
      Object obj = map.get("orderToContractDetail.id");
      if(obj instanceof Long) {
        entity.setOrderToContractDetailId((Long)obj);
      } else if(obj instanceof String) {
        entity.setOrderToContractDetailId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pricingUnit")) {
      Object obj = map.get("pricingUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setPricingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setVersion((Long)obj);
        } else if(obj instanceof String) {
            this.setVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relatedContractId")) {
      Object obj = map.get("relatedContractId");
      if(obj != null) {
        if(obj instanceof String){
            this.setRelatedContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generateDateStr")) {
      Object obj = map.get("generateDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGenerateDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGenerateDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setGenerateDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGenerateDateStr(null);
      }
    }
    if(map.containsKey("effectiveDateStr")) {
      Object obj = map.get("effectiveDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEffectiveDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEffectiveDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setEffectiveDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEffectiveDateStr(null);
      }
    }
    if(map.containsKey("expiryDateStr")) {
      Object obj = map.get("expiryDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setExpiryDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setExpiryDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setExpiryDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setExpiryDateStr(null);
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseQuantity")) {
      Object obj = map.get("purchaseQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPurchaseQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPurchaseQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPurchaseQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPurchaseQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPurchaseQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountStr")) {
      Object obj = map.get("totalAmountStr");
      if(obj != null) {
        if(obj instanceof String){
            this.setTotalAmountStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPercent")) {
      Object obj = map.get("paymentPercent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPaymentPercent((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPaymentPercent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPaymentPercent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPaymentPercent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPaymentPercent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceType")) {
      Object obj = map.get("serviceType");
      if(obj != null) {
        if(obj instanceof String){
            this.setServiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isRetentionMoney")) {
      Object obj = map.get("isRetentionMoney");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsRetentionMoney((Boolean)obj);
        } else if(obj instanceof String) {
            this.setIsRetentionMoney(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manyOrderToOneContract.id")) {
      Object obj = map.get("manyOrderToOneContract.id");
      if(obj instanceof Long) {
        this.setManyOrderToOneContractId((Long)obj);
      } else if(obj instanceof String) {
        this.setManyOrderToOneContractId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("orderToContractDetail.id")) {
      Object obj = map.get("orderToContractDetail.id");
      if(obj instanceof Long) {
        this.setOrderToContractDetailId((Long)obj);
      } else if(obj instanceof String) {
        this.setOrderToContractDetailId(Long.parseLong((String)obj));
      }
    }
  }
}
