package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * charge_code_budget
 * </p>
 *
 * @author ultraman
 * @since 2022-04-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChargeCodeBudget implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * Chargecode编号
   */
  private String ccCode;
  /**
   * Chargecode描述
   */
  private String ccName;
  /**
   * Chargecode类型
   */
  private String ccType;
  /**
   * Chargecode负责人工号
   */
  private String ownerCode;
  /**
   * Chargecode负责人
   */
  private String ownerName;
  /**
   * CFO工号
   */
  private String cfoCode;
  /**
   * CFO名称
   */
  private String cfoName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 类型code
   */
  private String ccTypeCode;
  /**
   * 一级部门负责人
   */
  private String levelOneDepartmentName;
  /**
   * 一级部门负责人工号
   */
  private String levelOneDepartmentCode;
  /**
   * 状态
   */
  private String status;
  /**
   * 批次号
   */
  private String requestId;
  /**
   * 推送时间
   */
  private String pushTime;
  /**
   * 创建用户Id
   */
  private Long ccCreateUserId;
  /**
   * 创建用户名称
   */
  private String ccCreateUserName;
  /**
   * 更新用户Id
   */
  private Long ccUpdateUserId;
  /**
   * 更新用户名称
   */
  private String ccUpdateUserName;
  /**
   * 审批通过时间
   */
  private String approveDate;
  /**
   * 失效时间
   */
  private String invalidDate;
  /**
   * 审批通过时间web
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approveDateWeb;
  /**
   * 失效时间web
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invalidDateWeb;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ccCode", ccCode);
      map.put("ccName", ccName);
      map.put("ccType", ccType);
      map.put("ownerCode", ownerCode);
      map.put("ownerName", ownerName);
      map.put("cfoCode", cfoCode);
      map.put("cfoName", cfoName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("ccTypeCode", ccTypeCode);
      map.put("levelOneDepartmentName", levelOneDepartmentName);
      map.put("levelOneDepartmentCode", levelOneDepartmentCode);
      map.put("status", status);
      map.put("requestId", requestId);
      map.put("pushTime", pushTime);
      map.put("ccCreateUserId", ccCreateUserId);
      map.put("ccCreateUserName", ccCreateUserName);
      map.put("ccUpdateUserId", ccUpdateUserId);
      map.put("ccUpdateUserName", ccUpdateUserName);
      map.put("approveDate", approveDate);
      map.put("invalidDate", invalidDate);
      map.put("approveDateWeb", BocpGenUtils.toTimestamp(approveDateWeb));
      map.put("invalidDateWeb", BocpGenUtils.toTimestamp(invalidDateWeb));

      return map;
  }

  public static ChargeCodeBudget fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChargeCodeBudget entity = new ChargeCodeBudget();

    if(map.containsKey("ccCode")) {
      Object obj = map.get("ccCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCcCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccName")) {
      Object obj = map.get("ccName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCcName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccType")) {
      Object obj = map.get("ccType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCcType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cfoCode")) {
      Object obj = map.get("cfoCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCfoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cfoName")) {
      Object obj = map.get("cfoName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCfoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccTypeCode")) {
      Object obj = map.get("ccTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCcTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("levelOneDepartmentName")) {
      Object obj = map.get("levelOneDepartmentName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLevelOneDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("levelOneDepartmentCode")) {
      Object obj = map.get("levelOneDepartmentCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLevelOneDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requestId")) {
      Object obj = map.get("requestId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pushTime")) {
      Object obj = map.get("pushTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPushTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccCreateUserId")) {
      Object obj = map.get("ccCreateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCcCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCcCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCcCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ccCreateUserName")) {
      Object obj = map.get("ccCreateUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCcCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccUpdateUserId")) {
      Object obj = map.get("ccUpdateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCcUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCcUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCcUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ccUpdateUserName")) {
      Object obj = map.get("ccUpdateUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCcUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApproveDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invalidDate")) {
      Object obj = map.get("invalidDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvalidDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approveDateWeb")) {
      Object obj = map.get("approveDateWeb");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApproveDateWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApproveDateWeb((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApproveDateWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApproveDateWeb(null);
      }
    }
    if(map.containsKey("invalidDateWeb")) {
      Object obj = map.get("invalidDateWeb");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvalidDateWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvalidDateWeb((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvalidDateWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvalidDateWeb(null);
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("ccCode")) {
      Object obj = map.get("ccCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setCcCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ccName")) {
      Object obj = map.get("ccName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCcName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ccType")) {
      Object obj = map.get("ccType");
      if(obj != null) {
        if(obj instanceof String){
            this.setCcType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setOwnerCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setOwnerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cfoCode")) {
      Object obj = map.get("cfoCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setCfoCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cfoName")) {
      Object obj = map.get("cfoName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCfoName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ccTypeCode")) {
      Object obj = map.get("ccTypeCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setCcTypeCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("levelOneDepartmentName")) {
      Object obj = map.get("levelOneDepartmentName");
      if(obj != null) {
        if(obj instanceof String){
            this.setLevelOneDepartmentName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("levelOneDepartmentCode")) {
      Object obj = map.get("levelOneDepartmentCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setLevelOneDepartmentCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
            this.setStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("requestId")) {
      Object obj = map.get("requestId");
      if(obj != null) {
        if(obj instanceof String){
            this.setRequestId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("pushTime")) {
      Object obj = map.get("pushTime");
      if(obj != null) {
        if(obj instanceof String){
            this.setPushTime((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ccCreateUserId")) {
      Object obj = map.get("ccCreateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCcCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCcCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCcCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("ccCreateUserName")) {
      Object obj = map.get("ccCreateUserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCcCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ccUpdateUserId")) {
      Object obj = map.get("ccUpdateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCcUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCcUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCcUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("ccUpdateUserName")) {
      Object obj = map.get("ccUpdateUserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCcUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof String){
            this.setApproveDate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invalidDate")) {
      Object obj = map.get("invalidDate");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvalidDate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("approveDateWeb")) {
      Object obj = map.get("approveDateWeb");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setApproveDateWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setApproveDateWeb((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setApproveDateWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setApproveDateWeb(null);
      }
   }
    if(map.containsKey("invalidDateWeb")) {
      Object obj = map.get("invalidDateWeb");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvalidDateWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setInvalidDateWeb((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setInvalidDateWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setInvalidDateWeb(null);
      }
   }

  }

}
