package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * settlement_main_data
 * </p>
 *
 * @author ultraman
 * @since 2022-04-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SettlementMainData implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 产品服务名称
   */
  private String productName;
  /**
   * 本次结算的付款条件
   */
  private String chargeRequirement;
  /**
   * 已结金额（含税）
   */
  private BigDecimal settledMoneyWithTax;
  /**
   * 待结金额（含税）
   */
  private BigDecimal waitingSettleMoneyWithTax;
  /**
   * 已开票金额（含税）
   */
  private BigDecimal invoicedMoneyWithTax;
  /**
   * 回款已核销金额
   */
  private BigDecimal returnedMoney;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 结算起始日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;
  /**
   * 结算结束日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;
  /**
   * 付费类型
   */
  private String chargeType;
  /**
   * 结算对账单编号
   */
  private String statementNo;
  /**
   * 客户
   */
  private String customer;
  /**
   * 经营单元
   */
  private String businessUnit;
  /**
   * 负责人
   */
  private String principalPerson;
  /**
   * 租户id
   */
  private Long tenantGroupId;
  /**
   * 订单总金额(含税)
   */
  private BigDecimal orderTotalMoneyWithTax;
  /**
   * 大区
   */
  private String region;
  /**
   * 大区id
   */
  private String regionId;
  /**
   * 产品code
   */
  private String productCode;

  /**
   * 对一关联关系 关联对象 contract
   */
  private Long toOneContractId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("projectName", projectName);
      map.put("productName", productName);
      map.put("chargeRequirement", chargeRequirement);
      map.put("settledMoneyWithTax", settledMoneyWithTax);
      map.put("waitingSettleMoneyWithTax", waitingSettleMoneyWithTax);
      map.put("invoicedMoneyWithTax", invoicedMoneyWithTax);
      map.put("returnedMoney", returnedMoney);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("contractNo", contractNo);
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("chargeType", chargeType);
      map.put("statementNo", statementNo);
      map.put("customer", customer);
      map.put("businessUnit", businessUnit);
      map.put("principalPerson", principalPerson);
      map.put("tenantGroupId", tenantGroupId);
      map.put("orderTotalMoneyWithTax", orderTotalMoneyWithTax);
      map.put("region", region);
      map.put("regionId", regionId);
      map.put("productCode", productCode);

      map.put("toOneContract.id", toOneContractId);
      return map;
  }

  public static SettlementMainData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SettlementMainData entity = new SettlementMainData();

    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeRequirement")) {
      Object obj = map.get("chargeRequirement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settledMoneyWithTax")) {
      Object obj = map.get("settledMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettledMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettledMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettledMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSettledMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettledMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("waitingSettleMoneyWithTax")) {
      Object obj = map.get("waitingSettleMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWaitingSettleMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWaitingSettleMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWaitingSettleMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setWaitingSettleMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWaitingSettleMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicedMoneyWithTax")) {
      Object obj = map.get("invoicedMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicedMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicedMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicedMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoicedMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicedMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("returnedMoney")) {
      Object obj = map.get("returnedMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnedMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnedMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnedMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReturnedMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnedMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("principalPerson")) {
      Object obj = map.get("principalPerson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrincipalPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantGroupId")) {
      Object obj = map.get("tenantGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantGroupId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderTotalMoneyWithTax")) {
      Object obj = map.get("orderTotalMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderTotalMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderTotalMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderTotalMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderTotalMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotalMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionId")) {
      Object obj = map.get("regionId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("toOneContract.id")) {
       Object obj = map.get("toOneContract.id");
       if(obj instanceof Long) {
         entity.setToOneContractId((Long)obj);
       } else if(obj instanceof String) {
         entity.setToOneContractId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProjectName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeRequirement")) {
      Object obj = map.get("chargeRequirement");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeRequirement((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("settledMoneyWithTax")) {
      Object obj = map.get("settledMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSettledMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSettledMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSettledMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setSettledMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSettledMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("waitingSettleMoneyWithTax")) {
      Object obj = map.get("waitingSettleMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setWaitingSettleMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setWaitingSettleMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setWaitingSettleMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setWaitingSettleMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setWaitingSettleMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("invoicedMoneyWithTax")) {
      Object obj = map.get("invoicedMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoicedMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoicedMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoicedMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setInvoicedMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoicedMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("returnedMoney")) {
      Object obj = map.get("returnedMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReturnedMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReturnedMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReturnedMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setReturnedMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReturnedMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setChargeStartDate(null);
      }
   }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setChargeEndDate(null);
      }
   }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setStatementNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("customer")) {
      Object obj = map.get("customer");
      if(obj != null) {
        if(obj instanceof String){
            this.setCustomer((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("principalPerson")) {
      Object obj = map.get("principalPerson");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrincipalPerson((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tenantGroupId")) {
      Object obj = map.get("tenantGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantGroupId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("orderTotalMoneyWithTax")) {
      Object obj = map.get("orderTotalMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOrderTotalMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOrderTotalMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOrderTotalMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setOrderTotalMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOrderTotalMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String){
            this.setRegion((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("regionId")) {
      Object obj = map.get("regionId");
      if(obj != null) {
        if(obj instanceof String){
            this.setRegionId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductCode((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("toOneContract.id")) {
    Object obj = map.get("toOneContract.id");
    if(obj instanceof Long) {
        this.setToOneContractId((Long)obj);
    } else if(obj instanceof String) {
        this.setToOneContractId(Long.parseLong((String)obj));
    }
  }
  }

}
