package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * bill_detail
 * </p>
 *
 * @author ultraman
 * @since 2022-04-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillDetail implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 对账单明细单号
   */
  private String billDetailNo;
  /**
   * 合同号
   */
  private String contractNo;
  /**
   * 产品编号
   */
  private String productNo;
  /**
   * 计费类型
   */
  private String chargeType;
  /**
   * 付费方式
   */
  private String paymentMethod;
  /**
   * 售价（不含税）
   */
  private String salePriceWithoutTax;
  /**
   * 单价（不含税）
   */
  private String unitAmountWithoutTax;
  /**
   * 本期应结算金额（含税）
   */
  private String currentPayableAmountWithTax;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 税号
   */
  private String taxNo;
  /**
   * 税号公司名称
   */
  private String taxCompanyName;
  /**
   * 结算开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingStartDate;
  /**
   * 结算结束日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingEndDate;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 结算单主号
   */
  private String billNo;
  /**
   * B租户代码
   */
  private String bTenantCode;
  /**
   * B租户id
   */
  private Long bTenantId;
  /**
   * 税号开通时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxBillingDate;
  /**
   * 状态
   */
  private String status;
  /**
   * 优惠金额(含税)
   */
  private String discountAmount;
  /**
   * 本期优惠后应结算金额(含税)
   */
  private String currentPayableAmountWithTaxAfterDiscount;
  /**
   * 本期优惠后应结算金额(不含税)
   */
  private String currentPayableAmountWithoutTaxAfterDiscount;
  /**
   * 产品名称
   */
  private String productName;
  /**
   * 内部处理状态
   */
  private String handleStatus;
  /**
   * 计费给的合同id-内部
   */
  private String originContractId;

  /**
   * 对一关联关系 关联对象 bill
   */
  private Long oneToManyDetailId;
  /**
   * 对一关联关系 关联对象 orderInfo
   */
  private Long settlementDetailToOrderId;
  /**
   * 对一关联关系 关联对象 billStaticsDetail
   */
  private Long oneSettlementDetailToOneReconciliationDetailId;
  /**
   * 对一关联关系 关联对象 orderInfo
   */
  private Long orderToManySettlementDetailId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billDetailNo", billDetailNo);
      map.put("contractNo", contractNo);
      map.put("productNo", productNo);
      map.put("chargeType", chargeType);
      map.put("paymentMethod", paymentMethod);
      map.put("salePriceWithoutTax", salePriceWithoutTax);
      map.put("unitAmountWithoutTax", unitAmountWithoutTax);
      map.put("currentPayableAmountWithTax", currentPayableAmountWithTax);
      map.put("taxRate", taxRate);
      map.put("taxNo", taxNo);
      map.put("taxCompanyName", taxCompanyName);
      map.put("accountingStartDate", BocpGenUtils.toTimestamp(accountingStartDate));
      map.put("accountingEndDate", BocpGenUtils.toTimestamp(accountingEndDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billNo", billNo);
      map.put("bTenantCode", bTenantCode);
      map.put("bTenantId", bTenantId);
      map.put("taxBillingDate", BocpGenUtils.toTimestamp(taxBillingDate));
      map.put("status", status);
      map.put("discountAmount", discountAmount);
      map.put("currentPayableAmountWithTaxAfterDiscount", currentPayableAmountWithTaxAfterDiscount);
      map.put("currentPayableAmountWithoutTaxAfterDiscount", currentPayableAmountWithoutTaxAfterDiscount);
      map.put("productName", productName);
      map.put("handleStatus", handleStatus);
      map.put("originContractId", originContractId);

      map.put("oneToManyDetail.id", oneToManyDetailId);
      map.put("settlementDetailToOrder.id", settlementDetailToOrderId);
      map.put("oneSettlementDetailToOneReconciliationDetail.id", oneSettlementDetailToOneReconciliationDetailId);
      map.put("orderToManySettlementDetail.id", orderToManySettlementDetailId);
      return map;
  }

  public static BillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillDetail entity = new BillDetail();

    if(map.containsKey("billDetailNo")) {
      Object obj = map.get("billDetailNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillDetailNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productNo")) {
      Object obj = map.get("productNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salePriceWithoutTax")) {
      Object obj = map.get("salePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalePriceWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitAmountWithoutTax")) {
      Object obj = map.get("unitAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnitAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountWithTax")) {
      Object obj = map.get("currentPayableAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentPayableAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantId")) {
      Object obj = map.get("bTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("taxBillingDate")) {
      Object obj = map.get("taxBillingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxBillingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTaxBillingDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTaxBillingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxBillingDate(null);
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountAmount")) {
      Object obj = map.get("discountAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountWithTaxAfterDiscount")) {
      Object obj = map.get("currentPayableAmountWithTaxAfterDiscount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentPayableAmountWithTaxAfterDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountWithoutTaxAfterDiscount")) {
      Object obj = map.get("currentPayableAmountWithoutTaxAfterDiscount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentPayableAmountWithoutTaxAfterDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginContractId((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("oneToManyDetail.id")) {
       Object obj = map.get("oneToManyDetail.id");
       if(obj instanceof Long) {
         entity.setOneToManyDetailId((Long)obj);
       } else if(obj instanceof String) {
         entity.setOneToManyDetailId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("settlementDetailToOrder.id")) {
       Object obj = map.get("settlementDetailToOrder.id");
       if(obj instanceof Long) {
         entity.setSettlementDetailToOrderId((Long)obj);
       } else if(obj instanceof String) {
         entity.setSettlementDetailToOrderId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("oneSettlementDetailToOneReconciliationDetail.id")) {
       Object obj = map.get("oneSettlementDetailToOneReconciliationDetail.id");
       if(obj instanceof Long) {
         entity.setOneSettlementDetailToOneReconciliationDetailId((Long)obj);
       } else if(obj instanceof String) {
         entity.setOneSettlementDetailToOneReconciliationDetailId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("orderToManySettlementDetail.id")) {
       Object obj = map.get("orderToManySettlementDetail.id");
       if(obj instanceof Long) {
         entity.setOrderToManySettlementDetailId((Long)obj);
       } else if(obj instanceof String) {
         entity.setOrderToManySettlementDetailId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("billDetailNo")) {
      Object obj = map.get("billDetailNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillDetailNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productNo")) {
      Object obj = map.get("productNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentMethod((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("salePriceWithoutTax")) {
      Object obj = map.get("salePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setSalePriceWithoutTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("unitAmountWithoutTax")) {
      Object obj = map.get("unitAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setUnitAmountWithoutTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("currentPayableAmountWithTax")) {
      Object obj = map.get("currentPayableAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrentPayableAmountWithTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxRate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxCompanyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingStartDate(null);
      }
   }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingEndDate(null);
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setBTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bTenantId")) {
      Object obj = map.get("bTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setBTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("taxBillingDate")) {
      Object obj = map.get("taxBillingDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTaxBillingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTaxBillingDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setTaxBillingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTaxBillingDate(null);
      }
   }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
            this.setStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("discountAmount")) {
      Object obj = map.get("discountAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setDiscountAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("currentPayableAmountWithTaxAfterDiscount")) {
      Object obj = map.get("currentPayableAmountWithTaxAfterDiscount");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrentPayableAmountWithTaxAfterDiscount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("currentPayableAmountWithoutTaxAfterDiscount")) {
      Object obj = map.get("currentPayableAmountWithoutTaxAfterDiscount");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrentPayableAmountWithoutTaxAfterDiscount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setHandleStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginContractId((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("oneToManyDetail.id")) {
    Object obj = map.get("oneToManyDetail.id");
    if(obj instanceof Long) {
        this.setOneToManyDetailId((Long)obj);
    } else if(obj instanceof String) {
        this.setOneToManyDetailId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("settlementDetailToOrder.id")) {
    Object obj = map.get("settlementDetailToOrder.id");
    if(obj instanceof Long) {
        this.setSettlementDetailToOrderId((Long)obj);
    } else if(obj instanceof String) {
        this.setSettlementDetailToOrderId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("oneSettlementDetailToOneReconciliationDetail.id")) {
    Object obj = map.get("oneSettlementDetailToOneReconciliationDetail.id");
    if(obj instanceof Long) {
        this.setOneSettlementDetailToOneReconciliationDetailId((Long)obj);
    } else if(obj instanceof String) {
        this.setOneSettlementDetailToOneReconciliationDetailId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("orderToManySettlementDetail.id")) {
    Object obj = map.get("orderToManySettlementDetail.id");
    if(obj instanceof Long) {
        this.setOrderToManySettlementDetailId((Long)obj);
    } else if(obj instanceof String) {
        this.setOrderToManySettlementDetailId(Long.parseLong((String)obj));
    }
  }
  }

}
