package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * charge_meta_data
 * </p>
 *
 * @author ultraman
 * @since 2022-05-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChargeMetaData implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 合同号
   */
  private String contractNo;
  /**
   * 税号
   */
  private String taxNo;
  /**
   * 计费开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;
  /**
   * 计费结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;
  /**
   * 计费类型
   */
  private String chargeDimension;
  /**
   * 产品名称
   */
  private String productName;
  /**
   * 公司名称
   */
  private String companyName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 计费业务维度（即将删除）
   */
  private String chargeItem;
  /**
   * 计费时间生效标识
   */
  private String chargeLabel;
  /**
   * 计费金额(不含税)
   */
  private BigDecimal chargeMoneyWithoutTax;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 计费业务量
   */
  private BigDecimal actualUsage;
  /**
   * 使用月份
   */
  private Long usingMonth;
  /**
   * 单价（不含税）
   */
  private BigDecimal unitPriceWithoutTax;
  /**
   * 付费方式
   */
  private String chargeType;
  /**
   * 是否是质保金
   */
  private String isWaranty;
  /**
   * 限制业务量
   */
  private BigDecimal limitAmount;
  /**
   * 产品编号
   */
  private String productCode;
  /**
   * 租户名称
   */
  private String tenantName;
  /**
   * 公司ID
   */
  private String companyId;
  /**
   * 结算对账单号
   */
  private String reconcilationCode;
  /**
   * 结算开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementStartTime;
  /**
   * 结算结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementEndTime;
  /**
   * 订单号
   */
  private String orderNo;
  /**
   * 合同ID(计费)
   */
  private String contractId;
  /**
   * 计费业务维度
   */
  private String chargeBizDimension;
  /**
   * 结算开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingStartDate;
  /**
   * 结算开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingEndDate;
  /**
   * 结算对账单主单号
   */
  private String billCode;
  /**
   * 付费方式
   */
  private String paymentType;
  /**
   * 处理状态
   */
  private String handleStatus;

  /**
   * 对一关联关系 关联对象 incomeMainMsg
   */
  private Long incomeMainMsgOneToManychargeMetaDataId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("taxNo", taxNo);
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("chargeDimension", chargeDimension);
      map.put("productName", productName);
      map.put("companyName", companyName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("chargeItem", chargeItem);
      map.put("chargeLabel", chargeLabel);
      map.put("chargeMoneyWithoutTax", chargeMoneyWithoutTax);
      map.put("taxRate", taxRate);
      map.put("actualUsage", actualUsage);
      map.put("usingMonth", usingMonth);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("chargeType", chargeType);
      map.put("isWaranty", isWaranty);
      map.put("limitAmount", limitAmount);
      map.put("productCode", productCode);
      map.put("tenantName", tenantName);
      map.put("companyId", companyId);
      map.put("reconcilationCode", reconcilationCode);
      map.put("settlementStartTime", BocpGenUtils.toTimestamp(settlementStartTime));
      map.put("settlementEndTime", BocpGenUtils.toTimestamp(settlementEndTime));
      map.put("orderNo", orderNo);
      map.put("contractId", contractId);
      map.put("chargeBizDimension", chargeBizDimension);
      map.put("accountingStartDate", BocpGenUtils.toTimestamp(accountingStartDate));
      map.put("accountingEndDate", BocpGenUtils.toTimestamp(accountingEndDate));
      map.put("billCode", billCode);
      map.put("paymentType", paymentType);
      map.put("handleStatus", handleStatus);

      map.put("incomeMainMsgOneToManychargeMetaData.id", incomeMainMsgOneToManychargeMetaDataId);
      return map;
  }

  public static ChargeMetaData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChargeMetaData entity = new ChargeMetaData();

    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("chargeDimension")) {
      Object obj = map.get("chargeDimension");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeDimension((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeItem")) {
      Object obj = map.get("chargeItem");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeLabel")) {
      Object obj = map.get("chargeLabel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeLabel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeMoneyWithoutTax")) {
      Object obj = map.get("chargeMoneyWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChargeMoneyWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChargeMoneyWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChargeMoneyWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setChargeMoneyWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChargeMoneyWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("actualUsage")) {
      Object obj = map.get("actualUsage");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualUsage((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualUsage(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualUsage(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setActualUsage(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualUsage(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("usingMonth")) {
      Object obj = map.get("usingMonth");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUsingMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setUsingMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUsingMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isWaranty")) {
      Object obj = map.get("isWaranty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsWaranty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("limitAmount")) {
      Object obj = map.get("limitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLimitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLimitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLimitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setLimitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLimitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reconcilationCode")) {
      Object obj = map.get("reconcilationCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReconcilationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementStartTime")) {
      Object obj = map.get("settlementStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementStartTime(null);
      }
    }
    if(map.containsKey("settlementEndTime")) {
      Object obj = map.get("settlementEndTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementEndTime(null);
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeBizDimension")) {
      Object obj = map.get("chargeBizDimension");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeBizDimension((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("billCode")) {
      Object obj = map.get("billCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("incomeMainMsgOneToManychargeMetaData.id")) {
       Object obj = map.get("incomeMainMsgOneToManychargeMetaData.id");
       if(obj instanceof Long) {
         entity.setIncomeMainMsgOneToManychargeMetaDataId((Long)obj);
       } else if(obj instanceof String) {
         entity.setIncomeMainMsgOneToManychargeMetaDataId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setChargeStartDate(null);
      }
   }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setChargeEndDate(null);
      }
   }
    if(map.containsKey("chargeDimension")) {
      Object obj = map.get("chargeDimension");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeDimension((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCompanyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeItem")) {
      Object obj = map.get("chargeItem");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeItem((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeLabel")) {
      Object obj = map.get("chargeLabel");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeLabel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeMoneyWithoutTax")) {
      Object obj = map.get("chargeMoneyWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setChargeMoneyWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setChargeMoneyWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setChargeMoneyWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setChargeMoneyWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setChargeMoneyWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("actualUsage")) {
      Object obj = map.get("actualUsage");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setActualUsage((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setActualUsage(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setActualUsage(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setActualUsage(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setActualUsage(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("usingMonth")) {
      Object obj = map.get("usingMonth");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUsingMonth((Long)obj);
        } else if(obj instanceof String) {
            this.setUsingMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUsingMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("isWaranty")) {
      Object obj = map.get("isWaranty");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsWaranty((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("limitAmount")) {
      Object obj = map.get("limitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setLimitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setLimitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setLimitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setLimitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setLimitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof String){
            this.setCompanyId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reconcilationCode")) {
      Object obj = map.get("reconcilationCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setReconcilationCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("settlementStartTime")) {
      Object obj = map.get("settlementStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSettlementStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSettlementStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setSettlementStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSettlementStartTime(null);
      }
   }
    if(map.containsKey("settlementEndTime")) {
      Object obj = map.get("settlementEndTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSettlementEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSettlementEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setSettlementEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSettlementEndTime(null);
      }
   }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeBizDimension")) {
      Object obj = map.get("chargeBizDimension");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeBizDimension((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingStartDate(null);
      }
   }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingEndDate(null);
      }
   }
    if(map.containsKey("billCode")) {
      Object obj = map.get("billCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setHandleStatus((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("incomeMainMsgOneToManychargeMetaData.id")) {
    Object obj = map.get("incomeMainMsgOneToManychargeMetaData.id");
    if(obj instanceof Long) {
        this.setIncomeMainMsgOneToManychargeMetaDataId((Long)obj);
    } else if(obj instanceof String) {
        this.setIncomeMainMsgOneToManychargeMetaDataId(Long.parseLong((String)obj));
    }
  }
  }

}
