package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * income_main_msg
 * </p>
 *
 * @author ultraman
 * @since 2022-05-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class IncomeMainMsg implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 合同号
   */
  private String contractNo;
  /**
   * 产品名称
   */
  private String productName;
  /**
   * 开始计费时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startChargeTime;
  /**
   * 结束计费时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime stopChargeTime;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 计费业务纬度
   */
  private String chargeItem;
  /**
   * 使用公司名称
   */
  private String companyName;
  /**
   * 使用公司税号
   */
  private String companyTax;
  /**
   * 总金额(含税)
   */
  private BigDecimal totalMoneyTax;
  /**
   * 总金额(不含税)
   */
  private BigDecimal totalMoneyWithoutTax;
  /**
   * 性质
   */
  private String property;
  /**
   * 结算开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementStartTime;
  /**
   * 结算结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementEndTime;
  /**
   * 产品code
   */
  private String productCode;
  /**
   * 对应租户ID
   */
  private Long correspondingTenantId;
  /**
   * 对应租户编号
   */
  private String correspondingTenantCode;
  /**
   * 对应租户名称 
   */
  private String correspondingTenantName;
  /**
   * 收入状态
   */
  private String incomeStatus;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("productName", productName);
      map.put("startChargeTime", BocpGenUtils.toTimestamp(startChargeTime));
      map.put("stopChargeTime", BocpGenUtils.toTimestamp(stopChargeTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("projectName", projectName);
      map.put("chargeItem", chargeItem);
      map.put("companyName", companyName);
      map.put("companyTax", companyTax);
      map.put("totalMoneyTax", totalMoneyTax);
      map.put("totalMoneyWithoutTax", totalMoneyWithoutTax);
      map.put("property", property);
      map.put("settlementStartTime", BocpGenUtils.toTimestamp(settlementStartTime));
      map.put("settlementEndTime", BocpGenUtils.toTimestamp(settlementEndTime));
      map.put("productCode", productCode);
      map.put("correspondingTenantId", correspondingTenantId);
      map.put("correspondingTenantCode", correspondingTenantCode);
      map.put("correspondingTenantName", correspondingTenantName);
      map.put("incomeStatus", incomeStatus);

      return map;
  }

  public static IncomeMainMsg fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    IncomeMainMsg entity = new IncomeMainMsg();

    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startChargeTime")) {
      Object obj = map.get("startChargeTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartChargeTime(null);
      }
    }
    if(map.containsKey("stopChargeTime")) {
      Object obj = map.get("stopChargeTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStopChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStopChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStopChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStopChargeTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeItem")) {
      Object obj = map.get("chargeItem");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTax")) {
      Object obj = map.get("companyTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalMoneyTax")) {
      Object obj = map.get("totalMoneyTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalMoneyTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalMoneyTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalMoneyTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalMoneyTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalMoneyTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalMoneyWithoutTax")) {
      Object obj = map.get("totalMoneyWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalMoneyWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalMoneyWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalMoneyWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalMoneyWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalMoneyWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementStartTime")) {
      Object obj = map.get("settlementStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementStartTime(null);
      }
    }
    if(map.containsKey("settlementEndTime")) {
      Object obj = map.get("settlementEndTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementEndTime(null);
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("correspondingTenantId")) {
      Object obj = map.get("correspondingTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCorrespondingTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCorrespondingTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCorrespondingTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("correspondingTenantCode")) {
      Object obj = map.get("correspondingTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCorrespondingTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("correspondingTenantName")) {
      Object obj = map.get("correspondingTenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCorrespondingTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("incomeStatus")) {
      Object obj = map.get("incomeStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIncomeStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("startChargeTime")) {
      Object obj = map.get("startChargeTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setStartChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartChargeTime(null);
      }
   }
    if(map.containsKey("stopChargeTime")) {
      Object obj = map.get("stopChargeTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStopChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStopChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setStopChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStopChargeTime(null);
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProjectName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeItem")) {
      Object obj = map.get("chargeItem");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeItem((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCompanyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("companyTax")) {
      Object obj = map.get("companyTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setCompanyTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("totalMoneyTax")) {
      Object obj = map.get("totalMoneyTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalMoneyTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalMoneyTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalMoneyTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTotalMoneyTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalMoneyTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("totalMoneyWithoutTax")) {
      Object obj = map.get("totalMoneyWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalMoneyWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalMoneyWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalMoneyWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTotalMoneyWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalMoneyWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String){
            this.setProperty((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("settlementStartTime")) {
      Object obj = map.get("settlementStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSettlementStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSettlementStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setSettlementStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSettlementStartTime(null);
      }
   }
    if(map.containsKey("settlementEndTime")) {
      Object obj = map.get("settlementEndTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSettlementEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSettlementEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setSettlementEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSettlementEndTime(null);
      }
   }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("correspondingTenantId")) {
      Object obj = map.get("correspondingTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCorrespondingTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setCorrespondingTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCorrespondingTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("correspondingTenantCode")) {
      Object obj = map.get("correspondingTenantCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setCorrespondingTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("correspondingTenantName")) {
      Object obj = map.get("correspondingTenantName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCorrespondingTenantName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("incomeStatus")) {
      Object obj = map.get("incomeStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setIncomeStatus((String)obj);
        }
      } else{
      }
   }

  }

}
