package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 绑定类型
 * </p>
 *
 * @author ultraman
 * @since 2022-05-07
 */
public enum BindTypeEnum {

    BIND("BIND", "绑定"),
    UNBIND("UNBIND", "解绑");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BindTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BindTypeEnum fromCode(String code){
        switch(code) {
            case "BIND":
                return BIND;
            case "UNBIND":
                return UNBIND;
            default:
                return null;
        }
    }
}
