package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * pay_water
 * </p>
 *
 * @author ultraman
 * @since 2022-05-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PayWater implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 交易时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime tradeTime;
  /**
   * 借方发生额/元(支取 )	
   */
  private BigDecimal debitMoneyAmount;
  /**
   * 贷方发生额/元(收入)
   */
  private BigDecimal creditMoneyAmount;
  /**
   * 账号名称
   */
  private String bankName;
  /**
   * 账号
   */
  private String bankAccount;
  /**
   * 对方开户机构
   */
  private String openAccountInstitutions;
  /**
   * 账户明细编号-交易流水号
   */
  private String tradeNo;
  /**
   * 备注
   */
  private String remark;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 币种
   */
  private String currency;
  /**
   * 对方户名
   */
  private String customerName;
  /**
   * 记账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingDate;
  /**
   * 摘要
   */
  private String abstraction;
  /**
   * 交易介质编号
   */
  private String tradeBusinessCode;
  /**
   * 余额
   */
  private BigDecimal balance;
  /**
   * 对方账号
   */
  private String customerAccount;
  /**
   * 企业流水号
   */
  private String enterpriseSerialNumber;
  /**
   * 凭证种类
   */
  private String documentCategory;
  /**
   * 凭证号
   */
  private String documentNo;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("tradeTime", BocpGenUtils.toTimestamp(tradeTime));
      map.put("debitMoneyAmount", debitMoneyAmount);
      map.put("creditMoneyAmount", creditMoneyAmount);
      map.put("bankName", bankName);
      map.put("bankAccount", bankAccount);
      map.put("openAccountInstitutions", openAccountInstitutions);
      map.put("tradeNo", tradeNo);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("currency", currency);
      map.put("customerName", customerName);
      map.put("accountingDate", BocpGenUtils.toTimestamp(accountingDate));
      map.put("abstraction", abstraction);
      map.put("tradeBusinessCode", tradeBusinessCode);
      map.put("balance", balance);
      map.put("customerAccount", customerAccount);
      map.put("enterpriseSerialNumber", enterpriseSerialNumber);
      map.put("documentCategory", documentCategory);
      map.put("documentNo", documentNo);

      return map;
  }

  public static PayWater fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PayWater entity = new PayWater();

    if(map.containsKey("tradeTime")) {
      Object obj = map.get("tradeTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTradeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTradeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTradeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTradeTime(null);
      }
    }
    if(map.containsKey("debitMoneyAmount")) {
      Object obj = map.get("debitMoneyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDebitMoneyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDebitMoneyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDebitMoneyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDebitMoneyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDebitMoneyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("creditMoneyAmount")) {
      Object obj = map.get("creditMoneyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCreditMoneyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCreditMoneyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCreditMoneyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCreditMoneyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreditMoneyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankAccount")) {
      Object obj = map.get("bankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openAccountInstitutions")) {
      Object obj = map.get("openAccountInstitutions");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOpenAccountInstitutions((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tradeNo")) {
      Object obj = map.get("tradeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingDate")) {
      Object obj = map.get("accountingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingDate(null);
      }
    }
    if(map.containsKey("abstraction")) {
      Object obj = map.get("abstraction");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbstraction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tradeBusinessCode")) {
      Object obj = map.get("tradeBusinessCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTradeBusinessCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("balance")) {
      Object obj = map.get("balance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBalance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBalance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBalance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBalance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBalance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customerAccount")) {
      Object obj = map.get("customerAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("enterpriseSerialNumber")) {
      Object obj = map.get("enterpriseSerialNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEnterpriseSerialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentCategory")) {
      Object obj = map.get("documentCategory");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocumentCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNo")) {
      Object obj = map.get("documentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocumentNo((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("tradeTime")) {
      Object obj = map.get("tradeTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTradeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTradeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setTradeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTradeTime(null);
      }
   }
    if(map.containsKey("debitMoneyAmount")) {
      Object obj = map.get("debitMoneyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDebitMoneyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDebitMoneyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDebitMoneyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setDebitMoneyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDebitMoneyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("creditMoneyAmount")) {
      Object obj = map.get("creditMoneyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCreditMoneyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCreditMoneyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCreditMoneyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setCreditMoneyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCreditMoneyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String){
            this.setBankName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bankAccount")) {
      Object obj = map.get("bankAccount");
      if(obj != null) {
        if(obj instanceof String){
            this.setBankAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("openAccountInstitutions")) {
      Object obj = map.get("openAccountInstitutions");
      if(obj != null) {
        if(obj instanceof String){
            this.setOpenAccountInstitutions((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tradeNo")) {
      Object obj = map.get("tradeNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setTradeNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrency((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCustomerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("accountingDate")) {
      Object obj = map.get("accountingDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAccountingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingDate(null);
      }
   }
    if(map.containsKey("abstraction")) {
      Object obj = map.get("abstraction");
      if(obj != null) {
        if(obj instanceof String){
            this.setAbstraction((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tradeBusinessCode")) {
      Object obj = map.get("tradeBusinessCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setTradeBusinessCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("balance")) {
      Object obj = map.get("balance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBalance((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBalance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBalance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setBalance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBalance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("customerAccount")) {
      Object obj = map.get("customerAccount");
      if(obj != null) {
        if(obj instanceof String){
            this.setCustomerAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("enterpriseSerialNumber")) {
      Object obj = map.get("enterpriseSerialNumber");
      if(obj != null) {
        if(obj instanceof String){
            this.setEnterpriseSerialNumber((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("documentCategory")) {
      Object obj = map.get("documentCategory");
      if(obj != null) {
        if(obj instanceof String){
            this.setDocumentCategory((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("documentNo")) {
      Object obj = map.get("documentNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setDocumentNo((String)obj);
        }
      } else{
      }
   }

  }

}
