package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 预算类型
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
public enum ChargeCodeBudgetType {

    PROJECT("project", "项目预算"),
    DEPT("dept", "部门预算");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeCodeBudgetType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeBudgetType fromCode(String code){
        switch(code) {
            case "project":
                return PROJECT;
            case "dept":
                return DEPT;
            default:
                return null;
        }
    }
}
