package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费规则
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
public enum ChargeRules {

    _1("1", "按日计费"),
    _2("2", "按价计费"),
    _3("3", "按月计费");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeRules(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeRules fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
