package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 付费方式
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
public enum PaymentMethodEnum {

    PRE_PAID("prePaid", "预付"),
    POST_PAID("postPaid", "后付"),
    _0("0", "预付"),
    _1("1", "后付");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PaymentMethodEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PaymentMethodEnum fromCode(String code){
        switch(code) {
            case "prePaid":
                return PRE_PAID;
            case "postPaid":
                return POST_PAID;
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
