package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 验收状态
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
public enum ReceptionStatus {

    RECEPTED("recepted", "已验收"),
    NOT_RECEPTED("notRecepted", "未验收");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReceptionStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceptionStatus fromCode(String code){
        switch(code) {
            case "recepted":
                return RECEPTED;
            case "notRecepted":
                return NOT_RECEPTED;
            default:
                return null;
        }
    }
}
