package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * bill_tax_usage
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillTaxUsage implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 对账单主单号
   */
  private String billNo;
  /**
   * 产品编号
   */
  private String productCode;
  /**
   * 产品名称
   */
  private String productName;
  /**
   * 使用公司名称
   */
  private String taxCompanyName;
  /**
   * 使用公司税号
   */
  private String taxNo;
  /**
   * 计费业务维度
   */
  private String chargeBizDimension;
  /**
   * 计费实际业务量
   */
  private String actualBizVolume;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 业务发生月份
   */
  private Long bizMonth;
  /**
   * 结算开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountintStartDate;
  /**
   * 结算结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountintEndDate;
  /**
   * 明细用量唯一编号
   */
  private Long detailNo;
  /**
   * 租户id
   */
  private Long bTenantId;
  /**
   * 租户名称
   */
  private String bTenantName;
  /**
   * 租户code
   */
  private String bTenantCode;
  /**
   * 表示计费的类型
   */
  private Long billingType;
  /**
   * 表示结算账单的生成日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime bcreateTime;
  /**
   * 明细用量唯一编号-备用
   */
  private String bDetailNo;

  /**
   * 对一关联关系 关联对象 orderInfo
   */
  private Long manyBillTaxUsageToOneOrderInfoId;
  /**
   * 对一关联关系 关联对象 contract
   */
  private Long manyBillTaxUsageToOneContractId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("billNo", billNo);
      map.put("productCode", productCode);
      map.put("productName", productName);
      map.put("taxCompanyName", taxCompanyName);
      map.put("taxNo", taxNo);
      map.put("chargeBizDimension", chargeBizDimension);
      map.put("actualBizVolume", actualBizVolume);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("bizMonth", bizMonth);
      map.put("accountintStartDate", BocpGenUtils.toTimestamp(accountintStartDate));
      map.put("accountintEndDate", BocpGenUtils.toTimestamp(accountintEndDate));
      map.put("detailNo", detailNo);
      map.put("bTenantId", bTenantId);
      map.put("bTenantName", bTenantName);
      map.put("bTenantCode", bTenantCode);
      map.put("billingType", billingType);
      map.put("bcreateTime", BocpGenUtils.toTimestamp(bcreateTime));
      map.put("bDetailNo", bDetailNo);

      map.put("manyBillTaxUsageToOneOrderInfo.id", manyBillTaxUsageToOneOrderInfoId);
      map.put("manyBillTaxUsageToOneContract.id", manyBillTaxUsageToOneContractId);
      return map;
  }

  public static BillTaxUsage fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillTaxUsage entity = new BillTaxUsage();

    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeBizDimension")) {
      Object obj = map.get("chargeBizDimension");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeBizDimension((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("actualBizVolume")) {
      Object obj = map.get("actualBizVolume");
      if(obj != null) {
        if(obj instanceof String){
          entity.setActualBizVolume((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizMonth")) {
      Object obj = map.get("bizMonth");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBizMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setBizMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBizMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("accountintStartDate")) {
      Object obj = map.get("accountintStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountintStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountintStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountintStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountintStartDate(null);
      }
    }
    if(map.containsKey("accountintEndDate")) {
      Object obj = map.get("accountintEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountintEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountintEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountintEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountintEndDate(null);
      }
    }
    if(map.containsKey("detailNo")) {
      Object obj = map.get("detailNo");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDetailNo((Long)obj);
        } else if(obj instanceof String) {
          entity.setDetailNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDetailNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bTenantId")) {
      Object obj = map.get("bTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bTenantName")) {
      Object obj = map.get("bTenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillingType((Long)obj);
        } else if(obj instanceof String) {
          entity.setBillingType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBillingType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bcreateTime")) {
      Object obj = map.get("bcreateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBcreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBcreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBcreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBcreateTime(null);
      }
    }
    if(map.containsKey("bDetailNo")) {
      Object obj = map.get("bDetailNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBDetailNo((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("manyBillTaxUsageToOneOrderInfo.id")) {
       Object obj = map.get("manyBillTaxUsageToOneOrderInfo.id");
       if(obj instanceof Long) {
         entity.setManyBillTaxUsageToOneOrderInfoId((Long)obj);
       } else if(obj instanceof String) {
         entity.setManyBillTaxUsageToOneOrderInfoId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("manyBillTaxUsageToOneContract.id")) {
       Object obj = map.get("manyBillTaxUsageToOneContract.id");
       if(obj instanceof Long) {
         entity.setManyBillTaxUsageToOneContractId((Long)obj);
       } else if(obj instanceof String) {
         entity.setManyBillTaxUsageToOneContractId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxCompanyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeBizDimension")) {
      Object obj = map.get("chargeBizDimension");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeBizDimension((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("actualBizVolume")) {
      Object obj = map.get("actualBizVolume");
      if(obj != null) {
        if(obj instanceof String){
            this.setActualBizVolume((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bizMonth")) {
      Object obj = map.get("bizMonth");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBizMonth((Long)obj);
        } else if(obj instanceof String) {
            this.setBizMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBizMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("accountintStartDate")) {
      Object obj = map.get("accountintStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountintStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountintStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAccountintStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountintStartDate(null);
      }
   }
    if(map.containsKey("accountintEndDate")) {
      Object obj = map.get("accountintEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountintEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountintEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAccountintEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountintEndDate(null);
      }
   }
    if(map.containsKey("detailNo")) {
      Object obj = map.get("detailNo");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDetailNo((Long)obj);
        } else if(obj instanceof String) {
            this.setDetailNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setDetailNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("bTenantId")) {
      Object obj = map.get("bTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setBTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("bTenantName")) {
      Object obj = map.get("bTenantName");
      if(obj != null) {
        if(obj instanceof String){
            this.setBTenantName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setBTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBillingType((Long)obj);
        } else if(obj instanceof String) {
            this.setBillingType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBillingType(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("bcreateTime")) {
      Object obj = map.get("bcreateTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBcreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setBcreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setBcreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setBcreateTime(null);
      }
   }
    if(map.containsKey("bDetailNo")) {
      Object obj = map.get("bDetailNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBDetailNo((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("manyBillTaxUsageToOneOrderInfo.id")) {
    Object obj = map.get("manyBillTaxUsageToOneOrderInfo.id");
    if(obj instanceof Long) {
        this.setManyBillTaxUsageToOneOrderInfoId((Long)obj);
    } else if(obj instanceof String) {
        this.setManyBillTaxUsageToOneOrderInfoId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("manyBillTaxUsageToOneContract.id")) {
    Object obj = map.get("manyBillTaxUsageToOneContract.id");
    if(obj instanceof Long) {
        this.setManyBillTaxUsageToOneContractId((Long)obj);
    } else if(obj instanceof String) {
        this.setManyBillTaxUsageToOneContractId(Long.parseLong((String)obj));
    }
  }
  }

}
