package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * business_serve_apply_bill
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BusinessServeApplyBill extends ApplyBasicBill {

  /**
   * 预计招待日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expectedReceptionDate;
  /**
   * 招待事由及招待方式
   */
  private String receptionReson;
  /**
   * 补充描述
   */
  private String addRemark;
  /**
   * 收款银行
   */
  private String receivingBank;
  /**
   * 收款账号
   */
  private String receivingAccount;
  /**
   * 收款人
   */
  private String receivingPerson;
  /**
   * 备注
   */
  private String remark;
  /**
   * 申请金额
   */
  private BigDecimal applyAmount;
  /**
   * 补充申请单号
   */
  private String applyCode;
  /**
   * 补充申请标题
   */
  private String applyName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("expectedReceptionDate", BocpGenUtils.toTimestamp(expectedReceptionDate));
      map.put("receptionReson", receptionReson);
      map.put("addRemark", addRemark);
      map.put("receivingBank", receivingBank);
      map.put("receivingAccount", receivingAccount);
      map.put("receivingPerson", receivingPerson);
      map.put("remark", remark);
      map.put("applyAmount", applyAmount);
      map.put("applyCode", applyCode);
      map.put("applyName", applyName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static BusinessServeApplyBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BusinessServeApplyBill entity = new BusinessServeApplyBill();

    entity.setParentByOQSMap(map);
    if(map.containsKey("expectedReceptionDate")) {
      Object obj = map.get("expectedReceptionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpectedReceptionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setExpectedReceptionDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setExpectedReceptionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpectedReceptionDate(null);
      }
    }
    if(map.containsKey("receptionReson")) {
      Object obj = map.get("receptionReson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceptionReson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addRemark")) {
      Object obj = map.get("addRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivingBank")) {
      Object obj = map.get("receivingBank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceivingBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivingAccount")) {
      Object obj = map.get("receivingAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceivingAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivingPerson")) {
      Object obj = map.get("receivingPerson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceivingPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyAmount")) {
      Object obj = map.get("applyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setApplyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setApplyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setApplyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setApplyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setApplyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("applyCode")) {
      Object obj = map.get("applyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map){
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map){
    super.setByOQSMap(map);
    if(map.containsKey("expectedReceptionDate")) {
      Object obj = map.get("expectedReceptionDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setExpectedReceptionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setExpectedReceptionDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setExpectedReceptionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setExpectedReceptionDate(null);
      }
   }
    if(map.containsKey("receptionReson")) {
      Object obj = map.get("receptionReson");
      if(obj != null) {
        if(obj instanceof String){
            this.setReceptionReson((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("addRemark")) {
      Object obj = map.get("addRemark");
      if(obj != null) {
        if(obj instanceof String){
            this.setAddRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receivingBank")) {
      Object obj = map.get("receivingBank");
      if(obj != null) {
        if(obj instanceof String){
            this.setReceivingBank((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receivingAccount")) {
      Object obj = map.get("receivingAccount");
      if(obj != null) {
        if(obj instanceof String){
            this.setReceivingAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receivingPerson")) {
      Object obj = map.get("receivingPerson");
      if(obj != null) {
        if(obj instanceof String){
            this.setReceivingPerson((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applyAmount")) {
      Object obj = map.get("applyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setApplyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setApplyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setApplyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setApplyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setApplyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("applyCode")) {
      Object obj = map.get("applyCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplyCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
