package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * business_serve_reimbursement_bill
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BusinessServeReimbursementBill extends ReimbursementBasicBill {

  /**
   * 关联申请单单号
   */
  private String applyCode;
  /**
   * 关联申请单标题
   */
  private String applyName;
  /**
   * 招待事由及招待方式
   */
  private String entertainmentReson;
  /**
   * 申请明细
   */
  private String applyDetails;
  /**
   * 出差申请单编码
   */
  private String travelCode;
  /**
   * 出差申请单名称
   */
  private String travelName;
  /**
   * 实际招待客户人数及职级
   */
  private String entertainmentCustomerAndLevel;
  /**
   * 备注
   */
  private String remark;
  /**
   * 预计招待客户人数及职级
   */
  private String estimateCustomerAndLevel;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("applyCode", applyCode);
      map.put("applyName", applyName);
      map.put("entertainmentReson", entertainmentReson);
      map.put("applyDetails", applyDetails);
      map.put("travelCode", travelCode);
      map.put("travelName", travelName);
      map.put("entertainmentCustomerAndLevel", entertainmentCustomerAndLevel);
      map.put("remark", remark);
      map.put("estimateCustomerAndLevel", estimateCustomerAndLevel);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static BusinessServeReimbursementBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BusinessServeReimbursementBill entity = new BusinessServeReimbursementBill();

    entity.setParentByOQSMap(map);
    if(map.containsKey("applyCode")) {
      Object obj = map.get("applyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entertainmentReson")) {
      Object obj = map.get("entertainmentReson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntertainmentReson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyDetails")) {
      Object obj = map.get("applyDetails");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyDetails((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("travelCode")) {
      Object obj = map.get("travelCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTravelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("travelName")) {
      Object obj = map.get("travelName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTravelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entertainmentCustomerAndLevel")) {
      Object obj = map.get("entertainmentCustomerAndLevel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntertainmentCustomerAndLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("estimateCustomerAndLevel")) {
      Object obj = map.get("estimateCustomerAndLevel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEstimateCustomerAndLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map){
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map){
    super.setByOQSMap(map);
    if(map.containsKey("applyCode")) {
      Object obj = map.get("applyCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplyCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("entertainmentReson")) {
      Object obj = map.get("entertainmentReson");
      if(obj != null) {
        if(obj instanceof String){
            this.setEntertainmentReson((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applyDetails")) {
      Object obj = map.get("applyDetails");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplyDetails((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("travelCode")) {
      Object obj = map.get("travelCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setTravelCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("travelName")) {
      Object obj = map.get("travelName");
      if(obj != null) {
        if(obj instanceof String){
            this.setTravelName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("entertainmentCustomerAndLevel")) {
      Object obj = map.get("entertainmentCustomerAndLevel");
      if(obj != null) {
        if(obj instanceof String){
            this.setEntertainmentCustomerAndLevel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("estimateCustomerAndLevel")) {
      Object obj = map.get("estimateCustomerAndLevel");
      if(obj != null) {
        if(obj instanceof String){
            this.setEstimateCustomerAndLevel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
