package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * fin_basic_bill_detail
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinBasicBillDetail implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 一级费用类型编码 
   */
  private String level1CostCode;
  /**
   * 一级费用类型名称
   */
  private String level1CostName;
  /**
   * 末级费用类型编码
   */
  private String lastCostCode;
  /**
   * 末级费用类型名称
   */
  private String lastCostName;
  /**
   * 起点
   */
  private String startPosition;
  /**
   * 终点
   */
  private String endPosition;
  /**
   * 金额
   */
  private BigDecimal amount;
  /**
   * 税额
   */
  private String taxAmount;
  /**
   * 附件
   */
  private String attachement;
  /**
   * 行程说明
   */
  private String tripRemark;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;

  /**
   * 对一关联关系 关联对象 finBasicBill
   */
  private Long billDetailsId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("level1CostCode", level1CostCode);
      map.put("level1CostName", level1CostName);
      map.put("lastCostCode", lastCostCode);
      map.put("lastCostName", lastCostName);
      map.put("startPosition", startPosition);
      map.put("endPosition", endPosition);
      map.put("amount", amount);
      map.put("taxAmount", taxAmount);
      map.put("attachement", attachement);
      map.put("tripRemark", tripRemark);
      map.put("invoiceType", invoiceType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      map.put("billDetails.id", billDetailsId);
      return map;
  }

  public static FinBasicBillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinBasicBillDetail entity = new FinBasicBillDetail();

    if(map.containsKey("level1CostCode")) {
      Object obj = map.get("level1CostCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLevel1CostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("level1CostName")) {
      Object obj = map.get("level1CostName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLevel1CostName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastCostCode")) {
      Object obj = map.get("lastCostCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastCostName")) {
      Object obj = map.get("lastCostName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastCostName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startPosition")) {
      Object obj = map.get("startPosition");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStartPosition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endPosition")) {
      Object obj = map.get("endPosition");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEndPosition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachement")) {
      Object obj = map.get("attachement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAttachement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tripRemark")) {
      Object obj = map.get("tripRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTripRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("billDetails.id")) {
       Object obj = map.get("billDetails.id");
       if(obj instanceof Long) {
         entity.setBillDetailsId((Long)obj);
       } else if(obj instanceof String) {
         entity.setBillDetailsId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("level1CostCode")) {
      Object obj = map.get("level1CostCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setLevel1CostCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("level1CostName")) {
      Object obj = map.get("level1CostName");
      if(obj != null) {
        if(obj instanceof String){
            this.setLevel1CostName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lastCostCode")) {
      Object obj = map.get("lastCostCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setLastCostCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lastCostName")) {
      Object obj = map.get("lastCostName");
      if(obj != null) {
        if(obj instanceof String){
            this.setLastCostName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("startPosition")) {
      Object obj = map.get("startPosition");
      if(obj != null) {
        if(obj instanceof String){
            this.setStartPosition((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("endPosition")) {
      Object obj = map.get("endPosition");
      if(obj != null) {
        if(obj instanceof String){
            this.setEndPosition((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("attachement")) {
      Object obj = map.get("attachement");
      if(obj != null) {
        if(obj instanceof String){
            this.setAttachement((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tripRemark")) {
      Object obj = map.get("tripRemark");
      if(obj != null) {
        if(obj instanceof String){
            this.setTripRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("billDetails.id")) {
    Object obj = map.get("billDetails.id");
    if(obj instanceof Long) {
        this.setBillDetailsId((Long)obj);
    } else if(obj instanceof String) {
        this.setBillDetailsId(Long.parseLong((String)obj));
    }
  }
  }

}
