package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * travel_apply_bill
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TravelApplyBill extends ApplyBasicBill {

  /**
   * 出差申请单编码
   */
  private String travelCode;
  /**
   * 出差申请单名称
   */
  private String travelName;
  /**
   * 补充申请单号
   */
  private String applyCode;
  /**
   * 补充申请标题
   */
  private String applyName;
  /**
   * 消费开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startCostDate;
  /**
   * 消费结束日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endCostDate;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("travelCode", travelCode);
      map.put("travelName", travelName);
      map.put("applyCode", applyCode);
      map.put("applyName", applyName);
      map.put("startCostDate", BocpGenUtils.toTimestamp(startCostDate));
      map.put("endCostDate", BocpGenUtils.toTimestamp(endCostDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static TravelApplyBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TravelApplyBill entity = new TravelApplyBill();

    entity.setParentByOQSMap(map);
    if(map.containsKey("travelCode")) {
      Object obj = map.get("travelCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTravelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("travelName")) {
      Object obj = map.get("travelName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTravelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyCode")) {
      Object obj = map.get("applyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startCostDate")) {
      Object obj = map.get("startCostDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartCostDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartCostDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartCostDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartCostDate(null);
      }
    }
    if(map.containsKey("endCostDate")) {
      Object obj = map.get("endCostDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndCostDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndCostDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndCostDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndCostDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map){
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map){
    super.setByOQSMap(map);
    if(map.containsKey("travelCode")) {
      Object obj = map.get("travelCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setTravelCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("travelName")) {
      Object obj = map.get("travelName");
      if(obj != null) {
        if(obj instanceof String){
            this.setTravelName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applyCode")) {
      Object obj = map.get("applyCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplyCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("startCostDate")) {
      Object obj = map.get("startCostDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartCostDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartCostDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setStartCostDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartCostDate(null);
      }
   }
    if(map.containsKey("endCostDate")) {
      Object obj = map.get("endCostDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEndCostDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEndCostDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setEndCostDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEndCostDate(null);
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
