package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * travel_apply_bill_detail
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TravelApplyBillDetail extends ShareInfo {

  /**
   * 申请人编码
   */
  private String applicatCode;
  /**
   * 申请人名称
   */
  private String applicatName;
  /**
   * 订票人编码
   */
  private String ordererCode;
  /**
   * 订票人名称
   */
  private String ordererName;
  /**
   * 预定人编码
   */
  private String preOrdererCode;
  /**
   * 预定人名称
   */
  private String preOrdererName;
  /**
   * 申请日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyDate;
  /**
   * 出行日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime tripDate;
  /**
   * 预估金额
   */
  private BigDecimal estimateAmount;
  /**
   * 出行人编码
   */
  private String billUserCode;
  /**
   * 出行人名称
   */
  private String billUserName;
  /**
   * 行程类型
   */
  private String travelType;
  /**
   * 出发城市
   */
  private String startCity;
  /**
   * 到达城市
   */
  private String arriveCity;
  /**
   * 出发时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;
  /**
   * 达到时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime arriveDate;
  /**
   * 消费内容
   */
  private String costContent;
  /**
   * 选择该交通方式的原因
   */
  private String selectTrafficReason;
  /**
   * 用车事由
   */
  private String useCarReason;
  /**
   * 用车城市
   */
  private String useCarCity;
  /**
   * 用车开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startUseCarDate;
  /**
   * 用车结束日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endUseCarDate;
  /**
   * 出差开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startEvectionDate;
  /**
   * 出差结束日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endEvectionDate;
  /**
   * 消费事由
   */
  private String remark;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("applicatCode", applicatCode);
      map.put("applicatName", applicatName);
      map.put("ordererCode", ordererCode);
      map.put("ordererName", ordererName);
      map.put("preOrdererCode", preOrdererCode);
      map.put("preOrdererName", preOrdererName);
      map.put("applyDate", BocpGenUtils.toTimestamp(applyDate));
      map.put("tripDate", BocpGenUtils.toTimestamp(tripDate));
      map.put("estimateAmount", estimateAmount);
      map.put("billUserCode", billUserCode);
      map.put("billUserName", billUserName);
      map.put("travelType", travelType);
      map.put("startCity", startCity);
      map.put("arriveCity", arriveCity);
      map.put("startDate", BocpGenUtils.toTimestamp(startDate));
      map.put("arriveDate", BocpGenUtils.toTimestamp(arriveDate));
      map.put("costContent", costContent);
      map.put("selectTrafficReason", selectTrafficReason);
      map.put("useCarReason", useCarReason);
      map.put("useCarCity", useCarCity);
      map.put("startUseCarDate", BocpGenUtils.toTimestamp(startUseCarDate));
      map.put("endUseCarDate", BocpGenUtils.toTimestamp(endUseCarDate));
      map.put("startEvectionDate", BocpGenUtils.toTimestamp(startEvectionDate));
      map.put("endEvectionDate", BocpGenUtils.toTimestamp(endEvectionDate));
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static TravelApplyBillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TravelApplyBillDetail entity = new TravelApplyBillDetail();

    entity.setParentByOQSMap(map);
    if(map.containsKey("applicatCode")) {
      Object obj = map.get("applicatCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicatName")) {
      Object obj = map.get("applicatName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicatName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ordererCode")) {
      Object obj = map.get("ordererCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrdererCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ordererName")) {
      Object obj = map.get("ordererName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrdererName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preOrdererCode")) {
      Object obj = map.get("preOrdererCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreOrdererCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preOrdererName")) {
      Object obj = map.get("preOrdererName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreOrdererName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyDate")) {
      Object obj = map.get("applyDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplyDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyDate(null);
      }
    }
    if(map.containsKey("tripDate")) {
      Object obj = map.get("tripDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTripDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTripDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTripDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTripDate(null);
      }
    }
    if(map.containsKey("estimateAmount")) {
      Object obj = map.get("estimateAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEstimateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEstimateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEstimateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setEstimateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEstimateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("billUserCode")) {
      Object obj = map.get("billUserCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billUserName")) {
      Object obj = map.get("billUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("travelType")) {
      Object obj = map.get("travelType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTravelType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startCity")) {
      Object obj = map.get("startCity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStartCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arriveCity")) {
      Object obj = map.get("arriveCity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArriveCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("arriveDate")) {
      Object obj = map.get("arriveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setArriveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setArriveDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setArriveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setArriveDate(null);
      }
    }
    if(map.containsKey("costContent")) {
      Object obj = map.get("costContent");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("selectTrafficReason")) {
      Object obj = map.get("selectTrafficReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSelectTrafficReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useCarReason")) {
      Object obj = map.get("useCarReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUseCarReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useCarCity")) {
      Object obj = map.get("useCarCity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUseCarCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startUseCarDate")) {
      Object obj = map.get("startUseCarDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartUseCarDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartUseCarDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartUseCarDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartUseCarDate(null);
      }
    }
    if(map.containsKey("endUseCarDate")) {
      Object obj = map.get("endUseCarDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndUseCarDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndUseCarDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndUseCarDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndUseCarDate(null);
      }
    }
    if(map.containsKey("startEvectionDate")) {
      Object obj = map.get("startEvectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartEvectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartEvectionDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartEvectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartEvectionDate(null);
      }
    }
    if(map.containsKey("endEvectionDate")) {
      Object obj = map.get("endEvectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndEvectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndEvectionDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndEvectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndEvectionDate(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map){
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map){
    super.setByOQSMap(map);
    if(map.containsKey("applicatCode")) {
      Object obj = map.get("applicatCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplicatCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applicatName")) {
      Object obj = map.get("applicatName");
      if(obj != null) {
        if(obj instanceof String){
            this.setApplicatName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ordererCode")) {
      Object obj = map.get("ordererCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrdererCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ordererName")) {
      Object obj = map.get("ordererName");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrdererName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("preOrdererCode")) {
      Object obj = map.get("preOrdererCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setPreOrdererCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("preOrdererName")) {
      Object obj = map.get("preOrdererName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPreOrdererName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applyDate")) {
      Object obj = map.get("applyDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setApplyDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setApplyDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setApplyDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setApplyDate(null);
      }
   }
    if(map.containsKey("tripDate")) {
      Object obj = map.get("tripDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTripDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTripDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setTripDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTripDate(null);
      }
   }
    if(map.containsKey("estimateAmount")) {
      Object obj = map.get("estimateAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setEstimateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setEstimateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setEstimateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setEstimateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setEstimateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("billUserCode")) {
      Object obj = map.get("billUserCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillUserCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("billUserName")) {
      Object obj = map.get("billUserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("travelType")) {
      Object obj = map.get("travelType");
      if(obj != null) {
        if(obj instanceof String){
            this.setTravelType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("startCity")) {
      Object obj = map.get("startCity");
      if(obj != null) {
        if(obj instanceof String){
            this.setStartCity((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("arriveCity")) {
      Object obj = map.get("arriveCity");
      if(obj != null) {
        if(obj instanceof String){
            this.setArriveCity((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartDate(null);
      }
   }
    if(map.containsKey("arriveDate")) {
      Object obj = map.get("arriveDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setArriveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setArriveDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setArriveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setArriveDate(null);
      }
   }
    if(map.containsKey("costContent")) {
      Object obj = map.get("costContent");
      if(obj != null) {
        if(obj instanceof String){
            this.setCostContent((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("selectTrafficReason")) {
      Object obj = map.get("selectTrafficReason");
      if(obj != null) {
        if(obj instanceof String){
            this.setSelectTrafficReason((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("useCarReason")) {
      Object obj = map.get("useCarReason");
      if(obj != null) {
        if(obj instanceof String){
            this.setUseCarReason((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("useCarCity")) {
      Object obj = map.get("useCarCity");
      if(obj != null) {
        if(obj instanceof String){
            this.setUseCarCity((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("startUseCarDate")) {
      Object obj = map.get("startUseCarDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartUseCarDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartUseCarDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setStartUseCarDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartUseCarDate(null);
      }
   }
    if(map.containsKey("endUseCarDate")) {
      Object obj = map.get("endUseCarDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEndUseCarDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEndUseCarDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setEndUseCarDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEndUseCarDate(null);
      }
   }
    if(map.containsKey("startEvectionDate")) {
      Object obj = map.get("startEvectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStartEvectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStartEvectionDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setStartEvectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStartEvectionDate(null);
      }
   }
    if(map.containsKey("endEvectionDate")) {
      Object obj = map.get("endEvectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEndEvectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEndEvectionDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setEndEvectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEndEvectionDate(null);
      }
   }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
