package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 匹配状态
 * </p>
 *
 * @author ultraman
 * @since 2022-07-12
 */
public enum MatchStatus {

    _0("0", "未匹配"),
    _1("1", "已匹配");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
