package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * financial_purchase_payment_bill
 * </p>
 *
 * @author ultraman
 * @since 2022-07-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialPurchasePaymentBill extends FinancialApplyBasicBill {

  /**
   * 关联采购申请单单号
   */
  private String relevanceProcurementApplyNo;
  /**
   * 关联采购申请单标题
   */
  private String relevanceProcurementApplyTitle;
  /**
   * 采购事项单据单号
   */
  private String procurementDocumentsNo;
  /**
   * 采购事项单据标题
   */
  private String procurementDocumentsTitle;
  /**
   * 核票责任人编码
   */
  private String responsibleCode;
  /**
   * 核票责任人名称
   */
  private String responsibleName;
  /**
   * 提交人编码
   */
  private String submitterCode;
  /**
   * 提交人名称
   */
  private String submitterName;
  /**
   * 申请部门
   */
  private String applicationDept;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 付款事由
   */
  private String payCause;
  /**
   * 供应商编码
   */
  private String supplierCode;
  /**
   * 供应商名称
   */
  private String supplierName;
  /**
   * 采购合同台账编码
   */
  private String procurementStandingCode;
  /**
   * 采购合同台账名称
   */
  private String procurementStandingName;
  /**
   * 付款类型编码
   */
  private String payTypeCode;
  /**
   * 付款类型名称
   */
  private String payTypeName;
  /**
   * 项目档案编码
   */
  private String projectArchivesCode;
  /**
   * 项目档案名称
   */
  private String projectArchivesName;
  /**
   * 收款银行
   */
  private String dueBank;
  /**
   * 收款账号
   */
  private String accountNumber;
  /**
   * 收款人
   */
  private String payee;
  /**
   * 采购阶段编码
   */
  private String acquisitionPhaseCode;
  /**
   * 采购阶段名称
   */
  private String acquisitionPhaseName;
  /**
   * 采购类别编码
   */
  private String procurementTypeCode;
  /**
   * 采购类别名称
   */
  private String procurementTypeName;
  /**
   * 付款主体编码
   */
  private String paymentCode;
  /**
   * 付款主体名称
   */
  private String paymentName;
  /**
   * 签约主体
   */
  private String contractParty;
  /**
   * 采购方式编码
   */
  private String procurementWayCode;
  /**
   * 采购方式名称
   */
  private String procurementWayName;
  /**
   * 法人实体编码
   */
  private String companyCode;
  /**
   * 法人实体名称
   */
  private String companyName;
  /**
   * 一级部门
   */
  private String oneDept;
  /**
   * 采购目的编码
   */
  private String procurementPurposesCode;
  /**
   * 采购目的名称
   */
  private String procurementPurposesName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("relevanceProcurementApplyNo", relevanceProcurementApplyNo);
      map.put("relevanceProcurementApplyTitle", relevanceProcurementApplyTitle);
      map.put("procurementDocumentsNo", procurementDocumentsNo);
      map.put("procurementDocumentsTitle", procurementDocumentsTitle);
      map.put("responsibleCode", responsibleCode);
      map.put("responsibleName", responsibleName);
      map.put("submitterCode", submitterCode);
      map.put("submitterName", submitterName);
      map.put("applicationDept", applicationDept);
      map.put("contractNo", contractNo);
      map.put("payCause", payCause);
      map.put("supplierCode", supplierCode);
      map.put("supplierName", supplierName);
      map.put("procurementStandingCode", procurementStandingCode);
      map.put("procurementStandingName", procurementStandingName);
      map.put("payTypeCode", payTypeCode);
      map.put("payTypeName", payTypeName);
      map.put("projectArchivesCode", projectArchivesCode);
      map.put("projectArchivesName", projectArchivesName);
      map.put("dueBank", dueBank);
      map.put("accountNumber", accountNumber);
      map.put("payee", payee);
      map.put("acquisitionPhaseCode", acquisitionPhaseCode);
      map.put("acquisitionPhaseName", acquisitionPhaseName);
      map.put("procurementTypeCode", procurementTypeCode);
      map.put("procurementTypeName", procurementTypeName);
      map.put("paymentCode", paymentCode);
      map.put("paymentName", paymentName);
      map.put("contractParty", contractParty);
      map.put("procurementWayCode", procurementWayCode);
      map.put("procurementWayName", procurementWayName);
      map.put("companyCode", companyCode);
      map.put("companyName", companyName);
      map.put("oneDept", oneDept);
      map.put("procurementPurposesCode", procurementPurposesCode);
      map.put("procurementPurposesName", procurementPurposesName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static FinancialPurchasePaymentBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialPurchasePaymentBill entity = new FinancialPurchasePaymentBill();

    entity.setParentByOQSMap(map);
    if(map.containsKey("relevanceProcurementApplyNo")) {
      Object obj = map.get("relevanceProcurementApplyNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRelevanceProcurementApplyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relevanceProcurementApplyTitle")) {
      Object obj = map.get("relevanceProcurementApplyTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRelevanceProcurementApplyTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementDocumentsNo")) {
      Object obj = map.get("procurementDocumentsNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementDocumentsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementDocumentsTitle")) {
      Object obj = map.get("procurementDocumentsTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementDocumentsTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("responsibleCode")) {
      Object obj = map.get("responsibleCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResponsibleCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("responsibleName")) {
      Object obj = map.get("responsibleName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResponsibleName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submitterCode")) {
      Object obj = map.get("submitterCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubmitterCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submitterName")) {
      Object obj = map.get("submitterName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubmitterName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicationDept")) {
      Object obj = map.get("applicationDept");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplicationDept((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCause")) {
      Object obj = map.get("payCause");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementStandingCode")) {
      Object obj = map.get("procurementStandingCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementStandingCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementStandingName")) {
      Object obj = map.get("procurementStandingName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementStandingName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payTypeCode")) {
      Object obj = map.get("payTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payTypeName")) {
      Object obj = map.get("payTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesCode")) {
      Object obj = map.get("projectArchivesCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectArchivesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesName")) {
      Object obj = map.get("projectArchivesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectArchivesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dueBank")) {
      Object obj = map.get("dueBank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDueBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountNumber")) {
      Object obj = map.get("accountNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acquisitionPhaseCode")) {
      Object obj = map.get("acquisitionPhaseCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAcquisitionPhaseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acquisitionPhaseName")) {
      Object obj = map.get("acquisitionPhaseName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAcquisitionPhaseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeCode")) {
      Object obj = map.get("procurementTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeName")) {
      Object obj = map.get("procurementTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentCode")) {
      Object obj = map.get("paymentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentName")) {
      Object obj = map.get("paymentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractParty")) {
      Object obj = map.get("contractParty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractParty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayCode")) {
      Object obj = map.get("procurementWayCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayName")) {
      Object obj = map.get("procurementWayName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oneDept")) {
      Object obj = map.get("oneDept");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOneDept((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementPurposesCode")) {
      Object obj = map.get("procurementPurposesCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementPurposesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementPurposesName")) {
      Object obj = map.get("procurementPurposesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementPurposesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map){
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map){
    super.setByOQSMap(map);
    if(map.containsKey("relevanceProcurementApplyNo")) {
      Object obj = map.get("relevanceProcurementApplyNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRelevanceProcurementApplyNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("relevanceProcurementApplyTitle")) {
      Object obj = map.get("relevanceProcurementApplyTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRelevanceProcurementApplyTitle((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("procurementDocumentsNo")) {
      Object obj = map.get("procurementDocumentsNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementDocumentsNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("procurementDocumentsTitle")) {
      Object obj = map.get("procurementDocumentsTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementDocumentsTitle((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("responsibleCode")) {
      Object obj = map.get("responsibleCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setResponsibleCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("responsibleName")) {
      Object obj = map.get("responsibleName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setResponsibleName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("submitterCode")) {
      Object obj = map.get("submitterCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubmitterCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("submitterName")) {
      Object obj = map.get("submitterName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubmitterName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("applicationDept")) {
      Object obj = map.get("applicationDept");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplicationDept((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payCause")) {
      Object obj = map.get("payCause");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayCause((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSupplierCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSupplierName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("procurementStandingCode")) {
      Object obj = map.get("procurementStandingCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementStandingCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("procurementStandingName")) {
      Object obj = map.get("procurementStandingName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementStandingName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payTypeCode")) {
      Object obj = map.get("payTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayTypeCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payTypeName")) {
      Object obj = map.get("payTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayTypeName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectArchivesCode")) {
      Object obj = map.get("projectArchivesCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectArchivesCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectArchivesName")) {
      Object obj = map.get("projectArchivesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectArchivesName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("dueBank")) {
      Object obj = map.get("dueBank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDueBank((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("accountNumber")) {
      Object obj = map.get("accountNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountNumber((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayee((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("acquisitionPhaseCode")) {
      Object obj = map.get("acquisitionPhaseCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAcquisitionPhaseCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("acquisitionPhaseName")) {
      Object obj = map.get("acquisitionPhaseName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAcquisitionPhaseName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("procurementTypeCode")) {
      Object obj = map.get("procurementTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementTypeCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("procurementTypeName")) {
      Object obj = map.get("procurementTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementTypeName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentCode")) {
      Object obj = map.get("paymentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentName")) {
      Object obj = map.get("paymentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractParty")) {
      Object obj = map.get("contractParty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractParty((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("procurementWayCode")) {
      Object obj = map.get("procurementWayCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementWayCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("procurementWayName")) {
      Object obj = map.get("procurementWayName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementWayName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("oneDept")) {
      Object obj = map.get("oneDept");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOneDept((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("procurementPurposesCode")) {
      Object obj = map.get("procurementPurposesCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementPurposesCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("procurementPurposesName")) {
      Object obj = map.get("procurementPurposesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcurementPurposesName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
