package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * pre_compute_tax_amount_info
 * </p>
 *
 * @author ultraman
 * @since 2022-07-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PreComputeTaxAmountInfo implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 订单号
   */
  private String orderNo;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 原始合同id
   */
  private String originContractId;
  /**
   * 客户名称
   */
  private String customName;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 项目分期名称
   */
  private String projectItemName;
  /**
   * 产品名称
   */
  private String productName;
  /**
   * 产品数量
   */
  private BigDecimal productNum;
  /**
   * 产品单价
   */
  private BigDecimal productSalePrice;
  /**
   * 税率
   */
  private BigDecimal rate;
  /**
   * 订单总金额(含税)
   */
  private BigDecimal orderTotalAmountWithTax;
  /**
   * 订单开票状态
   */
  private String orderInvoiceStatus;
  /**
   * 订单已开票金额
   */
  private BigDecimal orderReadyInvoiceAmount;
  /**
   * 计费税号
   */
  private String taxNo;
  /**
   * 计费公司名称
   */
  private String taxCompanyName;
  /**
   * 计费税号收入总金额（不含税）
   */
  private BigDecimal sumTaxNoAmount;
  /**
   * 计费税号回款金额
   */
  private BigDecimal taxNoPayBackAmount;
  /**
   * 计费开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxChargeStartDate;
  /**
   * 结算开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingStartDate;
  /**
   * 结算截止日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingEndDate;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 产品code
   */
  private String productCode;
  /**
   * 项目code
   */
  private String projectCode;
  /**
   * 项目分期code
   */
  private String projectItemCode;
  /**
   * 订单状态
   */
  private String orderStatusEnum;
  /**
   * 数据是否处理
   */
  private String dataStatus;
  /**
   * 其他信息
   */
  private String extendData;
  /**
   *  内部-设备信息
   */
  private String extendDevice;
  /**
   * 预分配-计费税号回款金额
   */
  private BigDecimal preTaxNoPayBackAmount;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderNo", orderNo);
      map.put("contractNo", contractNo);
      map.put("originContractId", originContractId);
      map.put("customName", customName);
      map.put("projectName", projectName);
      map.put("projectItemName", projectItemName);
      map.put("productName", productName);
      map.put("productNum", productNum);
      map.put("productSalePrice", productSalePrice);
      map.put("rate", rate);
      map.put("orderTotalAmountWithTax", orderTotalAmountWithTax);
      map.put("orderInvoiceStatus", orderInvoiceStatus);
      map.put("orderReadyInvoiceAmount", orderReadyInvoiceAmount);
      map.put("taxNo", taxNo);
      map.put("taxCompanyName", taxCompanyName);
      map.put("sumTaxNoAmount", sumTaxNoAmount);
      map.put("taxNoPayBackAmount", taxNoPayBackAmount);
      map.put("taxChargeStartDate", BocpGenUtils.toTimestamp(taxChargeStartDate));
      map.put("accountingStartDate", BocpGenUtils.toTimestamp(accountingStartDate));
      map.put("accountingEndDate", BocpGenUtils.toTimestamp(accountingEndDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("productCode", productCode);
      map.put("projectCode", projectCode);
      map.put("projectItemCode", projectItemCode);
      map.put("orderStatusEnum", orderStatusEnum);
      map.put("dataStatus", dataStatus);
      map.put("extendData", extendData);
      map.put("extendDevice", extendDevice);
      map.put("preTaxNoPayBackAmount", preTaxNoPayBackAmount);

      return map;
  }

  public static PreComputeTaxAmountInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PreComputeTaxAmountInfo entity = new PreComputeTaxAmountInfo();

    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customName")) {
      Object obj = map.get("customName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemName")) {
      Object obj = map.get("projectItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productNum")) {
      Object obj = map.get("productNum");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProductNum((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProductNum(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProductNum(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProductNum(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProductNum(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("productSalePrice")) {
      Object obj = map.get("productSalePrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProductSalePrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProductSalePrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProductSalePrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProductSalePrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProductSalePrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rate")) {
      Object obj = map.get("rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderTotalAmountWithTax")) {
      Object obj = map.get("orderTotalAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderTotalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderTotalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderTotalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTotalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderInvoiceStatus")) {
      Object obj = map.get("orderInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderReadyInvoiceAmount")) {
      Object obj = map.get("orderReadyInvoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderReadyInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderReadyInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderReadyInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderReadyInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderReadyInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sumTaxNoAmount")) {
      Object obj = map.get("sumTaxNoAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSumTaxNoAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSumTaxNoAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSumTaxNoAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSumTaxNoAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSumTaxNoAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxNoPayBackAmount")) {
      Object obj = map.get("taxNoPayBackAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxNoPayBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxNoPayBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxNoPayBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxNoPayBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxNoPayBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxChargeStartDate")) {
      Object obj = map.get("taxChargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTaxChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxChargeStartDate(null);
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectCode")) {
      Object obj = map.get("projectCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemCode")) {
      Object obj = map.get("projectItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatusEnum")) {
      Object obj = map.get("orderStatusEnum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatusEnum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataStatus")) {
      Object obj = map.get("dataStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extendData")) {
      Object obj = map.get("extendData");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtendData((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extendDevice")) {
      Object obj = map.get("extendDevice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtendDevice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preTaxNoPayBackAmount")) {
      Object obj = map.get("preTaxNoPayBackAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPreTaxNoPayBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPreTaxNoPayBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPreTaxNoPayBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPreTaxNoPayBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPreTaxNoPayBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginContractId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("customName")) {
      Object obj = map.get("customName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectItemName")) {
      Object obj = map.get("projectItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectItemName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productNum")) {
      Object obj = map.get("productNum");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setProductNum((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setProductNum(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setProductNum(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProductNum(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setProductNum(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("productSalePrice")) {
      Object obj = map.get("productSalePrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setProductSalePrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setProductSalePrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setProductSalePrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProductSalePrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setProductSalePrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("rate")) {
      Object obj = map.get("rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("orderTotalAmountWithTax")) {
      Object obj = map.get("orderTotalAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOrderTotalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOrderTotalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOrderTotalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderTotalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOrderTotalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("orderInvoiceStatus")) {
      Object obj = map.get("orderInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderInvoiceStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("orderReadyInvoiceAmount")) {
      Object obj = map.get("orderReadyInvoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOrderReadyInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOrderReadyInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOrderReadyInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderReadyInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOrderReadyInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxCompanyName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sumTaxNoAmount")) {
      Object obj = map.get("sumTaxNoAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSumTaxNoAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSumTaxNoAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSumTaxNoAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSumTaxNoAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSumTaxNoAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("taxNoPayBackAmount")) {
      Object obj = map.get("taxNoPayBackAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxNoPayBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxNoPayBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxNoPayBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxNoPayBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxNoPayBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("taxChargeStartDate")) {
      Object obj = map.get("taxChargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTaxChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTaxChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTaxChargeStartDate(null);
      }
   }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingStartDate(null);
      }
   }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingEndDate(null);
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectCode")) {
      Object obj = map.get("projectCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectItemCode")) {
      Object obj = map.get("projectItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProjectItemCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("orderStatusEnum")) {
      Object obj = map.get("orderStatusEnum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderStatusEnum((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("dataStatus")) {
      Object obj = map.get("dataStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("extendData")) {
      Object obj = map.get("extendData");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtendData((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("extendDevice")) {
      Object obj = map.get("extendDevice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtendDevice((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("preTaxNoPayBackAmount")) {
      Object obj = map.get("preTaxNoPayBackAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPreTaxNoPayBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPreTaxNoPayBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPreTaxNoPayBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPreTaxNoPayBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPreTaxNoPayBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }

  }

}
