package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 源数据枚举定义
 * </p>
 *
 * @author ultraman
 * @since 2022-07-20
 */
public enum SourceMateDataEnum {

    CHARGE_CODE_BASIC("chargeCodeBasic", "chargeCode基础数据"),
    CHARGE_CODE_BUDGET("chargeCodeBudget", "chargeCode预算数据"),
    ORDER_INFO("orderInfo", "订单数据"),
    CONTRACT("contract", "合同"),
    BILL("bill", "结算对账单"),
    BILL_DETAIL("billDetail", "结算单用量"),
    BILL_DETAIL_MONTH("billDetailMonth", "结算单用量月汇总"),
    MONTH_FLOW("monthFlow", "月流水"),
    INVOICE("invoice", "发票主数据"),
    ORDER_INVOICE("orderInvoice", "订单发票关系"),
    ORDER_TAX_NO("orderTaxNo", "订单税号关系"),
    ORDER_BILL("orderBill", "订单结算单关系"),
    TAX_NO_SERVICE("taxNoService", "税号服务开通履历"),
    ORDER_RECEPTION("orderReception", "订单验收履历"),
    PROJECT_ITEM("projectItem", "项目分期"),
    ORDER_PROJECT_ITEM_BIND("orderProjectItemBind", "订单绑定项目分期"),
    SMALL_ORDER("smallOrder", "小B订单"),
    SMALL_ORDER_INVOICE("smallOrderInvoice", "小B订单发票关系"),
    BANK_STATEMENT("bankStatement", "银企流水");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SourceMateDataEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SourceMateDataEnum fromCode(String code){
        switch(code) {
            case "chargeCodeBasic":
                return CHARGE_CODE_BASIC;
            case "chargeCodeBudget":
                return CHARGE_CODE_BUDGET;
            case "orderInfo":
                return ORDER_INFO;
            case "contract":
                return CONTRACT;
            case "bill":
                return BILL;
            case "billDetail":
                return BILL_DETAIL;
            case "billDetailMonth":
                return BILL_DETAIL_MONTH;
            case "monthFlow":
                return MONTH_FLOW;
            case "invoice":
                return INVOICE;
            case "orderInvoice":
                return ORDER_INVOICE;
            case "orderTaxNo":
                return ORDER_TAX_NO;
            case "orderBill":
                return ORDER_BILL;
            case "taxNoService":
                return TAX_NO_SERVICE;
            case "orderReception":
                return ORDER_RECEPTION;
            case "projectItem":
                return PROJECT_ITEM;
            case "orderProjectItemBind":
                return ORDER_PROJECT_ITEM_BIND;
            case "smallOrder":
                return SMALL_ORDER;
            case "smallOrderInvoice":
                return SMALL_ORDER_INVOICE;
            case "bankStatement":
                return BANK_STATEMENT;
            default:
                return null;
        }
    }
}
