package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 流程类型
 * </p>
 *
 * @author ultraman
 * @since 2022-07-30
 */
public enum ProcessType {

    FORWARD_FLOW("forwardFlow", "正向流程"),
    REVERSE_PROCESS("reverseProcess", "逆向流程"),
    RETURN_MONEY_IMPORT("returnMoneyImport", "回款流水导入");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProcessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessType fromCode(String code){
        switch(code) {
            case "forwardFlow":
                return FORWARD_FLOW;
            case "reverseProcess":
                return REVERSE_PROCESS;
            case "returnMoneyImport":
                return RETURN_MONEY_IMPORT;
            default:
                return null;
        }
    }
}
