package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 订单状态
 * </p>
 *
 * @author ultraman
 * @since 2022-08-24
 */
public enum OrderStatusEnum {

    UN_PAID("UN_PAID", "未支付"),
    PAID("PAID", "已支付"),
    CANCEL("CANCEL", "作废"),
    PART_PAY("PART_PAY", "部分支付"),
    UN_CANCEL("UN_CANCEL", "非作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderStatusEnum fromCode(String code){
        switch(code) {
            case "UN_PAID":
                return UN_PAID;
            case "PAID":
                return PAID;
            case "CANCEL":
                return CANCEL;
            case "PART_PAY":
                return PART_PAY;
            case "UN_CANCEL":
                return UN_CANCEL;
            default:
                return null;
        }
    }
}
