package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 组织架构
 * </p>
 *
 * @author ultraman
 * @since 2022-06-22
 */
public enum ChargeCodeOrganization {

    SS0("SS0", "总部公海"),
    SS3A("SS3A", "北区A组"),
    SS3B("SS3B", "北区B组"),
    SS3C("SS3C", "北区C组"),
    SS1A("SS1A", "华东A组"),
    SS1B("SS1B", "华东B组"),
    SS1D("SS1D", "华东D组"),
    SS1G("SS1G", "华东G组"),
    SS1Z("SS1Z", "华东Z组"),
    SS1C("SS1C", "华东C组"),
    SS1E("SS1E", "华东E组"),
    SS1F("SS1F", "华东F组"),
    SS4A("SS4A", "华中A组"),
    SS4B("SS4B", "华中B组"),
    SS2A("SS2A", "南区A组"),
    SS2B("SS2B", "南区B组"),
    SS2C("SS2C", "南区C组"),
    SS2D("SS2D", "南区D组"),
    SS2E("SS2E", "南区E组");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeCodeOrganization(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeOrganization fromCode(String code){
        switch(code) {
            case "SS0":
                return SS0;
            case "SS3A":
                return SS3A;
            case "SS3B":
                return SS3B;
            case "SS3C":
                return SS3C;
            case "SS1A":
                return SS1A;
            case "SS1B":
                return SS1B;
            case "SS1D":
                return SS1D;
            case "SS1G":
                return SS1G;
            case "SS1Z":
                return SS1Z;
            case "SS1C":
                return SS1C;
            case "SS1E":
                return SS1E;
            case "SS1F":
                return SS1F;
            case "SS4A":
                return SS4A;
            case "SS4B":
                return SS4B;
            case "SS2A":
                return SS2A;
            case "SS2B":
                return SS2B;
            case "SS2C":
                return SS2C;
            case "SS2D":
                return SS2D;
            case "SS2E":
                return SS2E;
            default:
                return null;
        }
    }
}
