package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * bill_statics
 * </p>
 *
 * @author ultraman
 * @since 2022-06-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillStatics implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 结算对账主单号
   */
  private String billNo;
  /**
   * 合同编号
   */
  private String contractNo;
  /**
   * 产品编号
   */
  private String productCode;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 结算开始日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingStartDate;
  /**
   * 结算结束日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingEndDate;
  /**
   * 订单总金额（含税）
   */
  private BigDecimal orderTotalAmountWithTax;
  /**
   * 已开票金额（含税）
   */
  private BigDecimal invoiceAmountWithTax;
  /**
   * 回款金额（含税）
   */
  private BigDecimal refundAmountWithTax;
  /**
   * 大区编号
   */
  private String regionCode;
  /**
   * 大区名称
   */
  private String regionName;
  /**
   * 经营单元
   */
  private String businessUnit;
  /**
   * 负责人
   */
  private String principalPerson;
  /**
   * 产品服务名称
   */
  private String productName;
  /**
   * 客户ChargeCode
   */
  private String saChargeCode;
  /**
   * 签约方名称
   */
  private String customerSignatoryName;
  /**
   * 客户名称
   */
  private String saChargeCodeName;
  /**
   * 项目名称
   */
  private String projectName;
  /**
   * 付费类型
   */
  private String paymentType;
  /**
   * 付款条件
   */
  private String paymentRequirement;
  /**
   * 订单含税总金额
   */
  private BigDecimal totalOrderAmountWithTax;
  /**
   * 原始合同id
   */
  private String originContractId;
  /**
   * 是否有效
   */
  private String whetherEffectiveOrNot;

  /**
   * 对一关联关系 关联对象 orderInfo
   */
  private Long manyBillStaticsToOneOrderInfoId;
  /**
   * 对一关联关系 关联对象 contract
   */
  private Long manyBillStaticsToOneContractId;
  /**
   * 对一关联关系 关联对象 bill
   */
  private Long oneBillStaticsToOneReconciliationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billNo", billNo);
      map.put("contractNo", contractNo);
      map.put("productCode", productCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("accountingStartDate", BocpGenUtils.toTimestamp(accountingStartDate));
      map.put("accountingEndDate", BocpGenUtils.toTimestamp(accountingEndDate));
      map.put("orderTotalAmountWithTax", orderTotalAmountWithTax);
      map.put("invoiceAmountWithTax", invoiceAmountWithTax);
      map.put("refundAmountWithTax", refundAmountWithTax);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("businessUnit", businessUnit);
      map.put("principalPerson", principalPerson);
      map.put("productName", productName);
      map.put("saChargeCode", saChargeCode);
      map.put("customerSignatoryName", customerSignatoryName);
      map.put("saChargeCodeName", saChargeCodeName);
      map.put("projectName", projectName);
      map.put("paymentType", paymentType);
      map.put("paymentRequirement", paymentRequirement);
      map.put("totalOrderAmountWithTax", totalOrderAmountWithTax);
      map.put("originContractId", originContractId);
      map.put("whetherEffectiveOrNot", whetherEffectiveOrNot);

      map.put("manyBillStaticsToOneOrderInfo.id", manyBillStaticsToOneOrderInfoId);
      map.put("manyBillStaticsToOneContract.id", manyBillStaticsToOneContractId);
      map.put("oneBillStaticsToOneReconciliation.id", oneBillStaticsToOneReconciliationId);
      return map;
  }

  public static BillStatics fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillStatics entity = new BillStatics();

    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("orderTotalAmountWithTax")) {
      Object obj = map.get("orderTotalAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderTotalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderTotalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderTotalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderTotalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmountWithTax")) {
      Object obj = map.get("invoiceAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refundAmountWithTax")) {
      Object obj = map.get("refundAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRefundAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("principalPerson")) {
      Object obj = map.get("principalPerson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrincipalPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saChargeCode")) {
      Object obj = map.get("saChargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerSignatoryName")) {
      Object obj = map.get("customerSignatoryName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerSignatoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saChargeCodeName")) {
      Object obj = map.get("saChargeCodeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaChargeCodeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalOrderAmountWithTax")) {
      Object obj = map.get("totalOrderAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalOrderAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalOrderAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalOrderAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalOrderAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalOrderAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("whetherEffectiveOrNot")) {
      Object obj = map.get("whetherEffectiveOrNot");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWhetherEffectiveOrNot((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("manyBillStaticsToOneOrderInfo.id")) {
       Object obj = map.get("manyBillStaticsToOneOrderInfo.id");
       if(obj instanceof Long) {
         entity.setManyBillStaticsToOneOrderInfoId((Long)obj);
       } else if(obj instanceof String) {
         entity.setManyBillStaticsToOneOrderInfoId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("manyBillStaticsToOneContract.id")) {
       Object obj = map.get("manyBillStaticsToOneContract.id");
       if(obj instanceof Long) {
         entity.setManyBillStaticsToOneContractId((Long)obj);
       } else if(obj instanceof String) {
         entity.setManyBillStaticsToOneContractId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("oneBillStaticsToOneReconciliation.id")) {
       Object obj = map.get("oneBillStaticsToOneReconciliation.id");
       if(obj instanceof Long) {
         entity.setOneBillStaticsToOneReconciliationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setOneBillStaticsToOneReconciliationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContractNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingStartDate(null);
      }
   }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingEndDate(null);
      }
   }
    if(map.containsKey("orderTotalAmountWithTax")) {
      Object obj = map.get("orderTotalAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOrderTotalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOrderTotalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOrderTotalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setOrderTotalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOrderTotalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("invoiceAmountWithTax")) {
      Object obj = map.get("invoiceAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("refundAmountWithTax")) {
      Object obj = map.get("refundAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRefundAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRefundAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRefundAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setRefundAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRefundAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setRegionCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String){
            this.setRegionName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("principalPerson")) {
      Object obj = map.get("principalPerson");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrincipalPerson((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("saChargeCode")) {
      Object obj = map.get("saChargeCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setSaChargeCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("customerSignatoryName")) {
      Object obj = map.get("customerSignatoryName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCustomerSignatoryName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("saChargeCodeName")) {
      Object obj = map.get("saChargeCodeName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSaChargeCodeName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
            this.setProjectName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentRequirement((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("totalOrderAmountWithTax")) {
      Object obj = map.get("totalOrderAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalOrderAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalOrderAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalOrderAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTotalOrderAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalOrderAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginContractId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("whetherEffectiveOrNot")) {
      Object obj = map.get("whetherEffectiveOrNot");
      if(obj != null) {
        if(obj instanceof String){
            this.setWhetherEffectiveOrNot((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("manyBillStaticsToOneOrderInfo.id")) {
    Object obj = map.get("manyBillStaticsToOneOrderInfo.id");
    if(obj instanceof Long) {
        this.setManyBillStaticsToOneOrderInfoId((Long)obj);
    } else if(obj instanceof String) {
        this.setManyBillStaticsToOneOrderInfoId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("manyBillStaticsToOneContract.id")) {
    Object obj = map.get("manyBillStaticsToOneContract.id");
    if(obj instanceof Long) {
        this.setManyBillStaticsToOneContractId((Long)obj);
    } else if(obj instanceof String) {
        this.setManyBillStaticsToOneContractId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("oneBillStaticsToOneReconciliation.id")) {
    Object obj = map.get("oneBillStaticsToOneReconciliation.id");
    if(obj instanceof Long) {
        this.setOneBillStaticsToOneReconciliationId((Long)obj);
    } else if(obj instanceof String) {
        this.setOneBillStaticsToOneReconciliationId(Long.parseLong((String)obj));
    }
  }
  }

}
