package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * charge_code_budget_usage
 * </p>
 *
 * @author ultraman
 * @since 2022-06-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChargeCodeBudgetUsage implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 结果类型
   */
  private String type;
  /**
   * 预算报ID
   */
  private String budgetId;
  /**
   * 节点ID
   */
  private String nodeId;
  /**
   * 预算金额
   */
  private BigDecimal budgetMoney;
  /**
   * 已使用金额
   */
  private BigDecimal usedMoney;
  /**
   * 占用金额
   */
  private BigDecimal lockedMoney;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("type", type);
      map.put("budgetId", budgetId);
      map.put("nodeId", nodeId);
      map.put("budgetMoney", budgetMoney);
      map.put("usedMoney", usedMoney);
      map.put("lockedMoney", lockedMoney);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static ChargeCodeBudgetUsage fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChargeCodeBudgetUsage entity = new ChargeCodeBudgetUsage();

    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("budgetId")) {
      Object obj = map.get("budgetId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBudgetId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nodeId")) {
      Object obj = map.get("nodeId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNodeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("budgetMoney")) {
      Object obj = map.get("budgetMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBudgetMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBudgetMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBudgetMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBudgetMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBudgetMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("usedMoney")) {
      Object obj = map.get("usedMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUsedMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUsedMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUsedMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUsedMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUsedMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("lockedMoney")) {
      Object obj = map.get("lockedMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLockedMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLockedMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLockedMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setLockedMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLockedMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
            this.setType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("budgetId")) {
      Object obj = map.get("budgetId");
      if(obj != null) {
        if(obj instanceof String){
            this.setBudgetId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("nodeId")) {
      Object obj = map.get("nodeId");
      if(obj != null) {
        if(obj instanceof String){
            this.setNodeId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("budgetMoney")) {
      Object obj = map.get("budgetMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBudgetMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBudgetMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBudgetMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setBudgetMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBudgetMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("usedMoney")) {
      Object obj = map.get("usedMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUsedMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUsedMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUsedMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setUsedMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUsedMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("lockedMoney")) {
      Object obj = map.get("lockedMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setLockedMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setLockedMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setLockedMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setLockedMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setLockedMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
