package com.xforceplus.ultraman.app.financialsettlement.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2022-06-22
*/
public class EntityMeta {
    public interface ChargeMetaData {
        static Long id() {
            return 1414504703901081602L;
        }
        static String code() {
            return "chargeMetaData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_DIMENSION = new TypedField<>(String.class, "chargeDimension");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "chargeItem");
        TypedField<String> CHARGE_LABEL = new TypedField<>(String.class, "chargeLabel");
        TypedField<BigDecimal> CHARGE_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> ACTUAL_USAGE = new TypedField<>(BigDecimal.class, "actualUsage");
        TypedField<Long> USING_MONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> IS_WARANTY = new TypedField<>(String.class, "isWaranty");
        TypedField<BigDecimal> LIMIT_AMOUNT = new TypedField<>(BigDecimal.class, "limitAmount");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> COMPANY_ID = new TypedField<>(String.class, "companyId");
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "settlementStartTime");
        TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "settlementEndTime");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "contractId");
        TypedField<String> CHARGE_BIZ_DIMENSION = new TypedField<>(String.class, "chargeBizDimension");
        TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "billCode");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handleStatus");
        /**
         * 对一关联关系 关联对象 incomeMainMsg
         */
        TypedField<Long> INCOME_MAIN_MSG_ONE_TO_MANYCHARGE_META_DATA_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INCOME_MAIN_MSG_ONE_TO_MANYCHARGE_META_DATA {
                static String code () {
                    return "incomeMainMsgOneToManychargeMetaData" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.productName");
                TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.startChargeTime");
                TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.stopChargeTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.delete_flag");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.projectName");
                TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.chargeItem");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.companyName");
                TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.companyTax");
                TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManychargeMetaData.totalMoneyTax");
                TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManychargeMetaData.totalMoneyWithoutTax");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.property");
                TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.settlementStartTime");
                TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManychargeMetaData.settlementEndTime");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.productCode");
                TypedField<Long> CORRESPONDING_TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManychargeMetaData.correspondingTenantId");
                TypedField<String> CORRESPONDING_TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.correspondingTenantCode");
                TypedField<String> CORRESPONDING_TENANT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.correspondingTenantName");
                TypedField<String> INCOME_STATUS = new TypedField<>(String.class, "incomeMainMsgOneToManychargeMetaData.incomeStatus");
            }
        }
    }
    public interface Costing {
        static Long id() {
            return 1415207897100840961L;
        }
        static String code() {
            return "costing";
        }
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "charge_type");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<BigDecimal> CHARGE_MONEY = new TypedField<>(BigDecimal.class, "charge_money");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<LocalDateTime> OCCURRENCE_TIME = new TypedField<>(LocalDateTime.class, "occurrence_time");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 serviceCost
         */
        TypedField<Long> SERVICE_COST_ONE_TO_MANY_COST_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SERVICE_COST_ONE_TO_MANY_COST {
                static String code () {
                    return "serviceCostOneToManyCost" ;
                }
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "serviceCostOneToManyCost.service_type");
                TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.service_code");
                TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.service_name");
                TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.occrency_time");
                TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.divide_code");
                TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "serviceCostOneToManyCost.currency_status");
                TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.cumulative_cost");
                TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.current_cost");
                TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.cumulative_output");
                TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.current_output");
                TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "serviceCostOneToManyCost.accounting_year");
                TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "serviceCostOneToManyCost.accounting_month");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "serviceCostOneToManyCost.unit_price");
                TypedField<String> SRV_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.srv_code");
                TypedField<String> SRV_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.srv_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "serviceCostOneToManyCost.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "serviceCostOneToManyCost.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "serviceCostOneToManyCost.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "serviceCostOneToManyCost.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "serviceCostOneToManyCost.delete_flag");
            }
        }
    }
    public interface ChargeCode {
        static Long id() {
            return 1415208266803572738L;
        }
        static String code() {
            return "chargeCode";
        }
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<String> CUSTOMER_CODE = new TypedField<>(String.class, "customer_code");
        TypedField<String> CLASSIFICATION = new TypedField<>(String.class, "classification");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ProjectBasicInfo {
        static Long id() {
            return 1415208663073026050L;
        }
        static String code() {
            return "projectBasicInfo";
        }
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "project_name");
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> TENTANT_NAME = new TypedField<>(String.class, "tentant_name");
        TypedField<String> PRODUCT_MODEL = new TypedField<>(String.class, "product_model");
        TypedField<BigDecimal> COUNT = new TypedField<>(BigDecimal.class, "count");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 unitPrice
         */
        TypedField<Long> PROJECT_MANY_TO_ONE_UNIT_PRICE_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PROJECT_MANY_TO_ONE_UNIT_PRICE {
                static String code () {
                    return "projectManyToOneUnitPrice" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "projectManyToOneUnitPrice.code");
                TypedField<String> NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.name");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "projectManyToOneUnitPrice.unit_price");
                TypedField<String> UNIT = new TypedField<>(String.class, "projectManyToOneUnitPrice.unit");
                TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.start_time");
                TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.end_time");
                TypedField<String> INPUT_WAY = new TypedField<>(String.class, "projectManyToOneUnitPrice.input_way");
                TypedField<Long> YEAR = new TypedField<>(Long.class, "projectManyToOneUnitPrice.year");
                TypedField<Long> MONTH = new TypedField<>(Long.class, "projectManyToOneUnitPrice.month");
                TypedField<Long> ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "projectManyToOneUnitPrice.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "projectManyToOneUnitPrice.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "projectManyToOneUnitPrice.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "projectManyToOneUnitPrice.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "projectManyToOneUnitPrice.delete_flag");
            }
        }
    }
    public interface ProductAllocation {
        static Long id() {
            return 1415208799121907714L;
        }
        static String code() {
            return "productAllocation";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<LocalDateTime> TIME = new TypedField<>(LocalDateTime.class, "time");
        TypedField<String> NUMBER = new TypedField<>(String.class, "number");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 contractDetail
         */
        TypedField<Long> INCOME_TO_ONE_CONTRACT_DETAIL_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INCOME_TO_ONE_CONTRACT_DETAIL {
                static String code () {
                    return "incomeToOneContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.productName");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.productCode");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.amount");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.unitPrice");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "incomeToOneContractDetail.chargeRequirement");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeToOneContractDetail.delete_flag");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "incomeToOneContractDetail.chargeType");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "incomeToOneContractDetail.taxRate");
                TypedField<String> VALIDATION = new TypedField<>(String.class, "incomeToOneContractDetail.validation");
                TypedField<String> QUANTITY = new TypedField<>(String.class, "incomeToOneContractDetail.quantity");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.unitPriceWithoutTax");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "incomeToOneContractDetail.paymentRequirement");
                TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.paymentPercent");
                TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "incomeToOneContractDetail.containsRetentionMoney");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "incomeToOneContractDetail.receiptSignDateStr");
                TypedField<String> FIRST_PAY_REQUIREMENT_OR_NOT = new TypedField<>(String.class, "incomeToOneContractDetail.firstPayRequirementOrNot");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "incomeToOneContractDetail.chargeCycle");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "incomeToOneContractDetail.billingType");
                TypedField<String> DAYS = new TypedField<>(String.class, "incomeToOneContractDetail.days");
                TypedField<Boolean> OUTSOURCING = new TypedField<>(Boolean.class, "incomeToOneContractDetail.outsourcing");
                TypedField<String> LINKED_PURCHASE_CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractDetail.linkedPurchaseContractNo");
                TypedField<String> CHARGE_RULES = new TypedField<>(String.class, "incomeToOneContractDetail.chargeRules");
                TypedField<String> PRODUCT_STATUS = new TypedField<>(String.class, "incomeToOneContractDetail.productStatus");
                TypedField<String> PRODUCT_ACCEPTANCE_STATUS = new TypedField<>(String.class, "incomeToOneContractDetail.productAcceptanceStatus");
            }
        }
    }
    public interface UnitPrice {
        static Long id() {
            return 1415208953767653377L;
        }
        static String code() {
            return "unitPrice";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> INPUT_WAY = new TypedField<>(String.class, "input_way");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface AllocationRuleDetails {
        static Long id() {
            return 1415209110972604418L;
        }
        static String code() {
            return "allocationRuleDetails";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> ALLOCATION_PROPORTION = new TypedField<>(BigDecimal.class, "allocation_proportion");
        TypedField<BigDecimal> CONSUMPTION = new TypedField<>(BigDecimal.class, "consumption");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        /**
         * 对一关联关系 关联对象 allocationRule
         */
        TypedField<Long> ALLOCATION_RULE_ONE_TO_MANY_RULE_DETAIL_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ALLOCATION_RULE_ONE_TO_MANY_RULE_DETAIL {
                static String code () {
                    return "allocationRuleOneToManyRuleDetail" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.code");
                TypedField<String> NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.name");
                TypedField<String> ALLOCATION_TYPE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.allocation_type");
                TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.start_time");
                TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.end_time");
                TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.charge_belong");
                TypedField<Long> MONTH = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.month");
                TypedField<Long> ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "allocationRuleOneToManyRuleDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "allocationRuleOneToManyRuleDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "allocationRuleOneToManyRuleDetail.delete_flag");
            }
        }
    }
    public interface AllocationRule {
        static Long id() {
            return 1415211734738006018L;
        }
        static String code() {
            return "allocationRule";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> ALLOCATION_TYPE = new TypedField<>(String.class, "allocation_type");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface ChargeCodeMaintain {
        static Long id() {
            return 1415212005962674177L;
        }
        static String code() {
            return "chargeCodeMaintain";
        }
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface InfoBI {
        static Long id() {
            return 1415212818932035585L;
        }
        static String code() {
            return "infoBI";
        }
        TypedField<String> TAX_NUMBER = new TypedField<>(String.class, "tax_number");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> MIDDLE_GROUND_CODE = new TypedField<>(String.class, "middle_ground_code");
        TypedField<BigDecimal> AMOUNT_USAGE = new TypedField<>(BigDecimal.class, "amount_usage");
        TypedField<String> MIDDLE_GROUND_NAME = new TypedField<>(String.class, "middle_ground_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> TENTANT = new TypedField<>(String.class, "tentant");
        TypedField<LocalDateTime> STARTING_TIME = new TypedField<>(LocalDateTime.class, "starting_time");
        TypedField<LocalDateTime> ENDING_TIME = new TypedField<>(LocalDateTime.class, "ending_time");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ServiceCostDetails {
        static Long id() {
            return 1415214963842392066L;
        }
        static String code() {
            return "serviceCostDetails";
        }
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> COST_CODE = new TypedField<>(String.class, "cost_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> COST_TYPE = new TypedField<>(String.class, "cost_type");
        TypedField<String> COST_BELONG = new TypedField<>(String.class, "cost_belong");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<LocalDateTime> OCCURENCY_TIME = new TypedField<>(LocalDateTime.class, "occurency_time");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> COST_NAME = new TypedField<>(String.class, "cost_name");
        TypedField<String> PARENT_CHARGECODE = new TypedField<>(String.class, "parent_chargecode");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 serviceCost
         */
        TypedField<Long> SEVICE_COST_ONE_TO_MANY_DETAIL_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SEVICE_COST_ONE_TO_MANY_DETAIL {
                static String code () {
                    return "seviceCostOneToManyDetail" ;
                }
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_type");
                TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_code");
                TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.service_name");
                TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.occrency_time");
                TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.divide_code");
                TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "seviceCostOneToManyDetail.currency_status");
                TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.cumulative_cost");
                TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.current_cost");
                TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.cumulative_output");
                TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.current_output");
                TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "seviceCostOneToManyDetail.accounting_year");
                TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "seviceCostOneToManyDetail.accounting_month");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "seviceCostOneToManyDetail.unit_price");
                TypedField<String> SRV_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.srv_code");
                TypedField<String> SRV_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.srv_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "seviceCostOneToManyDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "seviceCostOneToManyDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "seviceCostOneToManyDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "seviceCostOneToManyDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "seviceCostOneToManyDetail.delete_flag");
            }
        }
    }
    public interface ServiceCost {
        static Long id() {
            return 1415215356366331905L;
        }
        static String code() {
            return "serviceCost";
        }
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "occrency_time");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "currency_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> SRV_CODE = new TypedField<>(String.class, "srv_code");
        TypedField<String> SRV_NAME = new TypedField<>(String.class, "srv_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface Income {
        static Long id() {
            return 1415498206489735170L;
        }
        static String code() {
            return "income";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> USE_COMPANY_NAME = new TypedField<>(String.class, "useCompanyName");
        TypedField<String> USE_COMPANYTAX_NO = new TypedField<>(String.class, "useCompanytaxNo");
        TypedField<String> PRODUCT = new TypedField<>(String.class, "product");
        TypedField<String> MODEL_NO = new TypedField<>(String.class, "modelNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<BigDecimal> UNIT = new TypedField<>(BigDecimal.class, "unit");
        TypedField<BigDecimal> RATIO = new TypedField<>(BigDecimal.class, "ratio");
        TypedField<Long> NUMBER = new TypedField<>(Long.class, "number");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> START_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "startChargeDate");
        TypedField<LocalDateTime> END_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "endChargeDate");
        TypedField<Long> USE_MONTH = new TypedField<>(Long.class, "useMonth");
        TypedField<Long> USE_YEAR = new TypedField<>(Long.class, "useYear");
        TypedField<BigDecimal> CUR_INCOME = new TypedField<>(BigDecimal.class, "curIncome");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> CORRESPONDING_TENANT_ID = new TypedField<>(Long.class, "correspondingTenantId");
        TypedField<String> CORRESPONDING_TENANT_CODE = new TypedField<>(String.class, "correspondingTenantCode");
        TypedField<String> CORRESPONDING_TENANT_NAME = new TypedField<>(String.class, "correspondingTenantName");
    }
    public interface SettlementData {
        static Long id() {
            return 1415502111091400706L;
        }
        static String code() {
            return "settlementData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<LocalDateTime> STATEMENT_CREATE_DATE = new TypedField<>(LocalDateTime.class, "statementCreateDate");
        TypedField<String> INVOICE_COMPANY_NAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<String> INVOICE_COMPANY_TAX = new TypedField<>(String.class, "invoiceCompanyTax");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoiceDate");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithoutTax");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithTax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_METHOD = new TypedField<>(String.class, "chargeMethod");
        TypedField<LocalDateTime> ACCEPTANCE_DATE = new TypedField<>(LocalDateTime.class, "acceptanceDate");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<BigDecimal> CHARGE_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithoutTax");
        TypedField<BigDecimal> CHARGE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithTax");
        TypedField<LocalDateTime> RETURN_DATE = new TypedField<>(LocalDateTime.class, "returnDate");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> PAYER_COMPANY = new TypedField<>(String.class, "payerCompany");
        TypedField<String> CURRENT_STATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<Long> CHARGE_DAYS = new TypedField<>(Long.class, "chargeDays");
        TypedField<BigDecimal> CURRENT_DISCOUNT_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "currentDiscountMoneyWithTax");
        TypedField<BigDecimal> DISCOUNT_LATER_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "discountLaterMoneyWithTax");
        TypedField<BigDecimal> DISCOUNT_LATER_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "discountLaterMoneyWithoutTax");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<LocalDateTime> ORDER_GENERATE_DATE = new TypedField<>(LocalDateTime.class, "orderGenerateDate");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "receiptSignDateStr");
        /**
         * 对一关联关系 关联对象 settlementMainData
         */
        TypedField<Long> SETTLEMENT_MAIN_DATA_ONE_TO_MANY_SETTLEMENT_DATA_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.id");
        /**
         * 对一关联关系 关联对象 reconciliationDetailData
         */
        TypedField<Long> ONE_SETTLEMENT_DETAIL_TO_ONE_RECONCILIATION_DETAIL_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SETTLEMENT_MAIN_DATA_ONE_TO_MANY_SETTLEMENT_DATA {
                static String code () {
                    return "settlementMainDataOneToManySettlementData" ;
                }
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.projectName");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.productName");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.chargeRequirement");
                TypedField<BigDecimal> SETTLED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.settledMoneyWithTax");
                TypedField<BigDecimal> WAITING_SETTLE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.waitingSettleMoneyWithTax");
                TypedField<BigDecimal> INVOICED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.invoicedMoneyWithTax");
                TypedField<BigDecimal> RETURNED_MONEY = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.returnedMoney");
                TypedField<Long> ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.delete_flag");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.contractNo");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "settlementMainDataOneToManySettlementData.chargeEndDate");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.chargeType");
                TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.statementNo");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.customer");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.principalPerson");
                TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "settlementMainDataOneToManySettlementData.tenantGroupId");
                TypedField<BigDecimal> ORDER_TOTAL_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementMainDataOneToManySettlementData.orderTotalMoneyWithTax");
                TypedField<String> REGION = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.region");
                TypedField<String> REGION_ID = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.regionId");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "settlementMainDataOneToManySettlementData.productCode");
            }
            interface ONE_SETTLEMENT_DETAIL_TO_ONE_RECONCILIATION_DETAIL {
                static String code () {
                    return "oneSettlementDetailToOneReconciliationDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.contractNo");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.tenantName");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.productName");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.chargeEndDate");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.chargeType");
                TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.payableAmount");
                TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.discountMoney");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.amount");
                TypedField<String> RECONCILIATION_DETAIL_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationDetailCode");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.projectNo");
                TypedField<String> TAX_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.taxNo");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.companyName");
                TypedField<String> COMPANY_I_D = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.companyID");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.billingType");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.unitPriceWithoutTax");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.taxRate");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.delete_flag");
                TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationCode");
                TypedField<LocalDateTime> RECONCILIATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationCreateTime");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.productCode");
                TypedField<BigDecimal> RECONCILIATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.reconciliationSettleAccounts");
                TypedField<String> ONE_TIME_UNIT = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.oneTimeUnit");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.chargeCycle");
                TypedField<BigDecimal> SETTLEMENT_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.settlementAmount");
            }
        }
    }
    public interface Contract {
        static Long id() {
            return 1415514648138260481L;
        }
        static String code() {
            return "contract";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "periodPromise");
        TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "paymentPeriod");
        TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "paymentPeriodType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "containsRetentionMoney");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contractType");
        TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "contractTotalMoney");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "chargeContractId");
        TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "saChargeCode");
        TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "saChargeCodeName");
        TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "totalAmountWithTax");
        TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "relatedContractNo");
        TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "signTeamCode");
        TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "signTeamName");
        TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "customerSignatoryTaxNos");
        TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "customerSignatoryName");
        TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "expenseBearer");
        TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "businessUnitDeptCode");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> REGION_CODE = new TypedField<>(String.class, "regionCode");
        TypedField<String> REGION_NAME = new TypedField<>(String.class, "regionName");
        TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "ourSignatoryName");
        TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "ourSignatoryTaxNo");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "signDateStr");
        TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "expiryDateStr");
        TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "receiptSignDateStr");
        TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "effectiveDateStr");
        TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "contractStatus");
        TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "contractVersion");
        TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "supplementaryAgreementTypes");
        TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "receiptSignDate");
        TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "supplementaryAgreementTypesDesc");
        TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "mandatoryRenewal");
        TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "otherSignatoryName");
        TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "otherSignatoryTaxNo");
        TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "contractFileNo");
        TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "whetherOutsourcing");
        TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "relatedContractId");
        TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "attachmentUrl");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface Project {
        static Long id() {
            return 1415517014084415490L;
        }
        static String code() {
            return "project";
        }
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> SALE_DIRECTOR_EMAIL = new TypedField<>(String.class, "saleDirectorEmail");
        TypedField<String> SALE_DIRECTOR = new TypedField<>(String.class, "saleDirector");
        TypedField<String> EMAIL = new TypedField<>(String.class, "email");
        TypedField<String> SALE_PRINCIPAL = new TypedField<>(String.class, "salePrincipal");
        TypedField<String> SIGN_TEAM = new TypedField<>(String.class, "signTeam");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ProductFunction {
        static Long id() {
            return 1415519149595336706L;
        }
        static String code() {
            return "productFunction";
        }
        TypedField<String> PRODUCT_NO = new TypedField<>(String.class, "productNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_TYPE = new TypedField<>(String.class, "productType");
        TypedField<String> FUNCTION_TYPE = new TypedField<>(String.class, "functionType");
        TypedField<String> FUNTION_DESC = new TypedField<>(String.class, "funtionDesc");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> PRODUCT_SRV_NAME = new TypedField<>(String.class, "productSrvName");
        TypedField<String> TAX_ED = new TypedField<>(String.class, "taxEd");
        TypedField<String> INVOICE_UNIT = new TypedField<>(String.class, "invoiceUnit");
        TypedField<String> USE_INVOICE_TYPE = new TypedField<>(String.class, "useInvoiceType");
        TypedField<LocalDateTime> SRV_START_DATE = new TypedField<>(LocalDateTime.class, "srvStartDate");
        TypedField<LocalDateTime> SRV_END_DATE = new TypedField<>(LocalDateTime.class, "srvEndDate");
        TypedField<String> CREATE_USER = new TypedField<>(String.class, "createUser");
        TypedField<String> UPDATE_USER = new TypedField<>(String.class, "updateUser");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface IncomeMainMsg {
        static Long id() {
            return 1415957144165621761L;
        }
        static String code() {
            return "incomeMainMsg";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "stopChargeTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "chargeItem");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "totalMoneyTax");
        TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "totalMoneyWithoutTax");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "settlementStartTime");
        TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "settlementEndTime");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<Long> CORRESPONDING_TENANT_ID = new TypedField<>(Long.class, "correspondingTenantId");
        TypedField<String> CORRESPONDING_TENANT_CODE = new TypedField<>(String.class, "correspondingTenantCode");
        TypedField<String> CORRESPONDING_TENANT_NAME = new TypedField<>(String.class, "correspondingTenantName");
        TypedField<String> INCOME_STATUS = new TypedField<>(String.class, "incomeStatus");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface ChargeJob {
        static Long id() {
            return 1416945394439102465L;
        }
        static String code() {
            return "chargeJob";
        }
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> INCOME_MAIN_MSG_ID = new TypedField<>(String.class, "incomeMainMsgId");
        TypedField<String> JOB_TYPE = new TypedField<>(String.class, "jobType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELF_ID = new TypedField<>(String.class, "selfId");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> WHETHER_RECEIVED = new TypedField<>(String.class, "whetherReceived");
        TypedField<String> WHETHER_VALIDATE = new TypedField<>(String.class, "whetherValidate");
    }
    public interface IncomeDetail {
        static Long id() {
            return 1422827562209681410L;
        }
        static String code() {
            return "incomeDetail";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<LocalDateTime> START_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "startChargeDate");
        TypedField<LocalDateTime> END_CHARGE_DATE = new TypedField<>(LocalDateTime.class, "endChargeDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "companyTax");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> CURRENT_INCOME_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "currentIncomeWithoutTax");
        TypedField<String> ACCEPTANCE_DATE = new TypedField<>(String.class, "acceptanceDate");
        TypedField<String> ACCOUNTING_TIME = new TypedField<>(String.class, "accountingTime");
        TypedField<String> CHARGE_METHOD = new TypedField<>(String.class, "chargeMethod");
        TypedField<String> USING_MONTH = new TypedField<>(String.class, "usingMonth");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> REGION_ID = new TypedField<>(String.class, "regionId");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> RELATED_ORDER_NOS = new TypedField<>(String.class, "relatedOrderNos");
        /**
         * 对一关联关系 关联对象 incomeMainMsg
         */
        TypedField<Long> INCOME_MAIN_MSG_ONE_TO_MANYINCOME_DETAIL_MSG_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.id");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> MANY_INCOME_DETAIL_TO_ONE_CONTRACT_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.id");
        /**
         * 对一关联关系 关联对象 contractDetail
         */
        TypedField<Long> MANY_INCOME_DETAIL_TO_ONE_CONTRACT_DETAIL_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContractDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INCOME_MAIN_MSG_ONE_TO_MANYINCOME_DETAIL_MSG {
                static String code () {
                    return "incomeMainMsgOneToManyincomeDetailMsg" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.productName");
                TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.startChargeTime");
                TypedField<LocalDateTime> STOP_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.stopChargeTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.delete_flag");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.projectName");
                TypedField<String> CHARGE_ITEM = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.chargeItem");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.companyName");
                TypedField<String> COMPANY_TAX = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.companyTax");
                TypedField<BigDecimal> TOTAL_MONEY_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManyincomeDetailMsg.totalMoneyTax");
                TypedField<BigDecimal> TOTAL_MONEY_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "incomeMainMsgOneToManyincomeDetailMsg.totalMoneyWithoutTax");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.property");
                TypedField<LocalDateTime> SETTLEMENT_START_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.settlementStartTime");
                TypedField<LocalDateTime> SETTLEMENT_END_TIME = new TypedField<>(LocalDateTime.class, "incomeMainMsgOneToManyincomeDetailMsg.settlementEndTime");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.productCode");
                TypedField<Long> CORRESPONDING_TENANT_ID = new TypedField<>(Long.class, "incomeMainMsgOneToManyincomeDetailMsg.correspondingTenantId");
                TypedField<String> CORRESPONDING_TENANT_CODE = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.correspondingTenantCode");
                TypedField<String> CORRESPONDING_TENANT_NAME = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.correspondingTenantName");
                TypedField<String> INCOME_STATUS = new TypedField<>(String.class, "incomeMainMsgOneToManyincomeDetailMsg.incomeStatus");
            }
            interface MANY_INCOME_DETAIL_TO_ONE_CONTRACT {
                static String code () {
                    return "manyIncomeDetailToOneContract" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContract.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContract.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyIncomeDetailToOneContract.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyIncomeDetailToOneContract.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyIncomeDetailToOneContract.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "manyIncomeDetailToOneContract.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "manyIncomeDetailToOneContract.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "manyIncomeDetailToOneContract.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "manyIncomeDetailToOneContract.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "manyIncomeDetailToOneContract.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manyIncomeDetailToOneContract.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContract.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "manyIncomeDetailToOneContract.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "manyIncomeDetailToOneContract.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "manyIncomeDetailToOneContract.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContract.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "manyIncomeDetailToOneContract.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "manyIncomeDetailToOneContract.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "manyIncomeDetailToOneContract.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "manyIncomeDetailToOneContract.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "manyIncomeDetailToOneContract.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "manyIncomeDetailToOneContract.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "manyIncomeDetailToOneContract.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "manyIncomeDetailToOneContract.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "manyIncomeDetailToOneContract.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "manyIncomeDetailToOneContract.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "manyIncomeDetailToOneContract.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContract.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContract.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContract.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "manyIncomeDetailToOneContract.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "manyIncomeDetailToOneContract.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "manyIncomeDetailToOneContract.attachmentUrl");
            }
            interface MANY_INCOME_DETAIL_TO_ONE_CONTRACT_DETAIL {
                static String code () {
                    return "manyIncomeDetailToOneContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.productName");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.productCode");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "manyIncomeDetailToOneContractDetail.amount");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "manyIncomeDetailToOneContractDetail.unitPrice");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.chargeRequirement");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyIncomeDetailToOneContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyIncomeDetailToOneContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyIncomeDetailToOneContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.delete_flag");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.chargeType");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.taxRate");
                TypedField<String> VALIDATION = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.validation");
                TypedField<String> QUANTITY = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.quantity");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "manyIncomeDetailToOneContractDetail.unitPriceWithoutTax");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.paymentRequirement");
                TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "manyIncomeDetailToOneContractDetail.paymentPercent");
                TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.containsRetentionMoney");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.receiptSignDateStr");
                TypedField<String> FIRST_PAY_REQUIREMENT_OR_NOT = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.firstPayRequirementOrNot");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.chargeCycle");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.billingType");
                TypedField<String> DAYS = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.days");
                TypedField<Boolean> OUTSOURCING = new TypedField<>(Boolean.class, "manyIncomeDetailToOneContractDetail.outsourcing");
                TypedField<String> LINKED_PURCHASE_CONTRACT_NO = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.linkedPurchaseContractNo");
                TypedField<String> CHARGE_RULES = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.chargeRules");
                TypedField<String> PRODUCT_STATUS = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.productStatus");
                TypedField<String> PRODUCT_ACCEPTANCE_STATUS = new TypedField<>(String.class, "manyIncomeDetailToOneContractDetail.productAcceptanceStatus");
            }
        }
    }
    public interface InvoiceData {
        static Long id() {
            return 1422867883811573762L;
        }
        static String code() {
            return "invoiceData";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "originalInvoiceCode");
        TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "originalInvoiceNo");
        TypedField<String> SELLER_TAX_NAME = new TypedField<>(String.class, "sellerTaxName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> EFFECTIVE_STATUS = new TypedField<>(String.class, "effectiveStatus");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchStatus");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> INVOICE_DATE = new TypedField<>(String.class, "invoiceDate");
        TypedField<BigDecimal> AMOUT_WITH_TAX_UN_MATCHED = new TypedField<>(BigDecimal.class, "amoutWithTaxUnMatched");
        TypedField<BigDecimal> PAYMENT_FLOW = new TypedField<>(BigDecimal.class, "paymentFlow");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<Long> RED_STATUS = new TypedField<>(Long.class, "redStatus");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "businessBillType");
        TypedField<LocalDateTime> RED_TIME = new TypedField<>(LocalDateTime.class, "redTime");
        TypedField<String> RED_FLAG = new TypedField<>(String.class, "redFlag");
        TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceColor");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "sellerBankAccount");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaserBankName");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaserBankAccount");
    }
    public interface JobList {
        static Long id() {
            return 1425736007619231745L;
        }
        static String code() {
            return "jobList";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> WHETHER_EFFECTIVE = new TypedField<>(String.class, "whetherEffective");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ReconciliationDetailData {
        static Long id() {
            return 1428252466707075073L;
        }
        static String code() {
            return "reconciliationDetailData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> RECONCILIATION_DETAIL_CODE = new TypedField<>(String.class, "reconciliationDetailCode");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_I_D = new TypedField<>(String.class, "companyID");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<LocalDateTime> RECONCILIATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconciliationCreateTime");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<BigDecimal> RECONCILIATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "reconciliationSettleAccounts");
        TypedField<String> ONE_TIME_UNIT = new TypedField<>(String.class, "oneTimeUnit");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<BigDecimal> SETTLEMENT_AMOUNT = new TypedField<>(BigDecimal.class, "settlementAmount");
    }
    public interface ReconciliationAndInvoiceRelation {
        static Long id() {
            return 1428562157585108994L;
        }
        static String code() {
            return "reconciliationAndInvoiceRelation";
        }
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ReconciliationData {
        static Long id() {
            return 1429648136449986561L;
        }
        static String code() {
            return "reconciliationData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> RECONCILATION_CODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<String> RECONCILATION_STATUS = new TypedField<>(String.class, "reconcilationStatus");
        TypedField<BigDecimal> ACTUAL_MONEY = new TypedField<>(BigDecimal.class, "actualMoney");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<LocalDateTime> RECONCILATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconcilationCreateTime");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> SETTLEMENT_AMOUNT = new TypedField<>(BigDecimal.class, "settlementAmount");
        TypedField<BigDecimal> DISCOUNT_AMOUNT = new TypedField<>(BigDecimal.class, "discountAmount");
    }
    public interface SettlementMainData {
        static Long id() {
            return 1432542303681417217L;
        }
        static String code() {
            return "settlementMainData";
        }
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "chargeRequirement");
        TypedField<BigDecimal> SETTLED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "settledMoneyWithTax");
        TypedField<BigDecimal> WAITING_SETTLE_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "waitingSettleMoneyWithTax");
        TypedField<BigDecimal> INVOICED_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "invoicedMoneyWithTax");
        TypedField<BigDecimal> RETURNED_MONEY = new TypedField<>(BigDecimal.class, "returnedMoney");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> STATEMENT_NO = new TypedField<>(String.class, "statementNo");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "tenantGroupId");
        TypedField<BigDecimal> ORDER_TOTAL_MONEY_WITH_TAX = new TypedField<>(BigDecimal.class, "orderTotalMoneyWithTax");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> REGION_ID = new TypedField<>(String.class, "regionId");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> TO_ONE_CONTRACT_ID = new TypedField<>(Long.class, "toOneContract.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface TO_ONE_CONTRACT {
                static String code () {
                    return "toOneContract" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "toOneContract.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "toOneContract.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "toOneContract.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "toOneContract.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "toOneContract.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "toOneContract.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "toOneContract.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "toOneContract.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "toOneContract.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "toOneContract.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "toOneContract.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "toOneContract.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "toOneContract.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "toOneContract.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "toOneContract.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "toOneContract.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "toOneContract.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "toOneContract.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "toOneContract.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "toOneContract.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "toOneContract.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "toOneContract.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "toOneContract.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "toOneContract.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "toOneContract.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "toOneContract.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "toOneContract.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "toOneContract.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "toOneContract.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "toOneContract.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "toOneContract.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "toOneContract.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "toOneContract.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "toOneContract.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "toOneContract.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "toOneContract.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "toOneContract.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "toOneContract.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "toOneContract.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "toOneContract.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "toOneContract.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "toOneContract.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "toOneContract.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "toOneContract.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "toOneContract.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "toOneContract.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "toOneContract.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "toOneContract.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "toOneContract.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "toOneContract.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "toOneContract.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "toOneContract.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "toOneContract.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "toOneContract.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "toOneContract.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "toOneContract.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "toOneContract.attachmentUrl");
            }
        }
    }
    public interface PayWater {
        static Long id() {
            return 1433255154737909761L;
        }
        static String code() {
            return "payWater";
        }
        TypedField<LocalDateTime> TRADE_TIME = new TypedField<>(LocalDateTime.class, "tradeTime");
        TypedField<BigDecimal> DEBIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "debitMoneyAmount");
        TypedField<BigDecimal> CREDIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "creditMoneyAmount");
        TypedField<String> BANK_NAME = new TypedField<>(String.class, "bankName");
        TypedField<String> BANK_ACCOUNT = new TypedField<>(String.class, "bankAccount");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "accountingDate");
        TypedField<String> ABSTRACTION = new TypedField<>(String.class, "abstraction");
        TypedField<String> TRADE_BUSINESS_CODE = new TypedField<>(String.class, "tradeBusinessCode");
        TypedField<BigDecimal> BALANCE = new TypedField<>(BigDecimal.class, "balance");
        TypedField<String> CUSTOMER_ACCOUNT = new TypedField<>(String.class, "customerAccount");
        TypedField<String> ENTERPRISE_SERIAL_NUMBER = new TypedField<>(String.class, "enterpriseSerialNumber");
        TypedField<String> DOCUMENT_CATEGORY = new TypedField<>(String.class, "documentCategory");
        TypedField<String> DOCUMENT_NO = new TypedField<>(String.class, "documentNo");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface StatisticBusinessUsage {
        static Long id() {
            return 1434914546386120706L;
        }
        static String code() {
            return "statisticBusinessUsage";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlementCycle");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> BUSINESS_DIMENSION = new TypedField<>(String.class, "businessDimension");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> BUSINESS_TIME = new TypedField<>(String.class, "businessTime");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
    }
    public interface SettlementDetailAndInvoiceRelation {
        static Long id() {
            return 1437620316654374914L;
        }
        static String code() {
            return "settlementDetailAndInvoiceRelation";
        }
        TypedField<String> SETTLEMENT_DETAIL_CODE = new TypedField<>(String.class, "settlementDetailCode");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
    }
    public interface RecordTable {
        static Long id() {
            return 1451184261675716610L;
        }
        static String code() {
            return "recordTable";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<BigDecimal> RECONCILIATION_SETTLE_ACCOUNTS = new TypedField<>(BigDecimal.class, "reconciliationSettleAccounts");
        TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "reconciliationStatus");
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> INCOME_TYPE = new TypedField<>(String.class, "incomeType");
        TypedField<BigDecimal> ACTUAL_MONEY = new TypedField<>(BigDecimal.class, "actualMoney");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<LocalDateTime> RECONCILIATION_CREATE_TIME = new TypedField<>(LocalDateTime.class, "reconciliationCreateTime");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<BigDecimal> DISCOUNT_MONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<BigDecimal> PAYABLE_AMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlementCycle");
        TypedField<String> WHETHER_VALIDATION = new TypedField<>(String.class, "whetherValidation");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> RECONCILIATION_DETAIL_CODE = new TypedField<>(String.class, "reconciliationDetailCode");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_I_D = new TypedField<>(String.class, "companyID");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> BUSINESS_DIMENSION = new TypedField<>(String.class, "businessDimension");
        TypedField<BigDecimal> USAGE = new TypedField<>(BigDecimal.class, "usage");
        TypedField<String> COMPRESS = new TypedField<>(String.class, "compress");
        TypedField<String> RECORD_TYPE = new TypedField<>(String.class, "recordType");
    }
    public interface ContractDetail {
        static Long id() {
            return 1455020711739621378L;
        }
        static String code() {
            return "contractDetail";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "chargeRequirement");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> VALIDATION = new TypedField<>(String.class, "validation");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "paymentPercent");
        TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "containsRetentionMoney");
        TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "receiptSignDateStr");
        TypedField<String> FIRST_PAY_REQUIREMENT_OR_NOT = new TypedField<>(String.class, "firstPayRequirementOrNot");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> DAYS = new TypedField<>(String.class, "days");
        TypedField<Boolean> OUTSOURCING = new TypedField<>(Boolean.class, "outsourcing");
        TypedField<String> LINKED_PURCHASE_CONTRACT_NO = new TypedField<>(String.class, "linkedPurchaseContractNo");
        TypedField<String> CHARGE_RULES = new TypedField<>(String.class, "chargeRules");
        TypedField<String> PRODUCT_STATUS = new TypedField<>(String.class, "productStatus");
        TypedField<String> PRODUCT_ACCEPTANCE_STATUS = new TypedField<>(String.class, "productAcceptanceStatus");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> ONE_CONTRACT_MAIN_TO_MANY_CONTRACT_DETAIL_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_CONTRACT_MAIN_TO_MANY_CONTRACT_DETAIL {
                static String code () {
                    return "oneContractMainToManyContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneContractMainToManyContractDetail.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "oneContractMainToManyContractDetail.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "oneContractMainToManyContractDetail.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneContractMainToManyContractDetail.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneContractMainToManyContractDetail.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "oneContractMainToManyContractDetail.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneContractMainToManyContractDetail.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "oneContractMainToManyContractDetail.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "oneContractMainToManyContractDetail.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneContractMainToManyContractDetail.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneContractMainToManyContractDetail.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyContractDetail.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyContractDetail.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyContractDetail.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyContractDetail.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "oneContractMainToManyContractDetail.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "oneContractMainToManyContractDetail.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyContractDetail.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "oneContractMainToManyContractDetail.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "oneContractMainToManyContractDetail.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyContractDetail.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "oneContractMainToManyContractDetail.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "oneContractMainToManyContractDetail.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "oneContractMainToManyContractDetail.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "oneContractMainToManyContractDetail.attachmentUrl");
            }
        }
    }
    public interface TaxNoList {
        static Long id() {
            return 1455075594576560130L;
        }
        static String code() {
            return "taxNoList";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<LocalDateTime> STOP_TIME = new TypedField<>(LocalDateTime.class, "stopTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TAX_NO_STATUS = new TypedField<>(String.class, "taxNoStatus");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<LocalDateTime> OPEN_TIME = new TypedField<>(LocalDateTime.class, "openTime");
        TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "deviceType");
        TypedField<String> DEVICE_NO = new TypedField<>(String.class, "deviceNo");
        TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<String> DEVICE_TYPE_PK = new TypedField<>(String.class, "deviceTypePk");
        TypedField<String> DEVICE_NO_PK = new TypedField<>(String.class, "deviceNoPk");
        TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "originContractId");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> ONE_CONTRACT_MAIN_TO_MANY_TAX_NO_LIST_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.id");
        /**
         * 对一关联关系 关联对象 orderInfo
         */
        TypedField<Long> ONE_ORDER_TO_MULTIPLE_TAX_NOLIST_ID = new TypedField<>(Long.class, "oneOrderToMultipleTaxNolist.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_CONTRACT_MAIN_TO_MANY_TAX_NO_LIST {
                static String code () {
                    return "oneContractMainToManyTaxNoList" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "oneContractMainToManyTaxNoList.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "oneContractMainToManyTaxNoList.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneContractMainToManyTaxNoList.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "oneContractMainToManyTaxNoList.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractMainToManyTaxNoList.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "oneContractMainToManyTaxNoList.attachmentUrl");
            }
            interface ONE_ORDER_TO_MULTIPLE_TAX_NOLIST {
                static String code () {
                    return "oneOrderToMultipleTaxNolist" ;
                }
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.orderNo");
                TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.pricingUnit");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneOrderToMultipleTaxNolist.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneOrderToMultipleTaxNolist.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneOrderToMultipleTaxNolist.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneOrderToMultipleTaxNolist.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneOrderToMultipleTaxNolist.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneOrderToMultipleTaxNolist.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.delete_flag");
                TypedField<Long> VERSION = new TypedField<>(Long.class, "oneOrderToMultipleTaxNolist.version");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.orderStatus");
                TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.contractId");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.relatedContractId");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.productCode");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.productName");
                TypedField<BigDecimal> PURCHASE_QUANTITY = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.purchaseQuantity");
                TypedField<BigDecimal> TOTAL_AMOUNT_STR = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.totalAmountStr");
                TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.paymentPercent");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.paymentType");
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.serviceType");
                TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "oneOrderToMultipleTaxNolist.isRetentionMoney");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.paymentRequirement");
                TypedField<BigDecimal> WAITING_AMOUNT = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.waitingAmount");
                TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.readyAmount");
                TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.discountAmountWithTax");
                TypedField<BigDecimal> PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.payableAmountWithTax");
                TypedField<BigDecimal> RECEIVABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.receivableAmountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.taxRate");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.unitPriceWithoutTax");
                TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.orderInvoiceStatus");
                TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "oneOrderToMultipleTaxNolist.generateDate");
                TypedField<LocalDateTime> EFFECTIVE_DATE = new TypedField<>(LocalDateTime.class, "oneOrderToMultipleTaxNolist.effectiveDate");
                TypedField<LocalDateTime> EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "oneOrderToMultipleTaxNolist.expiryDate");
                TypedField<String> PAY_TYPE = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.payType");
                TypedField<String> PAYMENT_CONDITION = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.paymentCondition");
                TypedField<Long> CENTRAL_TENANT_ID = new TypedField<>(Long.class, "oneOrderToMultipleTaxNolist.centralTenantId");
                TypedField<String> CENTRAL_TENANT_NAME = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.centralTenantName");
                TypedField<String> CENTRAL_TENANT_CODE = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.centralTenantCode");
                TypedField<BigDecimal> IN_ORDER_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.inOrderInvoicedAmount");
                TypedField<BigDecimal> IN_ORDER_NO_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.inOrderNoInvoicedAmount");
                TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.originContractId");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.payStatus");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.billingType");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.orderType");
                TypedField<BigDecimal> REMAIN_DEDUCT_AMOUNT = new TypedField<>(BigDecimal.class, "oneOrderToMultipleTaxNolist.remainDeductAmount");
                TypedField<String> ORIGIN_REMAIN_DEDUCT_AMOUTN_ORDER = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.originRemainDeductAmoutnOrder");
                TypedField<String> BILLING_RULE = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.billingRule");
                TypedField<LocalDateTime> RECEPTION_DATE = new TypedField<>(LocalDateTime.class, "oneOrderToMultipleTaxNolist.receptionDate");
                TypedField<String> RECEPTION_STATUS = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.receptionStatus");
                TypedField<String> PROJECT_ITEM_CODE = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.projectItemCode");
                TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "oneOrderToMultipleTaxNolist.projectItemName");
            }
        }
    }
    public interface ContractRawData {
        static Long id() {
            return 1455449612420874242L;
        }
        static String code() {
            return "contractRawData";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<Long> TENANT_GROUP_ID = new TypedField<>(Long.class, "tenantGroupId");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> JSON_STR = new TypedField<>(String.class, "jsonStr");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "chargeContractId");
    }
    public interface ChargeCodePool {
        static Long id() {
            return 1455811807088549889L;
        }
        static String code() {
            return "chargeCodePool";
        }
        TypedField<String> CC_CODE = new TypedField<>(String.class, "ccCode");
        TypedField<String> CC_NAME = new TypedField<>(String.class, "ccName");
        TypedField<String> CC_TYPE = new TypedField<>(String.class, "ccType");
        TypedField<String> RELATION_CODES = new TypedField<>(String.class, "relationCodes");
        TypedField<String> DISTRICT = new TypedField<>(String.class, "district");
        TypedField<String> BIZ_UNIT = new TypedField<>(String.class, "bizUnit");
        TypedField<String> CC_STATUS = new TypedField<>(String.class, "ccStatus");
        TypedField<String> EXTENSION_TAG = new TypedField<>(String.class, "extensionTag");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> KAM = new TypedField<>(String.class, "kam");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PRIMARY_LEADER_CODE = new TypedField<>(String.class, "primaryLeaderCode");
        TypedField<String> PRIMARY_LEADER_NAME = new TypedField<>(String.class, "primaryLeaderName");
        TypedField<String> CC_TYPE_CODE = new TypedField<>(String.class, "ccTypeCode");
        TypedField<String> DISTRICT_CODE = new TypedField<>(String.class, "districtCode");
        TypedField<String> BIZ_UNIT_CODE = new TypedField<>(String.class, "bizUnitCode");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> LEVEL_ONE_DEPARTMENT_CODE = new TypedField<>(String.class, "levelOneDepartmentCode");
        TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "levelOneDepartmentName");
        TypedField<String> REQUEST_ID = new TypedField<>(String.class, "requestId");
        TypedField<String> PUSH_TIME = new TypedField<>(String.class, "pushTime");
        TypedField<Long> CC_CREATE_USER_ID = new TypedField<>(Long.class, "ccCreateUserId");
        TypedField<String> CC_CREATE_USER_NAME = new TypedField<>(String.class, "ccCreateUserName");
        TypedField<Long> CC_UPDATE_USER_ID = new TypedField<>(Long.class, "ccUpdateUserId");
        TypedField<String> CC_UPDATE_USER_NAME = new TypedField<>(String.class, "ccUpdateUserName");
        TypedField<LocalDateTime> INSERT_TIME = new TypedField<>(LocalDateTime.class, "insertTime");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "departmentName");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface ChargeGivenRelation {
        static Long id() {
            return 1458801856491102209L;
        }
        static String code() {
            return "chargeGivenRelation";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> RECONCILIATION_CODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<LocalDateTime> TAX_START_DATE = new TypedField<>(LocalDateTime.class, "taxStartDate");
        TypedField<LocalDateTime> SETTLEMENT_START_DATE = new TypedField<>(LocalDateTime.class, "settlementStartDate");
        TypedField<LocalDateTime> SETTLEMENT_END_DATE = new TypedField<>(LocalDateTime.class, "settlementEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAX_NO_COMPANY_NAME = new TypedField<>(String.class, "taxNoCompanyName");
        TypedField<Long> CORRESPONDING_TENANT_ID = new TypedField<>(Long.class, "correspondingTenantId");
        TypedField<String> CORRESPONDING_TENANT_NAME = new TypedField<>(String.class, "correspondingTenantName");
    }
    public interface AuthorizedMembers {
        static Long id() {
            return 1460896585479196673L;
        }
        static String code() {
            return "authorizedMembers";
        }
        TypedField<String> AUTHORIZED_MEMBER_CODE = new TypedField<>(String.class, "authorizedMemberCode");
        TypedField<String> AUTHORIZED_MEMBER_NAME = new TypedField<>(String.class, "authorizedMemberName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ACTIVE = new TypedField<>(String.class, "active");
        TypedField<LocalDateTime> INACTIVE_TIME = new TypedField<>(LocalDateTime.class, "inactiveTime");
        /**
         * 对一关联关系 关联对象 chargeCodePool
         */
        TypedField<Long> AUTHORIZED_MEMBERS_ID = new TypedField<>(Long.class, "authorizedMembers.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface AUTHORIZED_MEMBERS {
                static String code () {
                    return "authorizedMembers" ;
                }
                TypedField<String> CC_CODE = new TypedField<>(String.class, "authorizedMembers.ccCode");
                TypedField<String> CC_NAME = new TypedField<>(String.class, "authorizedMembers.ccName");
                TypedField<String> CC_TYPE = new TypedField<>(String.class, "authorizedMembers.ccType");
                TypedField<String> RELATION_CODES = new TypedField<>(String.class, "authorizedMembers.relationCodes");
                TypedField<String> DISTRICT = new TypedField<>(String.class, "authorizedMembers.district");
                TypedField<String> BIZ_UNIT = new TypedField<>(String.class, "authorizedMembers.bizUnit");
                TypedField<String> CC_STATUS = new TypedField<>(String.class, "authorizedMembers.ccStatus");
                TypedField<String> EXTENSION_TAG = new TypedField<>(String.class, "authorizedMembers.extensionTag");
                TypedField<Long> ID = new TypedField<>(Long.class, "authorizedMembers.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "authorizedMembers.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "authorizedMembers.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "authorizedMembers.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "authorizedMembers.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "authorizedMembers.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "authorizedMembers.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "authorizedMembers.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "authorizedMembers.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "authorizedMembers.delete_flag");
                TypedField<String> KAM = new TypedField<>(String.class, "authorizedMembers.kam");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "authorizedMembers.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "authorizedMembers.ownerName");
                TypedField<String> PRIMARY_LEADER_CODE = new TypedField<>(String.class, "authorizedMembers.primaryLeaderCode");
                TypedField<String> PRIMARY_LEADER_NAME = new TypedField<>(String.class, "authorizedMembers.primaryLeaderName");
                TypedField<String> CC_TYPE_CODE = new TypedField<>(String.class, "authorizedMembers.ccTypeCode");
                TypedField<String> DISTRICT_CODE = new TypedField<>(String.class, "authorizedMembers.districtCode");
                TypedField<String> BIZ_UNIT_CODE = new TypedField<>(String.class, "authorizedMembers.bizUnitCode");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "authorizedMembers.kamCode");
                TypedField<String> LEVEL_ONE_DEPARTMENT_CODE = new TypedField<>(String.class, "authorizedMembers.levelOneDepartmentCode");
                TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "authorizedMembers.levelOneDepartmentName");
                TypedField<String> REQUEST_ID = new TypedField<>(String.class, "authorizedMembers.requestId");
                TypedField<String> PUSH_TIME = new TypedField<>(String.class, "authorizedMembers.pushTime");
                TypedField<Long> CC_CREATE_USER_ID = new TypedField<>(Long.class, "authorizedMembers.ccCreateUserId");
                TypedField<String> CC_CREATE_USER_NAME = new TypedField<>(String.class, "authorizedMembers.ccCreateUserName");
                TypedField<Long> CC_UPDATE_USER_ID = new TypedField<>(Long.class, "authorizedMembers.ccUpdateUserId");
                TypedField<String> CC_UPDATE_USER_NAME = new TypedField<>(String.class, "authorizedMembers.ccUpdateUserName");
                TypedField<LocalDateTime> INSERT_TIME = new TypedField<>(LocalDateTime.class, "authorizedMembers.insertTime");
                TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "authorizedMembers.departmentName");
            }
        }
    }
    public interface InvoiceRawData {
        static Long id() {
            return 1460936664507584513L;
        }
        static String code() {
            return "invoiceRawData";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PAPER_DRAW_DATE = new TypedField<>(String.class, "paperDrawDate");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<LocalDateTime> DEPOSE_TIME = new TypedField<>(LocalDateTime.class, "deposeTime");
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RAW_JSON = new TypedField<>(String.class, "rawJson");
    }
    public interface ReceivedPaymentsNotTaken {
        static Long id() {
            return 1461010346936832002L;
        }
        static String code() {
            return "receivedPaymentsNotTaken";
        }
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "waitingTakenMoney");
        TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "takenMoney");
        TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CNY = new TypedField<>(String.class, "cny");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface ReceivedPaymentsNoNeed {
        static Long id() {
            return 1461010672058306561L;
        }
        static String code() {
            return "receivedPaymentsNoNeed";
        }
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface ReceivedPaymentsTaken {
        static Long id() {
            return 1461010979454652417L;
        }
        static String code() {
            return "receivedPaymentsTaken";
        }
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "takenMoney");
        TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ACCOUNT_NAME = new TypedField<>(String.class, "accountName");
        TypedField<String> SEARCH_TYPE = new TypedField<>(String.class, "searchType");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface AllocationByOrder {
        static Long id() {
            return 1461023981952241666L;
        }
        static String code() {
            return "allocationByOrder";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDER_MONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDER_WAITING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<BigDecimal> ORDER_INVOICE_MONEY = new TypedField<>(BigDecimal.class, "orderInvoiceMoney");
        TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_START_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_END_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<LocalDateTime> ORDER_DATE = new TypedField<>(LocalDateTime.class, "orderDate");
        TypedField<BigDecimal> CURRENT_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
        /**
         * 对一关联关系 关联对象 receivedPaymentsNotTaken
         */
        TypedField<Long> ONE_RECEIVE_PAYMENTS_NOT_TAKEN_TO_MANY_ALLOCATIONS_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_RECEIVE_PAYMENTS_NOT_TAKEN_TO_MANY_ALLOCATIONS {
                static String code () {
                    return "oneReceivePaymentsNotTakenToManyAllocations" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyAllocations.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyAllocations.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.takenStatus");
                TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyAllocations.waitingTakenMoney");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyAllocations.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyAllocations.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyAllocations.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyAllocations.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.delete_flag");
                TypedField<String> CNY = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyAllocations.cny");
            }
        }
    }
    public interface AllocationByInvoice {
        static Long id() {
            return 1461157480399048706L;
        }
        static String code() {
            return "allocationByInvoice";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDER_MONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDER_WAITING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_START_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_END_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> CURRENT_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_COMPANY_NAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<BigDecimal> INVOICE_MONEY = new TypedField<>(BigDecimal.class, "invoiceMoney");
        TypedField<BigDecimal> INVOICE_WAITING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "invoiceWaitingWrittenOffMoney");
        TypedField<BigDecimal> INVOICE_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "invoiceWrittenOffMoney");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoiceDate");
        /**
         * 对一关联关系 关联对象 receivedPaymentsNotTaken
         */
        TypedField<Long> ONE_RECEIVE_PAYMENTS_NOT_TAKEN_TO_MANY_INVOICE_ALLOCATIONS_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_RECEIVE_PAYMENTS_NOT_TAKEN_TO_MANY_INVOICE_ALLOCATIONS {
                static String code () {
                    return "oneReceivePaymentsNotTakenToManyInvoiceAllocations" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.takenStatus");
                TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.waitingTakenMoney");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.delete_flag");
                TypedField<String> CNY = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyInvoiceAllocations.cny");
            }
        }
    }
    public interface AllocationByTaxNo {
        static Long id() {
            return 1461158165773488129L;
        }
        static String code() {
            return "allocationByTaxNo";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDER_MONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDER_WAITING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_START_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD_END_DATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<LocalDateTime> ORDER_DATE = new TypedField<>(LocalDateTime.class, "orderDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> CURRENT_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
        TypedField<String> USING_COMPANY_NAME = new TypedField<>(String.class, "usingCompanyName");
        TypedField<BigDecimal> USING_PAYABLE_MONEY = new TypedField<>(BigDecimal.class, "usingPayableMoney");
        TypedField<BigDecimal> USING_WRITTEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "usingWrittenOffMoney");
        TypedField<String> USING_TAX_NO = new TypedField<>(String.class, "usingTaxNo");
        TypedField<BigDecimal> USING_TAKEN_OFF_MONEY = new TypedField<>(BigDecimal.class, "usingTakenOffMoney");
        /**
         * 对一关联关系 关联对象 receivedPaymentsNotTaken
         */
        TypedField<Long> ONE_RECEIVE_PAYMENTS_NOT_TAKEN_TO_MANY_TAX_NO_ALLOCATIONS_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_RECEIVE_PAYMENTS_NOT_TAKEN_TO_MANY_TAX_NO_ALLOCATIONS {
                static String code () {
                    return "oneReceivePaymentsNotTakenToManyTaxNoAllocations" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.takenStatus");
                TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.waitingTakenMoney");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.delete_flag");
                TypedField<String> CNY = new TypedField<>(String.class, "oneReceivePaymentsNotTakenToManyTaxNoAllocations.cny");
            }
        }
    }
    public interface NoNeedList {
        static Long id() {
            return 1461263582046392321L;
        }
        static String code() {
            return "noNeedList";
        }
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface CapitalFlowOperationRecord {
        static Long id() {
            return 1464077964732080130L;
        }
        static String code() {
            return "capitalFlowOperationRecord";
        }
        TypedField<LocalDateTime> OPERATION_TIME = new TypedField<>(LocalDateTime.class, "operationTime");
        TypedField<String> OPERATION_PERSON = new TypedField<>(String.class, "operationPerson");
        TypedField<String> OPERATION_CONTENT = new TypedField<>(String.class, "operationContent");
        TypedField<String> RESULT = new TypedField<>(String.class, "result");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        /**
         * 对一关联关系 关联对象 payWater
         */
        TypedField<Long> ONE_RECEIVED_PAYMENT_TO_MANY_CAPITAL_FLOW_RECORDS_ID = new TypedField<>(Long.class, "oneReceivedPaymentToManyCapitalFlowRecords.id");
        /**
         * 对一关联关系 关联对象 receivedPaymentsTaken
         */
        TypedField<Long> ONE_RECEIVED_PAYMENT_TAKEN_TO_MANY_RECORDS_ID = new TypedField<>(Long.class, "oneReceivedPaymentTakenToManyRecords.id");
        /**
         * 对一关联关系 关联对象 receivedPaymentsNotTaken
         */
        TypedField<Long> ONE_RECEIVED_PAYMENT_NOT_TAKEN_TO_MANY_RECORDS_ID = new TypedField<>(Long.class, "oneReceivedPaymentNotTakenToManyRecords.id");
        /**
         * 对一关联关系 关联对象 receivedPaymentsNoNeed
         */
        TypedField<Long> ONE_CAPITAL_FLOW_NO_NEED_TO_MANY_RESUMES_ID = new TypedField<>(Long.class, "oneCapitalFlowNoNeedToManyResumes.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_RECEIVED_PAYMENT_TO_MANY_CAPITAL_FLOW_RECORDS {
                static String code () {
                    return "oneReceivedPaymentToManyCapitalFlowRecords" ;
                }
                TypedField<LocalDateTime> TRADE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentToManyCapitalFlowRecords.tradeTime");
                TypedField<BigDecimal> DEBIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "oneReceivedPaymentToManyCapitalFlowRecords.debitMoneyAmount");
                TypedField<BigDecimal> CREDIT_MONEY_AMOUNT = new TypedField<>(BigDecimal.class, "oneReceivedPaymentToManyCapitalFlowRecords.creditMoneyAmount");
                TypedField<String> BANK_NAME = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.bankName");
                TypedField<String> BANK_ACCOUNT = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.bankAccount");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.openAccountInstitutions");
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.tradeNo");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivedPaymentToManyCapitalFlowRecords.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivedPaymentToManyCapitalFlowRecords.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentToManyCapitalFlowRecords.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentToManyCapitalFlowRecords.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentToManyCapitalFlowRecords.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentToManyCapitalFlowRecords.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.delete_flag");
                TypedField<String> CURRENCY = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.currency");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.customerName");
                TypedField<LocalDateTime> ACCOUNTING_DATE = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentToManyCapitalFlowRecords.accountingDate");
                TypedField<String> ABSTRACTION = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.abstraction");
                TypedField<String> TRADE_BUSINESS_CODE = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.tradeBusinessCode");
                TypedField<BigDecimal> BALANCE = new TypedField<>(BigDecimal.class, "oneReceivedPaymentToManyCapitalFlowRecords.balance");
                TypedField<String> CUSTOMER_ACCOUNT = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.customerAccount");
                TypedField<String> ENTERPRISE_SERIAL_NUMBER = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.enterpriseSerialNumber");
                TypedField<String> DOCUMENT_CATEGORY = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.documentCategory");
                TypedField<String> DOCUMENT_NO = new TypedField<>(String.class, "oneReceivedPaymentToManyCapitalFlowRecords.documentNo");
            }
            interface ONE_RECEIVED_PAYMENT_TAKEN_TO_MANY_RECORDS {
                static String code () {
                    return "oneReceivedPaymentTakenToManyRecords" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentTakenToManyRecords.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivedPaymentTakenToManyRecords.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.takenStatus");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivedPaymentTakenToManyRecords.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.remark");
                TypedField<String> CONTRACT_SIGNATURE_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.contractSignatureName");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.contractNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.projectName");
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.orderNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.productName");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivedPaymentTakenToManyRecords.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivedPaymentTakenToManyRecords.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentTakenToManyRecords.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentTakenToManyRecords.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentTakenToManyRecords.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentTakenToManyRecords.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.delete_flag");
                TypedField<String> ACCOUNT_NAME = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.accountName");
                TypedField<String> SEARCH_TYPE = new TypedField<>(String.class, "oneReceivedPaymentTakenToManyRecords.searchType");
            }
            interface ONE_RECEIVED_PAYMENT_NOT_TAKEN_TO_MANY_RECORDS {
                static String code () {
                    return "oneReceivedPaymentNotTakenToManyRecords" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentNotTakenToManyRecords.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivedPaymentNotTakenToManyRecords.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.takenStatus");
                TypedField<BigDecimal> WAITING_TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivedPaymentNotTakenToManyRecords.waitingTakenMoney");
                TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "oneReceivedPaymentNotTakenToManyRecords.takenMoney");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneReceivedPaymentNotTakenToManyRecords.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneReceivedPaymentNotTakenToManyRecords.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentNotTakenToManyRecords.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneReceivedPaymentNotTakenToManyRecords.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentNotTakenToManyRecords.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneReceivedPaymentNotTakenToManyRecords.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.delete_flag");
                TypedField<String> CNY = new TypedField<>(String.class, "oneReceivedPaymentNotTakenToManyRecords.cny");
            }
            interface ONE_CAPITAL_FLOW_NO_NEED_TO_MANY_RESUMES {
                static String code () {
                    return "oneCapitalFlowNoNeedToManyResumes" ;
                }
                TypedField<String> TRADE_NO = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.tradeNo");
                TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "oneCapitalFlowNoNeedToManyResumes.returnedTime");
                TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "oneCapitalFlowNoNeedToManyResumes.returnMoney");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.customerName");
                TypedField<String> TAKEN_STATUS = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.takenStatus");
                TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.customerBankNo");
                TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.openAccountInstitutions");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.remark");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneCapitalFlowNoNeedToManyResumes.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneCapitalFlowNoNeedToManyResumes.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneCapitalFlowNoNeedToManyResumes.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneCapitalFlowNoNeedToManyResumes.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneCapitalFlowNoNeedToManyResumes.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneCapitalFlowNoNeedToManyResumes.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneCapitalFlowNoNeedToManyResumes.delete_flag");
            }
        }
    }
    public interface Test {
        static Long id() {
            return 1467688303306440706L;
        }
        static String code() {
            return "test";
        }
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> AGE = new TypedField<>(Long.class, "age");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> RETENTION_MONEY = new TypedField<>(String.class, "retentionMoney");
        TypedField<String> NEW_FIELD = new TypedField<>(String.class, "newField");
        TypedField<String> TEST = new TypedField<>(String.class, "test");
        TypedField<String> TEST1 = new TypedField<>(String.class, "test1");
        TypedField<String> TEST2 = new TypedField<>(String.class, "test2");
        TypedField<String> TEST3 = new TypedField<>(String.class, "test3");
    }
    public interface SettleStaticsOrderRel {
        static Long id() {
            return 1469139798002339842L;
        }
        static String code() {
            return "settleStaticsOrderRel";
        }
        TypedField<Long> SETTLE_STATICS_ID = new TypedField<>(Long.class, "settleStaticsId");
        TypedField<Long> ORDER_ID = new TypedField<>(Long.class, "orderId");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ChargeCodeBudget {
        static Long id() {
            return 1473551179818655746L;
        }
        static String code() {
            return "chargeCodeBudget";
        }
        TypedField<String> CC_CODE = new TypedField<>(String.class, "ccCode");
        TypedField<String> CC_NAME = new TypedField<>(String.class, "ccName");
        TypedField<String> CC_TYPE = new TypedField<>(String.class, "ccType");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> CFO_CODE = new TypedField<>(String.class, "cfoCode");
        TypedField<String> CFO_NAME = new TypedField<>(String.class, "cfoName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CC_TYPE_CODE = new TypedField<>(String.class, "ccTypeCode");
        TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "levelOneDepartmentName");
        TypedField<String> LEVEL_ONE_DEPARTMENT_CODE = new TypedField<>(String.class, "levelOneDepartmentCode");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> REQUEST_ID = new TypedField<>(String.class, "requestId");
        TypedField<String> PUSH_TIME = new TypedField<>(String.class, "pushTime");
        TypedField<Long> CC_CREATE_USER_ID = new TypedField<>(Long.class, "ccCreateUserId");
        TypedField<String> CC_CREATE_USER_NAME = new TypedField<>(String.class, "ccCreateUserName");
        TypedField<Long> CC_UPDATE_USER_ID = new TypedField<>(Long.class, "ccUpdateUserId");
        TypedField<String> CC_UPDATE_USER_NAME = new TypedField<>(String.class, "ccUpdateUserName");
        TypedField<String> APPROVE_DATE = new TypedField<>(String.class, "approveDate");
        TypedField<String> INVALID_DATE = new TypedField<>(String.class, "invalidDate");
        TypedField<LocalDateTime> APPROVE_DATE_WEB = new TypedField<>(LocalDateTime.class, "approveDateWeb");
        TypedField<LocalDateTime> INVALID_DATE_WEB = new TypedField<>(LocalDateTime.class, "invalidDateWeb");
        /**
         * 对一关联关系 关联对象 chargeCodeBudgetPackge
         */
        TypedField<Long> NODES_ID = new TypedField<>(Long.class, "nodes.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface NODES {
                static String code () {
                    return "nodes" ;
                }
                TypedField<String> BUDGET_ID = new TypedField<>(String.class, "nodes.budgetId");
                TypedField<String> BUDGET_NAME = new TypedField<>(String.class, "nodes.budgetName");
                TypedField<Long> VERSION = new TypedField<>(Long.class, "nodes.version");
                TypedField<Long> ID = new TypedField<>(Long.class, "nodes.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "nodes.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "nodes.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "nodes.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "nodes.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "nodes.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "nodes.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "nodes.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "nodes.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "nodes.delete_flag");
                TypedField<String> CC_TYPES = new TypedField<>(String.class, "nodes.ccTypes");
            }
        }
    }
    public interface Organize {
        static Long id() {
            return 1473561617230913537L;
        }
        static String code() {
            return "organize";
        }
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "orgCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> OWNER_NO = new TypedField<>(String.class, "ownerNo");
        TypedField<String> PARENT_ORG_NAME = new TypedField<>(String.class, "parentOrgName");
        TypedField<String> PARENT_ORG_CODE = new TypedField<>(String.class, "parentOrgCode");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "orgName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ESTABLISH_DATE = new TypedField<>(String.class, "establishDate");
        TypedField<String> CHANGE_DATE = new TypedField<>(String.class, "changeDate");
        TypedField<String> ORG_LEVEL = new TypedField<>(String.class, "orgLevel");
        TypedField<String> ORG_LEVEL_SERIA = new TypedField<>(String.class, "orgLevelSeria");
        TypedField<String> ORG_ID = new TypedField<>(String.class, "orgId");
        TypedField<String> OWNER_ID = new TypedField<>(String.class, "ownerId");
        TypedField<String> PARENT_ORG_ID = new TypedField<>(String.class, "parentOrgId");
        TypedField<LocalDateTime> ESTABLISH_DATE_WEB = new TypedField<>(LocalDateTime.class, "establishDateWeb");
        TypedField<LocalDateTime> CHANGE_DATE_WEB = new TypedField<>(LocalDateTime.class, "changeDateWeb");
    }
    public interface ChargeCodeBudgetDetail {
        static Long id() {
            return 1473849458675421185L;
        }
        static String code() {
            return "chargeCodeBudgetDetail";
        }
        TypedField<String> BUDGET_DESC = new TypedField<>(String.class, "budgetDesc");
        TypedField<BigDecimal> BUDGET_AMOUNT = new TypedField<>(BigDecimal.class, "budgetAmount");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CC_CODE = new TypedField<>(String.class, "ccCode");
        TypedField<String> BUDGET_TYPE = new TypedField<>(String.class, "budgetType");
        /**
         * 对一关联关系 关联对象 chargeCodeBudget
         */
        TypedField<Long> BUDGET_DETAIL_ID = new TypedField<>(Long.class, "budgetDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BUDGET_DETAIL {
                static String code () {
                    return "budgetDetail" ;
                }
                TypedField<String> CC_CODE = new TypedField<>(String.class, "budgetDetail.ccCode");
                TypedField<String> CC_NAME = new TypedField<>(String.class, "budgetDetail.ccName");
                TypedField<String> CC_TYPE = new TypedField<>(String.class, "budgetDetail.ccType");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "budgetDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "budgetDetail.ownerName");
                TypedField<String> CFO_CODE = new TypedField<>(String.class, "budgetDetail.cfoCode");
                TypedField<String> CFO_NAME = new TypedField<>(String.class, "budgetDetail.cfoName");
                TypedField<Long> ID = new TypedField<>(Long.class, "budgetDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "budgetDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "budgetDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "budgetDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "budgetDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "budgetDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "budgetDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "budgetDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "budgetDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "budgetDetail.delete_flag");
                TypedField<String> CC_TYPE_CODE = new TypedField<>(String.class, "budgetDetail.ccTypeCode");
                TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "budgetDetail.levelOneDepartmentName");
                TypedField<String> LEVEL_ONE_DEPARTMENT_CODE = new TypedField<>(String.class, "budgetDetail.levelOneDepartmentCode");
                TypedField<String> STATUS = new TypedField<>(String.class, "budgetDetail.status");
                TypedField<String> REQUEST_ID = new TypedField<>(String.class, "budgetDetail.requestId");
                TypedField<String> PUSH_TIME = new TypedField<>(String.class, "budgetDetail.pushTime");
                TypedField<Long> CC_CREATE_USER_ID = new TypedField<>(Long.class, "budgetDetail.ccCreateUserId");
                TypedField<String> CC_CREATE_USER_NAME = new TypedField<>(String.class, "budgetDetail.ccCreateUserName");
                TypedField<Long> CC_UPDATE_USER_ID = new TypedField<>(Long.class, "budgetDetail.ccUpdateUserId");
                TypedField<String> CC_UPDATE_USER_NAME = new TypedField<>(String.class, "budgetDetail.ccUpdateUserName");
                TypedField<String> APPROVE_DATE = new TypedField<>(String.class, "budgetDetail.approveDate");
                TypedField<String> INVALID_DATE = new TypedField<>(String.class, "budgetDetail.invalidDate");
                TypedField<LocalDateTime> APPROVE_DATE_WEB = new TypedField<>(LocalDateTime.class, "budgetDetail.approveDateWeb");
                TypedField<LocalDateTime> INVALID_DATE_WEB = new TypedField<>(LocalDateTime.class, "budgetDetail.invalidDateWeb");
            }
        }
    }
    public interface PmsMateData {
        static Long id() {
            return 1474187323395461122L;
        }
        static String code() {
            return "pmsMateData";
        }
        TypedField<String> PMS_CODE = new TypedField<>(String.class, "pmsCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> PUSH_TIME = new TypedField<>(String.class, "pushTime");
        TypedField<String> BODY = new TypedField<>(String.class, "body");
        TypedField<String> REQUEST_ID = new TypedField<>(String.class, "requestId");
    }
    public interface IncomeDetailOrderRel {
        static Long id() {
            return 1474197210030673922L;
        }
        static String code() {
            return "incomeDetailOrderRel";
        }
        TypedField<Long> INCOME_DETAIL_ID = new TypedField<>(Long.class, "incomeDetailId");
        TypedField<Long> ORDER_ID = new TypedField<>(Long.class, "orderId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
    }
    public interface MemberInfo {
        static Long id() {
            return 1475703079099883521L;
        }
        static String code() {
            return "memberInfo";
        }
        TypedField<String> MEMBER_NAME = new TypedField<>(String.class, "member_name");
        TypedField<String> MEMBER_CODE = new TypedField<>(String.class, "member_code");
        TypedField<String> BELONGS_COMPANY = new TypedField<>(String.class, "belongs_company");
        TypedField<String> BELONGS_COMPANY_TAX_NO = new TypedField<>(String.class, "belongs_company_tax_no");
        TypedField<String> COMPANY_EMAIL_ADDRESS = new TypedField<>(String.class, "company_email_address");
        TypedField<String> MEMBER_PHONE_NO = new TypedField<>(String.class, "member_phone_no");
        TypedField<String> MEMBER_STATUS = new TypedField<>(String.class, "member_status");
        TypedField<String> BELONGS_DEPARTMENT = new TypedField<>(String.class, "belongs_department");
        TypedField<String> PRIMARY_LEADER_CODE = new TypedField<>(String.class, "primary_leader_code");
        TypedField<String> PRIMARY_LEADER_NAME = new TypedField<>(String.class, "primary_leader_name");
        TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "level_one_department_name");
        TypedField<String> YKB_SYNC_ID = new TypedField<>(String.class, "ykb_sync_id");
        TypedField<String> LEVEL_ONE_DEPARTMENT_CODE = new TypedField<>(String.class, "level_one_department_code");
        TypedField<String> LEVEL_ONE_DEPARTMENT_OWNER_NAME = new TypedField<>(String.class, "level_one_department_owner_name");
        TypedField<String> LEVEL_ONE_DEPARTMENT_OWNER_CODE = new TypedField<>(String.class, "level_one_department_owner_code");
        TypedField<String> MEMBER_LEVEL = new TypedField<>(String.class, "member_level");
        TypedField<String> BELONGS_DEPARTMENT_CODE = new TypedField<>(String.class, "belongs_department_code");
        TypedField<String> IS_OUTER = new TypedField<>(String.class, "is_outer");
        TypedField<String> INDUCTION_TIME = new TypedField<>(String.class, "induction_time");
        TypedField<String> LEAVE_TIME = new TypedField<>(String.class, "leave_time");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SYNC_TIME = new TypedField<>(String.class, "sync_time");
        TypedField<Long> USER_ID = new TypedField<>(Long.class, "user_id");
        TypedField<String> BELONGS_COMPANY_SEIRA = new TypedField<>(String.class, "belongs_company_seira");
        TypedField<String> PRIMARY_LEADER_USER_ID = new TypedField<>(String.class, "primary_leader_user_id");
        TypedField<String> LEVEL_ONE_DEPARTMENT_OWNER_USER_ID = new TypedField<>(String.class, "level_one_department_owner_user_id");
        TypedField<String> LEVEL_ONE_DEPARTMENT_ID = new TypedField<>(String.class, "level_one_department_id");
        TypedField<String> BELONGS_DEPARTMENT_ID = new TypedField<>(String.class, "belongs_department_id");
        TypedField<LocalDateTime> INDUCTION_TIME_WEB = new TypedField<>(LocalDateTime.class, "induction_time_web");
        TypedField<LocalDateTime> LEAVE_TIME_WEB = new TypedField<>(LocalDateTime.class, "leave_time_web");
    }
    public interface FinancialSyncWindow {
        static Long id() {
            return 1476437584449032194L;
        }
        static String code() {
            return "financialSyncWindow";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> SYNC_TIME = new TypedField<>(String.class, "syncTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
    }
    public interface ChargeCodePrimeCost {
        static Long id() {
            return 1479004481472352258L;
        }
        static String code() {
            return "chargeCodePrimeCost";
        }
        TypedField<String> PROJECT_MONTH = new TypedField<>(String.class, "projectMonth");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CHARGE_CODE_NAME = new TypedField<>(String.class, "chargeCodeName");
        TypedField<String> CHARGE_CODE_DESC = new TypedField<>(String.class, "chargeCodeDesc");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "departmentCode");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "departmentName");
        TypedField<String> TOTAL_AMOUNT = new TypedField<>(String.class, "totalAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROJECT_MONTH_TIME = new TypedField<>(String.class, "projectMonthTime");
        TypedField<BigDecimal> TOTAL_AMOUNT_WEB = new TypedField<>(BigDecimal.class, "totalAmountWeb");
    }
    public interface OrderTaxRelation {
        static Long id() {
            return 1481437369255256065L;
        }
        static String code() {
            return "orderTaxRelation";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> TAX_CHARGE_START_DATE = new TypedField<>(String.class, "taxChargeStartDate");
        TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> WAIT_AMOUNT = new TypedField<>(BigDecimal.class, "waitAmount");
        TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "readyAmount");
        TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "deviceType");
        TypedField<String> DEVICE_NO = new TypedField<>(String.class, "deviceNo");
        TypedField<String> DEVICE_TYPE_PK = new TypedField<>(String.class, "deviceTypePk");
        TypedField<String> DEVICE_NO_PK = new TypedField<>(String.class, "deviceNoPk");
    }
    public interface OrderBillRelation {
        static Long id() {
            return 1481437684166479873L;
        }
        static String code() {
            return "orderBillRelation";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> BILL_DETAIL_NO = new TypedField<>(String.class, "billDetailNo");
        TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handleStatus");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        /**
         * 对一关联关系 关联对象 orderInfo
         */
        TypedField<Long> ONE_ORDER_TO_MANY_ORDER_BILL_RELATIONS_ID = new TypedField<>(Long.class, "oneOrderToManyOrderBillRelations.id");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> RELATION_TO_ONE_CONTRACT_ID = new TypedField<>(Long.class, "relationToOneContract.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_ORDER_TO_MANY_ORDER_BILL_RELATIONS {
                static String code () {
                    return "oneOrderToManyOrderBillRelations" ;
                }
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.orderNo");
                TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.pricingUnit");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneOrderToManyOrderBillRelations.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneOrderToManyOrderBillRelations.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneOrderToManyOrderBillRelations.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneOrderToManyOrderBillRelations.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneOrderToManyOrderBillRelations.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneOrderToManyOrderBillRelations.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.delete_flag");
                TypedField<Long> VERSION = new TypedField<>(Long.class, "oneOrderToManyOrderBillRelations.version");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.orderStatus");
                TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.contractId");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.relatedContractId");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.productCode");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.productName");
                TypedField<BigDecimal> PURCHASE_QUANTITY = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.purchaseQuantity");
                TypedField<BigDecimal> TOTAL_AMOUNT_STR = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.totalAmountStr");
                TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.paymentPercent");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.paymentType");
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.serviceType");
                TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "oneOrderToManyOrderBillRelations.isRetentionMoney");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.paymentRequirement");
                TypedField<BigDecimal> WAITING_AMOUNT = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.waitingAmount");
                TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.readyAmount");
                TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.discountAmountWithTax");
                TypedField<BigDecimal> PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.payableAmountWithTax");
                TypedField<BigDecimal> RECEIVABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.receivableAmountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.taxRate");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.unitPriceWithoutTax");
                TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.orderInvoiceStatus");
                TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "oneOrderToManyOrderBillRelations.generateDate");
                TypedField<LocalDateTime> EFFECTIVE_DATE = new TypedField<>(LocalDateTime.class, "oneOrderToManyOrderBillRelations.effectiveDate");
                TypedField<LocalDateTime> EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "oneOrderToManyOrderBillRelations.expiryDate");
                TypedField<String> PAY_TYPE = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.payType");
                TypedField<String> PAYMENT_CONDITION = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.paymentCondition");
                TypedField<Long> CENTRAL_TENANT_ID = new TypedField<>(Long.class, "oneOrderToManyOrderBillRelations.centralTenantId");
                TypedField<String> CENTRAL_TENANT_NAME = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.centralTenantName");
                TypedField<String> CENTRAL_TENANT_CODE = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.centralTenantCode");
                TypedField<BigDecimal> IN_ORDER_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.inOrderInvoicedAmount");
                TypedField<BigDecimal> IN_ORDER_NO_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.inOrderNoInvoicedAmount");
                TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.originContractId");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.payStatus");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.billingType");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.orderType");
                TypedField<BigDecimal> REMAIN_DEDUCT_AMOUNT = new TypedField<>(BigDecimal.class, "oneOrderToManyOrderBillRelations.remainDeductAmount");
                TypedField<String> ORIGIN_REMAIN_DEDUCT_AMOUTN_ORDER = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.originRemainDeductAmoutnOrder");
                TypedField<String> BILLING_RULE = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.billingRule");
                TypedField<LocalDateTime> RECEPTION_DATE = new TypedField<>(LocalDateTime.class, "oneOrderToManyOrderBillRelations.receptionDate");
                TypedField<String> RECEPTION_STATUS = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.receptionStatus");
                TypedField<String> PROJECT_ITEM_CODE = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.projectItemCode");
                TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "oneOrderToManyOrderBillRelations.projectItemName");
            }
            interface RELATION_TO_ONE_CONTRACT {
                static String code () {
                    return "relationToOneContract" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "relationToOneContract.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "relationToOneContract.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "relationToOneContract.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "relationToOneContract.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "relationToOneContract.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "relationToOneContract.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "relationToOneContract.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "relationToOneContract.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "relationToOneContract.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "relationToOneContract.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "relationToOneContract.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "relationToOneContract.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "relationToOneContract.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "relationToOneContract.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "relationToOneContract.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "relationToOneContract.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "relationToOneContract.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "relationToOneContract.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "relationToOneContract.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "relationToOneContract.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "relationToOneContract.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "relationToOneContract.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "relationToOneContract.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "relationToOneContract.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "relationToOneContract.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "relationToOneContract.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "relationToOneContract.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "relationToOneContract.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "relationToOneContract.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "relationToOneContract.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "relationToOneContract.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "relationToOneContract.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "relationToOneContract.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "relationToOneContract.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "relationToOneContract.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "relationToOneContract.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "relationToOneContract.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "relationToOneContract.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "relationToOneContract.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "relationToOneContract.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "relationToOneContract.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "relationToOneContract.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "relationToOneContract.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "relationToOneContract.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "relationToOneContract.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "relationToOneContract.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "relationToOneContract.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "relationToOneContract.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "relationToOneContract.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "relationToOneContract.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "relationToOneContract.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "relationToOneContract.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "relationToOneContract.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "relationToOneContract.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "relationToOneContract.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "relationToOneContract.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "relationToOneContract.attachmentUrl");
            }
        }
    }
    public interface OrderInvoiceRelation {
        static Long id() {
            return 1481437944976691201L;
        }
        static String code() {
            return "orderInvoiceRelation";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> WAIT_AMOUNT = new TypedField<>(BigDecimal.class, "waitAmount");
        TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "readyAmount");
        TypedField<BigDecimal> INVOICE_OPEN_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceOpenAmount");
    }
    public interface OrderInfo {
        static Long id() {
            return 1481443933895528450L;
        }
        static String code() {
            return "orderInfo";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "pricingUnit");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> VERSION = new TypedField<>(Long.class, "version");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "contractId");
        TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "relatedContractId");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> PURCHASE_QUANTITY = new TypedField<>(BigDecimal.class, "purchaseQuantity");
        TypedField<BigDecimal> TOTAL_AMOUNT_STR = new TypedField<>(BigDecimal.class, "totalAmountStr");
        TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "paymentPercent");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "serviceType");
        TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "isRetentionMoney");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<BigDecimal> WAITING_AMOUNT = new TypedField<>(BigDecimal.class, "waitingAmount");
        TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "readyAmount");
        TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "discountAmountWithTax");
        TypedField<BigDecimal> PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "payableAmountWithTax");
        TypedField<BigDecimal> RECEIVABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "receivableAmountWithTax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "generateDate");
        TypedField<LocalDateTime> EFFECTIVE_DATE = new TypedField<>(LocalDateTime.class, "effectiveDate");
        TypedField<LocalDateTime> EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "expiryDate");
        TypedField<String> PAY_TYPE = new TypedField<>(String.class, "payType");
        TypedField<String> PAYMENT_CONDITION = new TypedField<>(String.class, "paymentCondition");
        TypedField<Long> CENTRAL_TENANT_ID = new TypedField<>(Long.class, "centralTenantId");
        TypedField<String> CENTRAL_TENANT_NAME = new TypedField<>(String.class, "centralTenantName");
        TypedField<String> CENTRAL_TENANT_CODE = new TypedField<>(String.class, "centralTenantCode");
        TypedField<BigDecimal> IN_ORDER_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "inOrderInvoicedAmount");
        TypedField<BigDecimal> IN_ORDER_NO_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "inOrderNoInvoicedAmount");
        TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "originContractId");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "payStatus");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderType");
        TypedField<BigDecimal> REMAIN_DEDUCT_AMOUNT = new TypedField<>(BigDecimal.class, "remainDeductAmount");
        TypedField<String> ORIGIN_REMAIN_DEDUCT_AMOUTN_ORDER = new TypedField<>(String.class, "originRemainDeductAmoutnOrder");
        TypedField<String> BILLING_RULE = new TypedField<>(String.class, "billingRule");
        TypedField<LocalDateTime> RECEPTION_DATE = new TypedField<>(LocalDateTime.class, "receptionDate");
        TypedField<String> RECEPTION_STATUS = new TypedField<>(String.class, "receptionStatus");
        TypedField<String> PROJECT_ITEM_CODE = new TypedField<>(String.class, "projectItemCode");
        TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "projectItemName");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> MANY_ORDER_TO_ONE_CONTRACT_ID = new TypedField<>(Long.class, "manyOrderToOneContract.id");
        /**
         * 对一关联关系 关联对象 contractDetail
         */
        TypedField<Long> ORDER_TO_CONTRACT_DETAIL_ID = new TypedField<>(Long.class, "orderToContractDetail.id");
        /**
         * 对一关联关系 关联对象 incomeSummary
         */
        TypedField<Long> ONE_INCOME_SUMMARY_TO_MANY_ORDER_INFO_ID = new TypedField<>(Long.class, "oneIncomeSummaryToManyOrderInfo.id");
        /**
         * 对一关联关系 关联对象 billStatics
         */
        TypedField<Long> ONE_BILL_STATICS_TO_MANY_ORDER_INFO_ID = new TypedField<>(Long.class, "oneBillStaticsToManyOrderInfo.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface MANY_ORDER_TO_ONE_CONTRACT {
                static String code () {
                    return "manyOrderToOneContract" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "manyOrderToOneContract.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "manyOrderToOneContract.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "manyOrderToOneContract.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "manyOrderToOneContract.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "manyOrderToOneContract.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "manyOrderToOneContract.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyOrderToOneContract.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyOrderToOneContract.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyOrderToOneContract.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyOrderToOneContract.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyOrderToOneContract.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyOrderToOneContract.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyOrderToOneContract.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyOrderToOneContract.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyOrderToOneContract.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyOrderToOneContract.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "manyOrderToOneContract.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "manyOrderToOneContract.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "manyOrderToOneContract.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "manyOrderToOneContract.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "manyOrderToOneContract.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "manyOrderToOneContract.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "manyOrderToOneContract.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "manyOrderToOneContract.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "manyOrderToOneContract.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manyOrderToOneContract.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "manyOrderToOneContract.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "manyOrderToOneContract.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "manyOrderToOneContract.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "manyOrderToOneContract.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "manyOrderToOneContract.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "manyOrderToOneContract.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "manyOrderToOneContract.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "manyOrderToOneContract.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "manyOrderToOneContract.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "manyOrderToOneContract.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "manyOrderToOneContract.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "manyOrderToOneContract.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "manyOrderToOneContract.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "manyOrderToOneContract.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "manyOrderToOneContract.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "manyOrderToOneContract.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "manyOrderToOneContract.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "manyOrderToOneContract.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "manyOrderToOneContract.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "manyOrderToOneContract.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "manyOrderToOneContract.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "manyOrderToOneContract.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "manyOrderToOneContract.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "manyOrderToOneContract.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "manyOrderToOneContract.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "manyOrderToOneContract.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "manyOrderToOneContract.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "manyOrderToOneContract.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "manyOrderToOneContract.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "manyOrderToOneContract.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "manyOrderToOneContract.attachmentUrl");
            }
            interface ORDER_TO_CONTRACT_DETAIL {
                static String code () {
                    return "orderToContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "orderToContractDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "orderToContractDetail.productName");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "orderToContractDetail.productCode");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "orderToContractDetail.amount");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "orderToContractDetail.unitPrice");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "orderToContractDetail.chargeRequirement");
                TypedField<Long> ID = new TypedField<>(Long.class, "orderToContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "orderToContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "orderToContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "orderToContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "orderToContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "orderToContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "orderToContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "orderToContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "orderToContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "orderToContractDetail.delete_flag");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "orderToContractDetail.chargeType");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "orderToContractDetail.taxRate");
                TypedField<String> VALIDATION = new TypedField<>(String.class, "orderToContractDetail.validation");
                TypedField<String> QUANTITY = new TypedField<>(String.class, "orderToContractDetail.quantity");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "orderToContractDetail.unitPriceWithoutTax");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "orderToContractDetail.paymentRequirement");
                TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "orderToContractDetail.paymentPercent");
                TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "orderToContractDetail.containsRetentionMoney");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "orderToContractDetail.receiptSignDateStr");
                TypedField<String> FIRST_PAY_REQUIREMENT_OR_NOT = new TypedField<>(String.class, "orderToContractDetail.firstPayRequirementOrNot");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "orderToContractDetail.chargeCycle");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "orderToContractDetail.billingType");
                TypedField<String> DAYS = new TypedField<>(String.class, "orderToContractDetail.days");
                TypedField<Boolean> OUTSOURCING = new TypedField<>(Boolean.class, "orderToContractDetail.outsourcing");
                TypedField<String> LINKED_PURCHASE_CONTRACT_NO = new TypedField<>(String.class, "orderToContractDetail.linkedPurchaseContractNo");
                TypedField<String> CHARGE_RULES = new TypedField<>(String.class, "orderToContractDetail.chargeRules");
                TypedField<String> PRODUCT_STATUS = new TypedField<>(String.class, "orderToContractDetail.productStatus");
                TypedField<String> PRODUCT_ACCEPTANCE_STATUS = new TypedField<>(String.class, "orderToContractDetail.productAcceptanceStatus");
            }
            interface ONE_INCOME_SUMMARY_TO_MANY_ORDER_INFO {
                static String code () {
                    return "oneIncomeSummaryToManyOrderInfo" ;
                }
                TypedField<String> BILL_NO = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.billNo");
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.orderNo");
                TypedField<String> TAX_NO = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.taxNo");
                TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.taxCompanyName");
                TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.pricingUnit");
                TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyOrderInfo.receiptDate");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyOrderInfo.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyOrderInfo.chargeEndDate");
                TypedField<Long> USING_MONTH = new TypedField<>(Long.class, "oneIncomeSummaryToManyOrderInfo.usingMonth");
                TypedField<Long> ACCOUNTING_PERIOD = new TypedField<>(Long.class, "oneIncomeSummaryToManyOrderInfo.accountingPeriod");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneIncomeSummaryToManyOrderInfo.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneIncomeSummaryToManyOrderInfo.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyOrderInfo.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyOrderInfo.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneIncomeSummaryToManyOrderInfo.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneIncomeSummaryToManyOrderInfo.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.delete_flag");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.contractNo");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.productCode");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.property");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneIncomeSummaryToManyOrderInfo.unitPriceWithoutTax");
                TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "oneIncomeSummaryToManyOrderInfo.quantity");
                TypedField<BigDecimal> CURRENT_PERIOD_INCOME_AMOUNT = new TypedField<>(BigDecimal.class, "oneIncomeSummaryToManyOrderInfo.currentPeriodIncomeAmount");
                TypedField<String> INCOME_STATUS = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.incomeStatus");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.productName");
                TypedField<Long> PRODUCT_INCOME_EFFECTIVE_DAY = new TypedField<>(Long.class, "oneIncomeSummaryToManyOrderInfo.productIncomeEffectiveDay");
                TypedField<BigDecimal> PRODUCT_INCOME_BALANCE = new TypedField<>(BigDecimal.class, "oneIncomeSummaryToManyOrderInfo.productIncomeBalance");
                TypedField<Long> PRODUCT_INCOME_USAGE_COUNT1 = new TypedField<>(Long.class, "oneIncomeSummaryToManyOrderInfo.productIncomeUsageCount1");
                TypedField<BigDecimal> PRODUCT_INCOME_DAY_AMOUNT = new TypedField<>(BigDecimal.class, "oneIncomeSummaryToManyOrderInfo.productIncomeDayAmount");
                TypedField<String> CONFIRM_TYPE = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.confirmType");
                TypedField<String> PRODUCT_INCOME_TYPE = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.productIncomeType");
                TypedField<LocalDateTime> USING_MONTH_DATE = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyOrderInfo.usingMonthDate");
                TypedField<String> BILL_MONTH = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.billMonth");
                TypedField<String> ACCOUNTING_PERIOD_STR = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.accountingPeriodStr");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.chargeCycle");
                TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.deviceType");
                TypedField<String> DEVICE_NO = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.deviceNo");
                TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "oneIncomeSummaryToManyOrderInfo.isRetentionMoney");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.remark");
                TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.projectItemName");
                TypedField<String> PROJECT_ITEM_CODE = new TypedField<>(String.class, "oneIncomeSummaryToManyOrderInfo.projectItemCode");
            }
            interface ONE_BILL_STATICS_TO_MANY_ORDER_INFO {
                static String code () {
                    return "oneBillStaticsToManyOrderInfo" ;
                }
                TypedField<String> BILL_NO = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.billNo");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.contractNo");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.productCode");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneBillStaticsToManyOrderInfo.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneBillStaticsToManyOrderInfo.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneBillStaticsToManyOrderInfo.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneBillStaticsToManyOrderInfo.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneBillStaticsToManyOrderInfo.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneBillStaticsToManyOrderInfo.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.delete_flag");
                TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "oneBillStaticsToManyOrderInfo.accountingStartDate");
                TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "oneBillStaticsToManyOrderInfo.accountingEndDate");
                TypedField<BigDecimal> ORDER_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneBillStaticsToManyOrderInfo.orderTotalAmountWithTax");
                TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneBillStaticsToManyOrderInfo.invoiceAmountWithTax");
                TypedField<BigDecimal> REFUND_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneBillStaticsToManyOrderInfo.refundAmountWithTax");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.regionName");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.principalPerson");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.productName");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.saChargeCode");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.customerSignatoryName");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.saChargeCodeName");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.projectName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.paymentType");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.paymentRequirement");
                TypedField<BigDecimal> TOTAL_ORDER_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneBillStaticsToManyOrderInfo.totalOrderAmountWithTax");
                TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.originContractId");
                TypedField<String> WHETHER_EFFECTIVE_OR_NOT = new TypedField<>(String.class, "oneBillStaticsToManyOrderInfo.whetherEffectiveOrNot");
            }
        }
    }
    public interface BillStatics {
        static Long id() {
            return 1481470809122721793L;
        }
        static String code() {
            return "billStatics";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<BigDecimal> ORDER_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "orderTotalAmountWithTax");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithTax");
        TypedField<BigDecimal> REFUND_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "refundAmountWithTax");
        TypedField<String> REGION_CODE = new TypedField<>(String.class, "regionCode");
        TypedField<String> REGION_NAME = new TypedField<>(String.class, "regionName");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "saChargeCode");
        TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "customerSignatoryName");
        TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "saChargeCodeName");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<BigDecimal> TOTAL_ORDER_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "totalOrderAmountWithTax");
        TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "originContractId");
        TypedField<String> WHETHER_EFFECTIVE_OR_NOT = new TypedField<>(String.class, "whetherEffectiveOrNot");
        /**
         * 对一关联关系 关联对象 orderInfo
         */
        TypedField<Long> MANY_BILL_STATICS_TO_ONE_ORDER_INFO_ID = new TypedField<>(Long.class, "manyBillStaticsToOneOrderInfo.id");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> MANY_BILL_STATICS_TO_ONE_CONTRACT_ID = new TypedField<>(Long.class, "manyBillStaticsToOneContract.id");
        /**
         * 对一关联关系 关联对象 bill
         */
        TypedField<Long> ONE_BILL_STATICS_TO_ONE_RECONCILIATION_ID = new TypedField<>(Long.class, "oneBillStaticsToOneReconciliation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface MANY_BILL_STATICS_TO_ONE_ORDER_INFO {
                static String code () {
                    return "manyBillStaticsToOneOrderInfo" ;
                }
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.orderNo");
                TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.pricingUnit");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyBillStaticsToOneOrderInfo.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyBillStaticsToOneOrderInfo.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyBillStaticsToOneOrderInfo.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyBillStaticsToOneOrderInfo.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyBillStaticsToOneOrderInfo.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyBillStaticsToOneOrderInfo.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.delete_flag");
                TypedField<Long> VERSION = new TypedField<>(Long.class, "manyBillStaticsToOneOrderInfo.version");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.orderStatus");
                TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.contractId");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.relatedContractId");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.productCode");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.productName");
                TypedField<BigDecimal> PURCHASE_QUANTITY = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.purchaseQuantity");
                TypedField<BigDecimal> TOTAL_AMOUNT_STR = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.totalAmountStr");
                TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.paymentPercent");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.paymentType");
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.serviceType");
                TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "manyBillStaticsToOneOrderInfo.isRetentionMoney");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.paymentRequirement");
                TypedField<BigDecimal> WAITING_AMOUNT = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.waitingAmount");
                TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.readyAmount");
                TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.discountAmountWithTax");
                TypedField<BigDecimal> PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.payableAmountWithTax");
                TypedField<BigDecimal> RECEIVABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.receivableAmountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.taxRate");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.unitPriceWithoutTax");
                TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.orderInvoiceStatus");
                TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "manyBillStaticsToOneOrderInfo.generateDate");
                TypedField<LocalDateTime> EFFECTIVE_DATE = new TypedField<>(LocalDateTime.class, "manyBillStaticsToOneOrderInfo.effectiveDate");
                TypedField<LocalDateTime> EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "manyBillStaticsToOneOrderInfo.expiryDate");
                TypedField<String> PAY_TYPE = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.payType");
                TypedField<String> PAYMENT_CONDITION = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.paymentCondition");
                TypedField<Long> CENTRAL_TENANT_ID = new TypedField<>(Long.class, "manyBillStaticsToOneOrderInfo.centralTenantId");
                TypedField<String> CENTRAL_TENANT_NAME = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.centralTenantName");
                TypedField<String> CENTRAL_TENANT_CODE = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.centralTenantCode");
                TypedField<BigDecimal> IN_ORDER_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.inOrderInvoicedAmount");
                TypedField<BigDecimal> IN_ORDER_NO_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.inOrderNoInvoicedAmount");
                TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.originContractId");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.payStatus");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.billingType");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.orderType");
                TypedField<BigDecimal> REMAIN_DEDUCT_AMOUNT = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneOrderInfo.remainDeductAmount");
                TypedField<String> ORIGIN_REMAIN_DEDUCT_AMOUTN_ORDER = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.originRemainDeductAmoutnOrder");
                TypedField<String> BILLING_RULE = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.billingRule");
                TypedField<LocalDateTime> RECEPTION_DATE = new TypedField<>(LocalDateTime.class, "manyBillStaticsToOneOrderInfo.receptionDate");
                TypedField<String> RECEPTION_STATUS = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.receptionStatus");
                TypedField<String> PROJECT_ITEM_CODE = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.projectItemCode");
                TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "manyBillStaticsToOneOrderInfo.projectItemName");
            }
            interface MANY_BILL_STATICS_TO_ONE_CONTRACT {
                static String code () {
                    return "manyBillStaticsToOneContract" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "manyBillStaticsToOneContract.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "manyBillStaticsToOneContract.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "manyBillStaticsToOneContract.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "manyBillStaticsToOneContract.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "manyBillStaticsToOneContract.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "manyBillStaticsToOneContract.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyBillStaticsToOneContract.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyBillStaticsToOneContract.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyBillStaticsToOneContract.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyBillStaticsToOneContract.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyBillStaticsToOneContract.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyBillStaticsToOneContract.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyBillStaticsToOneContract.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyBillStaticsToOneContract.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyBillStaticsToOneContract.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyBillStaticsToOneContract.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "manyBillStaticsToOneContract.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "manyBillStaticsToOneContract.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "manyBillStaticsToOneContract.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneContract.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "manyBillStaticsToOneContract.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "manyBillStaticsToOneContract.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "manyBillStaticsToOneContract.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "manyBillStaticsToOneContract.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "manyBillStaticsToOneContract.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manyBillStaticsToOneContract.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "manyBillStaticsToOneContract.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "manyBillStaticsToOneContract.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "manyBillStaticsToOneContract.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "manyBillStaticsToOneContract.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "manyBillStaticsToOneContract.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "manyBillStaticsToOneContract.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "manyBillStaticsToOneContract.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "manyBillStaticsToOneContract.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "manyBillStaticsToOneContract.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "manyBillStaticsToOneContract.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "manyBillStaticsToOneContract.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "manyBillStaticsToOneContract.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "manyBillStaticsToOneContract.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "manyBillStaticsToOneContract.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "manyBillStaticsToOneContract.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "manyBillStaticsToOneContract.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "manyBillStaticsToOneContract.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "manyBillStaticsToOneContract.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "manyBillStaticsToOneContract.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "manyBillStaticsToOneContract.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "manyBillStaticsToOneContract.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "manyBillStaticsToOneContract.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "manyBillStaticsToOneContract.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "manyBillStaticsToOneContract.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "manyBillStaticsToOneContract.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "manyBillStaticsToOneContract.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "manyBillStaticsToOneContract.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "manyBillStaticsToOneContract.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "manyBillStaticsToOneContract.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "manyBillStaticsToOneContract.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "manyBillStaticsToOneContract.attachmentUrl");
            }
            interface ONE_BILL_STATICS_TO_ONE_RECONCILIATION {
                static String code () {
                    return "oneBillStaticsToOneReconciliation" ;
                }
                TypedField<String> BILL_NO = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.billNo");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.contractNo");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.productCode");
                TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "oneBillStaticsToOneReconciliation.generateDate");
                TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.reconciliationStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneBillStaticsToOneReconciliation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneBillStaticsToOneReconciliation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneBillStaticsToOneReconciliation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneBillStaticsToOneReconciliation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneBillStaticsToOneReconciliation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneBillStaticsToOneReconciliation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.delete_flag");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.handleStatus");
                TypedField<LocalDateTime> ACCOUNTINT_START_DATE = new TypedField<>(LocalDateTime.class, "oneBillStaticsToOneReconciliation.accountintStartDate");
                TypedField<LocalDateTime> ACCOUNTINT_END_DATE = new TypedField<>(LocalDateTime.class, "oneBillStaticsToOneReconciliation.accountintEndDate");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneBillStaticsToOneReconciliation.billAmountWithTax");
                TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneBillStaticsToOneReconciliation.discountAmountWithTax");
                TypedField<String> B_TENANT_CODE = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.bTenantCode");
                TypedField<String> B_TENANT_NAME = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.bTenantName");
                TypedField<Long> B_TENANT_ID = new TypedField<>(Long.class, "oneBillStaticsToOneReconciliation.bTenantId");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "oneBillStaticsToOneReconciliation.paymentAmount");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "oneBillStaticsToOneReconciliation.taxRate");
                TypedField<Long> TAX_COUNT = new TypedField<>(Long.class, "oneBillStaticsToOneReconciliation.taxCount");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.productName");
                TypedField<String> ORIGIN_CONTRACT_NO = new TypedField<>(String.class, "oneBillStaticsToOneReconciliation.originContractNo");
            }
        }
    }
    public interface BillStaticsDetail {
        static Long id() {
            return 1481471899815907330L;
        }
        static String code() {
            return "billStaticsDetail";
        }
        TypedField<String> BILL_DETAIL_NO = new TypedField<>(String.class, "billDetailNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NO = new TypedField<>(String.class, "productNo");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> SALE_PRICE_WITHOUT_TAX = new TypedField<>(String.class, "salePriceWithoutTax");
        TypedField<String> UNIT_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "unitAmountWithoutTax");
        TypedField<String> CURRENT_PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(String.class, "currentPayableAmountWithTax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<BigDecimal> WAITING_AMOUNT = new TypedField<>(BigDecimal.class, "waitingAmount");
        TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "readyAmount");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<Long> CHARGE_DAYS = new TypedField<>(Long.class, "chargeDays");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<LocalDateTime> BILL_CREATE_DATE = new TypedField<>(LocalDateTime.class, "billCreateDate");
        TypedField<String> INVOICE_COMPANY_NAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<String> INVOICE_COMPANY_TAX_NO = new TypedField<>(String.class, "invoiceCompanyTaxNo");
        TypedField<LocalDateTime> INVOICE_GENERATE_DATE = new TypedField<>(LocalDateTime.class, "invoiceGenerateDate");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithoutTax");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithTax");
        TypedField<String> PAYMENT_COMPANY = new TypedField<>(String.class, "paymentCompany");
        TypedField<BigDecimal> CURRENT_DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "currentDiscountAmountWithTax");
        TypedField<LocalDateTime> PAY_BACK_DATE = new TypedField<>(LocalDateTime.class, "payBackDate");
        TypedField<BigDecimal> PAY_BACK_AMOUNT = new TypedField<>(BigDecimal.class, "payBackAmount");
        TypedField<String> DATA_TYPE = new TypedField<>(String.class, "dataType");
        TypedField<BigDecimal> COMPENSATE_AMOUNT = new TypedField<>(BigDecimal.class, "compensateAmount");
        TypedField<BigDecimal> CURRENT_PAYABLE_AMOUNT_AFTER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "currentPayableAmountAfterDiscountWithTax");
        TypedField<BigDecimal> CURRENT_PAYABLE_AMOUNT_AFTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "currentPayableAmountAfterDiscountWithoutTax");
        TypedField<BigDecimal> ORDER_TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "orderTotalAmount");
        TypedField<BigDecimal> ORDER_WAIT_AMOUNT = new TypedField<>(BigDecimal.class, "orderWaitAmount");
        TypedField<BigDecimal> ORDER_READY_AMOUNT = new TypedField<>(BigDecimal.class, "orderReadyAmount");
        TypedField<BigDecimal> INVOICE_WAIT_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceWaitAmount");
        TypedField<BigDecimal> INVOICE_READY_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceReadyAmount");
        TypedField<BigDecimal> TAX_WAIT_AMOUNT = new TypedField<>(BigDecimal.class, "taxWaitAmount");
        TypedField<BigDecimal> TAX_READY_AMOUNT = new TypedField<>(BigDecimal.class, "taxReadyAmount");
        TypedField<Boolean> IS_SHOW = new TypedField<>(Boolean.class, "isShow");
        TypedField<String> INDEX_TRADE_NO = new TypedField<>(String.class, "indexTradeNo");
        TypedField<String> TRADE_SHARE_INFO = new TypedField<>(String.class, "tradeShareInfo");
        TypedField<LocalDateTime> ORDER_GENERATE_DATE = new TypedField<>(LocalDateTime.class, "orderGenerateDate");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> REDUCED_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "reducedAmountWithTax");
        TypedField<String> DEVICE_NO = new TypedField<>(String.class, "deviceNo");
        TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "deviceType");
        TypedField<String> WHETHER_EFFECTIVE_OR_NOT = new TypedField<>(String.class, "whetherEffectiveOrNot");
        TypedField<LocalDateTime> ACCEPTANCE_TIME = new TypedField<>(LocalDateTime.class, "acceptanceTime");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> ONE_CONTRACT_TO_MANY_BILL_STATICS_DETAIL_ID = new TypedField<>(Long.class, "oneContractToManyBillStaticsDetail.id");
        /**
         * 对一关联关系 关联对象 billStatics
         */
        TypedField<Long> MANY_SETTLEMENT_DETAIL_TO_ONE_SETTLEMENT_MAIN_ID = new TypedField<>(Long.class, "manySettlementDetailToOneSettlementMain.id");
        /**
         * 对一关联关系 关联对象 billStatics
         */
        TypedField<Long> ONE_SETTLEMENT_MAIN_TO_MANY_SETTLEMENT_DETAILS_ID = new TypedField<>(Long.class, "oneSettlementMainToManySettlementDetails.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_CONTRACT_TO_MANY_BILL_STATICS_DETAIL {
                static String code () {
                    return "oneContractToManyBillStaticsDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "oneContractToManyBillStaticsDetail.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneContractToManyBillStaticsDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneContractToManyBillStaticsDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractToManyBillStaticsDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractToManyBillStaticsDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneContractToManyBillStaticsDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneContractToManyBillStaticsDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "oneContractToManyBillStaticsDetail.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "oneContractToManyBillStaticsDetail.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneContractToManyBillStaticsDetail.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "oneContractToManyBillStaticsDetail.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractToManyBillStaticsDetail.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "oneContractToManyBillStaticsDetail.attachmentUrl");
            }
            interface MANY_SETTLEMENT_DETAIL_TO_ONE_SETTLEMENT_MAIN {
                static String code () {
                    return "manySettlementDetailToOneSettlementMain" ;
                }
                TypedField<String> BILL_NO = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.billNo");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.contractNo");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.productCode");
                TypedField<Long> ID = new TypedField<>(Long.class, "manySettlementDetailToOneSettlementMain.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manySettlementDetailToOneSettlementMain.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manySettlementDetailToOneSettlementMain.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manySettlementDetailToOneSettlementMain.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manySettlementDetailToOneSettlementMain.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manySettlementDetailToOneSettlementMain.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.delete_flag");
                TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "manySettlementDetailToOneSettlementMain.accountingStartDate");
                TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "manySettlementDetailToOneSettlementMain.accountingEndDate");
                TypedField<BigDecimal> ORDER_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manySettlementDetailToOneSettlementMain.orderTotalAmountWithTax");
                TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manySettlementDetailToOneSettlementMain.invoiceAmountWithTax");
                TypedField<BigDecimal> REFUND_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manySettlementDetailToOneSettlementMain.refundAmountWithTax");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.regionName");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.principalPerson");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.productName");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.saChargeCode");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.customerSignatoryName");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.saChargeCodeName");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.projectName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.paymentType");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.paymentRequirement");
                TypedField<BigDecimal> TOTAL_ORDER_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manySettlementDetailToOneSettlementMain.totalOrderAmountWithTax");
                TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.originContractId");
                TypedField<String> WHETHER_EFFECTIVE_OR_NOT = new TypedField<>(String.class, "manySettlementDetailToOneSettlementMain.whetherEffectiveOrNot");
            }
            interface ONE_SETTLEMENT_MAIN_TO_MANY_SETTLEMENT_DETAILS {
                static String code () {
                    return "oneSettlementMainToManySettlementDetails" ;
                }
                TypedField<String> BILL_NO = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.billNo");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.contractNo");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.productCode");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneSettlementMainToManySettlementDetails.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneSettlementMainToManySettlementDetails.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementMainToManySettlementDetails.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementMainToManySettlementDetails.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneSettlementMainToManySettlementDetails.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneSettlementMainToManySettlementDetails.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.delete_flag");
                TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementMainToManySettlementDetails.accountingStartDate");
                TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementMainToManySettlementDetails.accountingEndDate");
                TypedField<BigDecimal> ORDER_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneSettlementMainToManySettlementDetails.orderTotalAmountWithTax");
                TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneSettlementMainToManySettlementDetails.invoiceAmountWithTax");
                TypedField<BigDecimal> REFUND_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneSettlementMainToManySettlementDetails.refundAmountWithTax");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.regionName");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.principalPerson");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.productName");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.saChargeCode");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.customerSignatoryName");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.saChargeCodeName");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.projectName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.paymentType");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.paymentRequirement");
                TypedField<BigDecimal> TOTAL_ORDER_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneSettlementMainToManySettlementDetails.totalOrderAmountWithTax");
                TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.originContractId");
                TypedField<String> WHETHER_EFFECTIVE_OR_NOT = new TypedField<>(String.class, "oneSettlementMainToManySettlementDetails.whetherEffectiveOrNot");
            }
        }
    }
    public interface Bill {
        static Long id() {
            return 1481525805784682498L;
        }
        static String code() {
            return "bill";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "generateDate");
        TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "reconciliationStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handleStatus");
        TypedField<LocalDateTime> ACCOUNTINT_START_DATE = new TypedField<>(LocalDateTime.class, "accountintStartDate");
        TypedField<LocalDateTime> ACCOUNTINT_END_DATE = new TypedField<>(LocalDateTime.class, "accountintEndDate");
        TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billAmountWithTax");
        TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "discountAmountWithTax");
        TypedField<String> B_TENANT_CODE = new TypedField<>(String.class, "bTenantCode");
        TypedField<String> B_TENANT_NAME = new TypedField<>(String.class, "bTenantName");
        TypedField<Long> B_TENANT_ID = new TypedField<>(Long.class, "bTenantId");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "paymentAmount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<Long> TAX_COUNT = new TypedField<>(Long.class, "taxCount");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> ORIGIN_CONTRACT_NO = new TypedField<>(String.class, "originContractNo");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface BillDetail {
        static Long id() {
            return 1481527030850785282L;
        }
        static String code() {
            return "billDetail";
        }
        TypedField<String> BILL_DETAIL_NO = new TypedField<>(String.class, "billDetailNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_NO = new TypedField<>(String.class, "productNo");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> PAYMENT_METHOD = new TypedField<>(String.class, "paymentMethod");
        TypedField<BigDecimal> SALE_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "salePriceWithoutTax");
        TypedField<BigDecimal> UNIT_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitAmountWithoutTax");
        TypedField<BigDecimal> CURRENT_PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "currentPayableAmountWithTax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> B_TENANT_CODE = new TypedField<>(String.class, "bTenantCode");
        TypedField<Long> B_TENANT_ID = new TypedField<>(Long.class, "bTenantId");
        TypedField<LocalDateTime> TAX_BILLING_DATE = new TypedField<>(LocalDateTime.class, "taxBillingDate");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<BigDecimal> DISCOUNT_AMOUNT = new TypedField<>(BigDecimal.class, "discountAmount");
        TypedField<BigDecimal> CURRENT_PAYABLE_AMOUNT_WITH_TAX_AFTER_DISCOUNT = new TypedField<>(BigDecimal.class, "currentPayableAmountWithTaxAfterDiscount");
        TypedField<BigDecimal> CURRENT_PAYABLE_AMOUNT_WITHOUT_TAX_AFTER_DISCOUNT = new TypedField<>(BigDecimal.class, "currentPayableAmountWithoutTaxAfterDiscount");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handleStatus");
        TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "originContractId");
        TypedField<BigDecimal> REDUCED_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "reducedAmountWithTax");
        TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "deviceType");
        TypedField<String> DEVICE_NO = new TypedField<>(String.class, "deviceNo");
        TypedField<LocalDateTime> DEVICE_START_DATE = new TypedField<>(LocalDateTime.class, "deviceStartDate");
        TypedField<LocalDateTime> DEVICE_END_DATE = new TypedField<>(LocalDateTime.class, "deviceEndDate");
        /**
         * 对一关联关系 关联对象 bill
         */
        TypedField<Long> ONE_TO_MANY_DETAIL_ID = new TypedField<>(Long.class, "oneToManyDetail.id");
        /**
         * 对一关联关系 关联对象 orderInfo
         */
        TypedField<Long> SETTLEMENT_DETAIL_TO_ORDER_ID = new TypedField<>(Long.class, "settlementDetailToOrder.id");
        /**
         * 对一关联关系 关联对象 billStaticsDetail
         */
        TypedField<Long> ONE_SETTLEMENT_DETAIL_TO_ONE_RECONCILIATION_DETAIL_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.id");
        /**
         * 对一关联关系 关联对象 orderInfo
         */
        TypedField<Long> ORDER_TO_MANY_SETTLEMENT_DETAIL_ID = new TypedField<>(Long.class, "orderToManySettlementDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_TO_MANY_DETAIL {
                static String code () {
                    return "oneToManyDetail" ;
                }
                TypedField<String> BILL_NO = new TypedField<>(String.class, "oneToManyDetail.billNo");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneToManyDetail.contractNo");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneToManyDetail.productCode");
                TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "oneToManyDetail.generateDate");
                TypedField<String> RECONCILIATION_STATUS = new TypedField<>(String.class, "oneToManyDetail.reconciliationStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneToManyDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneToManyDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneToManyDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneToManyDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneToManyDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneToManyDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneToManyDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneToManyDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneToManyDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneToManyDetail.delete_flag");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "oneToManyDetail.handleStatus");
                TypedField<LocalDateTime> ACCOUNTINT_START_DATE = new TypedField<>(LocalDateTime.class, "oneToManyDetail.accountintStartDate");
                TypedField<LocalDateTime> ACCOUNTINT_END_DATE = new TypedField<>(LocalDateTime.class, "oneToManyDetail.accountintEndDate");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneToManyDetail.billAmountWithTax");
                TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneToManyDetail.discountAmountWithTax");
                TypedField<String> B_TENANT_CODE = new TypedField<>(String.class, "oneToManyDetail.bTenantCode");
                TypedField<String> B_TENANT_NAME = new TypedField<>(String.class, "oneToManyDetail.bTenantName");
                TypedField<Long> B_TENANT_ID = new TypedField<>(Long.class, "oneToManyDetail.bTenantId");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "oneToManyDetail.paymentAmount");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "oneToManyDetail.taxRate");
                TypedField<Long> TAX_COUNT = new TypedField<>(Long.class, "oneToManyDetail.taxCount");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneToManyDetail.productName");
                TypedField<String> ORIGIN_CONTRACT_NO = new TypedField<>(String.class, "oneToManyDetail.originContractNo");
            }
            interface SETTLEMENT_DETAIL_TO_ORDER {
                static String code () {
                    return "settlementDetailToOrder" ;
                }
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "settlementDetailToOrder.orderNo");
                TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "settlementDetailToOrder.pricingUnit");
                TypedField<Long> ID = new TypedField<>(Long.class, "settlementDetailToOrder.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "settlementDetailToOrder.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "settlementDetailToOrder.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "settlementDetailToOrder.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "settlementDetailToOrder.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "settlementDetailToOrder.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "settlementDetailToOrder.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "settlementDetailToOrder.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "settlementDetailToOrder.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "settlementDetailToOrder.delete_flag");
                TypedField<Long> VERSION = new TypedField<>(Long.class, "settlementDetailToOrder.version");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "settlementDetailToOrder.orderStatus");
                TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "settlementDetailToOrder.contractId");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "settlementDetailToOrder.relatedContractId");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "settlementDetailToOrder.productCode");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "settlementDetailToOrder.productName");
                TypedField<BigDecimal> PURCHASE_QUANTITY = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.purchaseQuantity");
                TypedField<BigDecimal> TOTAL_AMOUNT_STR = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.totalAmountStr");
                TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.paymentPercent");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "settlementDetailToOrder.paymentType");
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "settlementDetailToOrder.serviceType");
                TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "settlementDetailToOrder.isRetentionMoney");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "settlementDetailToOrder.paymentRequirement");
                TypedField<BigDecimal> WAITING_AMOUNT = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.waitingAmount");
                TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.readyAmount");
                TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.discountAmountWithTax");
                TypedField<BigDecimal> PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.payableAmountWithTax");
                TypedField<BigDecimal> RECEIVABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.receivableAmountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "settlementDetailToOrder.taxRate");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.unitPriceWithoutTax");
                TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "settlementDetailToOrder.orderInvoiceStatus");
                TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "settlementDetailToOrder.generateDate");
                TypedField<LocalDateTime> EFFECTIVE_DATE = new TypedField<>(LocalDateTime.class, "settlementDetailToOrder.effectiveDate");
                TypedField<LocalDateTime> EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "settlementDetailToOrder.expiryDate");
                TypedField<String> PAY_TYPE = new TypedField<>(String.class, "settlementDetailToOrder.payType");
                TypedField<String> PAYMENT_CONDITION = new TypedField<>(String.class, "settlementDetailToOrder.paymentCondition");
                TypedField<Long> CENTRAL_TENANT_ID = new TypedField<>(Long.class, "settlementDetailToOrder.centralTenantId");
                TypedField<String> CENTRAL_TENANT_NAME = new TypedField<>(String.class, "settlementDetailToOrder.centralTenantName");
                TypedField<String> CENTRAL_TENANT_CODE = new TypedField<>(String.class, "settlementDetailToOrder.centralTenantCode");
                TypedField<BigDecimal> IN_ORDER_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.inOrderInvoicedAmount");
                TypedField<BigDecimal> IN_ORDER_NO_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.inOrderNoInvoicedAmount");
                TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "settlementDetailToOrder.originContractId");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "settlementDetailToOrder.payStatus");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "settlementDetailToOrder.billingType");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "settlementDetailToOrder.orderType");
                TypedField<BigDecimal> REMAIN_DEDUCT_AMOUNT = new TypedField<>(BigDecimal.class, "settlementDetailToOrder.remainDeductAmount");
                TypedField<String> ORIGIN_REMAIN_DEDUCT_AMOUTN_ORDER = new TypedField<>(String.class, "settlementDetailToOrder.originRemainDeductAmoutnOrder");
                TypedField<String> BILLING_RULE = new TypedField<>(String.class, "settlementDetailToOrder.billingRule");
                TypedField<LocalDateTime> RECEPTION_DATE = new TypedField<>(LocalDateTime.class, "settlementDetailToOrder.receptionDate");
                TypedField<String> RECEPTION_STATUS = new TypedField<>(String.class, "settlementDetailToOrder.receptionStatus");
                TypedField<String> PROJECT_ITEM_CODE = new TypedField<>(String.class, "settlementDetailToOrder.projectItemCode");
                TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "settlementDetailToOrder.projectItemName");
            }
            interface ONE_SETTLEMENT_DETAIL_TO_ONE_RECONCILIATION_DETAIL {
                static String code () {
                    return "oneSettlementDetailToOneReconciliationDetail" ;
                }
                TypedField<String> BILL_DETAIL_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.billDetailNo");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.contractNo");
                TypedField<String> PRODUCT_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.productNo");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.chargeType");
                TypedField<String> SALE_PRICE_WITHOUT_TAX = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.salePriceWithoutTax");
                TypedField<String> UNIT_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.unitAmountWithoutTax");
                TypedField<String> CURRENT_PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.currentPayableAmountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.taxRate");
                TypedField<String> TAX_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.taxNo");
                TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.taxCompanyName");
                TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.accountingStartDate");
                TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.accountingEndDate");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.delete_flag");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.invoiceNo");
                TypedField<BigDecimal> WAITING_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.waitingAmount");
                TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.readyAmount");
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.orderNo");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.paymentType");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.paymentRequirement");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.property");
                TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.quantity");
                TypedField<String> CHARGE_UNIT = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.chargeUnit");
                TypedField<Long> CHARGE_DAYS = new TypedField<>(Long.class, "oneSettlementDetailToOneReconciliationDetail.chargeDays");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.chargeCycle");
                TypedField<LocalDateTime> BILL_CREATE_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.billCreateDate");
                TypedField<String> INVOICE_COMPANY_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.invoiceCompanyName");
                TypedField<String> INVOICE_COMPANY_TAX_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.invoiceCompanyTaxNo");
                TypedField<LocalDateTime> INVOICE_GENERATE_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.invoiceGenerateDate");
                TypedField<BigDecimal> INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.invoiceAmountWithoutTax");
                TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.invoiceAmountWithTax");
                TypedField<String> PAYMENT_COMPANY = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.paymentCompany");
                TypedField<BigDecimal> CURRENT_DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.currentDiscountAmountWithTax");
                TypedField<LocalDateTime> PAY_BACK_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.payBackDate");
                TypedField<BigDecimal> PAY_BACK_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.payBackAmount");
                TypedField<String> DATA_TYPE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.dataType");
                TypedField<BigDecimal> COMPENSATE_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.compensateAmount");
                TypedField<BigDecimal> CURRENT_PAYABLE_AMOUNT_AFTER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.currentPayableAmountAfterDiscountWithTax");
                TypedField<BigDecimal> CURRENT_PAYABLE_AMOUNT_AFTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.currentPayableAmountAfterDiscountWithoutTax");
                TypedField<BigDecimal> ORDER_TOTAL_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.orderTotalAmount");
                TypedField<BigDecimal> ORDER_WAIT_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.orderWaitAmount");
                TypedField<BigDecimal> ORDER_READY_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.orderReadyAmount");
                TypedField<BigDecimal> INVOICE_WAIT_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.invoiceWaitAmount");
                TypedField<BigDecimal> INVOICE_READY_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.invoiceReadyAmount");
                TypedField<BigDecimal> TAX_WAIT_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.taxWaitAmount");
                TypedField<BigDecimal> TAX_READY_AMOUNT = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.taxReadyAmount");
                TypedField<Boolean> IS_SHOW = new TypedField<>(Boolean.class, "oneSettlementDetailToOneReconciliationDetail.isShow");
                TypedField<String> INDEX_TRADE_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.indexTradeNo");
                TypedField<String> TRADE_SHARE_INFO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.tradeShareInfo");
                TypedField<LocalDateTime> ORDER_GENERATE_DATE = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.orderGenerateDate");
                TypedField<String> BILL_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.billNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.productName");
                TypedField<BigDecimal> REDUCED_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneSettlementDetailToOneReconciliationDetail.reducedAmountWithTax");
                TypedField<String> DEVICE_NO = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.deviceNo");
                TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.deviceType");
                TypedField<String> WHETHER_EFFECTIVE_OR_NOT = new TypedField<>(String.class, "oneSettlementDetailToOneReconciliationDetail.whetherEffectiveOrNot");
                TypedField<LocalDateTime> ACCEPTANCE_TIME = new TypedField<>(LocalDateTime.class, "oneSettlementDetailToOneReconciliationDetail.acceptanceTime");
            }
            interface ORDER_TO_MANY_SETTLEMENT_DETAIL {
                static String code () {
                    return "orderToManySettlementDetail" ;
                }
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderToManySettlementDetail.orderNo");
                TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "orderToManySettlementDetail.pricingUnit");
                TypedField<Long> ID = new TypedField<>(Long.class, "orderToManySettlementDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "orderToManySettlementDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "orderToManySettlementDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "orderToManySettlementDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "orderToManySettlementDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "orderToManySettlementDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "orderToManySettlementDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "orderToManySettlementDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "orderToManySettlementDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "orderToManySettlementDetail.delete_flag");
                TypedField<Long> VERSION = new TypedField<>(Long.class, "orderToManySettlementDetail.version");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderToManySettlementDetail.orderStatus");
                TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "orderToManySettlementDetail.contractId");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "orderToManySettlementDetail.relatedContractId");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "orderToManySettlementDetail.productCode");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "orderToManySettlementDetail.productName");
                TypedField<BigDecimal> PURCHASE_QUANTITY = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.purchaseQuantity");
                TypedField<BigDecimal> TOTAL_AMOUNT_STR = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.totalAmountStr");
                TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.paymentPercent");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "orderToManySettlementDetail.paymentType");
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "orderToManySettlementDetail.serviceType");
                TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "orderToManySettlementDetail.isRetentionMoney");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "orderToManySettlementDetail.paymentRequirement");
                TypedField<BigDecimal> WAITING_AMOUNT = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.waitingAmount");
                TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.readyAmount");
                TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.discountAmountWithTax");
                TypedField<BigDecimal> PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.payableAmountWithTax");
                TypedField<BigDecimal> RECEIVABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.receivableAmountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "orderToManySettlementDetail.taxRate");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.unitPriceWithoutTax");
                TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderToManySettlementDetail.orderInvoiceStatus");
                TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "orderToManySettlementDetail.generateDate");
                TypedField<LocalDateTime> EFFECTIVE_DATE = new TypedField<>(LocalDateTime.class, "orderToManySettlementDetail.effectiveDate");
                TypedField<LocalDateTime> EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "orderToManySettlementDetail.expiryDate");
                TypedField<String> PAY_TYPE = new TypedField<>(String.class, "orderToManySettlementDetail.payType");
                TypedField<String> PAYMENT_CONDITION = new TypedField<>(String.class, "orderToManySettlementDetail.paymentCondition");
                TypedField<Long> CENTRAL_TENANT_ID = new TypedField<>(Long.class, "orderToManySettlementDetail.centralTenantId");
                TypedField<String> CENTRAL_TENANT_NAME = new TypedField<>(String.class, "orderToManySettlementDetail.centralTenantName");
                TypedField<String> CENTRAL_TENANT_CODE = new TypedField<>(String.class, "orderToManySettlementDetail.centralTenantCode");
                TypedField<BigDecimal> IN_ORDER_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.inOrderInvoicedAmount");
                TypedField<BigDecimal> IN_ORDER_NO_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.inOrderNoInvoicedAmount");
                TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "orderToManySettlementDetail.originContractId");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "orderToManySettlementDetail.payStatus");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "orderToManySettlementDetail.billingType");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "orderToManySettlementDetail.orderType");
                TypedField<BigDecimal> REMAIN_DEDUCT_AMOUNT = new TypedField<>(BigDecimal.class, "orderToManySettlementDetail.remainDeductAmount");
                TypedField<String> ORIGIN_REMAIN_DEDUCT_AMOUTN_ORDER = new TypedField<>(String.class, "orderToManySettlementDetail.originRemainDeductAmoutnOrder");
                TypedField<String> BILLING_RULE = new TypedField<>(String.class, "orderToManySettlementDetail.billingRule");
                TypedField<LocalDateTime> RECEPTION_DATE = new TypedField<>(LocalDateTime.class, "orderToManySettlementDetail.receptionDate");
                TypedField<String> RECEPTION_STATUS = new TypedField<>(String.class, "orderToManySettlementDetail.receptionStatus");
                TypedField<String> PROJECT_ITEM_CODE = new TypedField<>(String.class, "orderToManySettlementDetail.projectItemCode");
                TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "orderToManySettlementDetail.projectItemName");
            }
        }
    }
    public interface IncomeSummary {
        static Long id() {
            return 1481539368520966145L;
        }
        static String code() {
            return "incomeSummary";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "pricingUnit");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<Long> USING_MONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<Long> ACCOUNTING_PERIOD = new TypedField<>(Long.class, "accountingPeriod");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> CURRENT_PERIOD_INCOME_AMOUNT = new TypedField<>(BigDecimal.class, "currentPeriodIncomeAmount");
        TypedField<String> INCOME_STATUS = new TypedField<>(String.class, "incomeStatus");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<Long> PRODUCT_INCOME_EFFECTIVE_DAY = new TypedField<>(Long.class, "productIncomeEffectiveDay");
        TypedField<BigDecimal> PRODUCT_INCOME_BALANCE = new TypedField<>(BigDecimal.class, "productIncomeBalance");
        TypedField<Long> PRODUCT_INCOME_USAGE_COUNT1 = new TypedField<>(Long.class, "productIncomeUsageCount1");
        TypedField<BigDecimal> PRODUCT_INCOME_DAY_AMOUNT = new TypedField<>(BigDecimal.class, "productIncomeDayAmount");
        TypedField<String> CONFIRM_TYPE = new TypedField<>(String.class, "confirmType");
        TypedField<String> PRODUCT_INCOME_TYPE = new TypedField<>(String.class, "productIncomeType");
        TypedField<LocalDateTime> USING_MONTH_DATE = new TypedField<>(LocalDateTime.class, "usingMonthDate");
        TypedField<String> BILL_MONTH = new TypedField<>(String.class, "billMonth");
        TypedField<String> ACCOUNTING_PERIOD_STR = new TypedField<>(String.class, "accountingPeriodStr");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "deviceType");
        TypedField<String> DEVICE_NO = new TypedField<>(String.class, "deviceNo");
        TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "isRetentionMoney");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "projectItemName");
        TypedField<String> PROJECT_ITEM_CODE = new TypedField<>(String.class, "projectItemCode");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> INCOME_TO_ONE_CONTRACT_MAIN_ID = new TypedField<>(Long.class, "incomeToOneContractMain.id");
        /**
         * 对一关联关系 关联对象 contractDetail
         */
        TypedField<Long> INCOME_TO_ONE_CONTRACT_DETAIL_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INCOME_TO_ONE_CONTRACT_MAIN {
                static String code () {
                    return "incomeToOneContractMain" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractMain.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "incomeToOneContractMain.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeToOneContractMain.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "incomeToOneContractMain.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "incomeToOneContractMain.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "incomeToOneContractMain.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeToOneContractMain.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeToOneContractMain.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeToOneContractMain.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractMain.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractMain.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractMain.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractMain.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractMain.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractMain.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeToOneContractMain.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "incomeToOneContractMain.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "incomeToOneContractMain.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "incomeToOneContractMain.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "incomeToOneContractMain.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "incomeToOneContractMain.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "incomeToOneContractMain.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "incomeToOneContractMain.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "incomeToOneContractMain.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "incomeToOneContractMain.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "incomeToOneContractMain.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractMain.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "incomeToOneContractMain.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "incomeToOneContractMain.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "incomeToOneContractMain.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "incomeToOneContractMain.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "incomeToOneContractMain.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "incomeToOneContractMain.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "incomeToOneContractMain.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "incomeToOneContractMain.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "incomeToOneContractMain.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "incomeToOneContractMain.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "incomeToOneContractMain.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "incomeToOneContractMain.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "incomeToOneContractMain.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "incomeToOneContractMain.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "incomeToOneContractMain.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "incomeToOneContractMain.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "incomeToOneContractMain.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "incomeToOneContractMain.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "incomeToOneContractMain.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "incomeToOneContractMain.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "incomeToOneContractMain.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "incomeToOneContractMain.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "incomeToOneContractMain.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "incomeToOneContractMain.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "incomeToOneContractMain.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "incomeToOneContractMain.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "incomeToOneContractMain.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "incomeToOneContractMain.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "incomeToOneContractMain.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "incomeToOneContractMain.attachmentUrl");
            }
            interface INCOME_TO_ONE_CONTRACT_DETAIL {
                static String code () {
                    return "incomeToOneContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.productName");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.productCode");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.amount");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.unitPrice");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "incomeToOneContractDetail.chargeRequirement");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeToOneContractDetail.delete_flag");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "incomeToOneContractDetail.chargeType");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "incomeToOneContractDetail.taxRate");
                TypedField<String> VALIDATION = new TypedField<>(String.class, "incomeToOneContractDetail.validation");
                TypedField<String> QUANTITY = new TypedField<>(String.class, "incomeToOneContractDetail.quantity");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.unitPriceWithoutTax");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "incomeToOneContractDetail.paymentRequirement");
                TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.paymentPercent");
                TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "incomeToOneContractDetail.containsRetentionMoney");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "incomeToOneContractDetail.receiptSignDateStr");
                TypedField<String> FIRST_PAY_REQUIREMENT_OR_NOT = new TypedField<>(String.class, "incomeToOneContractDetail.firstPayRequirementOrNot");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "incomeToOneContractDetail.chargeCycle");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "incomeToOneContractDetail.billingType");
                TypedField<String> DAYS = new TypedField<>(String.class, "incomeToOneContractDetail.days");
                TypedField<Boolean> OUTSOURCING = new TypedField<>(Boolean.class, "incomeToOneContractDetail.outsourcing");
                TypedField<String> LINKED_PURCHASE_CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractDetail.linkedPurchaseContractNo");
                TypedField<String> CHARGE_RULES = new TypedField<>(String.class, "incomeToOneContractDetail.chargeRules");
                TypedField<String> PRODUCT_STATUS = new TypedField<>(String.class, "incomeToOneContractDetail.productStatus");
                TypedField<String> PRODUCT_ACCEPTANCE_STATUS = new TypedField<>(String.class, "incomeToOneContractDetail.productAcceptanceStatus");
            }
        }
    }
    public interface IncomeItem {
        static Long id() {
            return 1481546350567804929L;
        }
        static String code() {
            return "incomeItem";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> RELATED_ORDER_NOS = new TypedField<>(String.class, "relatedOrderNos");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "pricingUnit");
        TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<Long> USING_MONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<Long> ACCOUNTING_PERIOD = new TypedField<>(Long.class, "accountingPeriod");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> CURRENT_PERIOD_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "currentPeriodAmountWithoutTax");
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "startDate");
        TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "endDate");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> RELATED_ORDER_NO = new TypedField<>(String.class, "relatedOrderNo");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<Long> PRODUCT_INCOME_EFFECTIVE_DAY = new TypedField<>(Long.class, "productIncomeEffectiveDay");
        TypedField<BigDecimal> PRODUCT_INCOME_BALANCE = new TypedField<>(BigDecimal.class, "productIncomeBalance");
        TypedField<BigDecimal> PRODUCT_INCOME_DAY_AMOUNT = new TypedField<>(BigDecimal.class, "productIncomeDayAmount");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "discountAmountWithTax");
        TypedField<LocalDateTime> USING_MONTH_DATE = new TypedField<>(LocalDateTime.class, "usingMonthDate");
        TypedField<String> PRODUCT_INCOME_TYPE = new TypedField<>(String.class, "productIncomeType");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> BILL_MONTH = new TypedField<>(String.class, "billMonth");
        TypedField<String> ACCOUNTING_PERIOD_STR = new TypedField<>(String.class, "accountingPeriodStr");
        TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "deviceType");
        TypedField<String> DEVICE_NO = new TypedField<>(String.class, "deviceNo");
        TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "isRetentionMoney");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "projectItemName");
        TypedField<String> PROJECT_ITEM_CODE = new TypedField<>(String.class, "projectItemCode");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> INCOME_DETAIL_TO_ONE_CONTRACT_ID = new TypedField<>(Long.class, "incomeDetailToOneContract.id");
        /**
         * 对一关联关系 关联对象 incomeSummary
         */
        TypedField<Long> ONE_INCOME_SUMMARY_TO_MANY_INCOME_ITEM_ID = new TypedField<>(Long.class, "oneIncomeSummaryToManyIncomeItem.id");
        /**
         * 对一关联关系 关联对象 contractDetail
         */
        TypedField<Long> INCOME_TO_ONE_CONTRACT_DETAIL_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INCOME_DETAIL_TO_ONE_CONTRACT {
                static String code () {
                    return "incomeDetailToOneContract" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeDetailToOneContract.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "incomeDetailToOneContract.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "incomeDetailToOneContract.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "incomeDetailToOneContract.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "incomeDetailToOneContract.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeDetailToOneContract.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeDetailToOneContract.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeDetailToOneContract.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeDetailToOneContract.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeDetailToOneContract.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeDetailToOneContract.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeDetailToOneContract.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "incomeDetailToOneContract.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "incomeDetailToOneContract.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "incomeDetailToOneContract.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "incomeDetailToOneContract.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "incomeDetailToOneContract.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "incomeDetailToOneContract.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "incomeDetailToOneContract.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "incomeDetailToOneContract.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "incomeDetailToOneContract.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "incomeDetailToOneContract.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "incomeDetailToOneContract.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "incomeDetailToOneContract.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "incomeDetailToOneContract.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "incomeDetailToOneContract.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "incomeDetailToOneContract.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "incomeDetailToOneContract.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "incomeDetailToOneContract.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "incomeDetailToOneContract.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "incomeDetailToOneContract.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "incomeDetailToOneContract.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "incomeDetailToOneContract.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "incomeDetailToOneContract.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "incomeDetailToOneContract.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "incomeDetailToOneContract.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "incomeDetailToOneContract.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "incomeDetailToOneContract.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "incomeDetailToOneContract.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "incomeDetailToOneContract.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "incomeDetailToOneContract.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "incomeDetailToOneContract.attachmentUrl");
            }
            interface ONE_INCOME_SUMMARY_TO_MANY_INCOME_ITEM {
                static String code () {
                    return "oneIncomeSummaryToManyIncomeItem" ;
                }
                TypedField<String> BILL_NO = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.billNo");
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.orderNo");
                TypedField<String> TAX_NO = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.taxNo");
                TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.taxCompanyName");
                TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.pricingUnit");
                TypedField<LocalDateTime> RECEIPT_DATE = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyIncomeItem.receiptDate");
                TypedField<LocalDateTime> CHARGE_START_DATE = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyIncomeItem.chargeStartDate");
                TypedField<LocalDateTime> CHARGE_END_DATE = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyIncomeItem.chargeEndDate");
                TypedField<Long> USING_MONTH = new TypedField<>(Long.class, "oneIncomeSummaryToManyIncomeItem.usingMonth");
                TypedField<Long> ACCOUNTING_PERIOD = new TypedField<>(Long.class, "oneIncomeSummaryToManyIncomeItem.accountingPeriod");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneIncomeSummaryToManyIncomeItem.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneIncomeSummaryToManyIncomeItem.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyIncomeItem.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyIncomeItem.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneIncomeSummaryToManyIncomeItem.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneIncomeSummaryToManyIncomeItem.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.delete_flag");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.contractNo");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.productCode");
                TypedField<String> PROPERTY = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.property");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "oneIncomeSummaryToManyIncomeItem.unitPriceWithoutTax");
                TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "oneIncomeSummaryToManyIncomeItem.quantity");
                TypedField<BigDecimal> CURRENT_PERIOD_INCOME_AMOUNT = new TypedField<>(BigDecimal.class, "oneIncomeSummaryToManyIncomeItem.currentPeriodIncomeAmount");
                TypedField<String> INCOME_STATUS = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.incomeStatus");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.productName");
                TypedField<Long> PRODUCT_INCOME_EFFECTIVE_DAY = new TypedField<>(Long.class, "oneIncomeSummaryToManyIncomeItem.productIncomeEffectiveDay");
                TypedField<BigDecimal> PRODUCT_INCOME_BALANCE = new TypedField<>(BigDecimal.class, "oneIncomeSummaryToManyIncomeItem.productIncomeBalance");
                TypedField<Long> PRODUCT_INCOME_USAGE_COUNT1 = new TypedField<>(Long.class, "oneIncomeSummaryToManyIncomeItem.productIncomeUsageCount1");
                TypedField<BigDecimal> PRODUCT_INCOME_DAY_AMOUNT = new TypedField<>(BigDecimal.class, "oneIncomeSummaryToManyIncomeItem.productIncomeDayAmount");
                TypedField<String> CONFIRM_TYPE = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.confirmType");
                TypedField<String> PRODUCT_INCOME_TYPE = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.productIncomeType");
                TypedField<LocalDateTime> USING_MONTH_DATE = new TypedField<>(LocalDateTime.class, "oneIncomeSummaryToManyIncomeItem.usingMonthDate");
                TypedField<String> BILL_MONTH = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.billMonth");
                TypedField<String> ACCOUNTING_PERIOD_STR = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.accountingPeriodStr");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.chargeCycle");
                TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.deviceType");
                TypedField<String> DEVICE_NO = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.deviceNo");
                TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "oneIncomeSummaryToManyIncomeItem.isRetentionMoney");
                TypedField<String> REMARK = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.remark");
                TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.projectItemName");
                TypedField<String> PROJECT_ITEM_CODE = new TypedField<>(String.class, "oneIncomeSummaryToManyIncomeItem.projectItemCode");
            }
            interface INCOME_TO_ONE_CONTRACT_DETAIL {
                static String code () {
                    return "incomeToOneContractDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractDetail.contractNo");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.productName");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.productCode");
                TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.amount");
                TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.unitPrice");
                TypedField<String> CHARGE_REQUIREMENT = new TypedField<>(String.class, "incomeToOneContractDetail.chargeRequirement");
                TypedField<Long> ID = new TypedField<>(Long.class, "incomeToOneContractDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "incomeToOneContractDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "incomeToOneContractDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "incomeToOneContractDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "incomeToOneContractDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "incomeToOneContractDetail.delete_flag");
                TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "incomeToOneContractDetail.chargeType");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "incomeToOneContractDetail.taxRate");
                TypedField<String> VALIDATION = new TypedField<>(String.class, "incomeToOneContractDetail.validation");
                TypedField<String> QUANTITY = new TypedField<>(String.class, "incomeToOneContractDetail.quantity");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.unitPriceWithoutTax");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "incomeToOneContractDetail.paymentRequirement");
                TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "incomeToOneContractDetail.paymentPercent");
                TypedField<String> CONTAINS_RETENTION_MONEY = new TypedField<>(String.class, "incomeToOneContractDetail.containsRetentionMoney");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "incomeToOneContractDetail.receiptSignDateStr");
                TypedField<String> FIRST_PAY_REQUIREMENT_OR_NOT = new TypedField<>(String.class, "incomeToOneContractDetail.firstPayRequirementOrNot");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "incomeToOneContractDetail.chargeCycle");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "incomeToOneContractDetail.billingType");
                TypedField<String> DAYS = new TypedField<>(String.class, "incomeToOneContractDetail.days");
                TypedField<Boolean> OUTSOURCING = new TypedField<>(Boolean.class, "incomeToOneContractDetail.outsourcing");
                TypedField<String> LINKED_PURCHASE_CONTRACT_NO = new TypedField<>(String.class, "incomeToOneContractDetail.linkedPurchaseContractNo");
                TypedField<String> CHARGE_RULES = new TypedField<>(String.class, "incomeToOneContractDetail.chargeRules");
                TypedField<String> PRODUCT_STATUS = new TypedField<>(String.class, "incomeToOneContractDetail.productStatus");
                TypedField<String> PRODUCT_ACCEPTANCE_STATUS = new TypedField<>(String.class, "incomeToOneContractDetail.productAcceptanceStatus");
            }
        }
    }
    public interface BillTaxUsage {
        static Long id() {
            return 1482962910322065410L;
        }
        static String code() {
            return "billTaxUsage";
        }
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> TAX_COMPANY_NAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> CHARGE_BIZ_DIMENSION = new TypedField<>(String.class, "chargeBizDimension");
        TypedField<String> ACTUAL_BIZ_VOLUME = new TypedField<>(String.class, "actualBizVolume");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> BIZ_MONTH = new TypedField<>(Long.class, "bizMonth");
        TypedField<LocalDateTime> ACCOUNTINT_START_DATE = new TypedField<>(LocalDateTime.class, "accountintStartDate");
        TypedField<LocalDateTime> ACCOUNTINT_END_DATE = new TypedField<>(LocalDateTime.class, "accountintEndDate");
        TypedField<Long> DETAIL_NO = new TypedField<>(Long.class, "detailNo");
        TypedField<Long> B_TENANT_ID = new TypedField<>(Long.class, "bTenantId");
        TypedField<String> B_TENANT_NAME = new TypedField<>(String.class, "bTenantName");
        TypedField<String> B_TENANT_CODE = new TypedField<>(String.class, "bTenantCode");
        TypedField<Long> BILLING_TYPE = new TypedField<>(Long.class, "billingType");
        TypedField<LocalDateTime> BCREATE_TIME = new TypedField<>(LocalDateTime.class, "bcreateTime");
        TypedField<String> B_DETAIL_NO = new TypedField<>(String.class, "bDetailNo");
        /**
         * 对一关联关系 关联对象 orderInfo
         */
        TypedField<Long> MANY_BILL_TAX_USAGE_TO_ONE_ORDER_INFO_ID = new TypedField<>(Long.class, "manyBillTaxUsageToOneOrderInfo.id");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> MANY_BILL_TAX_USAGE_TO_ONE_CONTRACT_ID = new TypedField<>(Long.class, "manyBillTaxUsageToOneContract.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface MANY_BILL_TAX_USAGE_TO_ONE_ORDER_INFO {
                static String code () {
                    return "manyBillTaxUsageToOneOrderInfo" ;
                }
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.orderNo");
                TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.pricingUnit");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyBillTaxUsageToOneOrderInfo.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyBillTaxUsageToOneOrderInfo.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyBillTaxUsageToOneOrderInfo.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyBillTaxUsageToOneOrderInfo.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyBillTaxUsageToOneOrderInfo.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyBillTaxUsageToOneOrderInfo.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.delete_flag");
                TypedField<Long> VERSION = new TypedField<>(Long.class, "manyBillTaxUsageToOneOrderInfo.version");
                TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.orderStatus");
                TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.contractId");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.relatedContractId");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.productCode");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.productName");
                TypedField<BigDecimal> PURCHASE_QUANTITY = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.purchaseQuantity");
                TypedField<BigDecimal> TOTAL_AMOUNT_STR = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.totalAmountStr");
                TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.paymentPercent");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.paymentType");
                TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.serviceType");
                TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "manyBillTaxUsageToOneOrderInfo.isRetentionMoney");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.paymentRequirement");
                TypedField<BigDecimal> WAITING_AMOUNT = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.waitingAmount");
                TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.readyAmount");
                TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.discountAmountWithTax");
                TypedField<BigDecimal> PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.payableAmountWithTax");
                TypedField<BigDecimal> RECEIVABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.receivableAmountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.taxRate");
                TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.unitPriceWithoutTax");
                TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.orderInvoiceStatus");
                TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "manyBillTaxUsageToOneOrderInfo.generateDate");
                TypedField<LocalDateTime> EFFECTIVE_DATE = new TypedField<>(LocalDateTime.class, "manyBillTaxUsageToOneOrderInfo.effectiveDate");
                TypedField<LocalDateTime> EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "manyBillTaxUsageToOneOrderInfo.expiryDate");
                TypedField<String> PAY_TYPE = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.payType");
                TypedField<String> PAYMENT_CONDITION = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.paymentCondition");
                TypedField<Long> CENTRAL_TENANT_ID = new TypedField<>(Long.class, "manyBillTaxUsageToOneOrderInfo.centralTenantId");
                TypedField<String> CENTRAL_TENANT_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.centralTenantName");
                TypedField<String> CENTRAL_TENANT_CODE = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.centralTenantCode");
                TypedField<BigDecimal> IN_ORDER_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.inOrderInvoicedAmount");
                TypedField<BigDecimal> IN_ORDER_NO_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.inOrderNoInvoicedAmount");
                TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.originContractId");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.payStatus");
                TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.billingType");
                TypedField<String> ORDER_TYPE = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.orderType");
                TypedField<BigDecimal> REMAIN_DEDUCT_AMOUNT = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneOrderInfo.remainDeductAmount");
                TypedField<String> ORIGIN_REMAIN_DEDUCT_AMOUTN_ORDER = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.originRemainDeductAmoutnOrder");
                TypedField<String> BILLING_RULE = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.billingRule");
                TypedField<LocalDateTime> RECEPTION_DATE = new TypedField<>(LocalDateTime.class, "manyBillTaxUsageToOneOrderInfo.receptionDate");
                TypedField<String> RECEPTION_STATUS = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.receptionStatus");
                TypedField<String> PROJECT_ITEM_CODE = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.projectItemCode");
                TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneOrderInfo.projectItemName");
            }
            interface MANY_BILL_TAX_USAGE_TO_ONE_CONTRACT {
                static String code () {
                    return "manyBillTaxUsageToOneContract" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "manyBillTaxUsageToOneContract.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "manyBillTaxUsageToOneContract.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "manyBillTaxUsageToOneContract.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "manyBillTaxUsageToOneContract.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "manyBillTaxUsageToOneContract.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "manyBillTaxUsageToOneContract.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "manyBillTaxUsageToOneContract.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "manyBillTaxUsageToOneContract.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneContract.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "manyBillTaxUsageToOneContract.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "manyBillTaxUsageToOneContract.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "manyBillTaxUsageToOneContract.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "manyBillTaxUsageToOneContract.attachmentUrl");
            }
        }
    }
    public interface OrderInfoRawData {
        static Long id() {
            return 1493840515636101121L;
        }
        static String code() {
            return "orderInfoRawData";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "contractId");
        TypedField<String> RELATELD_CONTRACT_ID = new TypedField<>(String.class, "relateldContractId");
        TypedField<String> JSON = new TypedField<>(String.class, "json");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ImportBatchClaimData {
        static Long id() {
            return 1494125877503561729L;
        }
        static String code() {
            return "importBatchClaimData";
        }
        TypedField<String> TRACE_NO = new TypedField<>(String.class, "traceNo");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<BigDecimal> CLAIM_AMOUNT = new TypedField<>(BigDecimal.class, "claimAmount");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batchNo");
        TypedField<Long> STATUS = new TypedField<>(Long.class, "status");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface CompensateData {
        static Long id() {
            return 1495652134750195713L;
        }
        static String code() {
            return "compensateData";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<BigDecimal> COMPENSATE_AMOUNT = new TypedField<>(BigDecimal.class, "compensateAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
    }
    public interface MultiRelation {
        static Long id() {
            return 1496013110435454977L;
        }
        static String code() {
            return "multiRelation";
        }
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "readyAmount");
    }
    public interface OrderRawData {
        static Long id() {
            return 1498956659078664193L;
        }
        static String code() {
            return "orderRawData";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "contractId");
        TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "relatedContractId");
        TypedField<String> JSON = new TypedField<>(String.class, "json");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ChargeMonthData {
        static Long id() {
            return 1502518601290551297L;
        }
        static String code() {
            return "chargeMonthData";
        }
        TypedField<String> CONTRACT_CODE = new TypedField<>(String.class, "contractCode");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenantCode");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> TAX_NUM = new TypedField<>(String.class, "taxNum");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> SERVICE_OPEN_FLAG = new TypedField<>(String.class, "serviceOpenFlag");
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "startDate");
        TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "endDate");
        TypedField<String> BILL_MONTH = new TypedField<>(String.class, "billMonth");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> BUSINESS_CODE = new TypedField<>(String.class, "businessCode");
        TypedField<Long> USAGE_COUNT = new TypedField<>(Long.class, "usageCount");
        TypedField<Long> USAGE_LIMIT_COUNT = new TypedField<>(Long.class, "usageLimitCount");
        TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billAmountWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> PRICE_UNIT = new TypedField<>(BigDecimal.class, "priceUnit");
        TypedField<Long> PAYMENT_TYPE = new TypedField<>(Long.class, "paymentType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> B_TENANT_CODE = new TypedField<>(String.class, "bTenantCode");
        TypedField<String> B_TENANT_NAME = new TypedField<>(String.class, "bTenantName");
        TypedField<Long> FLOW_ID = new TypedField<>(Long.class, "flowId");
        TypedField<String> TAX_NUM_PK = new TypedField<>(String.class, "taxNumPk");
        TypedField<LocalDateTime> TAX_START_DATE = new TypedField<>(LocalDateTime.class, "taxStartDate");
        TypedField<LocalDateTime> TAX_END_DATE = new TypedField<>(LocalDateTime.class, "taxEndDate");
        TypedField<String> ORIGIN_CONTRACT_CODE = new TypedField<>(String.class, "originContractCode");
        TypedField<String> PAYMENT_TYPE_ENUM = new TypedField<>(String.class, "paymentTypeEnum");
        TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "deviceType");
        TypedField<String> DEVICE_NO = new TypedField<>(String.class, "deviceNo");
        TypedField<String> CYCLE = new TypedField<>(String.class, "cycle");
        TypedField<Long> PERIOD = new TypedField<>(Long.class, "period");
        TypedField<LocalDateTime> DEVICE_START_DATE = new TypedField<>(LocalDateTime.class, "deviceStartDate");
        TypedField<LocalDateTime> DEVICE_END_DATE = new TypedField<>(LocalDateTime.class, "deviceEndDate");
        TypedField<String> DEVICE_TYPE_PK = new TypedField<>(String.class, "deviceTypePk");
        TypedField<String> DEVICE_NO_PK = new TypedField<>(String.class, "deviceNoPk");
    }
    public interface BillDetailMonth {
        static Long id() {
            return 1503318639658631169L;
        }
        static String code() {
            return "billDetailMonth";
        }
        TypedField<Long> BILL_CYCLE_ID = new TypedField<>(Long.class, "billCycleId");
        TypedField<String> CONTRACT_CODE = new TypedField<>(String.class, "contractCode");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TAX_NUM = new TypedField<>(String.class, "taxNum");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<BigDecimal> USAGE_COUNT = new TypedField<>(BigDecimal.class, "usageCount");
        TypedField<LocalDateTime> BILL_MONTH = new TypedField<>(LocalDateTime.class, "billMonth");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILL_MONTH_STR = new TypedField<>(String.class, "billMonthStr");
        TypedField<String> TAX_NUM_PK = new TypedField<>(String.class, "taxNumPk");
        TypedField<String> B_TENANT_CODE = new TypedField<>(String.class, "bTenantCode");
        TypedField<String> B_TENANT_NAME = new TypedField<>(String.class, "bTenantName");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> BUSINESS_CODE = new TypedField<>(String.class, "businessCode");
        TypedField<String> ORIGIN_CONTRACT_CODE = new TypedField<>(String.class, "originContractCode");
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "startDate");
        TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "endDate");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "projectName");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        /**
         * 对一关联关系 关联对象 billStatics
         */
        TypedField<Long> BILL_STATICS_ONE_TO_MANY_BILL_STATICS_DETAIL_MONTH_ID = new TypedField<>(Long.class, "billStaticsOneToManyBillStaticsDetailMonth.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_STATICS_ONE_TO_MANY_BILL_STATICS_DETAIL_MONTH {
                static String code () {
                    return "billStaticsOneToManyBillStaticsDetailMonth" ;
                }
                TypedField<String> BILL_NO = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.billNo");
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.contractNo");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.productCode");
                TypedField<Long> ID = new TypedField<>(Long.class, "billStaticsOneToManyBillStaticsDetailMonth.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billStaticsOneToManyBillStaticsDetailMonth.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billStaticsOneToManyBillStaticsDetailMonth.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billStaticsOneToManyBillStaticsDetailMonth.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billStaticsOneToManyBillStaticsDetailMonth.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billStaticsOneToManyBillStaticsDetailMonth.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.delete_flag");
                TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "billStaticsOneToManyBillStaticsDetailMonth.accountingStartDate");
                TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "billStaticsOneToManyBillStaticsDetailMonth.accountingEndDate");
                TypedField<BigDecimal> ORDER_TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billStaticsOneToManyBillStaticsDetailMonth.orderTotalAmountWithTax");
                TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billStaticsOneToManyBillStaticsDetailMonth.invoiceAmountWithTax");
                TypedField<BigDecimal> REFUND_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billStaticsOneToManyBillStaticsDetailMonth.refundAmountWithTax");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.regionName");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.principalPerson");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.productName");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.saChargeCode");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.customerSignatoryName");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.saChargeCodeName");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.projectName");
                TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.paymentType");
                TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.paymentRequirement");
                TypedField<BigDecimal> TOTAL_ORDER_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billStaticsOneToManyBillStaticsDetailMonth.totalOrderAmountWithTax");
                TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.originContractId");
                TypedField<String> WHETHER_EFFECTIVE_OR_NOT = new TypedField<>(String.class, "billStaticsOneToManyBillStaticsDetailMonth.whetherEffectiveOrNot");
            }
        }
    }
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1511647092132646913L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface UntreatedOrderInfo {
        static Long id() {
            return 1511672926537093121L;
        }
        static String code() {
            return "untreatedOrderInfo";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRICING_UNIT = new TypedField<>(String.class, "pricingUnit");
        TypedField<Long> VERSION = new TypedField<>(Long.class, "version");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "contractId");
        TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "relatedContractId");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> PURCHASE_QUANTITY = new TypedField<>(BigDecimal.class, "purchaseQuantity");
        TypedField<BigDecimal> TOTAL_AMOUNT_STR = new TypedField<>(BigDecimal.class, "totalAmountStr");
        TypedField<BigDecimal> PAYMENT_PERCENT = new TypedField<>(BigDecimal.class, "paymentPercent");
        TypedField<String> PAYMENT_TYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "serviceType");
        TypedField<Boolean> IS_RETENTION_MONEY = new TypedField<>(Boolean.class, "isRetentionMoney");
        TypedField<String> PAYMENT_REQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<BigDecimal> WAITING_AMOUNT = new TypedField<>(BigDecimal.class, "waitingAmount");
        TypedField<BigDecimal> READY_AMOUNT = new TypedField<>(BigDecimal.class, "readyAmount");
        TypedField<BigDecimal> DISCOUNT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "discountAmountWithTax");
        TypedField<BigDecimal> PAYABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "payableAmountWithTax");
        TypedField<BigDecimal> RECEIVABLE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "receivableAmountWithTax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> ORDER_INVOICE_STATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> GENERATE_DATE = new TypedField<>(LocalDateTime.class, "generateDate");
        TypedField<LocalDateTime> EFFECTIVE_DATE = new TypedField<>(LocalDateTime.class, "effectiveDate");
        TypedField<LocalDateTime> EXPIRY_DATE = new TypedField<>(LocalDateTime.class, "expiryDate");
        TypedField<String> PAY_TYPE = new TypedField<>(String.class, "payType");
        TypedField<String> PAYMENT_CONDITION = new TypedField<>(String.class, "paymentCondition");
        TypedField<Long> CENTRAL_TENANT_ID = new TypedField<>(Long.class, "centralTenantId");
        TypedField<String> CENTRAL_TENANT_NAME = new TypedField<>(String.class, "centralTenantName");
        TypedField<String> CENTRAL_TENANT_CODE = new TypedField<>(String.class, "centralTenantCode");
        TypedField<BigDecimal> IN_ORDER_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "inOrderInvoicedAmount");
        TypedField<BigDecimal> IN_ORDER_NO_INVOICED_AMOUNT = new TypedField<>(BigDecimal.class, "inOrderNoInvoicedAmount");
        TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "originContractId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILLING_TYPE = new TypedField<>(String.class, "billingType");
        TypedField<BigDecimal> REMAIN_DEDUCT_AMOUNT = new TypedField<>(BigDecimal.class, "remainDeductAmount");
        TypedField<String> ORIGIN_REMAIN_DEDUCT_AMOUTN_ORDER = new TypedField<>(String.class, "originRemainDeductAmoutnOrder");
    }
    public interface YkbChargeCode {
        static Long id() {
            return 1517911661914198018L;
        }
        static String code() {
            return "ykbChargeCode";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> PARENT_CODE = new TypedField<>(String.class, "parentCode");
        TypedField<String> OWNER = new TypedField<>(String.class, "owner");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> AREA = new TypedField<>(String.class, "area");
        TypedField<String> LEADER = new TypedField<>(String.class, "leader");
        TypedField<String> MANAGER = new TypedField<>(String.class, "manager");
        TypedField<String> MEMBERS = new TypedField<>(String.class, "members");
        TypedField<String> ORGANIZATION = new TypedField<>(String.class, "organization");
        TypedField<String> KAM = new TypedField<>(String.class, "kam");
        TypedField<LocalDateTime> PMS_CREATE_TIME = new TypedField<>(LocalDateTime.class, "pmsCreateTime");
        TypedField<LocalDateTime> PMS_UPDATE_TIME = new TypedField<>(LocalDateTime.class, "pmsUpdateTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> SYN_STATUS = new TypedField<>(Boolean.class, "synStatus");
        TypedField<String> SYN_MSG = new TypedField<>(String.class, "synMsg");
    }
    public interface YkbChargeCodeResult {
        static Long id() {
            return 1517913257318387714L;
        }
        static String code() {
            return "ykbChargeCodeResult";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RESULT = new TypedField<>(String.class, "result");
    }
    public interface TaxNoProductBind {
        static Long id() {
            return 1522189399918768129L;
        }
        static String code() {
            return "taxNoProductBind";
        }
        TypedField<String> CONTRACT_CODE = new TypedField<>(String.class, "contractCode");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> ORDER_ID = new TypedField<>(String.class, "orderId");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operateType");
        TypedField<String> TAX_NUM = new TypedField<>(String.class, "taxNum");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<LocalDateTime> GENERAL_TIME = new TypedField<>(LocalDateTime.class, "generalTime");
        TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "contractId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> ONE_CONTRACT_TO_MULTIPLE_TAX_PRODUCT_RELATION_ID = new TypedField<>(Long.class, "oneContractToMultipleTaxProductRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_CONTRACT_TO_MULTIPLE_TAX_PRODUCT_RELATION {
                static String code () {
                    return "oneContractToMultipleTaxProductRelation" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "oneContractToMultipleTaxProductRelation.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneContractToMultipleTaxProductRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneContractToMultipleTaxProductRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractToMultipleTaxProductRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractToMultipleTaxProductRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneContractToMultipleTaxProductRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneContractToMultipleTaxProductRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "oneContractToMultipleTaxProductRelation.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "oneContractToMultipleTaxProductRelation.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneContractToMultipleTaxProductRelation.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "oneContractToMultipleTaxProductRelation.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractToMultipleTaxProductRelation.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "oneContractToMultipleTaxProductRelation.attachmentUrl");
            }
        }
    }
    public interface StandingBook {
        static Long id() {
            return 1522533478213718017L;
        }
        static String code() {
            return "standingBook";
        }
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNED_TIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURN_MONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<BigDecimal> TAKEN_MONEY = new TypedField<>(BigDecimal.class, "takenMoney");
        TypedField<String> CUSTOMER_BANK_NO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> INVOICE_COMPANY_NAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<String> BANK_NAME = new TypedField<>(String.class, "bankName");
        TypedField<String> BANK_NO = new TypedField<>(String.class, "bankNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> KAM_SEND_EMAIL_TIME = new TypedField<>(LocalDateTime.class, "kamSendEmailTime");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ACCOUNT_NAME = new TypedField<>(String.class, "accountName");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<Long> BILL_STATICS_DETAIL_ID = new TypedField<>(Long.class, "billStaticsDetailId");
        TypedField<String> OPEN_ACCOUNT_INSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> KAM_EMAIL = new TypedField<>(String.class, "kamEmail");
        TypedField<String> KAM = new TypedField<>(String.class, "kam");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECT_ITEM_NAME = new TypedField<>(String.class, "projectItemName");
    }
    public interface StandingBookAttachment {
        static Long id() {
            return 1522771577263169537L;
        }
        static String code() {
            return "standingBookAttachment";
        }
        TypedField<String> FILE_ID = new TypedField<>(String.class, "fileId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> STANDING_BOOK_ID = new TypedField<>(Long.class, "standingBookId");
    }
    public interface BugetItems {
        static Long id() {
            return 1523507028176658434L;
        }
        static String code() {
            return "bugetItems";
        }
        TypedField<String> COST_ITEM = new TypedField<>(String.class, "costItem");
        TypedField<String> PARENT_COST_ITEM = new TypedField<>(String.class, "parentCostItem");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BUDGET_DESC = new TypedField<>(String.class, "budgetDesc");
    }
    public interface ChargeCodeBudgetUsageSyn {
        static Long id() {
            return 1523912057457410050L;
        }
        static String code() {
            return "chargeCodeBudgetUsageSyn";
        }
        TypedField<String> MSG = new TypedField<>(String.class, "msg");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ChargeCodeBudgetUsage {
        static Long id() {
            return 1523913246743920642L;
        }
        static String code() {
            return "chargeCodeBudgetUsage";
        }
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> BUDGET_ID = new TypedField<>(String.class, "budgetId");
        TypedField<String> NODE_ID = new TypedField<>(String.class, "nodeId");
        TypedField<BigDecimal> BUDGET_MONEY = new TypedField<>(BigDecimal.class, "budgetMoney");
        TypedField<BigDecimal> USED_MONEY = new TypedField<>(BigDecimal.class, "usedMoney");
        TypedField<BigDecimal> LOCKED_MONEY = new TypedField<>(BigDecimal.class, "lockedMoney");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ChargeCodePoolCall {
        static Long id() {
            return 1523932141152305154L;
        }
        static String code() {
            return "chargeCodePoolCall";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> RESULT = new TypedField<>(String.class, "result");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ChargeCodeBudgetDetailCall {
        static Long id() {
            return 1523933105259216897L;
        }
        static String code() {
            return "chargeCodeBudgetDetailCall";
        }
        TypedField<String> BUDGET_ID = new TypedField<>(String.class, "budgetId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<Boolean> SUCCESS = new TypedField<>(Boolean.class, "success");
        TypedField<String> NODE_ID = new TypedField<>(String.class, "nodeId");
        TypedField<Boolean> RESULT = new TypedField<>(Boolean.class, "result");
        TypedField<String> MSG = new TypedField<>(String.class, "msg");
        TypedField<String> CALL_DATA = new TypedField<>(String.class, "callData");
    }
    public interface ChargeCodeBudgetPackge {
        static Long id() {
            return 1524247642546044930L;
        }
        static String code() {
            return "chargeCodeBudgetPackge";
        }
        TypedField<String> BUDGET_ID = new TypedField<>(String.class, "budgetId");
        TypedField<String> BUDGET_NAME = new TypedField<>(String.class, "budgetName");
        TypedField<Long> VERSION = new TypedField<>(Long.class, "version");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CC_TYPES = new TypedField<>(String.class, "ccTypes");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface OrderReceptionInfo {
        static Long id() {
            return 1525797061420748802L;
        }
        static String code() {
            return "orderReceptionInfo";
        }
        TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "contractId");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> RECEPTION_STATUS = new TypedField<>(String.class, "receptionStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> RECEPTION_TIME = new TypedField<>(LocalDateTime.class, "receptionTime");
        TypedField<String> PROJECT_SN_NO = new TypedField<>(String.class, "projectSnNo");
        TypedField<String> PROJECT_DL_NO = new TypedField<>(String.class, "projectDlNo");
    }
    public interface ContractTaxNoDetail {
        static Long id() {
            return 1527181306389004289L;
        }
        static String code() {
            return "contractTaxNoDetail";
        }
        TypedField<String> CONTRACT_CODE = new TypedField<>(String.class, "contractCode");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> ORDER_ID = new TypedField<>(String.class, "orderId");
        TypedField<String> TAX_NUM = new TypedField<>(String.class, "taxNum");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "contractId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operateType");
        TypedField<LocalDateTime> SERVICE_OPEN_TIME = new TypedField<>(LocalDateTime.class, "serviceOpenTime");
        TypedField<LocalDateTime> SERVICE_STOP_TIME = new TypedField<>(LocalDateTime.class, "serviceStopTime");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "deviceType");
        TypedField<String> DEVICE_NO = new TypedField<>(String.class, "deviceNo");
        TypedField<String> DEVICE_TYPE_PK = new TypedField<>(String.class, "deviceTypePk");
        TypedField<String> DEVICE_NO_PK = new TypedField<>(String.class, "deviceNoPk");
        TypedField<String> CHANNEL = new TypedField<>(String.class, "channel");
        /**
         * 对一关联关系 关联对象 taxNoList
         */
        TypedField<Long> ONE_TAX_NOLIST_MULTIPLE_CONTRACT_TAX_NO_ID = new TypedField<>(Long.class, "oneTaxNolistMultipleContractTaxNo.id");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> ONE_CONTRACT_ID_MULTIPLE_CONTRACT_TAX_NO_DETAIL_ID = new TypedField<>(Long.class, "oneContractIdMultipleContractTaxNoDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_TAX_NOLIST_MULTIPLE_CONTRACT_TAX_NO {
                static String code () {
                    return "oneTaxNolistMultipleContractTaxNo" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.contractNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.projectName");
                TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.productName");
                TypedField<String> TAX_NO = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.taxNo");
                TypedField<LocalDateTime> START_CHARGE_TIME = new TypedField<>(LocalDateTime.class, "oneTaxNolistMultipleContractTaxNo.startChargeTime");
                TypedField<LocalDateTime> STOP_TIME = new TypedField<>(LocalDateTime.class, "oneTaxNolistMultipleContractTaxNo.stopTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneTaxNolistMultipleContractTaxNo.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneTaxNolistMultipleContractTaxNo.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneTaxNolistMultipleContractTaxNo.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneTaxNolistMultipleContractTaxNo.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneTaxNolistMultipleContractTaxNo.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneTaxNolistMultipleContractTaxNo.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.delete_flag");
                TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.productCode");
                TypedField<String> TAX_NO_STATUS = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.taxNoStatus");
                TypedField<String> ORDER_NO = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.orderNo");
                TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.companyName");
                TypedField<LocalDateTime> OPEN_TIME = new TypedField<>(LocalDateTime.class, "oneTaxNolistMultipleContractTaxNo.openTime");
                TypedField<String> DEVICE_TYPE = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.deviceType");
                TypedField<String> DEVICE_NO = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.deviceNo");
                TypedField<LocalDateTime> ACCOUNTING_START_DATE = new TypedField<>(LocalDateTime.class, "oneTaxNolistMultipleContractTaxNo.accountingStartDate");
                TypedField<LocalDateTime> ACCOUNTING_END_DATE = new TypedField<>(LocalDateTime.class, "oneTaxNolistMultipleContractTaxNo.accountingEndDate");
                TypedField<String> DEVICE_TYPE_PK = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.deviceTypePk");
                TypedField<String> DEVICE_NO_PK = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.deviceNoPk");
                TypedField<String> ORIGIN_CONTRACT_ID = new TypedField<>(String.class, "oneTaxNolistMultipleContractTaxNo.originContractId");
            }
            interface ONE_CONTRACT_ID_MULTIPLE_CONTRACT_TAX_NO_DETAIL {
                static String code () {
                    return "oneContractIdMultipleContractTaxNoDetail" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "oneContractIdMultipleContractTaxNoDetail.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneContractIdMultipleContractTaxNoDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneContractIdMultipleContractTaxNoDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractIdMultipleContractTaxNoDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneContractIdMultipleContractTaxNoDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneContractIdMultipleContractTaxNoDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneContractIdMultipleContractTaxNoDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "oneContractIdMultipleContractTaxNoDetail.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "oneContractIdMultipleContractTaxNoDetail.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "oneContractIdMultipleContractTaxNoDetail.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "oneContractIdMultipleContractTaxNoDetail.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "oneContractIdMultipleContractTaxNoDetail.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "oneContractIdMultipleContractTaxNoDetail.attachmentUrl");
            }
        }
    }
    public interface BillSyn {
        static Long id() {
            return 1534065533414244354L;
        }
        static String code() {
            return "billSyn";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> CONTENT = new TypedField<>(String.class, "content");
    }
    public interface BillAttachmentSyn {
        static Long id() {
            return 1534065740667387905L;
        }
        static String code() {
            return "billAttachmentSyn";
        }
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> LIST = new TypedField<>(String.class, "list");
    }
    public interface BillInvoiceSyn {
        static Long id() {
            return 1534066162527711234L;
        }
        static String code() {
            return "billInvoiceSyn";
        }
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> LIST = new TypedField<>(String.class, "list");
    }
    public interface ProjectInfoUnderContract {
        static Long id() {
            return 1534379340137435138L;
        }
        static String code() {
            return "projectInfoUnderContract";
        }
        TypedField<String> PROJECT_STAGE_NAME = new TypedField<>(String.class, "projectStageName");
        TypedField<String> PROJECT_STAGE_NO = new TypedField<>(String.class, "projectStageNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PROJECT_STAGE = new TypedField<>(String.class, "projectStage");
        TypedField<String> PROJECT_STAGE_STATUS = new TypedField<>(String.class, "projectStageStatus");
        TypedField<String> RECEPTION_STATUS = new TypedField<>(String.class, "receptionStatus");
        TypedField<String> RECEPTION_DELIVERABLES = new TypedField<>(String.class, "receptionDeliverables");
        TypedField<String> PROJECT_MANAGER = new TypedField<>(String.class, "projectManager");
        TypedField<LocalDateTime> PROJECT_CREATE_TIME = new TypedField<>(LocalDateTime.class, "projectCreateTime");
        TypedField<LocalDateTime> PROJECT_STAGE_FINISH_TIME = new TypedField<>(LocalDateTime.class, "projectStageFinishTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 contract
         */
        TypedField<Long> CONRTACT_PROJECT_CONNECTION_ID = new TypedField<>(Long.class, "conrtactProjectConnection.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface CONRTACT_PROJECT_CONNECTION {
                static String code () {
                    return "conrtactProjectConnection" ;
                }
                TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "conrtactProjectConnection.contractNo");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "conrtactProjectConnection.projectNo");
                TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "conrtactProjectConnection.projectName");
                TypedField<String> PERIOD_PROMISE = new TypedField<>(String.class, "conrtactProjectConnection.periodPromise");
                TypedField<Long> PAYMENT_PERIOD = new TypedField<>(Long.class, "conrtactProjectConnection.paymentPeriod");
                TypedField<String> PAYMENT_PERIOD_TYPE = new TypedField<>(String.class, "conrtactProjectConnection.paymentPeriodType");
                TypedField<Long> ID = new TypedField<>(Long.class, "conrtactProjectConnection.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "conrtactProjectConnection.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "conrtactProjectConnection.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "conrtactProjectConnection.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "conrtactProjectConnection.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "conrtactProjectConnection.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "conrtactProjectConnection.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "conrtactProjectConnection.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "conrtactProjectConnection.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "conrtactProjectConnection.delete_flag");
                TypedField<Boolean> CONTAINS_RETENTION_MONEY = new TypedField<>(Boolean.class, "conrtactProjectConnection.containsRetentionMoney");
                TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "conrtactProjectConnection.chargeCode");
                TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "conrtactProjectConnection.contractType");
                TypedField<BigDecimal> CONTRACT_TOTAL_MONEY = new TypedField<>(BigDecimal.class, "conrtactProjectConnection.contractTotalMoney");
                TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "conrtactProjectConnection.businessUnit");
                TypedField<String> PRINCIPAL_PERSON = new TypedField<>(String.class, "conrtactProjectConnection.principalPerson");
                TypedField<String> CHARGE_CONTRACT_ID = new TypedField<>(String.class, "conrtactProjectConnection.chargeContractId");
                TypedField<String> SA_CHARGE_CODE = new TypedField<>(String.class, "conrtactProjectConnection.saChargeCode");
                TypedField<String> SA_CHARGE_CODE_NAME = new TypedField<>(String.class, "conrtactProjectConnection.saChargeCodeName");
                TypedField<BigDecimal> TOTAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "conrtactProjectConnection.totalAmountWithTax");
                TypedField<String> RELATED_CONTRACT_NO = new TypedField<>(String.class, "conrtactProjectConnection.relatedContractNo");
                TypedField<String> SIGN_TEAM_CODE = new TypedField<>(String.class, "conrtactProjectConnection.signTeamCode");
                TypedField<String> SIGN_TEAM_NAME = new TypedField<>(String.class, "conrtactProjectConnection.signTeamName");
                TypedField<String> CUSTOMER_SIGNATORY_TAX_NOS = new TypedField<>(String.class, "conrtactProjectConnection.customerSignatoryTaxNos");
                TypedField<String> CUSTOMER_SIGNATORY_NAME = new TypedField<>(String.class, "conrtactProjectConnection.customerSignatoryName");
                TypedField<String> EXPENSE_BEARER = new TypedField<>(String.class, "conrtactProjectConnection.expenseBearer");
                TypedField<String> BUSINESS_UNIT_DEPT_CODE = new TypedField<>(String.class, "conrtactProjectConnection.businessUnitDeptCode");
                TypedField<String> CUSTOMER = new TypedField<>(String.class, "conrtactProjectConnection.customer");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "conrtactProjectConnection.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "conrtactProjectConnection.kamName");
                TypedField<String> REGION_CODE = new TypedField<>(String.class, "conrtactProjectConnection.regionCode");
                TypedField<String> REGION_NAME = new TypedField<>(String.class, "conrtactProjectConnection.regionName");
                TypedField<String> OUR_SIGNATORY_NAME = new TypedField<>(String.class, "conrtactProjectConnection.ourSignatoryName");
                TypedField<String> OUR_SIGNATORY_TAX_NO = new TypedField<>(String.class, "conrtactProjectConnection.ourSignatoryTaxNo");
                TypedField<String> CHARGE_CYCLE = new TypedField<>(String.class, "conrtactProjectConnection.chargeCycle");
                TypedField<String> SIGN_DATE_STR = new TypedField<>(String.class, "conrtactProjectConnection.signDateStr");
                TypedField<String> EXPIRY_DATE_STR = new TypedField<>(String.class, "conrtactProjectConnection.expiryDateStr");
                TypedField<String> RECEIPT_SIGN_DATE_STR = new TypedField<>(String.class, "conrtactProjectConnection.receiptSignDateStr");
                TypedField<String> EFFECTIVE_DATE_STR = new TypedField<>(String.class, "conrtactProjectConnection.effectiveDateStr");
                TypedField<String> CONTRACT_STATUS = new TypedField<>(String.class, "conrtactProjectConnection.contractStatus");
                TypedField<Long> CONTRACT_VERSION = new TypedField<>(Long.class, "conrtactProjectConnection.contractVersion");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES = new TypedField<>(String.class, "conrtactProjectConnection.supplementaryAgreementTypes");
                TypedField<LocalDateTime> RECEIPT_SIGN_DATE = new TypedField<>(LocalDateTime.class, "conrtactProjectConnection.receiptSignDate");
                TypedField<String> SUPPLEMENTARY_AGREEMENT_TYPES_DESC = new TypedField<>(String.class, "conrtactProjectConnection.supplementaryAgreementTypesDesc");
                TypedField<String> MANDATORY_RENEWAL = new TypedField<>(String.class, "conrtactProjectConnection.mandatoryRenewal");
                TypedField<String> OTHER_SIGNATORY_NAME = new TypedField<>(String.class, "conrtactProjectConnection.otherSignatoryName");
                TypedField<String> OTHER_SIGNATORY_TAX_NO = new TypedField<>(String.class, "conrtactProjectConnection.otherSignatoryTaxNo");
                TypedField<String> CONTRACT_FILE_NO = new TypedField<>(String.class, "conrtactProjectConnection.contractFileNo");
                TypedField<String> WHETHER_OUTSOURCING = new TypedField<>(String.class, "conrtactProjectConnection.whetherOutsourcing");
                TypedField<String> RELATED_CONTRACT_ID = new TypedField<>(String.class, "conrtactProjectConnection.relatedContractId");
                TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "conrtactProjectConnection.attachmentUrl");
            }
        }
    }
    public interface ReturnMoneyRecordView {
        static Long id() {
            return 1534416071290335234L;
        }
        static String code() {
            return "returnMoneyRecordView";
        }
        TypedField<LocalDateTime> TAKEN_TIME = new TypedField<>(LocalDateTime.class, "takenTime");
        TypedField<String> OPERATOR = new TypedField<>(String.class, "operator");
        TypedField<BigDecimal> TAKEN_AMOUNT = new TypedField<>(BigDecimal.class, "takenAmount");
        TypedField<String> TRADE_NO = new TypedField<>(String.class, "tradeNo");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> CONTRACT_ID = new TypedField<>(String.class, "contractId");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "serviceType");
        TypedField<BigDecimal> RATE = new TypedField<>(BigDecimal.class, "rate");
        TypedField<String> OUTSOURCING = new TypedField<>(String.class, "outsourcing");
        TypedField<String> BUSINESS_UNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROCESS_TYPE = new TypedField<>(String.class, "processType");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "projectCode");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> DIMENSION_ENUM = new TypedField<>(String.class, "dimensionEnum");
        TypedField<String> MODULE_ENUM = new TypedField<>(String.class, "moduleEnum");
        TypedField<String> RESULT = new TypedField<>(String.class, "result");
    }
    public interface BillInvoice {
        static Long id() {
            return 1534417746637959170L;
        }
        static String code() {
            return "billInvoice";
        }
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        TypedField<String> INVOICE_URL = new TypedField<>(String.class, "invoiceUrl");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<LocalDateTime> INVOICE_TIME = new TypedField<>(LocalDateTime.class, "invoiceTime");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_CODE = new TypedField<>(String.class, "sellerTaxCode");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_TAX_CODE = new TypedField<>(String.class, "purchaserTaxCode");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> TAX_DEDUCTIBLE = new TypedField<>(BigDecimal.class, "taxDeductible");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_INVOICE_ID = new TypedField<>(Long.class, "billInvoice.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_INVOICE {
                static String code () {
                    return "billInvoice" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billInvoice.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billInvoice.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billInvoice.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billInvoice.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billInvoice.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billInvoice.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billInvoice.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billInvoice.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billInvoice.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billInvoice.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billInvoice.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billInvoice.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billInvoice.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billInvoice.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billInvoice.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billInvoice.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billInvoice.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billInvoice.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billInvoice.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billInvoice.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billInvoice.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billInvoice.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billInvoice.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billInvoice.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billInvoice.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billInvoice.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billInvoice.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billInvoice.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billInvoice.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billInvoice.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billInvoice.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billInvoice.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billInvoice.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billInvoice.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billInvoice.billsNumber");
            }
        }
    }
    public interface BillAttachment {
        static Long id() {
            return 1534418253691564034L;
        }
        static String code() {
            return "billAttachment";
        }
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "attachmentUrl");
        TypedField<String> ATTACHMENT_NAME = new TypedField<>(String.class, "attachmentName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_ATTACHMENT_ID = new TypedField<>(Long.class, "billAttachment.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_ATTACHMENT {
                static String code () {
                    return "billAttachment" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billAttachment.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billAttachment.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billAttachment.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billAttachment.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billAttachment.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billAttachment.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billAttachment.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billAttachment.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billAttachment.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billAttachment.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billAttachment.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billAttachment.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billAttachment.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billAttachment.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billAttachment.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billAttachment.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billAttachment.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billAttachment.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billAttachment.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billAttachment.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billAttachment.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billAttachment.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billAttachment.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billAttachment.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billAttachment.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billAttachment.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billAttachment.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billAttachment.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billAttachment.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billAttachment.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billAttachment.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billAttachment.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billAttachment.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billAttachment.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billAttachment.billsNumber");
            }
        }
    }
    public interface FinancialBasicBill {
        static Long id() {
            return 1534446067617566721L;
        }
        static String code() {
            return "financialBasicBill";
        }
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialPedestrianNumber {
        static Long id() {
            return 1534446691362091010L;
        }
        static String code() {
            return "financialPedestrianNumber";
        }
        TypedField<String> PEDESTRIAN_NUMBER = new TypedField<>(String.class, "pedestrianNumber");
        TypedField<String> PEDESTRIAN_NAME = new TypedField<>(String.class, "pedestrianName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 financialBasicBillDetail
         */
        TypedField<Long> PEDESTRIAN_NUMBER_DETAIL_ID = new TypedField<>(Long.class, "pedestrianNumberDetail.id");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> PEDESTRIA_O_T_M_ID = new TypedField<>(Long.class, "pedestriaOTM.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PEDESTRIAN_NUMBER_DETAIL {
                static String code () {
                    return "pedestrianNumberDetail" ;
                }
                TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "pedestrianNumberDetail.primaryCostTypeCode");
                TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "pedestrianNumberDetail.primaryCostTypeName");
                TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "pedestrianNumberDetail.lastCostTypeCode");
                TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "pedestrianNumberDetail.lastCostTypeName");
                TypedField<String> ORIGIN = new TypedField<>(String.class, "pedestrianNumberDetail.origin");
                TypedField<String> DESTINATION = new TypedField<>(String.class, "pedestrianNumberDetail.destination");
                TypedField<String> AMOUNT = new TypedField<>(String.class, "pedestrianNumberDetail.amount");
                TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "pedestrianNumberDetail.tripExplain");
                TypedField<Long> ID = new TypedField<>(Long.class, "pedestrianNumberDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "pedestrianNumberDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "pedestrianNumberDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "pedestrianNumberDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "pedestrianNumberDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "pedestrianNumberDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "pedestrianNumberDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "pedestrianNumberDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "pedestrianNumberDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "pedestrianNumberDetail.delete_flag");
                TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "pedestrianNumberDetail.costDate");
                TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "pedestrianNumberDetail.billTemplateDetail");
            }
            interface PEDESTRIA_O_T_M {
                static String code () {
                    return "pedestriaOTM" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "pedestriaOTM.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "pedestriaOTM.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "pedestriaOTM.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "pedestriaOTM.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "pedestriaOTM.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "pedestriaOTM.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "pedestriaOTM.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "pedestriaOTM.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "pedestriaOTM.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "pedestriaOTM.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "pedestriaOTM.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "pedestriaOTM.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "pedestriaOTM.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "pedestriaOTM.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "pedestriaOTM.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "pedestriaOTM.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "pedestriaOTM.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "pedestriaOTM.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "pedestriaOTM.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "pedestriaOTM.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "pedestriaOTM.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "pedestriaOTM.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "pedestriaOTM.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "pedestriaOTM.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "pedestriaOTM.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "pedestriaOTM.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "pedestriaOTM.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "pedestriaOTM.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "pedestriaOTM.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "pedestriaOTM.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "pedestriaOTM.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "pedestriaOTM.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "pedestriaOTM.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "pedestriaOTM.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "pedestriaOTM.billsNumber");
            }
        }
    }
    public interface FinancialBasicBillDetail {
        static Long id() {
            return 1534459021135261698L;
        }
        static String code() {
            return "financialBasicBillDetail";
        }
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialShareInfo {
        static Long id() {
            return 1534459405652275202L;
        }
        static String code() {
            return "financialShareInfo";
        }
        TypedField<String> APPORTION_PROJECT_CODE = new TypedField<>(String.class, "apportionProjectCode");
        TypedField<String> APPORTION_PROJECT_NAME = new TypedField<>(String.class, "apportionProjectName");
        TypedField<String> APPORTION_RATIO = new TypedField<>(String.class, "apportionRatio");
        TypedField<String> APPORTION_AMOUNT = new TypedField<>(String.class, "apportionAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 financialBasicBillDetail
         */
        TypedField<Long> SHARE_INFO_ID = new TypedField<>(Long.class, "shareInfo.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SHARE_INFO {
                static String code () {
                    return "shareInfo" ;
                }
                TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "shareInfo.primaryCostTypeCode");
                TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "shareInfo.primaryCostTypeName");
                TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "shareInfo.lastCostTypeCode");
                TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "shareInfo.lastCostTypeName");
                TypedField<String> ORIGIN = new TypedField<>(String.class, "shareInfo.origin");
                TypedField<String> DESTINATION = new TypedField<>(String.class, "shareInfo.destination");
                TypedField<String> AMOUNT = new TypedField<>(String.class, "shareInfo.amount");
                TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "shareInfo.tripExplain");
                TypedField<Long> ID = new TypedField<>(Long.class, "shareInfo.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "shareInfo.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "shareInfo.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "shareInfo.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "shareInfo.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "shareInfo.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "shareInfo.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "shareInfo.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "shareInfo.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "shareInfo.delete_flag");
                TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "shareInfo.costDate");
                TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "shareInfo.billTemplateDetail");
            }
        }
    }
    public interface FinancialApplyBasicBill {
        static Long id() {
            return 1534476129185378306L;
        }
        static String code() {
            return "financialApplyBasicBill";
        }
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialReimbursementBasicBill {
        static Long id() {
            return 1534477592322191361L;
        }
        static String code() {
            return "financialReimbursementBasicBill";
        }
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<String> CLAIM_DEPT = new TypedField<>(String.class, "claimDept");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> CLAIM_COMPANY_CODE = new TypedField<>(String.class, "claimCompanyCode");
        TypedField<String> CLAIM_COMPANY_NAME = new TypedField<>(String.class, "claimCompanyName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialWriteoffBasicBill {
        static Long id() {
            return 1534478033978208258L;
        }
        static String code() {
            return "financialWriteoffBasicBill";
        }
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<String> CLAIM_DEPT = new TypedField<>(String.class, "claimDept");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> CLAIM_COMPANY_CODE = new TypedField<>(String.class, "claimCompanyCode");
        TypedField<String> CLAIM_COMPANY_NAME = new TypedField<>(String.class, "claimCompanyName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialTravelApplyBill {
        static Long id() {
            return 1534478945072123906L;
        }
        static String code() {
            return "financialTravelApplyBill";
        }
        TypedField<String> BUSINESS_APPLY_CODE = new TypedField<>(String.class, "businessApplyCode");
        TypedField<String> BUSINESS_APPLY_NAME = new TypedField<>(String.class, "businessApplyName");
        TypedField<String> REPLENISH_APPLY_CODE = new TypedField<>(String.class, "replenishApplyCode");
        TypedField<String> REPLENISH_APPLY_NAME = new TypedField<>(String.class, "replenishApplyName");
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "startDate");
        TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "endDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialBusinessServeApplyBill {
        static Long id() {
            return 1534479773024727041L;
        }
        static String code() {
            return "financialBusinessServeApplyBill";
        }
        TypedField<LocalDateTime> EXPECTED_DATE = new TypedField<>(LocalDateTime.class, "expectedDate");
        TypedField<String> EXPECTED_CAUSE = new TypedField<>(String.class, "expectedCause");
        TypedField<String> SUPPLIMENTAL_DESCRIPTION = new TypedField<>(String.class, "supplimentalDescription");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> COMMENT = new TypedField<>(String.class, "comment");
        TypedField<String> APPLICATIONS_AMOUNT = new TypedField<>(String.class, "applicationsAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialTravelReimbursementBill {
        static Long id() {
            return 1534480173563981826L;
        }
        static String code() {
            return "financialTravelReimbursementBill";
        }
        TypedField<String> RELEVANCE_APPLY_NUMBER = new TypedField<>(String.class, "relevanceApplyNumber");
        TypedField<String> RELEVANCE_APPLY_TITLE = new TypedField<>(String.class, "relevanceApplyTitle");
        TypedField<String> BUSINESS_APPLY_CODE = new TypedField<>(String.class, "businessApplyCode");
        TypedField<String> BUSINESS_APPLY_NAME = new TypedField<>(String.class, "businessApplyName");
        TypedField<String> REASON = new TypedField<>(String.class, "reason");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<String> CLAIM_DEPT = new TypedField<>(String.class, "claimDept");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> CLAIM_COMPANY_CODE = new TypedField<>(String.class, "claimCompanyCode");
        TypedField<String> CLAIM_COMPANY_NAME = new TypedField<>(String.class, "claimCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialCityReimbursementBill {
        static Long id() {
            return 1534480433525755906L;
        }
        static String code() {
            return "financialCityReimbursementBill";
        }
        TypedField<LocalDateTime> LEGWORK_DATE = new TypedField<>(LocalDateTime.class, "legworkDate");
        TypedField<String> ADD_DESCRIPTION = new TypedField<>(String.class, "addDescription");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<String> CLAIM_DEPT = new TypedField<>(String.class, "claimDept");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> CLAIM_COMPANY_CODE = new TypedField<>(String.class, "claimCompanyCode");
        TypedField<String> CLAIM_COMPANY_NAME = new TypedField<>(String.class, "claimCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialBusinessServeReimbursementBill {
        static Long id() {
            return 1534480988244619266L;
        }
        static String code() {
            return "financialBusinessServeReimbursementBill";
        }
        TypedField<String> RELEVANCE_APPLY_NUMBER = new TypedField<>(String.class, "relevanceApplyNumber");
        TypedField<String> RELEVANCE_APPLY_TITLE = new TypedField<>(String.class, "relevanceApplyTitle");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> BUSINESS_APPLY_CODE = new TypedField<>(String.class, "businessApplyCode");
        TypedField<String> BUSINESS_APPLY_NAME = new TypedField<>(String.class, "businessApplyName");
        TypedField<String> ACTUAL_EXPECTED_NUMBER_RANK = new TypedField<>(String.class, "actualExpectedNumberRank");
        TypedField<String> COMMENT = new TypedField<>(String.class, "comment");
        TypedField<String> PREDICT_EXPECTED_NUMBER_RANK = new TypedField<>(String.class, "predictExpectedNumberRank");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<String> CLAIM_DEPT = new TypedField<>(String.class, "claimDept");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> CLAIM_COMPANY_CODE = new TypedField<>(String.class, "claimCompanyCode");
        TypedField<String> CLAIM_COMPANY_NAME = new TypedField<>(String.class, "claimCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialHesWriteoffBill {
        static Long id() {
            return 1534481715377549313L;
        }
        static String code() {
            return "financialHesWriteoffBill";
        }
        TypedField<String> RELEVANCE_APPLY_NUMBER = new TypedField<>(String.class, "relevanceApplyNumber");
        TypedField<String> RELEVANCE_APPLY_TITLE = new TypedField<>(String.class, "relevanceApplyTitle");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<String> CLAIM_DEPT = new TypedField<>(String.class, "claimDept");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> CLAIM_COMPANY_CODE = new TypedField<>(String.class, "claimCompanyCode");
        TypedField<String> CLAIM_COMPANY_NAME = new TypedField<>(String.class, "claimCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialHesWriteoffBillDetail {
        static Long id() {
            return 1534484610251427841L;
        }
        static String code() {
            return "financialHesWriteoffBillDetail";
        }
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> ORDER_AMOUNT = new TypedField<>(String.class, "orderAmount");
        TypedField<LocalDateTime> CONSUMPTION_START_DATE = new TypedField<>(LocalDateTime.class, "consumptionStartDate");
        TypedField<LocalDateTime> CONSUMPTION_END_DATE = new TypedField<>(LocalDateTime.class, "consumptionEndDate");
        TypedField<String> IF_APPORTION = new TypedField<>(String.class, "ifApportion");
        TypedField<String> APPORTION_PROJECT_CODE = new TypedField<>(String.class, "apportionProjectCode");
        TypedField<String> APPORTION_PROJECT_NAME = new TypedField<>(String.class, "apportionProjectName");
        TypedField<String> APPORTION_RATIO = new TypedField<>(String.class, "apportionRatio");
        TypedField<String> APPORTION_AMOUNT = new TypedField<>(String.class, "apportionAmount");
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> CLEARING_FORM = new TypedField<>(String.class, "clearingForm");
        TypedField<String> INVOICE_TAX = new TypedField<>(String.class, "invoiceTax");
        TypedField<String> INVOICE_NUMBER = new TypedField<>(String.class, "invoiceNumber");
        TypedField<String> INVOICE_QUANTITY = new TypedField<>(String.class, "invoiceQuantity");
        TypedField<String> COST_CITY = new TypedField<>(String.class, "costCity");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialBusinessServeBillDetail {
        static Long id() {
            return 1534485401772306434L;
        }
        static String code() {
            return "financialBusinessServeBillDetail";
        }
        TypedField<String> IF_APPORTION = new TypedField<>(String.class, "ifApportion");
        TypedField<String> APPORTION_PROJECT_CODE = new TypedField<>(String.class, "apportionProjectCode");
        TypedField<String> APPORTION_PROJECT_NAME = new TypedField<>(String.class, "apportionProjectName");
        TypedField<String> APPORTION_RATIO = new TypedField<>(String.class, "apportionRatio");
        TypedField<String> APPORTION_AMOUNT = new TypedField<>(String.class, "apportionAmount");
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> CLAIM_CAUSE = new TypedField<>(String.class, "claimCause");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialCityBillDetail {
        static Long id() {
            return 1534486374728011778L;
        }
        static String code() {
            return "financialCityBillDetail";
        }
        TypedField<String> IF_APPORTION = new TypedField<>(String.class, "ifApportion");
        TypedField<String> APPORTION_PROJECT_CODE = new TypedField<>(String.class, "apportionProjectCode");
        TypedField<String> APPORTION_PROJECT_NAME = new TypedField<>(String.class, "apportionProjectName");
        TypedField<String> APPORTION_RATIO = new TypedField<>(String.class, "apportionRatio");
        TypedField<String> APPORTION_AMOUNT = new TypedField<>(String.class, "apportionAmount");
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> CLEARING_FORM = new TypedField<>(String.class, "clearingForm");
        TypedField<String> INVOICE_TAX = new TypedField<>(String.class, "invoiceTax");
        TypedField<String> PARK_PLACE = new TypedField<>(String.class, "parkPlace");
        TypedField<String> PARK_MIN = new TypedField<>(String.class, "parkMin");
        TypedField<String> CONSUMPTION_CAUSE = new TypedField<>(String.class, "consumptionCause");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialTravelBillDetail {
        static Long id() {
            return 1534487741103419393L;
        }
        static String code() {
            return "financialTravelBillDetail";
        }
        TypedField<String> TRIPER_CODE = new TypedField<>(String.class, "triperCode");
        TypedField<String> TRIPER_NAME = new TypedField<>(String.class, "triperName");
        TypedField<String> ORDER_AMOUNT = new TypedField<>(String.class, "orderAmount");
        TypedField<LocalDateTime> CONSUMPTION_START_DATE = new TypedField<>(LocalDateTime.class, "consumptionStartDate");
        TypedField<LocalDateTime> CONSUMPTION_END_DATE = new TypedField<>(LocalDateTime.class, "consumptionEndDate");
        TypedField<LocalDateTime> PARK_START_DATE = new TypedField<>(LocalDateTime.class, "parkStartDate");
        TypedField<LocalDateTime> PARK_END_DATE = new TypedField<>(LocalDateTime.class, "parkEndDate");
        TypedField<LocalDateTime> BUSINESS_START_DATE = new TypedField<>(LocalDateTime.class, "businessStartDate");
        TypedField<LocalDateTime> BUSINESS_END_DATE = new TypedField<>(LocalDateTime.class, "businessEndDate");
        TypedField<String> IF_APPORTION = new TypedField<>(String.class, "ifApportion");
        TypedField<String> APPORTION_PROJECT_CODE = new TypedField<>(String.class, "apportionProjectCode");
        TypedField<String> APPORTION_PROJECT_NAME = new TypedField<>(String.class, "apportionProjectName");
        TypedField<String> APPORTION_RATIO = new TypedField<>(String.class, "apportionRatio");
        TypedField<String> APPORTION_AMOUNT = new TypedField<>(String.class, "apportionAmount");
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> CLEARING_FORM = new TypedField<>(String.class, "clearingForm");
        TypedField<String> INVOICE_TAX = new TypedField<>(String.class, "invoiceTax");
        TypedField<String> INVOICE_NUMBER = new TypedField<>(String.class, "invoiceNumber");
        TypedField<String> INVOICE_QUANTITY = new TypedField<>(String.class, "invoiceQuantity");
        TypedField<String> BOARDING_CHECK = new TypedField<>(String.class, "boardingCheck");
        TypedField<String> PREMIUM = new TypedField<>(String.class, "premium");
        TypedField<String> COST_CITY = new TypedField<>(String.class, "costCity");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialTravelApplyBillDetail {
        static Long id() {
            return 1534489337472299009L;
        }
        static String code() {
            return "financialTravelApplyBillDetail";
        }
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> BOOKER_CODE = new TypedField<>(String.class, "bookerCode");
        TypedField<String> BOOKER_NAME = new TypedField<>(String.class, "bookerName");
        TypedField<String> PSSENGER_CODE = new TypedField<>(String.class, "pssengerCode");
        TypedField<String> PSSENGER_NAME = new TypedField<>(String.class, "pssengerName");
        TypedField<LocalDateTime> APPLY_DATE = new TypedField<>(LocalDateTime.class, "applyDate");
        TypedField<LocalDateTime> TRIP_DATE = new TypedField<>(LocalDateTime.class, "tripDate");
        TypedField<String> ESTIMATED_AMOUNT = new TypedField<>(String.class, "estimatedAmount");
        TypedField<String> TRIPER_CODE = new TypedField<>(String.class, "triperCode");
        TypedField<String> TRIPER_NAME = new TypedField<>(String.class, "triperName");
        TypedField<String> TRIP_TYPE = new TypedField<>(String.class, "tripType");
        TypedField<String> DEPART_CITY = new TypedField<>(String.class, "departCity");
        TypedField<String> DESTINATION_CITY = new TypedField<>(String.class, "destinationCity");
        TypedField<LocalDateTime> DEPART_TIME = new TypedField<>(LocalDateTime.class, "departTime");
        TypedField<LocalDateTime> DESTINATION_TIME = new TypedField<>(LocalDateTime.class, "destinationTime");
        TypedField<String> CONTENT_CONSUMPTION = new TypedField<>(String.class, "contentConsumption");
        TypedField<String> REASON = new TypedField<>(String.class, "reason");
        TypedField<String> USED_CAR_CAUSE = new TypedField<>(String.class, "usedCarCause");
        TypedField<String> USED_CAR_CITY = new TypedField<>(String.class, "usedCarCity");
        TypedField<LocalDateTime> USED_CAR_START_DATE = new TypedField<>(LocalDateTime.class, "usedCarStartDate");
        TypedField<LocalDateTime> USED_CAR_END_DATE = new TypedField<>(LocalDateTime.class, "usedCarEndDate");
        TypedField<LocalDateTime> BUSINESS_START_DATE = new TypedField<>(LocalDateTime.class, "businessStartDate");
        TypedField<LocalDateTime> BUSINESS_END_DATE = new TypedField<>(LocalDateTime.class, "businessEndDate");
        TypedField<String> CONSUMPTION_CAUSE = new TypedField<>(String.class, "consumptionCause");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialTeamBuildingBill {
        static Long id() {
            return 1536626638218534914L;
        }
        static String code() {
            return "financialTeamBuildingBill";
        }
        TypedField<String> GROUP_CONSTRUCTION = new TypedField<>(String.class, "groupConstruction");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<String> CLAIM_DEPT = new TypedField<>(String.class, "claimDept");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> CLAIM_COMPANY_CODE = new TypedField<>(String.class, "claimCompanyCode");
        TypedField<String> CLAIM_COMPANY_NAME = new TypedField<>(String.class, "claimCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialPurchaseBill {
        static Long id() {
            return 1536627147247656962L;
        }
        static String code() {
            return "financialPurchaseBill";
        }
        TypedField<String> PROCUREMENT_PURPOSES = new TypedField<>(String.class, "procurementPurposes");
        TypedField<String> PROCUREMENT_TYPE_CODE = new TypedField<>(String.class, "procurementTypeCode");
        TypedField<String> PROCUREMENT_TYPE_NAME = new TypedField<>(String.class, "procurementTypeName");
        TypedField<String> PROCUREMENT_PURPOSES_CODE = new TypedField<>(String.class, "procurementPurposesCode");
        TypedField<String> PROCUREMENT_PURPOSES_NAME = new TypedField<>(String.class, "procurementPurposesName");
        TypedField<String> PROJECT_TXT = new TypedField<>(String.class, "projectTxt");
        TypedField<String> PROCUREMENT_CAUSE = new TypedField<>(String.class, "procurementCause");
        TypedField<String> PROJECT_ARCHIVES_CODE = new TypedField<>(String.class, "projectArchivesCode");
        TypedField<String> PROJECT_ARCHIVES_NAME = new TypedField<>(String.class, "projectArchivesName");
        TypedField<String> ONE_DEPR = new TypedField<>(String.class, "oneDepr");
        TypedField<String> COMPANY_CODE = new TypedField<>(String.class, "companyCode");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> PROCUREMENT_WAY_CODE = new TypedField<>(String.class, "procurementWayCode");
        TypedField<String> PROCUREMENT_WAY_NAME = new TypedField<>(String.class, "procurementWayName");
        TypedField<String> PROJECT_AREA_NAME = new TypedField<>(String.class, "projectAreaName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialPurchaseBillDetail {
        static Long id() {
            return 1536628835503906817L;
        }
        static String code() {
            return "financialPurchaseBillDetail";
        }
        TypedField<LocalDateTime> PURCHASE_APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "purchaseApplicationDate");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> PURCHASE_INSTRUCTIONS = new TypedField<>(String.class, "purchaseInstructions");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> PURCHASE_START_DATE = new TypedField<>(String.class, "purchaseStartDate");
        TypedField<String> PURCHASE_END_DATE = new TypedField<>(String.class, "purchaseEndDate");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> SPECIFICATION = new TypedField<>(String.class, "specification");
        TypedField<String> MODEL = new TypedField<>(String.class, "model");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> SUPPLIER_LINKMAN = new TypedField<>(String.class, "supplierLinkman");
        TypedField<String> CONTACT_WAY = new TypedField<>(String.class, "contactWay");
        TypedField<LocalDateTime> DELIVERY_TIME = new TypedField<>(LocalDateTime.class, "deliveryTime");
        TypedField<String> DELIVERY_WAY = new TypedField<>(String.class, "deliveryWay");
        TypedField<String> RECOMMENDED_SUPPLIER = new TypedField<>(String.class, "recommendedSupplier");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialTeamBuildingBillDetail {
        static Long id() {
            return 1536629415776223233L;
        }
        static String code() {
            return "financialTeamBuildingBillDetail";
        }
        TypedField<String> IF_APPORTION = new TypedField<>(String.class, "ifApportion");
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> CLAIM_CAUSE = new TypedField<>(String.class, "claimCause");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialDailyBill {
        static Long id() {
            return 1536631387921186818L;
        }
        static String code() {
            return "financialDailyBill";
        }
        TypedField<String> TEST = new TypedField<>(String.class, "test");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<String> CLAIM_DEPT = new TypedField<>(String.class, "claimDept");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> CLAIM_COMPANY_CODE = new TypedField<>(String.class, "claimCompanyCode");
        TypedField<String> CLAIM_COMPANY_NAME = new TypedField<>(String.class, "claimCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialPurchaseContractBill {
        static Long id() {
            return 1536632105221169153L;
        }
        static String code() {
            return "financialPurchaseContractBill";
        }
        TypedField<String> PROCUREMENT_DOCUMENTS_NO = new TypedField<>(String.class, "procurementDocumentsNo");
        TypedField<String> PROCUREMENT_DOCUMENTS_TITLE = new TypedField<>(String.class, "procurementDocumentsTitle");
        TypedField<String> CONTRACT_PARTICULARS = new TypedField<>(String.class, "contractParticulars");
        TypedField<String> CONTRACT_AMOUNT = new TypedField<>(String.class, "contractAmount");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> FEW_COPIES = new TypedField<>(String.class, "fewCopies");
        TypedField<String> MASTER_CONTRACT_CODE = new TypedField<>(String.class, "masterContractCode");
        TypedField<String> TITLE = new TypedField<>(String.class, "title");
        TypedField<String> MAILING_ADDRESS = new TypedField<>(String.class, "mailingAddress");
        TypedField<String> SUPPLIER_CODE = new TypedField<>(String.class, "supplierCode");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> PROCUREMENT_WAY_CODE = new TypedField<>(String.class, "procurementWayCode");
        TypedField<String> PROCUREMENT_WAY_NAME = new TypedField<>(String.class, "procurementWayName");
        TypedField<String> DELIVERY_WAY_CODE = new TypedField<>(String.class, "deliveryWayCode");
        TypedField<String> DELIVERY_WAY_NAME = new TypedField<>(String.class, "deliveryWayName");
        TypedField<String> CHECK_WAY_CODE = new TypedField<>(String.class, "checkWayCode");
        TypedField<String> CHECK_WAY_NAME = new TypedField<>(String.class, "checkWayName");
        TypedField<String> FILE_TYPE_CODE = new TypedField<>(String.class, "fileTypeCode");
        TypedField<String> FILE_TYPE_NAME = new TypedField<>(String.class, "fileTypeName");
        TypedField<String> SIGNATURE_TYPE_CODE = new TypedField<>(String.class, "signatureTypeCode");
        TypedField<String> SIGNATURE_TYPE_NAME = new TypedField<>(String.class, "signatureTypeName");
        TypedField<String> PROCUREMENT_STANDING_CODE = new TypedField<>(String.class, "procurementStandingCode");
        TypedField<String> PROCUREMENT_STANDING_NAME = new TypedField<>(String.class, "procurementStandingName");
        TypedField<String> PROCUREMENT_NO = new TypedField<>(String.class, "procurementNo");
        TypedField<String> PROJECT_TXT = new TypedField<>(String.class, "projectTxt");
        TypedField<String> CONTRACT_PARTY = new TypedField<>(String.class, "contractParty");
        TypedField<String> CONTRACT_PARTY_CODE = new TypedField<>(String.class, "contractPartyCode");
        TypedField<String> CONTRACT_PARTY_NAME = new TypedField<>(String.class, "contractPartyName");
        TypedField<String> PROJECT_ARCHIVES_CODE = new TypedField<>(String.class, "projectArchivesCode");
        TypedField<String> PROJECT_ARCHIVES_NAME = new TypedField<>(String.class, "projectArchivesName");
        TypedField<String> PROCUREMENTAPPLY_AMOUNT = new TypedField<>(String.class, "procurementapplyAmount");
        TypedField<String> CONTRACT_NAME = new TypedField<>(String.class, "contractName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialDailyBillDetail {
        static Long id() {
            return 1536633357281132545L;
        }
        static String code() {
            return "financialDailyBillDetail";
        }
        TypedField<String> IF_APPORTION = new TypedField<>(String.class, "ifApportion");
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> CLAIMCAUSE = new TypedField<>(String.class, "claimcause");
        TypedField<String> INVOICE_NUMBER = new TypedField<>(String.class, "invoiceNumber");
        TypedField<String> INVOICE_QUANTITY = new TypedField<>(String.class, "invoiceQuantity");
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "startDate");
        TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "endDate");
        TypedField<String> COST_CITY = new TypedField<>(String.class, "costCity");
        TypedField<String> INVOICE_TAX = new TypedField<>(String.class, "invoiceTax");
        TypedField<LocalDateTime> USED_CAR_START_DATE = new TypedField<>(LocalDateTime.class, "usedCarStartDate");
        TypedField<LocalDateTime> USED_CAR_END_DATE = new TypedField<>(LocalDateTime.class, "usedCarEndDate");
        TypedField<String> CLEARING_FORM = new TypedField<>(String.class, "clearingForm");
        TypedField<LocalDateTime> BUSINESS_START_DATE = new TypedField<>(LocalDateTime.class, "businessStartDate");
        TypedField<LocalDateTime> BUSINESS_END_DATE = new TypedField<>(LocalDateTime.class, "businessEndDate");
        TypedField<LocalDateTime> PARK_START_DATE = new TypedField<>(LocalDateTime.class, "parkStartDate");
        TypedField<LocalDateTime> PARK_END_DATE = new TypedField<>(LocalDateTime.class, "parkEndDate");
        TypedField<String> PARK_PLACE = new TypedField<>(String.class, "parkPlace");
        TypedField<String> PROCUREMENT_PURPOSES = new TypedField<>(String.class, "procurementPurposes");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> SPECIFICATION = new TypedField<>(String.class, "specification");
        TypedField<String> MODEL = new TypedField<>(String.class, "model");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> SUPPLIER_LINKMAN = new TypedField<>(String.class, "supplierLinkman");
        TypedField<String> CONTACT_WAY = new TypedField<>(String.class, "contactWay");
        TypedField<LocalDateTime> DELIVERY_TIME = new TypedField<>(LocalDateTime.class, "deliveryTime");
        TypedField<String> DELIVERY_WAY = new TypedField<>(String.class, "deliveryWay");
        TypedField<String> RECOMMENDED_SUPPLIER = new TypedField<>(String.class, "recommendedSupplier");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialPurchaseCheckBill {
        static Long id() {
            return 1536634423020224513L;
        }
        static String code() {
            return "financialPurchaseCheckBill";
        }
        TypedField<String> PROCUREMENT_DOCUMENTS_NO = new TypedField<>(String.class, "procurementDocumentsNo");
        TypedField<String> PROCUREMENT_DOCUMENTS_TITLE = new TypedField<>(String.class, "procurementDocumentsTitle");
        TypedField<String> PROCUREMENT_APPLICANT_NUMBER = new TypedField<>(String.class, "procurementApplicantNumber");
        TypedField<String> PROCUREMENT_APPLICANT_NAME = new TypedField<>(String.class, "procurementApplicantName");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> TITLE = new TypedField<>(String.class, "title");
        TypedField<String> SUPPLIER_CODE = new TypedField<>(String.class, "supplierCode");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> PROCUREMENT_STANDING_CODE = new TypedField<>(String.class, "procurementStandingCode");
        TypedField<String> PROCUREMENT_STANDING_NAME = new TypedField<>(String.class, "procurementStandingName");
        TypedField<String> IS_CHECK = new TypedField<>(String.class, "isCheck");
        TypedField<String> DING_DING_NO = new TypedField<>(String.class, "dingDingNo");
        TypedField<String> SEND_TYPE_CODE = new TypedField<>(String.class, "sendTypeCode");
        TypedField<String> SEND_TYPE_NAME = new TypedField<>(String.class, "sendTypeName");
        TypedField<String> ASSET_CATEGORIES_CODE = new TypedField<>(String.class, "assetCategoriesCode");
        TypedField<String> ASSET_CATEGORIES_NAME = new TypedField<>(String.class, "assetCategoriesName");
        TypedField<String> ASSET_SMALL_CODE = new TypedField<>(String.class, "assetSmallCode");
        TypedField<String> ASSET_SMALL_NAME = new TypedField<>(String.class, "assetSmallName");
        TypedField<String> SENT_REGIONAL_CODE = new TypedField<>(String.class, "sentRegionalCode");
        TypedField<String> SENT_REGIONAL_NAME = new TypedField<>(String.class, "sentRegionalName");
        TypedField<String> CHECK_WAY_CODE = new TypedField<>(String.class, "checkWayCode");
        TypedField<String> CHECK_WAY_NAME = new TypedField<>(String.class, "checkWayName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialPersonLoanBill {
        static Long id() {
            return 1536635248208846849L;
        }
        static String code() {
            return "financialPersonLoanBill";
        }
        TypedField<String> RESERVE_AMOUNT = new TypedField<>(String.class, "reserveAmount");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "paymentDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialPersonLoanBillDetail {
        static Long id() {
            return 1536635560055349250L;
        }
        static String code() {
            return "financialPersonLoanBillDetail";
        }
        TypedField<String> TEST = new TypedField<>(String.class, "test");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialPersonLoanBackBill {
        static Long id() {
            return 1536636414145667074L;
        }
        static String code() {
            return "financialPersonLoanBackBill";
        }
        TypedField<String> TEST = new TypedField<>(String.class, "test");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialPersonLoanBackBillDetail {
        static Long id() {
            return 1536636730717896706L;
        }
        static String code() {
            return "financialPersonLoanBackBillDetail";
        }
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialPurchasePaymentBill {
        static Long id() {
            return 1536637801264914433L;
        }
        static String code() {
            return "financialPurchasePaymentBill";
        }
        TypedField<String> RELEVANCE_PROCUREMENT_APPLY_NO = new TypedField<>(String.class, "relevanceProcurementApplyNo");
        TypedField<String> RELEVANCE_PROCUREMENT_APPLY_TITLE = new TypedField<>(String.class, "relevanceProcurementApplyTitle");
        TypedField<String> PROCUREMENT_DOCUMENTS_NO = new TypedField<>(String.class, "procurementDocumentsNo");
        TypedField<String> PROCUREMENT_DOCUMENTS_TITLE = new TypedField<>(String.class, "procurementDocumentsTitle");
        TypedField<String> RESPONSIBLE_CODE = new TypedField<>(String.class, "responsibleCode");
        TypedField<String> RESPONSIBLE_NAME = new TypedField<>(String.class, "responsibleName");
        TypedField<String> SUBMITTER_CODE = new TypedField<>(String.class, "submitterCode");
        TypedField<String> SUBMITTER_NAME = new TypedField<>(String.class, "submitterName");
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PAY_CAUSE = new TypedField<>(String.class, "payCause");
        TypedField<String> SUPPLIER_CODE = new TypedField<>(String.class, "supplierCode");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> PROCUREMENT_STANDING_CODE = new TypedField<>(String.class, "procurementStandingCode");
        TypedField<String> PROCUREMENT_STANDING_NAME = new TypedField<>(String.class, "procurementStandingName");
        TypedField<String> PAY_TYPE_CODE = new TypedField<>(String.class, "payTypeCode");
        TypedField<String> PAY_TYPE_NAME = new TypedField<>(String.class, "payTypeName");
        TypedField<String> PROJECT_ARCHIVES_CODE = new TypedField<>(String.class, "projectArchivesCode");
        TypedField<String> PROJECT_ARCHIVES_NAME = new TypedField<>(String.class, "projectArchivesName");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> ACQUISITION_PHASE_CODE = new TypedField<>(String.class, "acquisitionPhaseCode");
        TypedField<String> ACQUISITION_PHASE_NAME = new TypedField<>(String.class, "acquisitionPhaseName");
        TypedField<String> PROCUREMENT_TYPE_CODE = new TypedField<>(String.class, "procurementTypeCode");
        TypedField<String> PROCUREMENT_TYPE_NAME = new TypedField<>(String.class, "procurementTypeName");
        TypedField<String> PAYMENT_CODE = new TypedField<>(String.class, "paymentCode");
        TypedField<String> PAYMENT_NAME = new TypedField<>(String.class, "paymentName");
        TypedField<String> CONTRACT_PARTY = new TypedField<>(String.class, "contractParty");
        TypedField<String> PROCUREMENT_WAY_CODE = new TypedField<>(String.class, "procurementWayCode");
        TypedField<String> PROCUREMENT_WAY_NAME = new TypedField<>(String.class, "procurementWayName");
        TypedField<String> COMPANY_CODE = new TypedField<>(String.class, "companyCode");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> ONE_DEPT = new TypedField<>(String.class, "oneDept");
        TypedField<String> PROCUREMENT_PURPOSES_CODE = new TypedField<>(String.class, "procurementPurposesCode");
        TypedField<String> PROCUREMENT_PURPOSES_NAME = new TypedField<>(String.class, "procurementPurposesName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialRefundBill {
        static Long id() {
            return 1536638225138524162L;
        }
        static String code() {
            return "financialRefundBill";
        }
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> REFUND_AMOUNT = new TypedField<>(String.class, "refundAmount");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<String> CLAIM_COMPANY_CODE = new TypedField<>(String.class, "claimCompanyCode");
        TypedField<String> CLAIM_COMPANY_NAME = new TypedField<>(String.class, "claimCompanyName");
        TypedField<String> REFUND_PROJECT_CODE = new TypedField<>(String.class, "refundProjectCode");
        TypedField<String> REFUND_PROJECT_NAME = new TypedField<>(String.class, "refundProjectName");
        TypedField<String> REFUND_CAUSE_CODE = new TypedField<>(String.class, "refundCauseCode");
        TypedField<String> REFUND_CAUSE_NAME = new TypedField<>(String.class, "refundCauseName");
        TypedField<String> RETURN_INVOICE = new TypedField<>(String.class, "returnInvoice");
        TypedField<String> ADDITIONAL_REMARKS = new TypedField<>(String.class, "additionalRemarks");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialRefundBillDetail {
        static Long id() {
            return 1536638805440012290L;
        }
        static String code() {
            return "financialRefundBillDetail";
        }
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialPurchasePaymentBillDetail {
        static Long id() {
            return 1536639889884446721L;
        }
        static String code() {
            return "financialPurchasePaymentBillDetail";
        }
        TypedField<LocalDateTime> PURCHASE_APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "purchaseApplicationDate");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> PURCHASE_INSTRUCTIONS = new TypedField<>(String.class, "purchaseInstructions");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> SPECIFICATION = new TypedField<>(String.class, "specification");
        TypedField<String> MODEL = new TypedField<>(String.class, "model");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> SUPPLIER_LINKMAN = new TypedField<>(String.class, "supplierLinkman");
        TypedField<String> CONTACT_WAY = new TypedField<>(String.class, "contactWay");
        TypedField<LocalDateTime> DELIVERY_TIME = new TypedField<>(LocalDateTime.class, "deliveryTime");
        TypedField<String> DELIVERY_WAY = new TypedField<>(String.class, "deliveryWay");
        TypedField<String> RECOMMENDED_SUPPLIER = new TypedField<>(String.class, "recommendedSupplier");
        TypedField<String> PROCUREMENT_PURPOSES = new TypedField<>(String.class, "procurementPurposes");
        TypedField<String> IF_APPORTION = new TypedField<>(String.class, "ifApportion");
        TypedField<String> APPORTION_PROJECT_CODE = new TypedField<>(String.class, "apportionProjectCode");
        TypedField<String> APPORTION_PROJECT_NAME = new TypedField<>(String.class, "apportionProjectName");
        TypedField<String> APPORTION_RATIO = new TypedField<>(String.class, "apportionRatio");
        TypedField<String> APPORTION_AMOUNT = new TypedField<>(String.class, "apportionAmount");
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialAssetsBill {
        static Long id() {
            return 1536640591227854849L;
        }
        static String code() {
            return "financialAssetsBill";
        }
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<String> ASSET_CATEGORIES_CODE = new TypedField<>(String.class, "assetCategoriesCode");
        TypedField<String> ASSET_CATEGORIES_NAME = new TypedField<>(String.class, "assetCategoriesName");
        TypedField<String> ASSETS_REGIONAL_CODE = new TypedField<>(String.class, "assetsRegionalCode");
        TypedField<String> ASSETS_REGIONAL_NAME = new TypedField<>(String.class, "assetsRegionalName");
        TypedField<String> TEMPLATE_CODE = new TypedField<>(String.class, "templateCode");
        TypedField<String> TEMPLATE_NAME = new TypedField<>(String.class, "templateName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialAssetsBillDetail {
        static Long id() {
            return 1536640765424435201L;
        }
        static String code() {
            return "financialAssetsBillDetail";
        }
        TypedField<String> TEST = new TypedField<>(String.class, "test");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialAssetsBackBill {
        static Long id() {
            return 1536641951270117378L;
        }
        static String code() {
            return "financialAssetsBackBill";
        }
        TypedField<String> NEW_DUTY_DEPT = new TypedField<>(String.class, "newDutyDept");
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> NEW_DUTY_CODE = new TypedField<>(String.class, "newDutyCode");
        TypedField<String> NEW_DUTY_NAME = new TypedField<>(String.class, "newDutyName");
        TypedField<String> ASSET_TYPES = new TypedField<>(String.class, "assetTypes");
        TypedField<String> ASSET_CODE = new TypedField<>(String.class, "assetCode");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialInvoicePledgeBill {
        static Long id() {
            return 1536642359059881985L;
        }
        static String code() {
            return "financialInvoicePledgeBill";
        }
        TypedField<String> PROCUREMENT_DOCUMENTS_NO = new TypedField<>(String.class, "procurementDocumentsNo");
        TypedField<String> PROCUREMENT_DOCUMENTS_TITLE = new TypedField<>(String.class, "procurementDocumentsTitle");
        TypedField<String> RESPONSIBLE_CODE = new TypedField<>(String.class, "responsibleCode");
        TypedField<String> RESPONSIBLE_NAME = new TypedField<>(String.class, "responsibleName");
        TypedField<String> REPLEVIN_CODE = new TypedField<>(String.class, "replevinCode");
        TypedField<String> REPLEVIN_NAME = new TypedField<>(String.class, "replevinName");
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> SUPPLIER_CODE = new TypedField<>(String.class, "supplierCode");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> VERIFICATION_TYPE_CODE = new TypedField<>(String.class, "verificationTypeCode");
        TypedField<String> VERIFICATION_TYPE_NAME = new TypedField<>(String.class, "verificationTypeName");
        TypedField<String> PAYMENT_CODE = new TypedField<>(String.class, "paymentCode");
        TypedField<String> PAYMENT_NAME = new TypedField<>(String.class, "paymentName");
        TypedField<String> CONTRACT_PARTY = new TypedField<>(String.class, "contractParty");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<String> CLAIM_DEPT = new TypedField<>(String.class, "claimDept");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> CLAIM_COMPANY_CODE = new TypedField<>(String.class, "claimCompanyCode");
        TypedField<String> CLAIM_COMPANY_NAME = new TypedField<>(String.class, "claimCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialAssetsBackBillDetail {
        static Long id() {
            return 1536642621637337090L;
        }
        static String code() {
            return "financialAssetsBackBillDetail";
        }
        TypedField<String> TEST = new TypedField<>(String.class, "test");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialInvoicePledgeBillDetail {
        static Long id() {
            return 1536643684334116865L;
        }
        static String code() {
            return "financialInvoicePledgeBillDetail";
        }
        TypedField<LocalDateTime> PURCHASE_APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "purchaseApplicationDate");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> SPECIFICATION = new TypedField<>(String.class, "specification");
        TypedField<String> MODEL = new TypedField<>(String.class, "model");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> SUPPLIER_LINKMAN = new TypedField<>(String.class, "supplierLinkman");
        TypedField<String> CONTACT_WAY = new TypedField<>(String.class, "contactWay");
        TypedField<LocalDateTime> DELIVERY_TIME = new TypedField<>(LocalDateTime.class, "deliveryTime");
        TypedField<String> DELIVERY_WAY = new TypedField<>(String.class, "deliveryWay");
        TypedField<String> RECOMMENDED_SUPPLIER = new TypedField<>(String.class, "recommendedSupplier");
        TypedField<String> IF_APPORTION = new TypedField<>(String.class, "ifApportion");
        TypedField<String> APPORTION_PROJECT_CODE = new TypedField<>(String.class, "apportionProjectCode");
        TypedField<String> APPORTION_PROJECT_NAME = new TypedField<>(String.class, "apportionProjectName");
        TypedField<String> APPORTION_RATIO = new TypedField<>(String.class, "apportionRatio");
        TypedField<String> APPORTION_AMOUNT = new TypedField<>(String.class, "apportionAmount");
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<LocalDateTime> RETURN_TIME = new TypedField<>(LocalDateTime.class, "returnTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialAssetsTransferBill {
        static Long id() {
            return 1536643792302637057L;
        }
        static String code() {
            return "financialAssetsTransferBill";
        }
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<String> ASSET_CATEGORIES_CODE = new TypedField<>(String.class, "assetCategoriesCode");
        TypedField<String> ASSET_CATEGORIES_NAME = new TypedField<>(String.class, "assetCategoriesName");
        TypedField<String> CALL_PLACE_CODE = new TypedField<>(String.class, "callPlaceCode");
        TypedField<String> CALL_PLACE_NAME = new TypedField<>(String.class, "callPlaceName");
        TypedField<String> ASSETS_REGIONAL_CODE = new TypedField<>(String.class, "assetsRegionalCode");
        TypedField<String> ASSETS_REGIONAL_NAME = new TypedField<>(String.class, "assetsRegionalName");
        TypedField<String> TEMPLATE_CODE = new TypedField<>(String.class, "templateCode");
        TypedField<String> TEMPLATE_NAME = new TypedField<>(String.class, "templateName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialAssetsTransferBillDetail {
        static Long id() {
            return 1536644789671632897L;
        }
        static String code() {
            return "financialAssetsTransferBillDetail";
        }
        TypedField<String> TEST = new TypedField<>(String.class, "test");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialPurchaseAfterSaleBill {
        static Long id() {
            return 1536646052952801281L;
        }
        static String code() {
            return "financialPurchaseAfterSaleBill";
        }
        TypedField<String> PROCUREMENT_DOCUMENTS_NO = new TypedField<>(String.class, "procurementDocumentsNo");
        TypedField<String> PROCUREMENT_DOCUMENTS_TITLE = new TypedField<>(String.class, "procurementDocumentsTitle");
        TypedField<String> ASSET_ADMINISTRATOR_CODE = new TypedField<>(String.class, "assetAdministratorCode");
        TypedField<String> ASSET_ADMINISTRATOR_NAME = new TypedField<>(String.class, "assetAdministratorName");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> ACQUISITION_PHASE_CODE = new TypedField<>(String.class, "acquisitionPhaseCode");
        TypedField<String> ACQUISITION_PHASE_NAME = new TypedField<>(String.class, "acquisitionPhaseName");
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialKeeperChangeBill {
        static Long id() {
            return 1536646144510263297L;
        }
        static String code() {
            return "financialKeeperChangeBill";
        }
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> ASSET_TYPES = new TypedField<>(String.class, "assetTypes");
        TypedField<String> ASSET_CODE = new TypedField<>(String.class, "assetCode");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<String> ASSET_CATEGORIES_CODE = new TypedField<>(String.class, "assetCategoriesCode");
        TypedField<String> ASSET_CATEGORIES_NAME = new TypedField<>(String.class, "assetCategoriesName");
        TypedField<String> ASSETS_REGIONAL_CODE = new TypedField<>(String.class, "assetsRegionalCode");
        TypedField<String> ASSETS_REGIONAL_NAME = new TypedField<>(String.class, "assetsRegionalName");
        TypedField<String> TEMPLATE_CODE = new TypedField<>(String.class, "templateCode");
        TypedField<String> TEMPLATE_NAME = new TypedField<>(String.class, "templateName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialKeeperChangeBillDetail {
        static Long id() {
            return 1536646289609269249L;
        }
        static String code() {
            return "financialKeeperChangeBillDetail";
        }
        TypedField<String> TEST = new TypedField<>(String.class, "test");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialResponsibleChangeBill {
        static Long id() {
            return 1536647106282201089L;
        }
        static String code() {
            return "financialResponsibleChangeBill";
        }
        TypedField<String> PROCUREMENT_DOCUMENTS_NO = new TypedField<>(String.class, "procurementDocumentsNo");
        TypedField<String> PROCUREMENT_DOCUMENTS_TITLE = new TypedField<>(String.class, "procurementDocumentsTitle");
        TypedField<String> CHANGE_RESPONSIBLE_CODE = new TypedField<>(String.class, "changeResponsibleCode");
        TypedField<String> CHANGE_RESPONSIBLE_NAME = new TypedField<>(String.class, "changeResponsibleName");
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> CHANGE_CAUSE = new TypedField<>(String.class, "changeCause");
        TypedField<String> PROCUREMENT_NO = new TypedField<>(String.class, "procurementNo");
        TypedField<String> CONTRACT_PARTY = new TypedField<>(String.class, "contractParty");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> CONTRACT_NO = new TypedField<>(String.class, "contractNo");
        TypedField<String> CHECK_WAY_CODE = new TypedField<>(String.class, "checkWayCode");
        TypedField<String> CHECK_WAY_NAME = new TypedField<>(String.class, "checkWayName");
        TypedField<String> PROJECT_TXT = new TypedField<>(String.class, "projectTxt");
        TypedField<String> PROCUREMENT_TYPE_CODE = new TypedField<>(String.class, "procurementTypeCode");
        TypedField<String> PROCUREMENT_TYPE_NAME = new TypedField<>(String.class, "procurementTypeName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialInventorySaleDeliveryBill {
        static Long id() {
            return 1536647889649606657L;
        }
        static String code() {
            return "financialInventorySaleDeliveryBill";
        }
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> DELIVERY_ADDRESS = new TypedField<>(String.class, "deliveryAddress");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialSaleReturnBill {
        static Long id() {
            return 1536648308372668418L;
        }
        static String code() {
            return "financialSaleReturnBill";
        }
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialPurchAsassetBorrowBill {
        static Long id() {
            return 1536648866414927874L;
        }
        static String code() {
            return "financialPurchAsassetBorrowBill";
        }
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> USE_PURPOSE = new TypedField<>(String.class, "usePurpose");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<LocalDateTime> EXPECTED_DATE = new TypedField<>(LocalDateTime.class, "expectedDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialAssembleBill {
        static Long id() {
            return 1536649190196977665L;
        }
        static String code() {
            return "financialAssembleBill";
        }
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> USE_PURPOSE = new TypedField<>(String.class, "usePurpose");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialDisassemblyBill {
        static Long id() {
            return 1536649474723225601L;
        }
        static String code() {
            return "financialDisassemblyBill";
        }
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> USE_PURPOSE = new TypedField<>(String.class, "usePurpose");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialTransferBill {
        static Long id() {
            return 1536650003545268226L;
        }
        static String code() {
            return "financialTransferBill";
        }
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<String> ORIGINAL_LOCATION_CODE = new TypedField<>(String.class, "originalLocationCode");
        TypedField<String> ORIGINAL_LOCATION_NAME = new TypedField<>(String.class, "originalLocationName");
        TypedField<String> NER_LOCATION_CODE = new TypedField<>(String.class, "nerLocationCode");
        TypedField<String> NER_LOCATION_NAME = new TypedField<>(String.class, "nerLocationName");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialAccessoriesrReplaceBill {
        static Long id() {
            return 1536650563463880705L;
        }
        static String code() {
            return "financialAccessoriesrReplaceBill";
        }
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<String> ASSET_CATEGORIES_CODE = new TypedField<>(String.class, "assetCategoriesCode");
        TypedField<String> ASSET_CATEGORIES_NAME = new TypedField<>(String.class, "assetCategoriesName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialAssetCheckBill {
        static Long id() {
            return 1536651209959874562L;
        }
        static String code() {
            return "financialAssetCheckBill";
        }
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<String> ASSET_CATEGORIES_CODE = new TypedField<>(String.class, "assetCategoriesCode");
        TypedField<String> ASSET_CATEGORIES_NAME = new TypedField<>(String.class, "assetCategoriesName");
        TypedField<String> IS_DIFFERENCE = new TypedField<>(String.class, "isDifference");
        TypedField<String> IS_MORE_LAKH = new TypedField<>(String.class, "isMoreLakh");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialAssetScrapBill {
        static Long id() {
            return 1536651814738010114L;
        }
        static String code() {
            return "financialAssetScrapBill";
        }
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<String> ASSET_CATEGORIES_CODE = new TypedField<>(String.class, "assetCategoriesCode");
        TypedField<String> ASSET_CATEGORIES_NAME = new TypedField<>(String.class, "assetCategoriesName");
        TypedField<String> ASSET_SMALL_CODE = new TypedField<>(String.class, "assetSmallCode");
        TypedField<String> ASSET_SMALL_NAME = new TypedField<>(String.class, "assetSmallName");
        TypedField<String> IS_MORE_LAKH = new TypedField<>(String.class, "isMoreLakh");
        TypedField<String> ASSETS_REGIONAL_CODE = new TypedField<>(String.class, "assetsRegionalCode");
        TypedField<String> ASSETS_REGIONAL_NAME = new TypedField<>(String.class, "assetsRegionalName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialSalaryBill {
        static Long id() {
            return 1536662601184968705L;
        }
        static String code() {
            return "financialSalaryBill";
        }
        TypedField<String> VERIFICATION_DUTY_CODE = new TypedField<>(String.class, "verificationDutyCode");
        TypedField<String> VERIFICATION_DUTY_NAME = new TypedField<>(String.class, "verificationDutyName");
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<String> SUPPLIER_CODE = new TypedField<>(String.class, "supplierCode");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> PAYMENT_CODE = new TypedField<>(String.class, "paymentCode");
        TypedField<String> PAYMENT_NAME = new TypedField<>(String.class, "paymentName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialSalaryBillDetail {
        static Long id() {
            return 1536662812302319618L;
        }
        static String code() {
            return "financialSalaryBillDetail";
        }
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> SERVICE_FEE_TYPE = new TypedField<>(String.class, "serviceFeeType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialInvoiceCheckBill {
        static Long id() {
            return 1536663482837311490L;
        }
        static String code() {
            return "financialInvoiceCheckBill";
        }
        TypedField<String> SALARY_LEDGER_CODE = new TypedField<>(String.class, "salaryLedgerCode");
        TypedField<String> SALARY_LEDGER_NAME = new TypedField<>(String.class, "salaryLedgerName");
        TypedField<String> VERIFICATION_DUTY_CODE = new TypedField<>(String.class, "verificationDutyCode");
        TypedField<String> VERIFICATION_DUTY_NAME = new TypedField<>(String.class, "verificationDutyName");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> VERIFICATION_APPLY_DATE = new TypedField<>(String.class, "verificationApplyDate");
        TypedField<String> PAYMENT_CODE = new TypedField<>(String.class, "paymentCode");
        TypedField<String> PAYMENT_NAME = new TypedField<>(String.class, "paymentName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<String> CLAIM_DEPT = new TypedField<>(String.class, "claimDept");
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> CLAIM_COMPANY_CODE = new TypedField<>(String.class, "claimCompanyCode");
        TypedField<String> CLAIM_COMPANY_NAME = new TypedField<>(String.class, "claimCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialInvoiceCheckBillDetail {
        static Long id() {
            return 1536663635360423938L;
        }
        static String code() {
            return "financialInvoiceCheckBillDetail";
        }
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> SERVICE_FEE_TYPE = new TypedField<>(String.class, "serviceFeeType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialLaborUnionBill {
        static Long id() {
            return 1536664464582713345L;
        }
        static String code() {
            return "financialLaborUnionBill";
        }
        TypedField<String> DUE_BANK = new TypedField<>(String.class, "dueBank");
        TypedField<String> ACCOUNT_NUMBER = new TypedField<>(String.class, "accountNumber");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<LocalDateTime> ACTIVITY_DATE = new TypedField<>(LocalDateTime.class, "activityDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialLaborUnionBillDetail {
        static Long id() {
            return 1536664665990496258L;
        }
        static String code() {
            return "financialLaborUnionBillDetail";
        }
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<LocalDateTime> APPLY_DATE = new TypedField<>(LocalDateTime.class, "applyDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialPurchaseRedAdjustBill {
        static Long id() {
            return 1536665510354223106L;
        }
        static String code() {
            return "financialPurchaseRedAdjustBill";
        }
        TypedField<String> TITLE = new TypedField<>(String.class, "title");
        TypedField<String> ORIGINA_DOCUMENT_NUMBER = new TypedField<>(String.class, "originaDocumentNumber");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialPurchaseRedAdjustBillDetail {
        static Long id() {
            return 1536666315900919809L;
        }
        static String code() {
            return "financialPurchaseRedAdjustBillDetail";
        }
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> IF_APPORTION = new TypedField<>(String.class, "ifApportion");
        TypedField<String> APPORTION_PROJECT_CODE = new TypedField<>(String.class, "apportionProjectCode");
        TypedField<String> APPORTION_PROJECT_NAME = new TypedField<>(String.class, "apportionProjectName");
        TypedField<String> APPORTION_RATIO = new TypedField<>(String.class, "apportionRatio");
        TypedField<String> APPORTION_AMOUNT = new TypedField<>(String.class, "apportionAmount");
        TypedField<String> TITLE = new TypedField<>(String.class, "title");
        TypedField<String> SUBMISSION_DATE = new TypedField<>(String.class, "submissionDate");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CHARGE_NAME = new TypedField<>(String.class, "chargeName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialProjectShareAdjustBill {
        static Long id() {
            return 1536667319451066370L;
        }
        static String code() {
            return "financialProjectShareAdjustBill";
        }
        TypedField<String> TITLE = new TypedField<>(String.class, "title");
        TypedField<String> ORIGINA_DOCUMENT_NUMBER = new TypedField<>(String.class, "originaDocumentNumber");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialProjectShareAdjustBillDetail {
        static Long id() {
            return 1536667988095868929L;
        }
        static String code() {
            return "financialProjectShareAdjustBillDetail";
        }
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> IF_APPORTION = new TypedField<>(String.class, "ifApportion");
        TypedField<String> APPORTION_PROJECT_CODE = new TypedField<>(String.class, "apportionProjectCode");
        TypedField<String> APPORTION_PROJECT_NAME = new TypedField<>(String.class, "apportionProjectName");
        TypedField<String> APPORTION_RATIO = new TypedField<>(String.class, "apportionRatio");
        TypedField<String> APPORTION_AMOUNT = new TypedField<>(String.class, "apportionAmount");
        TypedField<String> TITLE = new TypedField<>(String.class, "title");
        TypedField<LocalDateTime> SUBMISSION_DATE = new TypedField<>(LocalDateTime.class, "submissionDate");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CHARGE_NAME = new TypedField<>(String.class, "chargeName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
    public interface FinancialCostTypeAdjustBill {
        static Long id() {
            return 1536668610139070466L;
        }
        static String code() {
            return "financialCostTypeAdjustBill";
        }
        TypedField<String> TITLE = new TypedField<>(String.class, "title");
        TypedField<String> ORIGINA_DOCUMENT_NUMBER = new TypedField<>(String.class, "originaDocumentNumber");
        TypedField<String> DESCRIBE = new TypedField<>(String.class, "describe");
        TypedField<String> APPLICATION_DEPT = new TypedField<>(String.class, "applicationDept");
        TypedField<LocalDateTime> CLAIM_DATE = new TypedField<>(LocalDateTime.class, "claimDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> APPLICATION_DATE = new TypedField<>(LocalDateTime.class, "applicationDate");
        TypedField<String> APPLICANT_DEPT = new TypedField<>(String.class, "applicantDept");
        TypedField<String> APPLICANT_COMPANY_CODE = new TypedField<>(String.class, "applicantCompanyCode");
        TypedField<String> APPLICANT_COMPANY_NAME = new TypedField<>(String.class, "applicantCompanyName");
        TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "applicantNumber");
        TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "applicantName");
        TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "travelReason");
        TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "costCenterCode");
        TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "costCenterName");
        TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "projectAreaCode");
        TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "projectAreaname");
        TypedField<String> KAM_CODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAM_NAME = new TypedField<>(String.class, "kamName");
        TypedField<String> LEADER_CODE = new TypedField<>(String.class, "leaderCode");
        TypedField<String> LEADER_NAME = new TypedField<>(String.class, "leaderName");
        TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "projectTypeCode");
        TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "projectTypeName");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "projectBudgetTypeCode");
        TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "projectBudgetTypeName");
        TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "staffEmail");
        TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billTemplate");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billType");
        TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "newSupplement");
        TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "supplementaryApplicationName");
        TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "supplementaryApplicationCode");
        TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billTemplateType");
        TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billsNumber");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface FinancialCostTypeAdjustBillDetail {
        static Long id() {
            return 1536669750002843649L;
        }
        static String code() {
            return "financialCostTypeAdjustBillDetail";
        }
        TypedField<String> INVOICE_FORM = new TypedField<>(String.class, "invoiceForm");
        TypedField<String> CAUSE = new TypedField<>(String.class, "cause");
        TypedField<String> IF_APPORTION = new TypedField<>(String.class, "ifApportion");
        TypedField<String> APPORTION_PROJECT_CODE = new TypedField<>(String.class, "apportionProjectCode");
        TypedField<String> APPORTION_PROJECT_NAME = new TypedField<>(String.class, "apportionProjectName");
        TypedField<String> APPORTION_RATIO = new TypedField<>(String.class, "apportionRatio");
        TypedField<String> APPORTION_AMOUNT = new TypedField<>(String.class, "apportionAmount");
        TypedField<String> TITLE = new TypedField<>(String.class, "title");
        TypedField<String> OWNER_CODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNER_NAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CHARGE_NAME = new TypedField<>(String.class, "chargeName");
        TypedField<LocalDateTime> SUBMISSION_DATE = new TypedField<>(LocalDateTime.class, "submissionDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRIMARY_COST_TYPE_CODE = new TypedField<>(String.class, "primaryCostTypeCode");
        TypedField<String> PRIMARY_COST_TYPE_NAME = new TypedField<>(String.class, "primaryCostTypeName");
        TypedField<String> LAST_COST_TYPE_CODE = new TypedField<>(String.class, "lastCostTypeCode");
        TypedField<String> LAST_COST_TYPE_NAME = new TypedField<>(String.class, "lastCostTypeName");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> AMOUNT = new TypedField<>(String.class, "amount");
        TypedField<String> TRIP_EXPLAIN = new TypedField<>(String.class, "tripExplain");
        TypedField<LocalDateTime> COST_DATE = new TypedField<>(LocalDateTime.class, "costDate");
        TypedField<String> BILL_TEMPLATE_DETAIL = new TypedField<>(String.class, "billTemplateDetail");
        /**
         * 对一关联关系 关联对象 financialBasicBill
         */
        TypedField<Long> BILL_DETAIL_ID = new TypedField<>(Long.class, "billDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL {
                static String code () {
                    return "billDetail" ;
                }
                TypedField<String> APPLICANT_NUMBER = new TypedField<>(String.class, "billDetail.applicantNumber");
                TypedField<String> APPLICANT_NAME = new TypedField<>(String.class, "billDetail.applicantName");
                TypedField<String> TRAVEL_REASON = new TypedField<>(String.class, "billDetail.travelReason");
                TypedField<String> COST_CENTER_CODE = new TypedField<>(String.class, "billDetail.costCenterCode");
                TypedField<String> COST_CENTER_NAME = new TypedField<>(String.class, "billDetail.costCenterName");
                TypedField<String> PROJECT_AREA_CODE = new TypedField<>(String.class, "billDetail.projectAreaCode");
                TypedField<String> PROJECT_AREANAME = new TypedField<>(String.class, "billDetail.projectAreaname");
                TypedField<String> KAM_CODE = new TypedField<>(String.class, "billDetail.kamCode");
                TypedField<String> KAM_NAME = new TypedField<>(String.class, "billDetail.kamName");
                TypedField<String> LEADER_CODE = new TypedField<>(String.class, "billDetail.leaderCode");
                TypedField<String> LEADER_NAME = new TypedField<>(String.class, "billDetail.leaderName");
                TypedField<String> PROJECT_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectTypeCode");
                TypedField<String> PROJECT_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectTypeName");
                TypedField<String> OWNER_CODE = new TypedField<>(String.class, "billDetail.ownerCode");
                TypedField<String> OWNER_NAME = new TypedField<>(String.class, "billDetail.ownerName");
                TypedField<String> PROJECT_BUDGET_TYPE_CODE = new TypedField<>(String.class, "billDetail.projectBudgetTypeCode");
                TypedField<String> PROJECT_BUDGET_TYPE_NAME = new TypedField<>(String.class, "billDetail.projectBudgetTypeName");
                TypedField<String> STAFF_EMAIL = new TypedField<>(String.class, "billDetail.staffEmail");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetail.delete_flag");
                TypedField<String> BILL_TEMPLATE = new TypedField<>(String.class, "billDetail.billTemplate");
                TypedField<String> BILL_TYPE = new TypedField<>(String.class, "billDetail.billType");
                TypedField<String> NEW_SUPPLEMENT = new TypedField<>(String.class, "billDetail.newSupplement");
                TypedField<String> SUPPLEMENTARY_APPLICATION_NAME = new TypedField<>(String.class, "billDetail.supplementaryApplicationName");
                TypedField<String> SUPPLEMENTARY_APPLICATION_CODE = new TypedField<>(String.class, "billDetail.supplementaryApplicationCode");
                TypedField<String> BILL_TEMPLATE_TYPE = new TypedField<>(String.class, "billDetail.billTemplateType");
                TypedField<String> BILLS_NUMBER = new TypedField<>(String.class, "billDetail.billsNumber");
            }
        }
    }
}
