package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pms源数据类型定义
 * </p>
 *
 * @author ultraman
 * @since 2022-08-29
 */
public enum PmsMateDataEnum {

    BASIS("basis", "chargeCode基础数据"),
    BUDGET("budget", "chargeCode预算数据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PmsMateDataEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PmsMateDataEnum fromCode(String code){
        switch(code) {
            case "basis":
                return BASIS;
            case "budget":
                return BUDGET;
            default:
                return null;
        }
    }
}
