package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * department_cost
 * </p>
 *
 * @author ultraman
 * @since 2022-08-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DepartmentCost implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 月份
   */
  private String chargeMonth;
  /**
   * 一级部门编号
   */
  private String firstDepartmentNo;
  /**
   * 一级部门名称
   */
  private String firstDepartmentName;
  /**
   * 人工成本
   */
  private BigDecimal memberCost;
  /**
   * A01B01
   */
  private BigDecimal a01B01;
  /**
   * 业务条线季度奖金
   */
  private BigDecimal businessQuarterBonus;
  /**
   * 非业务条线年终奖金
   */
  private BigDecimal noBusinessQuarterBonus;
  /**
   * 业务条线年底奖金
   */
  private BigDecimal businessYearBonus;
  /**
   * 离职补偿金
   */
  private BigDecimal dimissionCost;
  /**
   * ESOP
   */
  private BigDecimal esopCost;
  /**
   * 其他
   */
  private BigDecimal otherCost;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("chargeMonth", chargeMonth);
      map.put("firstDepartmentNo", firstDepartmentNo);
      map.put("firstDepartmentName", firstDepartmentName);
      map.put("memberCost", memberCost);
      map.put("a01B01", a01B01);
      map.put("businessQuarterBonus", businessQuarterBonus);
      map.put("noBusinessQuarterBonus", noBusinessQuarterBonus);
      map.put("businessYearBonus", businessYearBonus);
      map.put("dimissionCost", dimissionCost);
      map.put("esopCost", esopCost);
      map.put("otherCost", otherCost);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static DepartmentCost fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    DepartmentCost entity = new DepartmentCost();

    if(map.containsKey("chargeMonth")) {
      Object obj = map.get("chargeMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstDepartmentNo")) {
      Object obj = map.get("firstDepartmentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFirstDepartmentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstDepartmentName")) {
      Object obj = map.get("firstDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFirstDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("memberCost")) {
      Object obj = map.get("memberCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMemberCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMemberCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMemberCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMemberCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMemberCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("a01B01")) {
      Object obj = map.get("a01B01");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setA01B01((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setA01B01(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setA01B01(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setA01B01(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setA01B01(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("businessQuarterBonus")) {
      Object obj = map.get("businessQuarterBonus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBusinessQuarterBonus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBusinessQuarterBonus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBusinessQuarterBonus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessQuarterBonus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessQuarterBonus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("noBusinessQuarterBonus")) {
      Object obj = map.get("noBusinessQuarterBonus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNoBusinessQuarterBonus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNoBusinessQuarterBonus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNoBusinessQuarterBonus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNoBusinessQuarterBonus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNoBusinessQuarterBonus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("businessYearBonus")) {
      Object obj = map.get("businessYearBonus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBusinessYearBonus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBusinessYearBonus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBusinessYearBonus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessYearBonus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessYearBonus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("dimissionCost")) {
      Object obj = map.get("dimissionCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDimissionCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDimissionCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDimissionCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDimissionCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDimissionCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("esopCost")) {
      Object obj = map.get("esopCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEsopCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEsopCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEsopCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEsopCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEsopCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("otherCost")) {
      Object obj = map.get("otherCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOtherCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOtherCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOtherCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOtherCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOtherCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("chargeMonth")) {
      Object obj = map.get("chargeMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeMonth((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("firstDepartmentNo")) {
      Object obj = map.get("firstDepartmentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFirstDepartmentNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("firstDepartmentName")) {
      Object obj = map.get("firstDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFirstDepartmentName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("memberCost")) {
      Object obj = map.get("memberCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setMemberCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setMemberCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setMemberCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMemberCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setMemberCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("a01B01")) {
      Object obj = map.get("a01B01");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setA01B01((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setA01B01(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setA01B01(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setA01B01(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setA01B01(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("businessQuarterBonus")) {
      Object obj = map.get("businessQuarterBonus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBusinessQuarterBonus((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBusinessQuarterBonus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBusinessQuarterBonus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBusinessQuarterBonus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBusinessQuarterBonus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("noBusinessQuarterBonus")) {
      Object obj = map.get("noBusinessQuarterBonus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setNoBusinessQuarterBonus((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setNoBusinessQuarterBonus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setNoBusinessQuarterBonus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNoBusinessQuarterBonus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setNoBusinessQuarterBonus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("businessYearBonus")) {
      Object obj = map.get("businessYearBonus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBusinessYearBonus((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBusinessYearBonus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBusinessYearBonus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBusinessYearBonus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBusinessYearBonus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("dimissionCost")) {
      Object obj = map.get("dimissionCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDimissionCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDimissionCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDimissionCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDimissionCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDimissionCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("esopCost")) {
      Object obj = map.get("esopCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setEsopCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setEsopCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setEsopCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEsopCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setEsopCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("otherCost")) {
      Object obj = map.get("otherCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOtherCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOtherCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOtherCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOtherCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOtherCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
