package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 补偿类型
 * </p>
 *
 * @author ultraman
 * @since 2022-08-30
 */
public enum CompensateEnum {

    INVOICE("INVOICE", "发票"),
    TAX_NO("TAX_NO", "税号");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CompensateEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CompensateEnum fromCode(String code){
        switch(code) {
            case "INVOICE":
                return INVOICE;
            case "TAX_NO":
                return TAX_NO;
            default:
                return null;
        }
    }
}
