package com.xforceplus.ultraman.app.financialsettlement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * member_cost
 * </p>
 *
 * @author ultraman
 * @since 2022-08-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MemberCost implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 月份
   */
  private String chargeMonth;
  /**
   * 员工姓名
   */
  private String memberName;
  /**
   * 员工工号
   */
  private String memberNo;
  /**
   * chargeCode
   */
  private String chargeCode;
  /**
   * chargeCode类型
   */
  private String chargeCodeType;
  /**
   * 一级部门编号
   */
  private String firstDepartmentNo;
  /**
   * 一级部门名称
   */
  private String firstDepartmentName;
  /**
   * 角色
   */
  private String role;
  /**
   * 职级
   */
  private String rank;
  /**
   * 标准成本
   */
  private BigDecimal cost;
  /**
   * 工时
   */
  private Long hours;
  /**
   * 标准人工成本
   */
  private BigDecimal memberCost;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("chargeMonth", chargeMonth);
      map.put("memberName", memberName);
      map.put("memberNo", memberNo);
      map.put("chargeCode", chargeCode);
      map.put("chargeCodeType", chargeCodeType);
      map.put("firstDepartmentNo", firstDepartmentNo);
      map.put("firstDepartmentName", firstDepartmentName);
      map.put("role", role);
      map.put("rank", rank);
      map.put("cost", cost);
      map.put("hours", hours);
      map.put("memberCost", memberCost);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static MemberCost fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MemberCost entity = new MemberCost();

    if(map.containsKey("chargeMonth")) {
      Object obj = map.get("chargeMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("memberName")) {
      Object obj = map.get("memberName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMemberName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("memberNo")) {
      Object obj = map.get("memberNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMemberNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCodeType")) {
      Object obj = map.get("chargeCodeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCodeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstDepartmentNo")) {
      Object obj = map.get("firstDepartmentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFirstDepartmentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstDepartmentName")) {
      Object obj = map.get("firstDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFirstDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("role")) {
      Object obj = map.get("role");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rank")) {
      Object obj = map.get("rank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost")) {
      Object obj = map.get("cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("hours")) {
      Object obj = map.get("hours");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHours((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setHours(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setHours(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("memberCost")) {
      Object obj = map.get("memberCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMemberCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMemberCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMemberCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMemberCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMemberCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("chargeMonth")) {
      Object obj = map.get("chargeMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeMonth((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("memberName")) {
      Object obj = map.get("memberName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMemberName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("memberNo")) {
      Object obj = map.get("memberNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMemberNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("chargeCodeType")) {
      Object obj = map.get("chargeCodeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeCodeType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("firstDepartmentNo")) {
      Object obj = map.get("firstDepartmentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFirstDepartmentNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("firstDepartmentName")) {
      Object obj = map.get("firstDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFirstDepartmentName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("role")) {
      Object obj = map.get("role");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRole((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("rank")) {
      Object obj = map.get("rank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRank((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cost")) {
      Object obj = map.get("cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("hours")) {
      Object obj = map.get("hours");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setHours((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setHours(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setHours(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("memberCost")) {
      Object obj = map.get("memberCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setMemberCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setMemberCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setMemberCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMemberCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setMemberCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }

  }

}
