package com.xforceplus.ultraman.app.financialsettlement.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 北森人员雇佣关系枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-09-23
 */
public enum BsEmployTypeEnum {

    _0("0", "内部员工"),
    _2("2", "实习生"),
    _1("1", " 外部人员");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BsEmployTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BsEmployTypeEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
